The package _identifiers_ provides classes that can be used to create and
check identifiers for unique objects or unique classes of objects
according to international standards.

_Definition from Wikipedia_:

"An identifier is a name that identifies (that is, labels the identity of)
either a unique object or a unique class of objects, where the "object" or
class may be an idea, physical [countable] object (or class thereof), or
physical [noncountable] substance (or class thereof). The abbreviation ID
often refers to identity, identification (the process of identifying), or an
identifier (that is, an instance of identification). An identifier may be a
word, number, letter, symbol, or any combination of those."

## Overview

For more detailed documentation see http://identifiers.readthedocs.io.

### Identifiers standardized by GS1

  See http://www.gs1.org/id-keys.

* Global Trade Item Number (GTIN)

  Used to identify products and services.

  Variants: GTIN12, GTIN13, GTIN14

* Global Location Number (GLN)

  Used to identify parties and locations, for example companies, warehouses,
  factories and stores.

* Global Shipment Identification Number (GSIN)

  Used to identify shipments, i. e. logistics units delivered to a customer
  together.

* Serial Shipping Container Code (SSCC)

  Used to identify logistics units, for example loads on pallets,
  roll cages or parcels.

### Identifiers for publications

* International Standard Book Number (ISBN)

  A unique international identifier for monographic publications.

  See http://www.isbn-international.org.

* International Standard Music Number (ISMN)

  A unique international identifier of all notated music publications, whether
  available for sale, hire or gratis, whether a part, a score, or an element
  in a multi-media kit.

  See http://www.ismn-international.org.

* International Standard Serial Number (ISSN)

  Used to identify newspapers, journals, magazines and periodicals of all
  kinds and on all media - print and electronic.

  See http://www.issn.org.

### Identifiers for banks and bank accounts

  See http://www.swift.com.

* Business Identifier Code (BIC)

  Used to identify financial and non-financial institutions.

* International Bank Account Number (IBAN)

  An internationally agreed system of identifying bank accounts across
  national borders.

### Identifiers for exchanges and exchange traded financial assets

* Market Identifier Code (MIC)

  A unique identification code used to identify securities trading
  exchanges, regulated and non-regulated trading markets.

  See https://www.iso20022.org/10383/iso-10383-market-identifier-codes

* International Securities Identification Number (ISIN)

  Uniquely identifies a tradable financial asset, a.k.a security.

  See http://www.anna-web.org/standards/isin-iso-6166/.

### Identifiers for Value Added Taxation

* European Union VAT Registration Number

  The VAT Registration Number is used to identify natural and legal persons
  located in the European Union for purposes of VAT handling.

  See http://ec.europa.eu/taxation_customs/business/vat
