# AUTOGENERATED! DO NOT EDIT! File to edit: 00_Devices.ipynb (unless otherwise specified).

__all__ = ['DE10Class', 'DE10']

# Cell
import numpy as np
from typing import Optional, Tuple, Dict, Callable, Union

# Cell
class DE10Class:
    '''
    DE10 Nano Chip 5CSEBA6U23I7 as a callable with `x`, `y`, `n` coordinates.
    With two args `x` and `y`, give logic type. With three, give cell type.
    Also has attributes listing `MLAB`,`LAB`,`DSP`,`M10K` x-coordinates.
    '''
    def __init__(self):
        "Chip 5CSEBA6U23I7 as a dictionary indexed by location, valued by LAB logic type."
        chipdict = {}
        X,Y,N=(89,81,60)
        #at x=0, all y is blank
        Xs=np.arange(1,88+1)
        Ys=np.arange(1,80+1)

        #Locations of different logic X-values
        MLAB_X=[3,6,8,15,21,25,28,34,39,47,52,59,65,72,78,82,84,87]
        M10K_X=[5,14,26,38,41,44,49,58,69,76,89]
        DSP_X=[20,32,54,86]

        #Default to LABs
        for i in Xs:
            for j in Ys:
                chipdict[(i,j)]='LAB'
        #Then replace with other logic types
        for i in MLAB_X:
            for j in Ys:
                chipdict[(i,j)]='MLAB'
        for i in M10K_X:
            for j in Ys:
                chipdict[(i,j)]='M10K'
        for i in DSP_X:
            for j in Ys:
                chipdict[(i,j)]='DSP'

        #from x=1 to x=9, y=15 to y=31 is blank
        for i in range(1,9+1):
            for j in range(15,31+1):
                del chipdict[(i,j)]
        #at x=20, 32, 54, 86, y=32 and y=1 is blank
        for i in [20,32,54,86]:
            del chipdict[(i,32)]
            del chipdict[(i,1)]
        #at x=44, all y is blank
        for j in Ys:
            del chipdict[(44,j)]
        #at x=45 to x=50, y=37 is blank
        for i in range(45,50+1):
            del chipdict[(i,37)]
        #at x=51 onwards, y>=37 is blank
        for i in range(51,X):
            for j in range(37,Y):
                del chipdict[(i,j)]

        #Set attrs for easy access
        self.dict=chipdict
        self.LAB=sorted(list(set([x for (x,y) in chipdict.keys() if chipdict[x,y]=='LAB'])))
        self.MLAB=MLAB_X
        self.M10K=M10K_X
        self.DSP=DSP_X

    def SLA(self,x,y,n,name=None):
        if name is None:
            return f'set_location_assignment {self.__call__(x,y,n)}_X{x}_Y{y}_N{n} -to "{{0}}"\n'
        else:
            return f'set_location_assignment {self.__call__(x,y,n)}_X{x}_Y{y}_N{n} -to "{name}"\n'

    def __call__(self,
                 x : int,
                 y : int,
                 n : Optional[int] = None):
        "DE10 callable function. With two args, give LAB type. With three, give LABCELL type."
        T=self.dict[x,y]
        if n is None or T=='M10K' or T=='DSP': #return type of logic if no third arg, or ram/dsp
            return T
        else: #return flipflop based on position in labcell, or type of labcell
            z=n%6 #mod the number of elements in the cell
            if z==0 or z==3:
                return T+'CELL'
            else:
                return 'FF'

    def __repr__(self):
        return 'DE10 Nano 5CSEBA6U23I7 from X=1 to X=88, Y=1 to Y=80\n'\
            +'MLAB X-coords: {0}\n'.format(self.MLAB)+'M10K X-coords: {0}\n'.format(self.M10K)\
            +'DSP X-coords: {0}\n'.format(self.DSP)+'LAB X-coords: else'

# Cell
DE10=DE10Class()