"""
WARNING: AUTOGENERATED CODE

    This code was generated by a tool.
    
    Manual changes to this file may cause unexpected behavior in your application.
    Manual changes to this file will be overwritten if the code is regenerated.
"""

from pyxetabase.rest_clients._parent_rest_clients import _ParentRestClient


class Federation(_ParentRestClient):
    """
    This class contains methods for the 'Federations' webservices
    PATH: /{apiVersion}/federations
    """

    def __init__(self, configuration, token=None, login_handler=None, *args, **kwargs):
        super(Federation, self).__init__(configuration, token, login_handler, *args, **kwargs)

    def connect_client(self, data=None, **options):
        """
        Connect to a shared XetaBase instance.
        PATH: /{apiVersion}/federations/client/connect

        :param dict data: JSON containing the Federation server configuration.
            (REQUIRED)
        """

        return self._post(category='federations', resource='connect', subcategory='client', data=data, **options)

    def client_study_users_list(self, **options):
        """
        Show the list of users with access to the federated study.
        PATH: /{apiVersion}/federations/client/study/users/list

        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID.
        """

        return self._get(category='federations', resource='list', subcategory='client/study/users', **options)

    def client_study_users_update(self, data=None, **options):
        """
        Grant/Deny access to federated studies to users.
        PATH: /{apiVersion}/federations/client/study/users/update

        :param dict data: JSON containing the list of users to which this
            action will be applied. (REQUIRED)
        :param str study: Study [[organization@]project:]study where study and
            project can be either the ID or UUID.
        :param str action: Action to be performed: ADD access or REMOVE
            access. Allowed values: ['ADD', 'REMOVE']
        """

        return self._post(category='federations', resource='update', subcategory='client/study/users', data=data, **options)

    def delete_client(self, id, **options):
        """
        Delete a federation client.
        PATH: /{apiVersion}/federations/client/{id}/delete

        :param str id: Federation client id. (REQUIRED)
        """

        return self._delete(category='federations', resource='delete', subcategory='client', second_query_id=id, **options)

    def synchronize_client(self, id, **options):
        """
        Synchronize data from a known Federation server.
        PATH: /{apiVersion}/federations/client/{id}/synchronize

        :param str id: Federation client id to be synchronized. (REQUIRED)
        """

        return self._post(category='federations', resource='synchronize', subcategory='client', second_query_id=id, **options)

    def update_client(self, id, data=None, **options):
        """
        Update some fields from a Federation client.
        PATH: /{apiVersion}/federations/client/{id}/update

        :param dict data: JSON containing the Federation client parameters to
            be updated. (REQUIRED)
        :param str id: Federation client id. (REQUIRED)
        """

        return self._post(category='federations', resource='update', subcategory='client', second_query_id=id, data=data, **options)

    def create_server(self, data=None, **options):
        """
        Share a resource with another XetaBase instance.
        PATH: /{apiVersion}/federations/server/create

        :param dict data: JSON containing the new Federation object.
            (REQUIRED)
        """

        return self._post(category='federations', resource='create', subcategory='server', data=data, **options)

    def delete_server(self, id, **options):
        """
        Delete a federation server.
        PATH: /{apiVersion}/federations/server/{id}/delete

        :param str id: Federation server id. (REQUIRED)
        """

        return self._delete(category='federations', resource='delete', subcategory='server', second_query_id=id, **options)

    def reset_server(self, id, **options):
        """
        Reset the credentials of a federation server.
        PATH: /{apiVersion}/federations/server/{id}/reset

        :param str id: Federation server id to reset. (REQUIRED)
        """

        return self._post(category='federations', resource='reset', subcategory='server', second_query_id=id, **options)

    def update_server(self, id, data=None, **options):
        """
        Update some fields from a Federation server.
        PATH: /{apiVersion}/federations/server/{id}/update

        :param dict data: JSON containing the Federation server parameters to
            be updated. (REQUIRED)
        :param str id: Federation server id. (REQUIRED)
        """

        return self._post(category='federations', resource='update', subcategory='server', second_query_id=id, data=data, **options)

