# basic-deep-learning

Simple module for creating deep learning tools, with its own linear algebra and matrices utilities.

This library provides essential deep learning components "built from scratch" with minimal external dependencies. It's designed for educational purposes to help understand the fundamentals of deep learning without relying on complex frameworks.

The library contains:

**Matrix**: a matrix class with all the necessary operations.

**ActivationFunctionsRegistry**: a class containing the most used activation functions.

**MultiLayerPerceptron**: the main class that encapsulates a neural network.

## Installation

The package is available using pip. On your terminal, run

```bash
pip install basic-deep-learning
```

## Dependencies

matplotlib>=3.5.0 (only for visualization).

## Contributions and Contact

GitHub repository: [https://github.com/therealzaini/basic-deep-learning](https://github.com/therealzaini/basic-deep-learning)

Documentation: [https://basic-deep-learning.readthedocs.io/](https://basic-deep-learning.readthedocs.io/)

## License
Copyright (c) 2025 Diaa Eddine ZAINI

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the “Software”), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

## Citation

If you use this software in your research, please cite it as:

```bibtex
@software{zaini_basic_deep_learning_2025,
  author = {Zaini, Diaa Eddine},
  doi = {10.5281/zenodo.16934656},
  month = {1},
  title = {{Basic Deep Learning}},
  url = {https://github.com/therealzaini/basic-deep-learning},
  version = {1.0.0},
  year = {2025}
}