# mypy-boto3-elb

[![PyPI - mypy-boto3-elb](https://img.shields.io/pypi/v/mypy-boto3-elb.svg?color=blue)](https://pypi.org/project/mypy-boto3-elb)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-elb.svg?color=blue)](https://pypi.org/project/mypy-boto3-elb)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.ElasticLoadBalancing 1.14.22](https://boto3.amazonaws.com/v1/documentation/api/1.14.22/reference/services/elb.html#ElasticLoadBalancing) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.2.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to install

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `ElasticLoadBalancing` service.

```bash
python -m pip install boto3-stubs[elb]
```

## How to use

### Client annotations

`ElasticLoadBalancingClient` provides annotations for `boto3.client("elb")`.

```python
import boto3

from mypy_boto3_elb import ElasticLoadBalancingClient
from mypy_boto3_elb.paginator import DescribeAccountLimitsPaginator, DescribeLoadBalancersPaginator
from mypy_boto3_elb.type_defs import AccessLogTypeDef, ...
from mypy_boto3_elb.waiter import (
    AnyInstanceInServiceWaiter,
    InstanceDeregisteredWaiter,
    InstanceInServiceWaiter,
)

client: ElasticLoadBalancingClient = boto3.client("elb")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ElasticLoadBalancingClient = session.client("elb")
```

### Paginators annotations

`mypy_boto3_elb.paginator` module contains type annotations for all paginators.

```python

client: ElasticLoadBalancingClient = boto3.client("elb")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_account_limits_paginator: DescribeAccountLimitsPaginator = client.get_paginator("describe_account_limits")
describe_load_balancers_paginator: DescribeLoadBalancersPaginator = client.get_paginator("describe_load_balancers")
```


### Waiters annotations

`mypy_boto3_elb.waiter` module contains type annotations for all waiters.

```python

client: ElasticLoadBalancingClient = boto3.client("elb")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
any_instance_in_service_waiter: AnyInstanceInServiceWaiter = client.get_waiter("any_instance_in_service")
instance_deregistered_waiter: InstanceDeregisteredWaiter = client.get_waiter("instance_deregistered")
instance_in_service_waiter: InstanceInServiceWaiter = client.get_waiter("instance_in_service")
```





### Typed dictionations

`mypy_boto3_elb.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python

def get_structure() -> AccessLogTypeDef:
    return {
      ...
    }
```


## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_elb` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("elb")

session_client = boto3.Session().client("elb")
```
