"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConsumerGroup = exports.ConsumerGroupProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const dts_generated_1 = require("./dts.generated");
Object.defineProperty(exports, "ConsumerGroupProperty", { enumerable: true, get: function () { return dts_generated_1.RosConsumerGroup; } });
/**
 * A ROS resource type:  `ALIYUN::DTS::ConsumerGroup`
 */
class ConsumerGroup extends ros.Resource {
    /**
     * Create a new `ALIYUN::DTS::ConsumerGroup`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosConsumerGroup = new dts_generated_1.RosConsumerGroup(this, id, {
            consumerGroupPassword: props.consumerGroupPassword,
            consumerGroupUserName: props.consumerGroupUserName,
            consumerGroupName: props.consumerGroupName,
            subscriptionInstanceId: props.subscriptionInstanceId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosConsumerGroup;
        this.attrConsumerGroupId = rosConsumerGroup.attrConsumerGroupId;
        this.attrConsumerGroupName = rosConsumerGroup.attrConsumerGroupName;
        this.attrSubscriptionInstanceId = rosConsumerGroup.attrSubscriptionInstanceId;
    }
}
exports.ConsumerGroup = ConsumerGroup;
//# sourceMappingURL=data:application/json;base64,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