from setuptools import setup, find_packages

setup(
    name="mcp-proxy-adapter",
    version="6.2.23",
    description="Powerful JSON-RPC microservices framework with built-in security, authentication, and proxy registration",
    long_description=open("README.md").read(),
    long_description_content_type="text/markdown",
    author="Vasiliy Zdanovskiy",
    author_email="vasilyvz@gmail.com",
    url="https://github.com/maverikod/mcp-proxy-adapter",
    project_urls={
        "Homepage": "https://github.com/maverikod/mcp-proxy-adapter",
        "Documentation": "https://github.com/maverikod/mcp-proxy-adapter#readme",
        "Source": "https://github.com/maverikod/mcp-proxy-adapter",
        "Tracker": "https://github.com/maverikod/mcp-proxy-adapter/issues",
        "PyPI": "https://pypi.org/project/mcp-proxy-adapter/",
    },
    packages=find_packages(exclude=["mcp_sdk*", "test*", "tests*", ".venv*", "venv*", "build*", "dist*"]),
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
        "Framework :: FastAPI",
        "Topic :: Internet :: WWW/HTTP :: HTTP Servers",
        "Topic :: Security",
        "Topic :: Software Development :: Libraries :: Python Modules",
    ],
    keywords=[
        "json-rpc",
        "microservices",
        "fastapi",
        "security",
        "authentication",
        "authorization",
        "proxy",
        "mcp",
        "mtls",
        "ssl",
        "rest",
        "api",
    ],
    python_requires=">=3.9",
    install_requires=[
        "fastapi>=0.95.0,<1.0.0",
        "pydantic>=2.0.0",
        "hypercorn>=0.15.0,<1.0.0",
        "docstring-parser>=0.15,<1.0.0",
        "typing-extensions>=4.5.0,<5.0.0",
        "jsonrpc>=1.2.0",
        "psutil>=5.9.0",
        "mcp_security_framework>=1.1.2",
        "packaging>=20.0",
        "aiohttp>=3.8.0,<4.0.0",
        "requests>=2.28.0,<3.0.0"
    ],
    extras_require={
        "dev": [
            "pytest>=7.0.0",
            "pytest-asyncio>=0.20.0",
            "pytest-cov>=4.0.0",
            "black>=23.0.0",
            "isort>=5.12.0",
        ],
    },
    include_package_data=False,
) 