from dacopt import DACOpt, ConfigSpace, ConditionalSpace, AlgorithmChoice, IntegerParam, FloatParam, CategoricalParam, Forbidden
from hyperopt import Trials
from sklearn import datasets
from sklearn.svm import SVC
from sklearn.model_selection import cross_val_score
from sklearn.preprocessing import StandardScaler
from sklearn.ensemble import RandomForestClassifier
import numpy as np
from hyperopt import hp
import numpy as np
import time
search_space = ConfigSpace()
con = ConditionalSpace("test")
myforb = Forbidden()
p1= CategoricalParam(['none', 'weighting'],'p1',default='none')
search_space._add_singleparameter(p1)
p2= AlgorithmChoice(['sgd', 'passive_aggressive','lda', 'qda','liblinear_svc',
                     'libsvm_svc', 'k_nearest_neighbors', 'gaussian_nb',
                     'bernoulli_nb', 'multinomial_nb','random_forest', 'adaboost',
                     'gradient_boosting', 'extra_trees', 'decision_tree', 'mlp'],'p2',default='random_forest')
search_space._add_singleparameter(p2)
p3= AlgorithmChoice(['encoding', 'no_encoding', 'one_hot_encoding'],'p3',default='one_hot_encoding')
search_space._add_singleparameter(p3)
p4= AlgorithmChoice(['minority_coalescer', 'no_coalescense'],'p4',default='minority_coalescer')
search_space._add_singleparameter(p4)
p5= CategoricalParam(['mean', 'median', 'most_frequent'],'p5',default='mean')
search_space._add_singleparameter(p5)
p6= AlgorithmChoice(['standardize', 'minmax', 'robust_scaler','quantile_transformer',
                     'power_transformer', 'normalize', 'none'],'p6',default='standardize')
search_space._add_singleparameter(p6)
p7= AlgorithmChoice(['extra_trees_preproc_for_classification', 'random_trees_embedding',
                      'fast_ica', 'kernel_pca', 'pca', 'feature_agglomeration',
                      'kitchen_sinks', 'nystroem_sampler', 'liblinear_svc_preprocessor',
                      'polynomial', 'select_percentile_classification',
                      'select_rates_classification', 'no_preprocessing'],'p7',default='no_preprocessing')
search_space._add_singleparameter(p7)
p8= CategoricalParam(['SAMME.R', 'SAMME'],'p8',default='SAMME.R')
search_space._add_singleparameter(p8)
p9= FloatParam([0.01, 2.0],'p9',default=0.1)
search_space._add_singleparameter(p9)
p10= IntegerParam([1, 11],'p10',default=1)
search_space._add_singleparameter(p10)
p11= IntegerParam([50, 501],'p11',default=50)
search_space._add_singleparameter(p11)
p12= FloatParam([0.01, 100.0],'p12',default=1.0)
search_space._add_singleparameter(p12)
p13= CategoricalParam(['True', 'False'],'p13',default='True')
search_space._add_singleparameter(p13)
p14= CategoricalParam(['gini', 'entropy'],'p14',default='gini')
search_space._add_singleparameter(p14)
p15= FloatParam([0.0, 2.0],'p15',default=0.5)
search_space._add_singleparameter(p15)
p16= CategoricalParam([1.0],'p16',default=1.0)
search_space._add_singleparameter(p16)
p17= CategoricalParam(['None'],'p17',default='None')
search_space._add_singleparameter(p17)
p18= CategoricalParam([0.0],'p18',default=0.0)
search_space._add_singleparameter(p18)
p19= IntegerParam([1, 21],'p19',default=1)
search_space._add_singleparameter(p19)
p20= IntegerParam([2, 21],'p20',default=2)
search_space._add_singleparameter(p20)
p21= CategoricalParam([0.0],'p21',default=0.0)
search_space._add_singleparameter(p21)
p22= CategoricalParam(['True', 'False'],'p22',default='False')
search_space._add_singleparameter(p22)
p23= CategoricalParam(['gini', 'entropy'],'p23',default='gini')
search_space._add_singleparameter(p23)
p24= CategoricalParam(['None'],'p24',default='None')
search_space._add_singleparameter(p24)
p25= FloatParam([0.0, 1.0],'p25',default=0.5)
search_space._add_singleparameter(p25)
p26= CategoricalParam(['None'],'p26',default='None')
search_space._add_singleparameter(p26)
p27= CategoricalParam([0.0],'p27',default=0.0)
search_space._add_singleparameter(p27)
p28= IntegerParam([1, 21],'p28',default=1)
search_space._add_singleparameter(p28)
p29= IntegerParam([2, 21],'p29',default=2)
search_space._add_singleparameter(p29)
p30= CategoricalParam([0.0],'p30',default=0.0)
search_space._add_singleparameter(p30)
p31= CategoricalParam(['off', 'valid', 'train'],'p31',default='off')
search_space._add_singleparameter(p31)
p32= FloatParam([1e-10, 1.0],'p32',default=1e-10)
search_space._add_singleparameter(p32)
p33= FloatParam([0.01, 1.0],'p33',default=0.1)
search_space._add_singleparameter(p33)
p34= CategoricalParam(['auto'],'p34',default='auto')
search_space._add_singleparameter(p34)
p35= CategoricalParam([255],'p35',default=255)
search_space._add_singleparameter(p35)
p36= CategoricalParam(['None'],'p36',default='None')
search_space._add_singleparameter(p36)
p37= IntegerParam([3, 2048],'p37',default=31)
search_space._add_singleparameter(p37)
p38= IntegerParam([1, 201],'p38',default=20)
search_space._add_singleparameter(p38)
p39= CategoricalParam(['loss'],'p39',default='loss')
search_space._add_singleparameter(p39)
p40= CategoricalParam([1e-07],'p40',default=1e-07)
search_space._add_singleparameter(p40)
p41= IntegerParam([1, 101],'p41',default=1)
search_space._add_singleparameter(p41)
p42= CategoricalParam([1, 2],'p42',default=2)
search_space._add_singleparameter(p42)
p43= CategoricalParam(['uniform', 'distance'],'p43',default='uniform')
search_space._add_singleparameter(p43)
p44= CategoricalParam(['None', 'auto', 'manual'],'p44',default='None')
search_space._add_singleparameter(p44)
p45= FloatParam([1e-05, 0.1],'p45',default=0.0001)
search_space._add_singleparameter(p45)
p46= FloatParam([0.03125, 32768.0],'p46',default=1.0)
search_space._add_singleparameter(p46)
p47= CategoricalParam(['False'],'p47',default='False')
search_space._add_singleparameter(p47)
p48= CategoricalParam(['True'],'p48',default='True')
search_space._add_singleparameter(p48)
p49= CategoricalParam([1],'p49',default=1)
search_space._add_singleparameter(p49)
p50= CategoricalParam(['hinge', 'squared_hinge'],'p50',default='squared_hinge')
search_space._add_singleparameter(p50)
p51= CategoricalParam(['ovr'],'p51',default='ovr')
search_space._add_singleparameter(p51)
p52= CategoricalParam(['l1', 'l2'],'p52',default='l2')
search_space._add_singleparameter(p52)
p53= FloatParam([1e-05, 0.1],'p53',default=0.0001)
search_space._add_singleparameter(p53)
p54= FloatParam([0.03125, 32768.0],'p54',default=1.0)
search_space._add_singleparameter(p54)
p55= FloatParam([3.0517578125e-05, 8.0],'p55',default=0.1)
search_space._add_singleparameter(p55)
p56= CategoricalParam(['rbf', 'poly', 'sigmoid'],'p56',default='rbf')
search_space._add_singleparameter(p56)
p57= CategoricalParam([-1],'p57',default=-1)
search_space._add_singleparameter(p57)
p58= CategoricalParam(['True', 'False'],'p58',default='True')
search_space._add_singleparameter(p58)
p59= FloatParam([1e-05, 0.1],'p59',default=0.001)
search_space._add_singleparameter(p59)
p60= CategoricalParam(['tanh', 'relu'],'p60',default='relu')
search_space._add_singleparameter(p60)
p61= FloatParam([1e-07, 0.1],'p61',default=0.0001)
search_space._add_singleparameter(p61)
p62= CategoricalParam(['auto'],'p62',default='auto')
search_space._add_singleparameter(p62)
p63= CategoricalParam([0.9],'p63',default=0.9)
search_space._add_singleparameter(p63)
p64= CategoricalParam([0.999],'p64',default=0.999)
search_space._add_singleparameter(p64)
p65= CategoricalParam(['valid', 'train'],'p65',default='valid')
search_space._add_singleparameter(p65)
p66= CategoricalParam([1e-08],'p66',default=1e-08)
search_space._add_singleparameter(p66)
p67= IntegerParam([1, 4],'p67',default=1)
search_space._add_singleparameter(p67)
p68= FloatParam([0.0001, 0.5],'p68',default=0.001)
search_space._add_singleparameter(p68)
p69= CategoricalParam([32],'p69',default=32)
search_space._add_singleparameter(p69)
p70= IntegerParam([16, 265],'p70',default=32)
search_space._add_singleparameter(p70)
p71= CategoricalParam(['True'],'p71',default='True')
search_space._add_singleparameter(p71)
p72= CategoricalParam(['adam'],'p72',default='adam')
search_space._add_singleparameter(p72)
p73= CategoricalParam([0.0001],'p73',default=0.0001)
search_space._add_singleparameter(p73)
p74= FloatParam([0.01, 100.0],'p74',default=1.0)
search_space._add_singleparameter(p74)
p75= CategoricalParam(['True', 'False'],'p75',default='True')
search_space._add_singleparameter(p75)
p76= FloatParam([1e-05, 10.0],'p76',default=1.0)
search_space._add_singleparameter(p76)
p77= CategoricalParam(['False', 'True'],'p77',default='False')
search_space._add_singleparameter(p77)
p78= CategoricalParam(['True'],'p78',default='True')
search_space._add_singleparameter(p78)
p79= CategoricalParam(['hinge', 'squared_hinge'],'p79',default='hinge')
search_space._add_singleparameter(p79)
p80= FloatParam([1e-05, 0.1],'p80',default=0.0001)
search_space._add_singleparameter(p80)
p81= FloatParam([0.0, 1.0],'p81',default=0.0)
search_space._add_singleparameter(p81)
p82= CategoricalParam(['True', 'False'],'p82',default='True')
search_space._add_singleparameter(p82)
p83= CategoricalParam(['gini', 'entropy'],'p83',default='gini')
search_space._add_singleparameter(p83)
p84= CategoricalParam(['None'],'p84',default='None')
search_space._add_singleparameter(p84)
p85= FloatParam([0.0, 1.0],'p85',default=0.5)
search_space._add_singleparameter(p85)
p86= CategoricalParam(['None'],'p86',default='None')
search_space._add_singleparameter(p86)
p87= CategoricalParam([0.0],'p87',default=0.0)
search_space._add_singleparameter(p87)
p88= IntegerParam([1, 21],'p88',default=1)
search_space._add_singleparameter(p88)
p89= IntegerParam([2, 21],'p89',default=2)
search_space._add_singleparameter(p89)
p90= CategoricalParam([0.0],'p90',default=0.0)
search_space._add_singleparameter(p90)
p91= FloatParam([1e-07, 0.1],'p91',default=0.0001)
search_space._add_singleparameter(p91)
p92= CategoricalParam(['False', 'True'],'p92',default='False')
search_space._add_singleparameter(p92)
p93= CategoricalParam(['True'],'p93',default='True')
search_space._add_singleparameter(p93)
p94= CategoricalParam(['optimal', 'invscaling', 'constant'],'p94',default='invscaling')
search_space._add_singleparameter(p94)
p95= CategoricalParam(['hinge', 'log', 'modified_huber', 'squared_hinge', 'perceptron'],'p95',default='log')
search_space._add_singleparameter(p95)
p96= CategoricalParam(['l1', 'l2', 'elasticnet'],'p96',default='l2')
search_space._add_singleparameter(p96)
p97= FloatParam([1e-05, 0.1],'p97',default=0.0001)
search_space._add_singleparameter(p97)
p98= FloatParam([0.0001, 0.5],'p98',default=0.01)
search_space._add_singleparameter(p98)
p99= IntegerParam([10, 2001],'p99',default=1000)
search_space._add_singleparameter(p99)
p100= CategoricalParam(['uniform', 'normal'],'p100',default='uniform')
search_space._add_singleparameter(p100)
p101= FloatParam([0.7, 0.999],'p101',default=0.75)
search_space._add_singleparameter(p101)
p102= FloatParam([0.001, 0.3],'p102',default=0.25)
search_space._add_singleparameter(p102)
p103= CategoricalParam(['True', 'False'],'p103',default='False')
search_space._add_singleparameter(p103)
p104= CategoricalParam(['gini', 'entropy'],'p104',default='gini')
search_space._add_singleparameter(p104)
p105= CategoricalParam(['None'],'p105',default='None')
search_space._add_singleparameter(p105)
p106= FloatParam([0.0, 1.0],'p106',default=0.5)
search_space._add_singleparameter(p106)
p107= CategoricalParam(['None'],'p107',default='None')
search_space._add_singleparameter(p107)
p108= CategoricalParam([0.0],'p108',default=0.0)
search_space._add_singleparameter(p108)
p109= IntegerParam([1, 21],'p109',default=1)
search_space._add_singleparameter(p109)
p110= IntegerParam([2, 21],'p110',default=2)
search_space._add_singleparameter(p110)
p111= CategoricalParam([0.0],'p111',default=0.0)
search_space._add_singleparameter(p111)
p112= CategoricalParam([100],'p112',default=100)
search_space._add_singleparameter(p112)
p113= CategoricalParam(['parallel', 'deflation'],'p113',default='parallel')
search_space._add_singleparameter(p113)
p114= CategoricalParam(['logcosh', 'exp', 'cube'],'p114',default='logcosh')
search_space._add_singleparameter(p114)
p115= CategoricalParam(['False', 'True'],'p115',default='False')
search_space._add_singleparameter(p115)
p116= CategoricalParam(['euclidean', 'manhattan', 'cosine'],'p116',default='euclidean')
search_space._add_singleparameter(p116)
p117= CategoricalParam(['ward', 'complete', 'average'],'p117',default='ward')
search_space._add_singleparameter(p117)
p118= IntegerParam([2, 401],'p118',default=25)
search_space._add_singleparameter(p118)
p119= CategoricalParam(['mean', 'median', 'max'],'p119',default='mean')
search_space._add_singleparameter(p119)
p120= CategoricalParam(['poly', 'rbf', 'sigmoid', 'cosine'],'p120',default='rbf')
search_space._add_singleparameter(p120)
p121= IntegerParam([10, 2001],'p121',default=100)
search_space._add_singleparameter(p121)
p122= FloatParam([3.0517578125e-05, 8.0],'p122',default=1.0)
search_space._add_singleparameter(p122)
p123= IntegerParam([50, 10001],'p123',default=100)
search_space._add_singleparameter(p123)
p124= FloatParam([0.03125, 32768.0],'p124',default=1.0)
search_space._add_singleparameter(p124)
p125= CategoricalParam(['False'],'p125',default='False')
search_space._add_singleparameter(p125)
p126= CategoricalParam(['True'],'p126',default='True')
search_space._add_singleparameter(p126)
p127= CategoricalParam([1],'p127',default=1)
search_space._add_singleparameter(p127)
p128= CategoricalParam(['hinge', 'squared_hinge'],'p128',default='squared_hinge')
search_space._add_singleparameter(p128)
p129= CategoricalParam(['ovr'],'p129',default='ovr')
search_space._add_singleparameter(p129)
p130= CategoricalParam(['l1'],'p130',default='l1')
search_space._add_singleparameter(p130)
p131= FloatParam([1e-05, 0.1],'p131',default=0.0001)
search_space._add_singleparameter(p131)
p132= CategoricalParam(['poly', 'rbf', 'sigmoid', 'cosine'],'p132',default='rbf')
search_space._add_singleparameter(p132)
p133= IntegerParam([50, 10001],'p133',default=100)
search_space._add_singleparameter(p133)
p134= FloatParam([0.5, 0.9999],'p134',default=0.9999)
search_space._add_singleparameter(p134)
p135= CategoricalParam(['False', 'True'],'p135',default='False')
search_space._add_singleparameter(p135)
p136= IntegerParam([2, 4],'p136',default=2)
search_space._add_singleparameter(p136)
p137= CategoricalParam(['True', 'False'],'p137',default='True')
search_space._add_singleparameter(p137)
p138= CategoricalParam(['False', 'True'],'p138',default='False')
search_space._add_singleparameter(p138)
p139= CategoricalParam(['True', 'False'],'p139',default='True')
search_space._add_singleparameter(p139)
p140= IntegerParam([2, 11],'p140',default=5)
search_space._add_singleparameter(p140)
p141= CategoricalParam(['None'],'p141',default='None')
search_space._add_singleparameter(p141)
p142= IntegerParam([1, 21],'p142',default=1)
search_space._add_singleparameter(p142)
p143= IntegerParam([2, 21],'p143',default=2)
search_space._add_singleparameter(p143)
p144= CategoricalParam([1.0],'p144',default=1.0)
search_space._add_singleparameter(p144)
p145= IntegerParam([10, 101],'p145',default=10)
search_space._add_singleparameter(p145)
p146= FloatParam([1.0, 99.0],'p146',default=50.0)
search_space._add_singleparameter(p146)
p147= CategoricalParam(['chi2', 'f_classif', 'mutual_info'],'p147',default='chi2')
search_space._add_singleparameter(p147)
p148= FloatParam([0.01, 0.5],'p148',default=0.1)
search_space._add_singleparameter(p148)
p149= CategoricalParam(['chi2', 'f_classif', 'mutual_info_classif'],'p149',default='chi2')
search_space._add_singleparameter(p149)
p150= IntegerParam([1, 21],'p150',default=10)
search_space._add_singleparameter(p150)
p151= FloatParam([0.01, 0.4],'p151',default=0.1)
search_space._add_singleparameter(p151)
p152= FloatParam([0.0, 1.0],'p152',default=0.5)
search_space._add_singleparameter(p152)
p153= FloatParam([-1.0, 1.0],'p153',default=0.0)
search_space._add_singleparameter(p153)
p154= IntegerParam([2, 6],'p154',default=3)
search_space._add_singleparameter(p154)
p155= CategoricalParam([0.1],'p155',default=0.1)
search_space._add_singleparameter(p155)
p156= FloatParam([1e-05, 0.1],'p156',default=0.0001)
search_space._add_singleparameter(p156)
p157= FloatParam([1e-07, 0.1],'p157',default=0.01)
search_space._add_singleparameter(p157)
p158= FloatParam([1e-09, 1.0],'p158',default=0.15)
search_space._add_singleparameter(p158)
p159= FloatParam([1e-05, 1.0],'p159',default=0.5)
search_space._add_singleparameter(p159)
p160= IntegerParam([10, 2001],'p160',default=100)
search_space._add_singleparameter(p160)
p161= FloatParam([-1.0, 1.0],'p161',default=0.0)
search_space._add_singleparameter(p161)
p162= IntegerParam([2, 6],'p162',default=3)
search_space._add_singleparameter(p162)
p163= FloatParam([3.0517578125e-05, 8.0],'p163',default=0.01)
search_space._add_singleparameter(p163)
p164= FloatParam([-1.0, 1.0],'p164',default=0.0)
search_space._add_singleparameter(p164)
p165= IntegerParam([2, 6],'p165',default=3)
search_space._add_singleparameter(p165)
p166= FloatParam([3.0517578125e-05, 8.0],'p166',default=0.1)
search_space._add_singleparameter(p166)
p167= CategoricalParam(['fpr', 'fdr', 'fwe'],'p167',default='fpr')
search_space._add_singleparameter(p167)
con.addConditional(p8,p2,['adaboost'])
con.addConditional(p9,p2,['adaboost'])
con.addConditional(p10,p2,['adaboost'])
con.addConditional(p11,p2,['adaboost'])
con.addConditional(p12,p2,['bernoulli_nb'])
con.addConditional(p13,p2,['bernoulli_nb'])
con.addConditional(p14,p2,['decision_tree'])
con.addConditional(p15,p2,['decision_tree'])
con.addConditional(p16,p2,['decision_tree'])
con.addConditional(p17,p2,['decision_tree'])
con.addConditional(p18,p2,['decision_tree'])
con.addConditional(p19,p2,['decision_tree'])
con.addConditional(p20,p2,['decision_tree'])
con.addConditional(p21,p2,['decision_tree'])
con.addConditional(p22,p2,['extra_trees'])
con.addConditional(p23,p2,['extra_trees'])
con.addConditional(p24,p2,['extra_trees'])
con.addConditional(p25,p2,['extra_trees'])
con.addConditional(p26,p2,['extra_trees'])
con.addConditional(p27,p2,['extra_trees'])
con.addConditional(p28,p2,['extra_trees'])
con.addConditional(p29,p2,['extra_trees'])
con.addConditional(p30,p2,['extra_trees'])
con.addConditional(p31,p2,['gradient_boosting'])
con.addConditional(p32,p2,['gradient_boosting'])
con.addConditional(p33,p2,['gradient_boosting'])
con.addConditional(p34,p2,['gradient_boosting'])
con.addConditional(p35,p2,['gradient_boosting'])
con.addConditional(p36,p2,['gradient_boosting'])
con.addConditional(p37,p2,['gradient_boosting'])
con.addConditional(p38,p2,['gradient_boosting'])
con.addConditional(p39,p2,['gradient_boosting'])
con.addConditional(p40,p2,['gradient_boosting'])
con.addConditional(p41,p2,['k_nearest_neighbors'])
con.addConditional(p42,p2,['k_nearest_neighbors'])
con.addConditional(p43,p2,['k_nearest_neighbors'])
con.addConditional(p44,p2,['lda'])
con.addConditional(p45,p2,['lda'])
con.addConditional(p46,p2,['liblinear_svc'])
con.addConditional(p47,p2,['liblinear_svc'])
con.addConditional(p48,p2,['liblinear_svc'])
con.addConditional(p49,p2,['liblinear_svc'])
con.addConditional(p50,p2,['liblinear_svc'])
con.addConditional(p51,p2,['liblinear_svc'])
con.addConditional(p52,p2,['liblinear_svc'])
con.addConditional(p53,p2,['liblinear_svc'])
con.addConditional(p54,p2,['libsvm_svc'])
con.addConditional(p55,p2,['libsvm_svc'])
con.addConditional(p56,p2,['libsvm_svc'])
con.addConditional(p57,p2,['libsvm_svc'])
con.addConditional(p58,p2,['libsvm_svc'])
con.addConditional(p59,p2,['libsvm_svc'])
con.addConditional(p60,p2,['mlp'])
con.addConditional(p61,p2,['mlp'])
con.addConditional(p62,p2,['mlp'])
con.addConditional(p63,p2,['mlp'])
con.addConditional(p64,p2,['mlp'])
con.addConditional(p65,p2,['mlp'])
con.addConditional(p66,p2,['mlp'])
con.addConditional(p67,p2,['mlp'])
con.addConditional(p68,p2,['mlp'])
con.addConditional(p69,p2,['mlp'])
con.addConditional(p70,p2,['mlp'])
con.addConditional(p71,p2,['mlp'])
con.addConditional(p72,p2,['mlp'])
con.addConditional(p73,p2,['mlp'])
con.addConditional(p74,p2,['multinomial_nb'])
con.addConditional(p75,p2,['multinomial_nb'])
con.addConditional(p76,p2,['passive_aggressive'])
con.addConditional(p77,p2,['passive_aggressive'])
con.addConditional(p78,p2,['passive_aggressive'])
con.addConditional(p79,p2,['passive_aggressive'])
con.addConditional(p80,p2,['passive_aggressive'])
con.addConditional(p81,p2,['qda'])
con.addConditional(p82,p2,['random_forest'])
con.addConditional(p83,p2,['random_forest'])
con.addConditional(p84,p2,['random_forest'])
con.addConditional(p85,p2,['random_forest'])
con.addConditional(p86,p2,['random_forest'])
con.addConditional(p87,p2,['random_forest'])
con.addConditional(p88,p2,['random_forest'])
con.addConditional(p89,p2,['random_forest'])
con.addConditional(p90,p2,['random_forest'])
con.addConditional(p91,p2,['sgd'])
con.addConditional(p92,p2,['sgd'])
con.addConditional(p93,p2,['sgd'])
con.addConditional(p94,p2,['sgd'])
con.addConditional(p95,p2,['sgd'])
con.addConditional(p96,p2,['sgd'])
con.addConditional(p97,p2,['sgd'])
con.addConditional(p98,p4,['minority_coalescer'])
con.addConditional(p99,p6,['quantile_transformer'])
con.addConditional(p100,p6,['quantile_transformer'])
con.addConditional(p101,p6,['robust_scaler'])
con.addConditional(p102,p6,['robust_scaler'])
con.addConditional(p103,p7,['extra_trees_preproc_for_classification'])
con.addConditional(p104,p7,['extra_trees_preproc_for_classification'])
con.addConditional(p105,p7,['extra_trees_preproc_for_classification'])
con.addConditional(p106,p7,['extra_trees_preproc_for_classification'])
con.addConditional(p107,p7,['extra_trees_preproc_for_classification'])
con.addConditional(p108,p7,['extra_trees_preproc_for_classification'])
con.addConditional(p109,p7,['extra_trees_preproc_for_classification'])
con.addConditional(p110,p7,['extra_trees_preproc_for_classification'])
con.addConditional(p111,p7,['extra_trees_preproc_for_classification'])
con.addConditional(p112,p7,['extra_trees_preproc_for_classification'])
con.addConditional(p113,p7,['fast_ica'])
con.addConditional(p114,p7,['fast_ica'])
con.addConditional(p115,p7,['fast_ica'])
con.addConditional(p116,p7,['feature_agglomeration'])
con.addConditional(p117,p7,['feature_agglomeration'])
con.addConditional(p118,p7,['feature_agglomeration'])
con.addConditional(p119,p7,['feature_agglomeration'])
con.addConditional(p120,p7,['kernel_pca'])
con.addConditional(p121,p7,['kernel_pca'])
con.addConditional(p122,p7,['kitchen_sinks'])
con.addConditional(p123,p7,['kitchen_sinks'])
con.addConditional(p124,p7,['liblinear_svc_preprocessor'])
con.addConditional(p125,p7,['liblinear_svc_preprocessor'])
con.addConditional(p126,p7,['liblinear_svc_preprocessor'])
con.addConditional(p127,p7,['liblinear_svc_preprocessor'])
con.addConditional(p128,p7,['liblinear_svc_preprocessor'])
con.addConditional(p129,p7,['liblinear_svc_preprocessor'])
con.addConditional(p130,p7,['liblinear_svc_preprocessor'])
con.addConditional(p131,p7,['liblinear_svc_preprocessor'])
con.addConditional(p132,p7,['nystroem_sampler'])
con.addConditional(p133,p7,['nystroem_sampler'])
con.addConditional(p134,p7,['pca'])
con.addConditional(p135,p7,['pca'])
con.addConditional(p136,p7,['polynomial'])
con.addConditional(p137,p7,['polynomial'])
con.addConditional(p138,p7,['polynomial'])
con.addConditional(p139,p7,['random_trees_embedding'])
con.addConditional(p140,p7,['random_trees_embedding'])
con.addConditional(p141,p7,['random_trees_embedding'])
con.addConditional(p142,p7,['random_trees_embedding'])
con.addConditional(p143,p7,['random_trees_embedding'])
con.addConditional(p144,p7,['random_trees_embedding'])
con.addConditional(p145,p7,['random_trees_embedding'])
con.addConditional(p146,p7,['select_percentile_classification'])
con.addConditional(p147,p7,['select_percentile_classification'])
con.addConditional(p148,p7,['select_rates_classification'])
con.addConditional(p149,p7,['select_rates_classification'])
con.addConditional(p150,p31,['valid', 'train'])
con.addConditional(p151,p31,['valid'])
con.addConditional(p152,p44,['manual'])
con.addConditional(p153,p56,['poly', 'sigmoid'])
con.addConditional(p154,p56,['poly'])
con.addConditional(p155,p65,['valid'])
con.addConditional(p157,p94,['invscaling', 'constant'])
con.addConditional(p159,p94,['invscaling'])
con.addConditional(p156,p95,['modified_huber'])
con.addConditional(p158,p96,['elasticnet'])
con.addConditional(p160,p115,['True'])
con.addConditional(p161,p120,['poly', 'sigmoid'])
con.addConditional(p162,p120,['poly'])
con.addConditional(p163,p120,['poly', 'rbf'])
con.addConditional(p164,p132,['poly', 'sigmoid'])
con.addConditional(p165,p132,['poly'])
con.addConditional(p166,p132,['poly', 'rbf', 'sigmoid'])
con.addConditional(p167,p149,['chi2', 'f_classif'])
myforb.addForbidden(p116,["manhattan", "cosine"],p117,"ward")
myforb.addForbidden(p130,"l1",p128,"hinge")
myforb.addForbidden(p52,"l1",p50,"hinge")
myforb.addForbidden(p47,"False",p52,"l2",p50,"hinge")
myforb.addForbidden(p47,"False",p52,"l1")
myforb.addForbidden(p7,"extra_trees_preproc_for_classification",p2,"multinomial_nb")
myforb.addForbidden(p7,"fast_ica",p2,"multinomial_nb")
myforb.addForbidden(p7,"feature_agglomeration",p2,"multinomial_nb")
myforb.addForbidden(p7,"kernel_pca",p2,"multinomial_nb")
myforb.addForbidden(p7,"kitchen_sinks",p2,"multinomial_nb")
myforb.addForbidden(p7,"liblinear_svc_preprocessor",p2,"multinomial_nb")
myforb.addForbidden(p7,"no_preprocessing",p2,"multinomial_nb")
myforb.addForbidden(p7,"nystroem_sampler",p2,"multinomial_nb")
myforb.addForbidden(p7,"pca",p2,"multinomial_nb")
myforb.addForbidden(p7,"polynomial",p2,"multinomial_nb")
myforb.addForbidden(p7,"random_trees_embedding",p2,"gaussian_nb")
myforb.addForbidden(p7,"random_trees_embedding",p2,"gradient_boosting")
myforb.addForbidden(p7,"random_trees_embedding",p2,"lda")
myforb.addForbidden(p7,"random_trees_embedding",p2,"qda")
myforb.addForbidden(p7,"select_percentile_classification",p2,"multinomial_nb")
myforb.addForbidden(p7,"select_rates_classification",p2,"multinomial_nb")
myforb.addForbidden(p2,"adaboost",p7,"kernel_pca")
myforb.addForbidden(p2,"adaboost",p7,"kitchen_sinks")
myforb.addForbidden(p2,"adaboost",p7,"nystroem_sampler")
myforb.addForbidden(p2,"decision_tree",p7,"kernel_pca")
myforb.addForbidden(p2,"decision_tree",p7,"kitchen_sinks")
myforb.addForbidden(p2,"decision_tree",p7,"nystroem_sampler")
myforb.addForbidden(p2,"extra_trees",p7,"kernel_pca")
myforb.addForbidden(p2,"extra_trees",p7,"kitchen_sinks")
myforb.addForbidden(p2,"extra_trees",p7,"nystroem_sampler")
myforb.addForbidden(p2,"gradient_boosting",p7,"kernel_pca")
myforb.addForbidden(p2,"gradient_boosting",p7,"kitchen_sinks")
myforb.addForbidden(p2,"gradient_boosting",p7,"nystroem_sampler")
myforb.addForbidden(p2,"k_nearest_neighbors",p7,"kernel_pca")
myforb.addForbidden(p2,"k_nearest_neighbors",p7,"kitchen_sinks")
myforb.addForbidden(p2,"k_nearest_neighbors",p7,"nystroem_sampler")
myforb.addForbidden(p2,"libsvm_svc",p7,"kernel_pca")
myforb.addForbidden(p2,"libsvm_svc",p7,"kitchen_sinks")
myforb.addForbidden(p2,"libsvm_svc",p7,"nystroem_sampler")
myforb.addForbidden(p2,"mlp",p7,"kernel_pca")
myforb.addForbidden(p2,"mlp",p7,"kitchen_sinks")
myforb.addForbidden(p2,"mlp",p7,"nystroem_sampler")
myforb.addForbidden(p2,"random_forest",p7,"kernel_pca")
myforb.addForbidden(p2,"random_forest",p7,"kitchen_sinks")
myforb.addForbidden(p2,"random_forest",p7,"nystroem_sampler")
myforb.addForbidden(p2,"gaussian_nb",p7,"kernel_pca")
myforb.addForbidden(p2,"gaussian_nb",p7,"kitchen_sinks")
myforb.addForbidden(p2,"gaussian_nb",p7,"nystroem_sampler")
myforb.addForbidden(p7,"kitchen_sinks",p2,"multinomial_nb")
myforb.addForbidden(p7,"pca",p2,"multinomial_nb")
myforb.addForbidden(p7,"fast_ica",p2,"multinomial_nb")
myforb.addForbidden(p7,"kernel_pca",p2,"multinomial_nb")
myforb.addForbidden(p7,"nystroem_sampler",p2,"multinomial_nb")
import os
os.system("taskset -p 0xff %d" % os.getpid())
#https://stackoverflow.com/questions/15639779/why-does-multiprocessing-use-only-a-single-core-after-i-import-numpy
def new_obj(params):
    print(params)
    #print(params['p2']['name'],params['p7']['name'],params['p6']['name'],params['p3'],params['p4'],params['p5'])
    return (np.random.uniform(0, 1))
#ls = search_space.Combine(Conditional=con, Forbidden=myforb)
#print(len(ls))
'''
opt = BO4ML(search_space, new_obj,forbidden=myforb,conditional=con,SearchType="full",
            max_eval=300, verbose=True, n_job=1,n_init_sample=50)'''
thistrial=Trials()
opt = DACOpt(search_space, new_obj, conditional=con, forbidden=myforb, hpo_prefix="name", isDaC=True,
                HPOopitmizer='bo4ml', random_seed=1, max_threads=4
                ,eta=2,hpo_trials=thistrial,compare_strategy='highest',
                max_eval=50,hpo_algo='TPE',show_message=True,
            number_candidates=5, timeout= None#,n_init_sp=10
            , n_init_sample=10)
_starttime=time.time()
xopt, fopt, _, eval_count = opt.run()
print(fopt)
print(time.time()-_starttime)