#!/usr/bin/env python
from setuptools import setup
setup(
  name = 'cs.app.flag',
  author = 'Cameron Simpson',
  author_email = 'cs@cskk.id.au',
  version = '20201228',
  url = 'https://bitbucket.org/cameron_simpson/css/commits/all',
  description =
    'Persistent filesystem based flags for state and control.',
  long_description =
    ('Persistent filesystem based flags for state and control.\n'    
 '\n'    
 '*Latest release 20201228*:\n'    
 'Import fix.\n'    
 '\n'    
 'Filesystem visible boolean flags\n'    
 'for control and status,\n'    
 'allowing easy monitoring of services or other status,\n'    
 'and control by flag management\n'    
 'for programmes which also monitor the flags.\n'    
 '\n'    
 'The flags are expressed as individual files with uppercase names\n'    
 'in a common directory ($HOME/var/flags by default);\n'    
 'an empty or missing file is "false"\n'    
 'and a nonempty file is "true".\n'    
 '\n'    
 'The Flags class provides easy Pythonic access to this directory.\n'    
 'It presents as a modifiable mapping whose keys are the flag names:\n'    
 '\n'    
 '      flags = Flags()\n'    
 "      flags['UNTOPPOST'] = True\n"    
 '\n'    
 'There is also a FlaggedMixin class providing convenient methods and '    
 'attributes\n'    
 'for maintaining a collection of flags associated with some object\n'    
 "with flag names prefixed by the object's .name attribute\n"    
 'uppercased and with an underscore appended:\n'    
 '\n'    
 '      class SvcD(...,FlaggedMixin):\n'    
 '        def __init__(self, name, ...)\n'    
 '          self.name = name\n'    
 '          FlaggedMixin.__init__(self)\n'    
 '          ...\n'    
 '        def disable(self):\n'    
 '          self.flag_disable = True\n'    
 '        def restart(self):\n'    
 '          self.flag_restart = True\n'    
 '        def _restart(self):\n'    
 '          self.flag_restart = False\n'    
 '          ... restart the SvcD ...\n'    
 '\n'    
 'so that an object set up as:\n'    
 '\n'    
 '      svcd = SvcD("portfwd")\n'    
 '      print(svcd.flag_disable)\n'    
 '\n'    
 'accesses the flag named "PORTFWD_DISABLE".\n'    
 '\n'    
 '## Function `DummyFlags()`\n'    
 '\n'    
 'factory to make a dummy flagslike object without persistent storage\n'    
 '\n'    
 '## Class `FlaggedMixin`\n'    
 '\n'    
 'A mixin class adding flag_* and flagname_* attributes.\n'    
 '\n'    
 ' This defines the following attributes on instances:\n'    
 ' * `flags`: the `Flags` instance providing the flag values.\n'    
 ' * `flags_prefix`: the prefix for the flags of interest.\n'    
 ' * `flagname_`*name*: the full name within `.flags`\n'    
 '   of the flag referred to as *name*.\n'    
 "   This is `.flags_prefix + '_' + `*name*\n"    
 '   if `.flags_prefix` is not empty,\n'    
 '   or just *name* otherwise.\n'    
 '* `flag_`*name*: the value from `.flags`\n'    
 '   of the flag referred to as *name*.\n'    
 '   This is a setable attribute\n'    
 '   with changes propagated to `.flags`.\n'    
 '\n'    
 '### Method `FlaggedMixin.__init__(self, flags=None, debug=None, '    
 'prefix=None)`\n'    
 '\n'    
 'Initialise the mixin.\n'    
 '\n'    
 'Parameters:\n'    
 '* `flags`: optional parameter;\n'    
 '  if `None` defaults to a new default `Flags()`.\n'    
 '* `prefix`: optional prefix;\n'    
 '  if not provided the prefix is derived\n'    
 "  from the object's `.name` attribute,\n"    
 '  or is empty if there is no `.name`\n'    
 '\n'    
 '### Method `FlaggedMixin.__getattr__(self, attr)`\n'    
 '\n'    
 'Support .flag_suffix and .flagname_suffix.\n'    
 '\n'    
 '### Method `FlaggedMixin.__setattr__(self, attr, value)`\n'    
 '\n'    
 'Support .flag_suffix=value.\n'    
 '\n'    
 '## Class '    
 '`Flags(collections.abc.MutableMapping,collections.abc.Mapping,collections.abc.Collection,collections.abc.Sized,collections.abc.Iterable,collections.abc.Container,FlaggedMixin)`\n'    
 '\n'    
 'A mapping which directly inspects the flags directory.\n'    
 '\n'    
 '### Method `Flags.__init__(self, flagdir=None, environ=None, lock=None, '    
 'debug=None)`\n'    
 '\n'    
 'Initialise the `Flags` instance.\n'    
 '\n'    
 'Parameters:\n'    
 '* `flagdir`: the directory holding flag state files;\n'    
 '  if omitted use the value from `cs.env.FLAGDIR(environ)`\n'    
 '* `environ`: the environment mapping to use,\n'    
 '  default `os.environ`\n'    
 '* `lock`: a `Lock`like mutex to control multithreaded access;\n'    
 '  if omitted no locking is down\n'    
 '* `debug`: debug mode, default `False`\n'    
 '\n'    
 '### Method `Flags.__getitem__(self, k)`\n'    
 '\n'    
 'Return the truthiness of this flag.\n'    
 'True means a non-empty file exists.\n'    
 '\n'    
 '### Method `Flags.__iter__(self)`\n'    
 '\n'    
 'Iterator returning the flag names in the directory.\n'    
 '\n'    
 '### Method `Flags.__len__(self)`\n'    
 '\n'    
 'Return the number of flag files.\n'    
 '\n'    
 '### Method `Flags.__setitem__(self, k, value)`\n'    
 '\n'    
 'Set the flag value.\n'    
 '\n'    
 '        If true, write `"1\n'    
 '"` to the flag file.\n'    
 '        If false, truncate the flag file.\n'    
 '\n'    
 '### Method `Flags.init(self)`\n'    
 '\n'    
 'Ensure the flag directory exists.\n'    
 '\n'    
 '### Method `Flags.update_prefix(self, prefix, updates, '    
 'omitted_value=False)`\n'    
 '\n'    
 'Update all flag values commencing with `prefix`,\n'    
 'falsifying any unmentioned flags.\n'    
 '\n'    
 'Parameters:\n'    
 '* `prefix`: common prefix for updated flags.\n'    
 '* `updates`: iterable of `(flagname,flagvalue)`.\n'    
 '* `omitted_value`: value to be assigned to any unmentioned flags,\n'    
 '  default `False`.\n'    
 '  Set this to `None` to leave unmentioned flags alone.\n'    
 '\n'    
 '## Function `lowername(s)`\n'    
 '\n'    
 "Lowercase letters, transmute '_' to '-'. Note: NOT the reverse of "    
 'uppername.\n'    
 '\n'    
 '## Function `main(argv=None)`\n'    
 '\n'    
 'Main program: inspect or modify flags.\n'    
 '\n'    
 '## Function `main_flagset(argv=None, stdin=None)`\n'    
 '\n'    
 'Main program for "flagset" command.\n'    
 '\n'    
 '## Class `PolledFlags(builtins.dict)`\n'    
 '\n'    
 'A mapping which maintains a dict of the current state of the flags '    
 'directory\n'    
 'and updates it regularly.\n'    
 '\n'    
 'This allows an application to consult the flags very frequently\n'    
 'without hammering the filesystem.\n'    
 '\n'    
 '## Function `truthy(value)`\n'    
 '\n'    
 'Decide whether a value is considered true.\n'    
 '\n'    
 'Strings are converted to:\n'    
 "* `'0'`: `False`\n"    
 "* `'1'`: `True`\n"    
 "* `'true'`: `True` (case insensitive)\n"    
 "* `'false'`: `False` (case insensitive)\n"    
 '* other string values are unchanged.\n'    
 '\n'    
 'Other types are converted with `bool()`.\n'    
 '\n'    
 '## Function `uppername(s)`\n'    
 '\n'    
 "Uppercase letters, transmute some characters to '_' or '__'.\n"    
 '\n'    
 '# Release Log\n'    
 '\n'    
 '\n'    
 '\n'    
 '*Release 20201228*:\n'    
 'Import fix.\n'    
 '\n'    
 '*Release 20190729*:\n'    
 'Python 2 backport for super call. Other minor changes.\n'    
 '\n'    
 '*Release 20190220*:\n'    
 'FlaggedMixin: make .flags_prefix public; document mixin attributes.\n'    
 '\n'    
 '*Release 20181109*:\n'    
 'Assorted minor updates.\n'    
 '\n'    
 '*Release 20170906.2*:\n'    
 'tweak docstring\n'    
 '\n'    
 '*Release 20170906.1*:\n'    
 'Improve module docstring.\n'    
 '\n'    
 '*Release 20170906*:\n'    
 'Fill out module docstring.\n'    
 '\n'    
 '*Release 20170905*:\n'    
 'Initial PyPI release.'),
  classifiers = ['Programming Language :: Python', 'Programming Language :: Python :: 2', 'Programming Language :: Python :: 3', 'Development Status :: 4 - Beta', 'Intended Audience :: Developers', 'Operating System :: OS Independent', 'Topic :: Software Development :: Libraries :: Python Modules', 'License :: OSI Approved :: GNU General Public License v3 or later (GPLv3+)'],
  entry_points = {'console_scripts': ['flagset = cs.app.flag:main_flagset']},
  install_requires = ['cs.env', 'cs.lex', 'cs.pfx'],
  keywords = ['python2', 'python3'],
  license = 'GNU General Public License v3 or later (GPLv3+)',
  long_description_content_type = 'text/markdown',
  package_dir = {'': 'lib/python'},
  py_modules = ['cs.app.flag'],
)
