from typing import List, Optional, Union

import terrascript.core as core


@core.resource(type="aws_route53_traffic_policy", namespace="aws_route53")
class TrafficPolicy(core.Resource):

    comment: Optional[Union[str, core.StringOut]] = core.attr(str, default=None)

    document: Union[str, core.StringOut] = core.attr(str)

    id: Union[str, core.StringOut] = core.attr(str, computed=True)

    name: Union[str, core.StringOut] = core.attr(str)

    type: Union[str, core.StringOut] = core.attr(str, computed=True)

    version: Union[int, core.IntOut] = core.attr(int, computed=True)

    def __init__(
        self,
        resource_name: str,
        *,
        document: Union[str, core.StringOut],
        name: Union[str, core.StringOut],
        comment: Optional[Union[str, core.StringOut]] = None,
        depends_on: Optional[Union[List[str], core.ArrayOut[core.StringOut]]] = None,
        provider: Optional[Union[str, core.StringOut]] = None,
        lifecycle: Optional[core.Lifecycle] = None,
    ):
        super().__init__(
            name=resource_name,
            args=TrafficPolicy.Args(
                document=document,
                name=name,
                comment=comment,
                depends_on=depends_on,
                provider=provider,
                lifecycle=lifecycle,
            ),
        )

    @core.schema_args
    class Args(core.Resource.Args):
        comment: Optional[Union[str, core.StringOut]] = core.arg(default=None)

        document: Union[str, core.StringOut] = core.arg()

        name: Union[str, core.StringOut] = core.arg()
