from typing import List, Optional, Union

import terrascript.core as core


@core.resource(type="aws_ecr_pull_through_cache_rule", namespace="aws_ecr")
class PullThroughCacheRule(core.Resource):

    ecr_repository_prefix: Union[str, core.StringOut] = core.attr(str)

    id: Union[str, core.StringOut] = core.attr(str, computed=True)

    registry_id: Union[str, core.StringOut] = core.attr(str, computed=True)

    upstream_registry_url: Union[str, core.StringOut] = core.attr(str)

    def __init__(
        self,
        resource_name: str,
        *,
        ecr_repository_prefix: Union[str, core.StringOut],
        upstream_registry_url: Union[str, core.StringOut],
        depends_on: Optional[Union[List[str], core.ArrayOut[core.StringOut]]] = None,
        provider: Optional[Union[str, core.StringOut]] = None,
        lifecycle: Optional[core.Lifecycle] = None,
    ):
        super().__init__(
            name=resource_name,
            args=PullThroughCacheRule.Args(
                ecr_repository_prefix=ecr_repository_prefix,
                upstream_registry_url=upstream_registry_url,
                depends_on=depends_on,
                provider=provider,
                lifecycle=lifecycle,
            ),
        )

    @core.schema_args
    class Args(core.Resource.Args):
        ecr_repository_prefix: Union[str, core.StringOut] = core.arg()

        upstream_registry_url: Union[str, core.StringOut] = core.arg()
