from typing import List, Optional, Union

import terrascript.core as core


@core.resource(type="aws_prometheus_rule_group_namespace", namespace="aws_amp")
class PrometheusRuleGroupNamespace(core.Resource):

    data: Union[str, core.StringOut] = core.attr(str)

    id: Union[str, core.StringOut] = core.attr(str, computed=True)

    name: Union[str, core.StringOut] = core.attr(str)

    workspace_id: Union[str, core.StringOut] = core.attr(str)

    def __init__(
        self,
        resource_name: str,
        *,
        data: Union[str, core.StringOut],
        name: Union[str, core.StringOut],
        workspace_id: Union[str, core.StringOut],
        depends_on: Optional[Union[List[str], core.ArrayOut[core.StringOut]]] = None,
        provider: Optional[Union[str, core.StringOut]] = None,
        lifecycle: Optional[core.Lifecycle] = None,
    ):
        super().__init__(
            name=resource_name,
            args=PrometheusRuleGroupNamespace.Args(
                data=data,
                name=name,
                workspace_id=workspace_id,
                depends_on=depends_on,
                provider=provider,
                lifecycle=lifecycle,
            ),
        )

    @core.schema_args
    class Args(core.Resource.Args):
        data: Union[str, core.StringOut] = core.arg()

        name: Union[str, core.StringOut] = core.arg()

        workspace_id: Union[str, core.StringOut] = core.arg()
