# AUTOGENERATED! DO NOT EDIT! File to edit: 01_cli.ipynb (unless otherwise specified).

__all__ = ['dashapp']

# Cell
from .core import *

# Cell

import os
import webbrowser
from pathlib import Path
import click

# Cell


@click.command()
@click.argument("dashboard_yaml", nargs=1, required=False)
@click.option("--no-browser", "-nb", "no_browser", is_flag=True,
                 help="Launch a dashboard, but do not launch a browser.")
@click.option("--try-pickles", "-tp", "try_pickles", is_flag=True,
                 help="if DashFigureFactory parameter config has filepath defined, try to load it from pickle.")
@click.option("--force-pickles", "-fp", "force_pickles", is_flag=True,
                 help="if DashFigureFactory parameter config has filepath defined, load it from pickle or raise exception.")
@click.option("--querystrings", "-q", "querystrings", is_flag=True,
                 help="Store state in url querystring")
@click.option("--bootstrap", "-b", "bootstrap", is_flag=True,
                 help="include default bootstrap css")
@click.option("--port", "-p", "port", default=None, type=click.INT,
                help="specific port to run dashboard on")
def dashapp(dashboard_yaml, no_browser, try_pickles, force_pickles, querystrings, bootstrap, port):
    """
    dashapp is a CLI tool from the dash_oop_components library, used to launch a dash app from the commandline.

    You first need to store your dash app to a config yaml file using e.g

    \b
        db = DashApp(dashboard_component, port=8000)
        db.to_yaml("dashboard.yaml")

    \b
    You can then run the app directly from the commandline with and open it in a browser:

        $ dashapp dashboard.yaml

    or try the load figure factory from pickle:

        $ dashapp --try-pickles dashboard.yaml


    You can also store and run a DashComponent, by saving it to yaml:

    \b
        dashboard_component = CovidDashboard(plot_factory)
        dashboard_component.to_yaml("dashboard_component.yaml")

    And running it:

        $ dashapp dashboard_component.yaml

    To include the bootstrap css and store parameters in url querystring:

        $ dashapp dashboard_component.yaml --querystrings --bootstrap

    If you follow the naming convention of storing the yaml to `dashboard.yaml`,
    or `dashboard_component.yaml`, you can omit the argument and simply run:

        $ dashapp
    """
    if dashboard_yaml is None:
        if (Path().cwd() / "dashboard.yaml").exists():
            dashboard_yaml = Path().cwd() / "dashboard.yaml"
        elif (Path().cwd() / "dashboard_component.yaml").exists():
            dashboard_yaml = Path().cwd() / "dashboard_component.yaml"
        else:
            click.echo("No argument given and could find neither a "
                    "default filename dashboard.yaml or dashboard_component.yaml."
                    "Try `dashapp --help` for options. Aborting.")
            return

    if not str(dashboard_yaml).endswith(".yaml"):
        click.echo("you need to pass a .yaml file to start a dashboard! Aborting.")
        return

    kwargs = {}
    if try_pickles: kwargs["try_pickles"] = True
    if force_pickles: kwargs["force_pickles"] = True

    dashboard_component = DashComponentBase.from_yaml(dashboard_yaml, **kwargs)
    if isinstance(dashboard_component, DashApp):
        db = dashboard_component
    elif isinstance(dashboard_component, DashComponent):
        db_kwargs = {}
        if querystrings: db_kwargs["querystrings"] = True
        if bootstrap: db_kwargs["bootstrap"] = True

        db = DashApp(dashboard_component, **db_kwargs)

    if port is None:
        port =  db.port
        if port is None:
            port = 8050

    import socket
    sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    sock.settimeout(2)
    result = sock.connect_ex(('127.0.0.1',port))
    if result == 0:
        click.echo(f"dashapp ===> Port {port} already in use! Please override with e.g. --port {port+1}")
        return

    if not no_browser and not os.environ.get("WERKZEUG_RUN_MAIN"):
        click.echo(f"explainerdashboard ===> launching browser at {f'http://localhost:{port}/'}")
        webbrowser.open_new(f"http://localhost:{port}/")

    click.echo(f"dashapp ===> Starting dashboard:")

    db.run(port)