# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2025-10-29T17:38:59+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union
from uuid import UUID

import datetime
from pydantic import BaseModel, EmailStr, Field, RootModel, SecretStr
from typing_extensions import Annotated


class Account(BaseModel):
    """
    Account Information used when submitting requests to external services
    or the blockchain.

    `alias`: If present and a user needs to make a request as themselves, then this is used
    to reference a custodial wallet by alias.

    `org`: Organisation name to scope the alias by.
    If `alias` is present, this is used to further constrain the alias to an organisation
    wallet.

    `public_key`: Used for situations where a public key or address is needed for inputs to blockchain calls, specifically
    when creating a resource on-chain where the resource NFT token is transferred to this address when initially
    minted. If alias is not present, this address is considered to be a non-custodial wallet that will perform
    client side signing and as a result, the response will contain the prepared transaction dictionary for the client
    to sign.
    """

    public_key: Annotated[Optional[str], Field(None, title='Public Key')]
    alias: Annotated[Optional[str], Field(None, title='Alias')]
    org: Annotated[Optional[str], Field(None, title='Org')]


class Op(str, Enum):
    EQ = 'EQ'
    NE = 'NE'
    GT = 'GT'
    LT = 'LT'
    GTE = 'GTE'
    LTE = 'LTE'


class ApiCriteria(BaseModel):
    op: Annotated[Op, Field(title='Op')]
    value: Annotated[Union[str, int, bool], Field(title='Value')]


class BodyUploadFilesV1DomainsDomainNameBundlesUidFilesUploadPut(BaseModel):
    files: Annotated[List[bytes], Field(title='Files')]


class BodyUploadOrgFilesV1DomainsDomainNameOrganisationsOrganisationNameBundlesUidFilesUploadPut(
    BaseModel
):
    files: Annotated[List[bytes], Field(title='Files')]


class BundleAccessError(BaseModel):
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    resource_id: Annotated[Optional[str], Field(None, title='Resource Id')]
    reason: Annotated[Optional[str], Field(None, title='Reason')]
    error: Annotated[Optional[str], Field(None, title='Error')]


class BundleDomain(BaseModel):
    name: Annotated[str, Field(title='Name')]
    id: Annotated[UUID, Field(title='Id')]


class BundleEventModel(BaseModel):
    """
    The BundleEventModel represents an on chain event
    associated with a bundle.

    * `bundle_id` - the bundle the event is associated with.
    * `type` - the event type, or name of the event.
    * `transaction` - the hash of the transaction the event appeared in.
    * `trigger` - the trigger for the event - typically a smart contract method name.
    * `data` - the fields and values of the event.
    * `created_at` - when the event was recorded on chain.
    """

    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    bundle_id: Annotated[UUID, Field(title='Bundle Id')]
    type: Annotated[str, Field(title='Type')]
    transaction: Annotated[Optional[str], Field(None, title='Transaction')]
    trigger: Annotated[Optional[str], Field(None, title='Trigger')]
    data: Annotated[Optional[Dict[str, Any]], Field({}, title='Data')]


class BundleOrganisation(BaseModel):
    name: Annotated[str, Field(title='Name')]
    id: Annotated[UUID, Field(title='Id')]


class BundleStorage(BaseModel):
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    name: Annotated[str, Field(title='Name')]
    enabled: Annotated[bool, Field(title='Enabled')]


class BundleUser(BaseModel):
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    email: Annotated[Optional[EmailStr], Field(None, title='Email')]
    simba_id: Annotated[Optional[str], Field(None, title='Simba Id')]
    name: Annotated[Optional[str], Field(None, title='Name')]


class Configuration(BaseModel):
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    name: Annotated[str, Field(title='Name')]
    config: Annotated[Dict[str, Any], Field(title='Config')]


class ConfigurationModel(BaseModel):
    name: Annotated[str, Field(title='Name')]
    config: Annotated[Dict[str, Any], Field(title='Config')]


class CreateBundleAnnotation(BaseModel):
    on_behalf_simba_id: Annotated[str, Field(title='On Behalf Simba Id')]
    annotations: Annotated[str, Field(title='Annotations')]
    token: Annotated[Optional[str], Field(None, title='Token')]
    access_history_id: Annotated[Optional[UUID], Field(None, title='Access History Id')]


class CreateResourceBundleRequest(BaseModel):
    name: Annotated[str, Field(title='Name')]
    resource_id: Annotated[Optional[str], Field(None, title='Resource Id')]
    storage_name: Annotated[Optional[str], Field(None, title='Storage Name')]
    profile_id: Annotated[Optional[UUID], Field(None, title='Profile Id')]
    container: Annotated[Optional[str], Field(None, title='Container')]
    tags: Annotated[Optional[List[str]], Field([], title='Tags')]
    event_tags: Annotated[Optional[List[str]], Field([], title='Event Tags')]
    visible: Annotated[Optional[bool], Field(True, title='Visible')]
    private: Annotated[Optional[bool], Field(False, title='Private')]
    redact: Annotated[Optional[List[str]], Field([], title='Redact')]
    versioning: Annotated[Optional[bool], Field(False, title='Versioning')]
    account: Optional[Account] = None


class CreateStorageRequest(BaseModel):
    name: Annotated[str, Field(title='Name')]
    type_name: Annotated[str, Field(title='Type Name')]
    config: Annotated[Optional[Dict[str, Any]], Field({}, title='Config')]
    default: Annotated[Optional[bool], Field(False, title='Default')]


class CreateStorageType(BaseModel):
    name: Annotated[str, Field(title='Name')]
    description: Annotated[str, Field(title='Description')]
    config_description: Annotated[
        Optional[Dict[str, Any]], Field({}, title='Config Description')
    ]
    adapter: Annotated[str, Field(title='Adapter')]
    container_pattern: Annotated[Optional[str], Field(None, title='Container Pattern')]


class DomainOutput(BaseModel):
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    name: Annotated[str, Field(title='Name')]


class DomainConfigStatus(str, Enum):
    RUNNING = 'RUNNING'
    COMPLETED = 'COMPLETED'
    PARTIAL = 'PARTIAL'
    FAILED = 'FAILED'
    NONE = 'NONE'


class PoliciesStoreType(str, Enum):
    inmemory = 'inmemory'
    onchain = 'onchain'


class DomainConfiguration(BaseModel):
    policies_store_type: Annotated[
        Optional[PoliciesStoreType], Field(None, title='Policies Store Type')
    ]
    admin_account_alias: Annotated[
        Optional[str], Field(None, title='Admin Account Alias')
    ]
    admin_account_address: Annotated[
        Optional[str], Field(None, title='Admin Account Address')
    ]
    admin_account_org: Annotated[Optional[str], Field(None, title='Admin Account Org')]
    platform_org: Annotated[Optional[str], Field(None, title='Platform Org')]
    policy_app: Annotated[Optional[str], Field(None, title='Policy App')]
    policy_contract: Annotated[Optional[str], Field(None, title='Policy Contract')]
    policy_contract_design_id: Annotated[
        Optional[str], Field(None, title='Policy Contract Design Id')
    ]
    policy_contract_address: Annotated[
        Optional[str], Field(None, title='Policy Contract Address')
    ]
    policy_contract_version: Annotated[
        Optional[int], Field(2, title='Policy Contract Version')
    ]
    blockchain: Annotated[Optional[str], Field(None, title='Blockchain')]
    platform_api_base_uri: Annotated[
        Optional[str], Field(None, title='Platform Api Base Uri')
    ]
    platform_auth_base_uri: Annotated[
        Optional[str], Field(None, title='Platform Auth Base Uri')
    ]
    platform_client_id: Annotated[
        Optional[str], Field(None, title='Platform Client Id')
    ]
    platform_client_secret: Annotated[
        Optional[Union[str, SecretStr]], Field(None, title='Platform Client Secret')
    ]
    platform_auth_provider: Annotated[
        Optional[str], Field('PLAT', title='Platform Auth Provider')
    ]


class DomainConfigurationRequest(BaseModel):
    policies_store_type: Annotated[
        Optional[PoliciesStoreType], Field(None, title='Policies Store Type')
    ]
    admin_account_alias: Annotated[
        Optional[str], Field(None, title='Admin Account Alias')
    ]
    admin_account_address: Annotated[
        Optional[str], Field(None, title='Admin Account Address')
    ]
    admin_account_org: Annotated[Optional[str], Field(None, title='Admin Account Org')]
    platform_org: Annotated[Optional[str], Field(None, title='Platform Org')]
    policy_app: Annotated[Optional[str], Field(None, title='Policy App')]
    policy_contract: Annotated[Optional[str], Field(None, title='Policy Contract')]
    policy_contract_design_id: Annotated[
        Optional[str], Field(None, title='Policy Contract Design Id')
    ]
    policy_contract_address: Annotated[
        Optional[str], Field(None, title='Policy Contract Address')
    ]
    policy_contract_version: Annotated[
        Optional[int], Field(2, title='Policy Contract Version')
    ]
    blockchain: Annotated[Optional[str], Field(None, title='Blockchain')]
    status: DomainConfigStatus


class InternalSchemaModel(BaseModel):
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    domain: Annotated[str, Field(title='Domain')]
    name: Annotated[str, Field(title='Name')]
    data_type: Annotated[str, Field(title='Data Type')]
    data: Annotated[str, Field(title='Data')]


class ManifestFile(BaseModel):
    alg: Annotated[str, Field(title='Alg')]
    digest: Annotated[Optional[str], Field('hex', title='Digest')]
    uid: Annotated[str, Field(title='Uid')]
    mime: Annotated[str, Field(title='Mime')]
    name: Annotated[str, Field(title='Name')]
    hash: Annotated[str, Field(title='Hash')]
    size: Annotated[int, Field(title='Size')]
    time: Annotated[int, Field(title='Time')]


class MerkleTreeModel(BaseModel):
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    bundle_id: Annotated[UUID, Field(title='Bundle Id')]
    type: Annotated[str, Field(title='Type')]
    root: Annotated[Optional[str], Field(None, title='Root')]
    values: Annotated[Optional[Dict[str, Any]], Field({}, title='Values')]
    nodes: Annotated[Optional[Dict[str, Any]], Field({}, title='Nodes')]


class Organisation(BaseModel):
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    name: Annotated[str, Field(title='Name')]


class Total(RootModel[int]):
    root: Annotated[int, Field(ge=0, title='Total')]


class Page(RootModel[int]):
    root: Annotated[int, Field(ge=1, title='Page')]


class Size(RootModel[int]):
    root: Annotated[int, Field(ge=1, title='Size')]


class Pages(RootModel[int]):
    root: Annotated[int, Field(ge=0, title='Pages')]


class PageBundleAccessError(BaseModel):
    items: Annotated[List[BundleAccessError], Field(title='Items')]
    total: Annotated[Optional[Total], Field(title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]


class PageBundleEventModel(BaseModel):
    items: Annotated[List[BundleEventModel], Field(title='Items')]
    total: Annotated[Optional[Total], Field(title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]


class PageDomain(BaseModel):
    items: Annotated[List[DomainOutput], Field(title='Items')]
    total: Annotated[Optional[Total], Field(title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]


class PageOrganisation(BaseModel):
    items: Annotated[List[Organisation], Field(title='Items')]
    total: Annotated[Optional[Total], Field(title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]


class PingResponse(BaseModel):
    component: Annotated[str, Field(title='Component')]
    success: Annotated[bool, Field(title='Success')]
    error: Annotated[Optional[str], Field(None, title='Error')]


class PingResponses(BaseModel):
    service: Annotated[str, Field(title='Service')]
    responses: Annotated[List[PingResponse], Field(title='Responses')]


class Junction(str, Enum):
    AND = 'AND'
    OR = 'OR'


class DataType(str, Enum):
    INT = 'INT'
    BOOL = 'BOOL'
    STR = 'STR'


class Policy(BaseModel):
    """
    The policy `identifier` is the 16 byte value derived from the URL the policy's schema is available at.

    The `dataType` is used to identify the data type of the criteria values. Allowed values are:
    * `INT`
    * `STR`
    * `BOOL`

    Criteria are a list of tuples, made up of an operator and a value. Operators are one of:

    * `EQ` - equal
    * `NE`  - not equal
    * `GT` - greater than
    * `LT` - less than
    * `GTE` - greater than or equal
    * `LTE` - less than or equal

    For types `STR` AND `BOOL`, only `EQ` and `NE` are allowed. All operators are allowed for the numeric `INT`
    type.

    The junction value can be either `AND` or `OR`. It determines how the list of criteria are joined.

    The simplicity of the policy structure is a result of evaluation taking place on chain.

    All values are converted to integers before on-chain evaluation with boolean becoming `1` true or `0` false.
    String values are converted to large integers by converting a keccak256 hash of the string to an integer.

    Policies associated with a resource are stored in the database where they can be edited before publication.
    They are keyed to their identifier and therefore two policies for the same policy ID is not allowed.
    """

    identifier: Annotated[str, Field(title='Identifier')]
    junction: Annotated[Junction, Field(title='Junction')]
    dataType: Annotated[DataType, Field(title='Datatype')]
    criteria: Annotated[List[ApiCriteria], Field(title='Criteria')]
    name: Annotated[Optional[str], Field(None, title='Name')]
    definition: Annotated[Optional[str], Field(None, title='Definition')]


class Presentation(BaseModel):
    id: Annotated[Optional[Union[Dict[str, Any], str]], Field(None, title='Id')]
    field_context: Annotated[
        Optional[Union[str, Any]], Field(None, alias='@context', title='@Context')
    ]
    proof: Annotated[Any, Field(None, title='Proof')]
    type: Annotated[Any, Field(None, title='Type')]
    verifiableCredential: Annotated[Any, Field(None, title='Verifiablecredential')]


class ProofSerialization(str, Enum):
    SMT_POSEIDON_CIRCOM = 'SMT_POSEIDON_CIRCOM'
    SMT_POSEIDON_CIRCOM_CONCISE = 'SMT_POSEIDON_CIRCOM_CONCISE'
    SMT_POSEIDON = 'SMT_POSEIDON'
    MT_KECCAK_ZIPPED = 'MT_KECCAK_ZIPPED'
    MT_KECCAK = 'MT_KECCAK'
    MT_OZ = 'MT_OZ'


class ProposeTransferRequest(BaseModel):
    """
    A request to transfer a bundle to another user and/or organisation. The request is scoped by domain and optionally
    an organisation.

    If the `receiver_organisation_name` is specified and the `receiver_email` or `receiver_id` is not, it can be received by any member of the org.

    If the `receiver_email` or `receiver_id` is specified and the `receiver_organisation_name` is specified,
    it can only be received by the user and only if the user is a member of the organisation.

    If the `receiver_email` or `receiver_id` is specified and the `receiver_organisation_name` is not, it can be received by the user if
    the user is in the domain.

    The Account information is used to determine which address, wallet or on-behalf-of
    values should be used when submitting a transfer request. This account info must pertain to the current
    owner of the bundle NFT token.


    * `account` is the account associated with the bundle owner on chain. If not present,
        an account must be already associated with the bundle.
    * `receiver_email` is an optional email to receive the transfer
    * `receiver_id` is an optional simba_id to receive the transfer
    * `receiver_organisation_name` is an optional organisation to receive the transfer.

    One of `receiver_email` or `receiver_id` or `receiver_organisation_name` is required
    """

    account: Optional[Account] = None
    receiver_email: Annotated[Optional[EmailStr], Field(None, title='Receiver Email')]
    receiver_id: Annotated[Optional[str], Field(None, title='Receiver Id')]
    receiver_organisation_name: Annotated[
        Optional[str], Field(None, title='Receiver Organisation Name')
    ]


class PublicDomain(BaseModel):
    name: Annotated[str, Field(title='Name')]


class PublicManifestFile(BaseModel):
    alg: Annotated[Optional[str], Field(None, title='Alg')]
    digest: Annotated[Optional[str], Field(None, title='Digest')]
    uid: Annotated[Optional[str], Field(None, title='Uid')]
    mime: Annotated[Optional[str], Field(None, title='Mime')]
    name: Annotated[Optional[str], Field(None, title='Name')]
    hash: Annotated[Optional[str], Field(None, title='Hash')]
    size: Annotated[Optional[int], Field(None, title='Size')]
    time: Annotated[Optional[int], Field(None, title='Time')]


class PublicOrganisation(BaseModel):
    name: Annotated[str, Field(title='Name')]


class PublicUser(BaseModel):
    email: Annotated[Optional[EmailStr], Field(None, title='Email')]


class Action(str, Enum):
    publish = 'publish'
    unpublish = 'unpublish'
    burn = 'burn'


class PublicationRequest(BaseModel):
    """
    A request to publish a bundle. This can be either an
    `unpublish`, `burn` or `publish` request, determined by the action field.

    The `burn` action removes the resource from chain. The `unpublish` clears the policies and
    thumbprint on chain but leaves the resource ID.

    In both cases, the bundle's `published` field is set to false and the bundle will not be
    available for shared access. In the case of `publish` the current policies and thumbprint are
    submitted to chain and the `published` field is set to true.

    The Account information is used to determine which addresses, wallets or on-behalf-of
    values should be used when submitting a publication request. The details
    of this can vary depending on whether the bundle has been previously
    published or not. If not present, then an account must already be associated with the bundle

    If `clear_draft` is set to true, then the draft manifest and draft hash will be cleared
    on successful publication.
    """

    action: Annotated[Action, Field(title='Action')]
    account: Optional[Account] = None
    clear_draft: Annotated[Optional[bool], Field(None, title='Clear Draft')]


class RedactedDomainConfiguration(BaseModel):
    policies_store_type: Annotated[
        Optional[PoliciesStoreType], Field(None, title='Policies Store Type')
    ]
    admin_account_alias: Annotated[
        Optional[str], Field(None, title='Admin Account Alias')
    ]
    admin_account_address: Annotated[
        Optional[str], Field(None, title='Admin Account Address')
    ]
    admin_account_org: Annotated[Optional[str], Field(None, title='Admin Account Org')]
    platform_org: Annotated[Optional[str], Field(None, title='Platform Org')]
    policy_app: Annotated[Optional[str], Field(None, title='Policy App')]
    policy_contract: Annotated[Optional[str], Field(None, title='Policy Contract')]
    policy_contract_design_id: Annotated[
        Optional[str], Field(None, title='Policy Contract Design Id')
    ]
    policy_contract_address: Annotated[
        Optional[str], Field(None, title='Policy Contract Address')
    ]
    policy_contract_version: Annotated[
        Optional[int], Field(2, title='Policy Contract Version')
    ]
    blockchain: Annotated[Optional[str], Field(None, title='Blockchain')]
    platform_api_base_uri: Annotated[
        Optional[str], Field(None, title='Platform Api Base Uri')
    ]
    platform_auth_base_uri: Annotated[
        Optional[str], Field(None, title='Platform Auth Base Uri')
    ]
    platform_client_id: Annotated[
        Optional[str], Field(None, title='Platform Client Id')
    ]
    platform_client_secret: Annotated[
        Optional[Union[str, SecretStr]], Field(None, title='Platform Client Secret')
    ]
    platform_auth_provider: Annotated[
        Optional[str], Field('PLAT', title='Platform Auth Provider')
    ]


class ResourceProof(BaseModel):
    """
    A Resource Proof is an identifier to some data along with a proof value
    that is stored as an NFT onchain.

    Resource Proofs are immutable and cannot be updated or removed.
    """

    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    resource_id: Annotated[str, Field(title='Resource Id')]
    proof: Annotated[str, Field(title='Proof')]
    proof_type: Annotated[str, Field(title='Proof Type')]
    proof_fields: Annotated[Optional[Dict[str, Any]], Field(None, title='Proof Fields')]
    resource_type: Annotated[Optional[str], Field(None, title='Resource Type')]
    resource_reference: Annotated[
        Optional[str], Field(None, title='Resource Reference')
    ]
    publishing: Annotated[Optional[bool], Field(False, title='Publishing')]
    republish: Annotated[Optional[bool], Field(False, title='Republish')]
    domain: BundleDomain
    owner: Optional[BundleUser] = None
    organisation: Optional[BundleOrganisation] = None
    tree_id: Annotated[Optional[UUID], Field(None, title='Tree Id')]
    token_id: Annotated[Optional[str], Field(None, title='Token Id')]
    token_collection: Annotated[Optional[str], Field(None, title='Token Collection')]
    token_owner: Annotated[Optional[str], Field(None, title='Token Owner')]
    did: Annotated[Optional[str], Field(None, title='Did')]
    published_policy_keys: Annotated[
        Optional[List[str]], Field([], title='Published Policy Keys')
    ]
    policies: Annotated[Optional[List[Policy]], Field([], title='Policies')]
    account: Optional[Account] = None


class ResourceProofEventModel(BaseModel):
    """
    The ResourceProofEventModel represents an on chain event
    associated with a resource proof creation.

    * `resource_proof_id` - the resource proof the event is associated with.
    * `type` - the event type, or name of the event.
    * `transaction` - the hash of the transaction the event appeared in.
    * `trigger` - the trigger for the event - typically a smart contract method name.
    * `data` - the fields and values of the event.
    * `created_at` - when the event was recorded on chain.
    """

    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    resource_proof_id: Annotated[UUID, Field(title='Resource Proof Id')]
    type: Annotated[str, Field(title='Type')]
    transaction: Annotated[Optional[str], Field(None, title='Transaction')]
    trigger: Annotated[Optional[str], Field(None, title='Trigger')]
    data: Annotated[Optional[Dict[str, Any]], Field({}, title='Data')]


class ResourceProofProfile(BaseModel):
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    name: Annotated[str, Field(title='Name')]
    proof_type: Annotated[str, Field(title='Proof Type')]
    policies: Annotated[Optional[List[Policy]], Field([], title='Policies')]
    domain_id: Annotated[UUID, Field(title='Domain Id')]
    organisation_id: Annotated[Optional[UUID], Field(None, title='Organisation Id')]
    account: Optional[Account] = None


class SchemaDataType(str, Enum):
    SCHEMA = 'SCHEMA'
    VOCAB = 'VOCAB'
    REGISTRY_ENTRY = 'REGISTRY_ENTRY'


class SchemaEditResponse(BaseModel):
    ids: Annotated[List[UUID], Field(title='Ids')]


class SchemaSetRequest(BaseModel):
    claim: Annotated[str, Field(title='Claim')]
    vocab: Annotated[str, Field(title='Vocab')]
    registry_entry: Annotated[str, Field(title='Registry Entry')]


class StorageType(BaseModel):
    """
    A Storage type is a binding to a backend storage implementation.

    Storage type names are unique.
    The storage type adapter is a qualified class name of a BundleAdapter
    implementation. This must be on the python path.

    The container pattern is a regex defining the allowed structure of container names
    created in this storage type. At minimum, these must support '^[a-z0-9\-]{3,63}$'.

    As well as a general description field, a storage type
    has a config description dictionary to describe the fields of the configuration.
    """

    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    name: Annotated[str, Field(title='Name')]
    description: Annotated[str, Field(title='Description')]
    config_description: Annotated[
        Optional[Dict[str, Any]], Field({}, title='Config Description')
    ]
    adapter: Annotated[str, Field(title='Adapter')]
    container_pattern: Annotated[Optional[str], Field(None, title='Container Pattern')]


class StorageTypeView(BaseModel):
    name: Annotated[str, Field(title='Name')]
    description: Annotated[str, Field(title='Description')]
    config_description: Annotated[
        Optional[Dict[str, Any]], Field({}, title='Config Description')
    ]


class StorageView(BaseModel):
    name: Annotated[str, Field(title='Name')]
    domain: BundleDomain
    default: Annotated[Optional[bool], Field(None, title='Default')]
    organisation: Optional[BundleOrganisation] = None
    storage_type: StorageTypeView


class SuspendExternalProcessManagement(BaseModel):
    suspend: Annotated[bool, Field(title='Suspend')]


class TaskInformationInput(BaseModel):
    files: Annotated[Optional[List[str]], Field([], title='Files')]
    clear_draft: Annotated[Optional[bool], Field(None, title='Clear Draft')]
    tree_id: Annotated[Optional[UUID], Field(None, title='Tree Id')]
    tree_root: Annotated[Optional[str], Field(None, title='Tree Root')]
    new_resource: Annotated[Optional[bool], Field(None, title='New Resource')]


class TaskInformationOutput(RootModel[Any]):
    root: Any


class TaskStatus(str, Enum):
    INITED = 'INITED'
    PENDING = 'PENDING'
    RUNNING = 'RUNNING'
    COMPLETED = 'COMPLETED'
    FAILED = 'FAILED'
    ABORTED = 'ABORTED'


class TaskType(str, Enum):
    UPLOAD_FILES = 'UPLOAD_FILES'
    UPDATE_MANIFEST = 'UPDATE_MANIFEST'
    UPDATE_FILES = 'UPDATE_FILES'
    PUBLISH_PROOF = 'PUBLISH_PROOF'
    SET_PROOF_ROOT = 'SET_PROOF_ROOT'
    PUBLISH = 'PUBLISH'
    UNPUBLISH = 'UNPUBLISH'
    BURN = 'BURN'
    TRANSFER = 'TRANSFER'
    REMOVE = 'REMOVE'
    VERIFICATION = 'VERIFICATION'
    BUILD_TREE = 'BUILD_TREE'


class TokenStatus(str, Enum):
    PENDING = 'PENDING'
    ACTIVE = 'ACTIVE'
    FAILED = 'FAILED'


class TransferState(str, Enum):
    OPEN = 'OPEN'
    SUSPENDED = 'SUSPENDED'
    CLOSED = 'CLOSED'
    ACCEPTED = 'ACCEPTED'
    REJECTED = 'REJECTED'


class TreeNode(BaseModel):
    key: Annotated[Union[str, int, bool], Field(title='Key')]
    value: Annotated[Optional[Union[str, int, bool]], Field(None, title='Value')]


class TreeProofCreation(BaseModel):
    proof_type: ProofSerialization
    key: Annotated[Union[str, int, bool], Field(title='Key')]
    node_name: Annotated[Optional[str], Field(None, title='Node Name')]
    is_index: Annotated[Optional[bool], Field(False, title='Is Index')]


class UpdateBundleFilesRequest(BaseModel):
    removals: Annotated[Optional[List[str]], Field([], title='Removals')]


class UpdateBundleProfileRequest(BaseModel):
    name: Annotated[Optional[str], Field(None, title='Name')]
    storage_name: Annotated[Optional[str], Field(None, title='Storage Name')]
    container: Annotated[Optional[str], Field(None, title='Container')]
    tags: Annotated[Optional[List[str]], Field([], title='Tags')]
    visible: Annotated[Optional[bool], Field(True, title='Visible')]
    private: Annotated[Optional[bool], Field(False, title='Private')]
    redact: Annotated[Optional[List[str]], Field([], title='Redact')]
    versioning: Annotated[Optional[bool], Field(False, title='Versioning')]
    policies: Annotated[Optional[List[Policy]], Field([], title='Policies')]
    account: Optional[Account] = None


class UpdateBundleTask(BaseModel):
    signed_transaction: Annotated[Dict[str, Any], Field(title='Signed Transaction')]


class UpdateResourceBundleRequest(BaseModel):
    name: Annotated[Optional[str], Field(None, title='Name')]
    tags: Annotated[Optional[List[str]], Field([], title='Tags')]
    event_tags: Annotated[Optional[List[str]], Field([], title='Event Tags')]
    merge_tags: Annotated[Optional[bool], Field(None, title='Merge Tags')]
    visible: Annotated[Optional[bool], Field(None, title='Visible')]
    private: Annotated[Optional[bool], Field(None, title='Private')]
    redact: Annotated[Optional[List[str]], Field(None, title='Redact')]
    versioning: Annotated[Optional[bool], Field(None, title='Versioning')]
    clear_draft: Annotated[Optional[bool], Field(None, title='Clear Draft')]
    account: Optional[Account] = None


class UpdateResourceProofProfileRequest(BaseModel):
    proof_type: Annotated[str, Field(title='Proof Type')]
    name: Annotated[str, Field(title='Name')]
    policies: Annotated[Optional[List[Policy]], Field([], title='Policies')]
    account: Optional[Account] = None


class UpdateResourceProofRequest(BaseModel):
    tree_id: Annotated[UUID, Field(title='Tree Id')]
    publish_root: Annotated[bool, Field(title='Publish Root')]
    account: Optional[Account] = None


class UpdateResourceProofTask(BaseModel):
    signed_transaction: Annotated[Dict[str, Any], Field(title='Signed Transaction')]


class UpdateStorageRequest(BaseModel):
    enabled: Annotated[Optional[bool], Field(None, title='Enabled')]
    config: Annotated[Optional[Dict[str, Any]], Field(None, title='Config')]
    default: Annotated[Optional[bool], Field(None, title='Default')]


class UpdateStorageTypeRequest(BaseModel):
    description: Annotated[Optional[str], Field(None, title='Description')]
    config_description: Annotated[
        Optional[Dict[str, Any]], Field(None, title='Config Description')
    ]
    adapter: Annotated[Optional[str], Field(None, title='Adapter')]


class UpdateTransferRequest(BaseModel):
    """
    Role independent update transfer.
    This payload is converted to a ProposerUpdateTransferRequest or
    a ReceiverUpdateTransferRequest based on the requested role.

    For a proposer, the account is the address to transfer from.
    For a receiver, the account is the address to transfer to.

    Possible states that can be set by a proposer are:

    * OPEN - default initial state
    * SUSPENDED - the proposal cannot be edited until it is opened again
    * CLOSED - the proposal is closed. No further changes/updates can be made.

    Possible states that can be set by a receiver are:

    * ACCEPTED - accept the transfer. If a receiver account has been set or is sent in
        this payload, and the current state is OPEN, then the transfer will be attempted.
    * REJECTED - the proposal is rejected and cannot continue.
    """

    account: Optional[Account] = None
    state: Optional[TransferState] = None


class UpdateTreeBundleRequest(BaseModel):
    name: Annotated[Optional[str], Field(None, title='Name')]
    tags: Annotated[Optional[List[str]], Field([], title='Tags')]
    event_tags: Annotated[Optional[List[str]], Field([], title='Event Tags')]
    merge_tags: Annotated[Optional[bool], Field(None, title='Merge Tags')]
    visible: Annotated[Optional[bool], Field(None, title='Visible')]
    private: Annotated[Optional[bool], Field(None, title='Private')]
    redact: Annotated[Optional[List[str]], Field(None, title='Redact')]
    versioning: Annotated[Optional[bool], Field(None, title='Versioning')]
    clear_draft: Annotated[Optional[bool], Field(None, title='Clear Draft')]
    account: Optional[Account] = None
    additions: Annotated[Optional[List[TreeNode]], Field([], title='Additions')]
    removals: Annotated[Optional[List[TreeNode]], Field([], title='Removals')]
    clear_nodes: Annotated[Optional[bool], Field(False, title='Clear Nodes')]
    notify: Annotated[Optional[bool], Field(False, title='Notify')]


class User(BaseModel):
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    email: Annotated[Optional[EmailStr], Field(None, title='Email')]
    simba_id: Annotated[Optional[str], Field(None, title='Simba Id')]
    name: Annotated[Optional[str], Field(None, title='Name')]


class ValidationError(BaseModel):
    loc: Annotated[List[Union[str, int]], Field(title='Location')]
    msg: Annotated[str, Field(title='Message')]
    type: Annotated[str, Field(title='Error Type')]


class ResourceServiceDomainModelsTreeProofValidation(BaseModel):
    success: Annotated[bool, Field(title='Success')]
    error: Annotated[Optional[str], Field(None, title='Error')]


class ResourceServiceDomainTreesTreesTreeProofValidation(BaseModel):
    proof_type: ProofSerialization
    key: TreeNode
    proof: Annotated[Dict[str, Any], Field(title='Proof')]


class AccessHistoryInput(BaseModel):
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    name: Annotated[str, Field(title='Name')]
    resource_id: Annotated[str, Field(title='Resource Id')]
    file_name: Annotated[Optional[str], Field(None, title='File Name')]
    date_accessed: Annotated[
        Optional[datetime.datetime], Field(None, title='Date Accessed')
    ]
    is_token_valid: Annotated[Optional[bool], Field(False, title='Is Token Valid')]
    policies: Annotated[Optional[List[Policy]], Field([], title='Policies')]


class AccessHistoryOutput(BaseModel):
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    name: Annotated[str, Field(title='Name')]
    resource_id: Annotated[str, Field(title='Resource Id')]
    file_name: Annotated[Optional[str], Field(None, title='File Name')]
    date_accessed: Annotated[
        Optional[datetime.datetime], Field(None, title='Date Accessed')
    ]
    is_token_valid: Annotated[Optional[bool], Field(False, title='Is Token Valid')]
    policies: Annotated[Optional[List[Policy]], Field([], title='Policies')]


class AdminDomain(BaseModel):
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    name: Annotated[str, Field(title='Name')]
    config_status: Optional[DomainConfigStatus] = None
    config: Optional[RedactedDomainConfiguration] = None
    state: Annotated[Optional[Dict[str, Any]], Field(None, title='State')]


class BundleManifest(BaseModel):
    alg: Annotated[str, Field(title='Alg')]
    digest: Annotated[Optional[str], Field('hex', title='Digest')]
    time: Annotated[int, Field(title='Time')]
    files: Annotated[Optional[Dict[str, ManifestFile]], Field({}, title='Files')]


class BundleProfile(BaseModel):
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    name: Annotated[str, Field(title='Name')]
    storage_name: Annotated[str, Field(title='Storage Name')]
    container: Annotated[Optional[str], Field(None, title='Container')]
    tags: Annotated[Optional[List[str]], Field([], title='Tags')]
    visible: Annotated[Optional[bool], Field(True, title='Visible')]
    private: Annotated[Optional[bool], Field(False, title='Private')]
    redact: Annotated[Optional[List[str]], Field([], title='Redact')]
    versioning: Annotated[Optional[bool], Field(False, title='Versioning')]
    policies: Annotated[Optional[List[Policy]], Field([], title='Policies')]
    domain_id: Annotated[UUID, Field(title='Domain Id')]
    organisation_id: Annotated[Optional[UUID], Field(None, title='Organisation Id')]
    account: Optional[Account] = None


class BundleProfileRequest(BaseModel):
    name: Annotated[str, Field(title='Name')]
    storage_name: Annotated[str, Field(title='Storage Name')]
    container: Annotated[Optional[str], Field(None, title='Container')]
    tags: Annotated[Optional[List[str]], Field([], title='Tags')]
    visible: Annotated[Optional[bool], Field(True, title='Visible')]
    private: Annotated[Optional[bool], Field(False, title='Private')]
    redact: Annotated[Optional[List[str]], Field([], title='Redact')]
    versioning: Annotated[Optional[bool], Field(False, title='Versioning')]
    policies: Annotated[Optional[List[Policy]], Field([], title='Policies')]
    account: Optional[Account] = None


class BundleTask(BaseModel):
    """
    A BundleTask represents the state of a task being performed on a resource bundle.

    The `type` field represents the task being performed, e.g. publication, file upload etc.

    The `status` field defines the current state of the task. This can be one of:
    1. INITED - initial state
    2. PENDING - awaiting client side signing
    3. RUNNING - currently executing
    4. COMPLETED - successful completion
    5. FAILED - failed completion
    6. ABORTED - the task has timed out with an unknown error.

    For client side signing, the payload for signing is returned in the `transaction_data`
    field and the signed content sent back the server is expected to be in the
    `signed_transaction` field.
    """

    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    bundle_id: Annotated[UUID, Field(title='Bundle Id')]
    type: TaskType
    status: Optional[TaskStatus] = TaskStatus.INITED
    transaction_id: Annotated[Optional[str], Field(None, title='Transaction Id')]
    transaction_data: Annotated[
        Optional[Dict[str, Any]], Field(None, title='Transaction Data')
    ]
    signed_transaction: Annotated[
        Optional[Dict[str, Any]], Field(None, title='Signed Transaction')
    ]
    error: Annotated[Optional[str], Field(None, title='Error')]
    result: Annotated[Optional[Dict[str, Any]], Field({}, title='Result')]
    information: Optional[TaskInformationOutput] = None


class CreateResourceProofProfileRequest(BaseModel):
    proof_type: Annotated[str, Field(title='Proof Type')]
    name: Annotated[str, Field(title='Name')]
    policies: Annotated[Optional[List[Policy]], Field([], title='Policies')]
    account: Optional[Account] = None


class CreateResourceProofRequest(BaseModel):
    resource_id: Annotated[str, Field(title='Resource Id')]
    proof: Annotated[str, Field(title='Proof')]
    account: Optional[Account] = None
    proof_type: Annotated[str, Field(title='Proof Type')]
    resource_type: Annotated[Optional[str], Field(None, title='Resource Type')]
    resource_reference: Annotated[
        Optional[str], Field(None, title='Resource Reference')
    ]
    proof_fields: Annotated[Optional[Dict[str, Any]], Field(None, title='Proof Fields')]
    policies: Annotated[Optional[List[Policy]], Field(None, title='Policies')]
    profile_id: Annotated[Optional[UUID], Field(None, title='Profile Id')]


class CreateTreeBundleRequest(BaseModel):
    name: Annotated[str, Field(title='Name')]
    resource_id: Annotated[Optional[str], Field(None, title='Resource Id')]
    storage_name: Annotated[Optional[str], Field(None, title='Storage Name')]
    profile_id: Annotated[Optional[UUID], Field(None, title='Profile Id')]
    container: Annotated[Optional[str], Field(None, title='Container')]
    tags: Annotated[Optional[List[str]], Field([], title='Tags')]
    event_tags: Annotated[Optional[List[str]], Field([], title='Event Tags')]
    visible: Annotated[Optional[bool], Field(True, title='Visible')]
    private: Annotated[Optional[bool], Field(False, title='Private')]
    redact: Annotated[Optional[List[str]], Field([], title='Redact')]
    versioning: Annotated[Optional[bool], Field(False, title='Versioning')]
    account: Optional[Account] = None
    nodes: Annotated[List[TreeNode], Field(title='Nodes')]
    tree_type: Annotated[str, Field(title='Tree Type')]
    notify: Annotated[Optional[bool], Field(False, title='Notify')]


class DomainInput(BaseModel):
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    name: Annotated[str, Field(title='Name')]
    config_status: Optional[DomainConfigStatus] = None
    config: Optional[DomainConfiguration] = None
    state: Annotated[Optional[Dict[str, Any]], Field(None, title='State')]


class HTTPValidationError(BaseModel):
    detail: Annotated[Optional[List[ValidationError]], Field(None, title='Detail')]


class ListResourceToken(BaseModel):
    """
    A token is returned to a request for access to a resource bundle.
    A token has an expiry datetime, a status and a value that is used
    when requesting a resource.

    Tokens may not be immediately active on receipt. They can be polled
    to discover their status. Once ACTIVE, and not expired, they can be used.

    Tokens can be associated with a public `key` and a request flow may expect
    the token to be submitted with a signature over the token value before
    allowing resource access.
    """

    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    resource_id: Annotated[str, Field(title='Resource Id')]
    value: Annotated[str, Field(title='Value')]
    expires_at: Annotated[datetime.datetime, Field(title='Expires At')]
    status: TokenStatus
    nonce: Annotated[Optional[str], Field(None, title='Nonce')]


class PageAccessHistory(BaseModel):
    items: Annotated[List[AccessHistoryOutput], Field(title='Items')]
    total: Annotated[Optional[Total], Field(title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]


class PageBundleProfile(BaseModel):
    items: Annotated[List[BundleProfile], Field(title='Items')]
    total: Annotated[Optional[Total], Field(title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]


class PageBundleTask(BaseModel):
    items: Annotated[List[BundleTask], Field(title='Items')]
    total: Annotated[Optional[Total], Field(title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]


class PageListResourceToken(BaseModel):
    items: Annotated[List[ListResourceToken], Field(title='Items')]
    total: Annotated[Optional[Total], Field(title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]


class PageResourceProofEventModel(BaseModel):
    items: Annotated[List[ResourceProofEventModel], Field(title='Items')]
    total: Annotated[Optional[Total], Field(title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]


class PageResourceProofProfile(BaseModel):
    items: Annotated[List[ResourceProofProfile], Field(title='Items')]
    total: Annotated[Optional[Total], Field(title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]


class PageResourceProof(BaseModel):
    items: Annotated[List[ResourceProof], Field(title='Items')]
    total: Annotated[Optional[Total], Field(title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]


class PageStorageTypeView(BaseModel):
    items: Annotated[List[StorageTypeView], Field(title='Items')]
    total: Annotated[Optional[Total], Field(title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]


class PageStorageType(BaseModel):
    items: Annotated[List[StorageType], Field(title='Items')]
    total: Annotated[Optional[Total], Field(title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]


class PageStorageView(BaseModel):
    items: Annotated[List[StorageView], Field(title='Items')]
    total: Annotated[Optional[Total], Field(title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]


class PageUser(BaseModel):
    items: Annotated[List[User], Field(title='Items')]
    total: Annotated[Optional[Total], Field(title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]


class PublicBundleManifest(BaseModel):
    alg: Annotated[Optional[str], Field(None, title='Alg')]
    digest: Annotated[Optional[str], Field(None, title='Digest')]
    time: Annotated[Optional[int], Field(None, title='Time')]
    files: Annotated[Optional[Dict[str, PublicManifestFile]], Field({}, title='Files')]


class ResourceBundle(BaseModel):
    """
    ResourceBundles represent resources that are made up of one or more files, metadata and optional policies
    that control access to the resource.

    Bundles have a user defined name. This is unique within the container defined for the bundle. If a container
    name or path is not specified, one is created automatically. This is constructed from the domain name and
    the user's email or simba ID.

    The bundle name has restrictions on allowed values.
    The default regex to match name input against is `^[a-zA-Z0-9][a-zA-Z0-9.\-_ ]{1,125}[a-zA-Z0-9]$` which means
    alphanumeric values, upper and lower case, dot, dash, underscore and space are allowed and the minimum
    length is 3 and the maximum length is 127.

    Bundles reference the storage backend by name. Storages that are scoped only by domain are available to bundles
    in the domain whether they are scoped by organisation or not.

    Tags are arbitrary labels for the bundle.

    When the `visible` field is set to true, the bundle will be
    available for browsing and downloading at the public endpoints.

    When the `private` field is set to true, the bundle will only be
    visible for viewing and editing at non-public endpoints by the bundle owner. The bundle owner is the logged-in
    user that creates a bundle.

    The `redact` field specified fields to redact when the bundle is made public. Possible redactable fields
    are available at the `/v1/public/redactable_fields` endpoint. Essentially all fields can be redacted
    except the resource id, and the tags, which can be useful for filtering. Note some fields may by default
    not be visible as part of a public view of a bundle. If the redact field is null, then by default the
    `manifest` is redacted. If the field is an empty list, then no fields are redacted.

    The `event_tags` is reserved for future use and can be ignored.

    The `republish` flag is set to true when changes in the database may not be reflected on chain. It is
    set to false after publication.

    To enable versions of bundles, the `versioning` field should be set to true. When true, publication
    results in the old bundle hash being added to the `versions_history` list and - if the version is not being
    reused, e.g. via a rollback - added to the `versions` list. The `versions` list is all known versions of the bundle.
    The `version_history` field is an ordered list of versions that have been published, and may contain
    multiple elements of the same version, if previous versions have been reused during the bundle's history.

    To view version metadata (aka the manifest - the files associated with a version) and delete a previous version,
    use the `versions` field to get a list of the known versions, rather than the `version_history` which can
    contain versions that have since been deleted.

    Versioning can be turned on and off during a bundle's lifetime. Whenever versioning is off, the versions and
    version history will remain unchanged.

    The `resource_id` of a bundle is the unique identifier for it. It is generated on creation based on the domain
    it is scoped by and other input data. A typical bundle resource is structured as
    `<domain>:<name>:<hash-including a random component>`. The resource ID is used to access bundles and bind them
    on chain as NFTs.
    """

    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    owner: Optional[BundleUser] = None
    name: Annotated[str, Field(title='Name')]
    resource_id: Annotated[str, Field(title='Resource Id')]
    container: Annotated[str, Field(title='Container')]
    published: Annotated[Optional[bool], Field(False, title='Published')]
    publishing: Annotated[Optional[bool], Field(False, title='Publishing')]
    republish: Annotated[Optional[bool], Field(False, title='Republish')]
    private: Annotated[Optional[bool], Field(False, title='Private')]
    domain: BundleDomain
    organisation: Optional[BundleOrganisation] = None
    storage: BundleStorage
    visible: Annotated[Optional[bool], Field(True, title='Visible')]
    redact: Annotated[Optional[List[str]], Field(None, title='Redact')]
    tags: Annotated[Optional[List[str]], Field([], title='Tags')]
    event_tags: Annotated[Optional[List[str]], Field([], title='Event Tags')]
    draft_manifest: Optional[BundleManifest] = None
    manifest: Optional[BundleManifest] = None
    draft_hash: Annotated[Optional[str], Field(None, title='Draft Hash')]
    hash: Annotated[Optional[str], Field(None, title='Hash')]
    token_id: Annotated[Optional[str], Field(None, title='Token Id')]
    token_collection: Annotated[Optional[str], Field(None, title='Token Collection')]
    token_owner: Annotated[Optional[str], Field(None, title='Token Owner')]
    did: Annotated[Optional[str], Field(None, title='Did')]
    policies: Annotated[Optional[List[Policy]], Field([], title='Policies')]
    versions: Annotated[Optional[List[str]], Field([], title='Versions')]
    version_history: Annotated[Optional[List[str]], Field([], title='Version History')]
    versioning: Annotated[Optional[bool], Field(False, title='Versioning')]
    account: Optional[Account] = None


class ResourceBundleListingInput(BaseModel):
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    owner: Optional[BundleUser] = None
    name: Annotated[str, Field(title='Name')]
    resource_id: Annotated[str, Field(title='Resource Id')]
    container: Annotated[str, Field(title='Container')]
    published: Annotated[Optional[bool], Field(False, title='Published')]
    publishing: Annotated[Optional[bool], Field(False, title='Publishing')]
    republish: Annotated[Optional[bool], Field(False, title='Republish')]
    private: Annotated[Optional[bool], Field(False, title='Private')]
    domain: BundleDomain
    organisation: Optional[BundleOrganisation] = None
    visible: Annotated[Optional[bool], Field(True, title='Visible')]
    redact: Annotated[Optional[List[str]], Field(None, title='Redact')]
    tags: Annotated[Optional[List[str]], Field([], title='Tags')]
    draft_manifest: Optional[PublicBundleManifest] = None
    manifest: Optional[PublicBundleManifest] = None
    draft_hash: Annotated[Optional[str], Field(None, title='Draft Hash')]
    hash: Annotated[Optional[str], Field(None, title='Hash')]
    versioning: Annotated[Optional[bool], Field(False, title='Versioning')]
    account: Optional[Account] = None
    policies: Annotated[Optional[List[Policy]], Field([], title='Policies')]


class ResourceBundleListingOutput(BaseModel):
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    owner: Optional[BundleUser] = None
    name: Annotated[str, Field(title='Name')]
    resource_id: Annotated[str, Field(title='Resource Id')]
    container: Annotated[str, Field(title='Container')]
    published: Annotated[Optional[bool], Field(False, title='Published')]
    publishing: Annotated[Optional[bool], Field(False, title='Publishing')]
    republish: Annotated[Optional[bool], Field(False, title='Republish')]
    private: Annotated[Optional[bool], Field(False, title='Private')]
    domain: BundleDomain
    organisation: Optional[BundleOrganisation] = None
    visible: Annotated[Optional[bool], Field(True, title='Visible')]
    redact: Annotated[Optional[List[str]], Field(None, title='Redact')]
    tags: Annotated[Optional[List[str]], Field([], title='Tags')]
    draft_manifest: Optional[PublicBundleManifest] = None
    manifest: Optional[PublicBundleManifest] = None
    draft_hash: Annotated[Optional[str], Field(None, title='Draft Hash')]
    hash: Annotated[Optional[str], Field(None, title='Hash')]
    versioning: Annotated[Optional[bool], Field(False, title='Versioning')]
    account: Optional[Account] = None
    policies: Annotated[Optional[List[Policy]], Field([], title='Policies')]


class ResourceProofTask(BaseModel):
    """
    A ResourceProofTask represents the state of a task being performed on a resource proof.

    The `type` field represents the task being performed, e.g. publication.

    The `status` field defines the current state of the task. This can be one of:
    1. INITED - initial state
    2. PENDING - awaiting client side signing
    3. RUNNING - currently executing
    4. COMPLETED - successful completion
    5. FAILED - failed completion
    6. ABORTED - the task has timed out with an unknown error.

    For client side signing, the payload for signing is returned in the `transaction_data`
    field and the signed content sent back the server is expected to be in the
    `signed_transaction` field.
    """

    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    resource_proof_id: Annotated[UUID, Field(title='Resource Proof Id')]
    type: TaskType
    status: Optional[TaskStatus] = TaskStatus.INITED
    transaction_id: Annotated[Optional[str], Field(None, title='Transaction Id')]
    transaction_data: Annotated[
        Optional[Dict[str, Any]], Field(None, title='Transaction Data')
    ]
    signed_transaction: Annotated[
        Optional[Dict[str, Any]], Field(None, title='Signed Transaction')
    ]
    error: Annotated[Optional[str], Field(None, title='Error')]
    result: Annotated[Optional[Dict[str, Any]], Field({}, title='Result')]
    information: Optional[TaskInformationOutput] = None


class ResourceToken(BaseModel):
    """
    A token is returned to a request for access to a resource bundle.
    A token has an expiry datetime, a status and a value that is used
    when requesting a resource.

    Tokens may not be immediately active on receipt. They can be polled
    to discover their status. Once ACTIVE, and not expired, they can be used.

    Tokens can be associated with a public `key` and a request flow may expect
    the token to be submitted with a signature over the token value before
    allowing resource access.
    """

    resource_id: Annotated[str, Field(title='Resource Id')]
    value: Annotated[str, Field(title='Value')]
    expires_at: Annotated[datetime.datetime, Field(title='Expires At')]
    status: TokenStatus
    nonce: Annotated[Optional[str], Field(None, title='Nonce')]


class ResourceTokenWithFileNames(BaseModel):
    """
    ResourceToken with a list of file names in the bundle
    """

    token: ResourceToken
    file_names: Annotated[List[str], Field(title='File Names')]


class Storage(BaseModel):
    """
    A storage backend is scoped by domain and optionally by organisation as well.

    The storage name is unique within the domain.
    Storage backends that are not enabled cannot be used as a backend for new bundles, although
    historic bundles may be stored in disabled storage.

    A storage object references a storage type
    by name. It includes a configuration dictionary to allow connecting to a particular storage endpoint.
    This dictionary is passed to the adapter class referenced in the storage type, so the structure of the
    dictionary will be the same for all storages based on the same storage type.
    """

    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    name: Annotated[str, Field(title='Name')]
    domain: BundleDomain
    organisation: Optional[BundleOrganisation] = None
    enabled: Annotated[bool, Field(title='Enabled')]
    default: Annotated[Optional[bool], Field(None, title='Default')]
    config: Annotated[Optional[Dict[str, Any]], Field({}, title='Config')]
    storage_type: StorageType


class Transfer(BaseModel):
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    bundle: ResourceBundle
    state: Annotated[str, Field(title='State')]
    proposer: User
    proposer_organisation: Optional[Organisation] = None
    proposer_account: Account
    completed: Annotated[bool, Field(title='Completed')]
    receiver: Optional[User] = None
    receiver_account: Optional[Account] = None
    receiver_organisation: Optional[Organisation] = None
    task_id: Annotated[Optional[UUID], Field(None, title='Task Id')]


class PageResourceBundleListing(BaseModel):
    items: Annotated[List[ResourceBundleListingOutput], Field(title='Items')]
    total: Annotated[Optional[Total], Field(title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]


class PageResourceProofTask(BaseModel):
    items: Annotated[List[ResourceProofTask], Field(title='Items')]
    total: Annotated[Optional[Total], Field(title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]


class PageTransfer(BaseModel):
    items: Annotated[List[Transfer], Field(title='Items')]
    total: Annotated[Optional[Total], Field(title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]


class PublicBundle(BaseModel):
    owner: Optional[PublicUser] = None
    name: Annotated[Optional[str], Field(None, title='Name')]
    resource_id: Annotated[Optional[str], Field(None, title='Resource Id')]
    domain: Optional[PublicDomain] = None
    organisation: Optional[PublicOrganisation] = None
    tags: Annotated[Optional[List[str]], Field([], title='Tags')]
    manifest: Optional[PublicBundleManifest] = None
    hash: Annotated[Optional[str], Field(None, title='Hash')]
    token_id: Annotated[Optional[str], Field(None, title='Token Id')]
    token_collection: Annotated[Optional[str], Field(None, title='Token Collection')]
    token_owner: Annotated[Optional[str], Field(None, title='Token Owner')]
    did: Annotated[Optional[str], Field(None, title='Did')]
    policies: Annotated[Optional[List[Policy]], Field([], title='Policies')]
    versions: Annotated[Optional[List[str]], Field([], title='Versions')]


class PagePublicBundle(BaseModel):
    items: Annotated[List[PublicBundle], Field(title='Items')]
    total: Annotated[Optional[Total], Field(title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]
