
from dataclasses import dataclass
from typing import Optional, Union
from simba_sdk.core.requests.client.resource import schemas as resource_schemas


@dataclass
class GetBundleProfilesQuery:
    page: int = 1
    size: int = 50
    order_by: Union[str, None] = '-created_at'
    name: Union[str, None] = None
    storage_name: Union[str, None] = None


@dataclass
class GetBundleEventsQuery:
    page: int = 1
    size: int = 50
    order_by: Union[str, None] = '-created_at'
    type: Union[str, None] = None
    transaction: Union[str, None] = None
    trigger: Union[str, None] = None
    bundle_id: Union[str, None] = None
    created_at__lt: Union[str, None] = None
    created_at__gt: Union[str, None] = None


@dataclass
class GetBundlesQuery:
    page: int = 1
    size: int = 50
    order_by: Union[str, None] = '-created_at'
    name: Union[str, None] = None
    container: Union[str, None] = None
    tags__in: Union[str, None] = None
    hash: Union[str, None] = None
    storage_id: Union[str, None] = None
    owner_id: Union[str, None] = None
    owner__email: Union[str, None] = None
    owner__simba_id: Union[str, None] = None
    owner__name: Union[str, None] = None


@dataclass
class GetTasksQuery:
    page: int = 1
    size: int = 50
    order_by: Union[str, None] = '-created_at'
    type: Union[str, None] = None
    status: Union[str, None] = None


@dataclass
class GetTransferQuery:
    role: str


@dataclass
class UpdateTransferQuery:
    role: str


@dataclass
class GetTransfersQuery:
    role: str
    order_by: Union[str, None] = '-created_at'
    completed: Union[bool, None] = None
    state: Union[str, None] = None
    page: int = 1
    size: int = 50


@dataclass
class GetStoragesQuery:
    order_by: Union[str, None] = '-created_at'
    name: Union[str, None] = None
    enabled: Union[bool, None] = None
    page: int = 1
    size: int = 50


@dataclass
class GetStorageTypeViewsQuery:
    order_by: Union[str, None] = '-created_at'
    name: Union[str, None] = None
    adapter: Union[str, None] = None
    page: int = 1
    size: int = 50


@dataclass
class GetOrgBundleProfilesQuery:
    page: int = 1
    size: int = 50
    order_by: Union[str, None] = '-created_at'
    name: Union[str, None] = None
    storage_name: Union[str, None] = None


@dataclass
class GetOrgBundleEventsQuery:
    page: int = 1
    size: int = 50
    order_by: Union[str, None] = '-created_at'
    type: Union[str, None] = None
    transaction: Union[str, None] = None
    trigger: Union[str, None] = None
    bundle_id: Union[str, None] = None
    created_at__lt: Union[str, None] = None
    created_at__gt: Union[str, None] = None


@dataclass
class GetOrgBundlesQuery:
    page: int = 1
    size: int = 50
    order_by: Union[str, None] = '-created_at'
    name: Union[str, None] = None
    container: Union[str, None] = None
    tags__in: Union[str, None] = None
    hash: Union[str, None] = None
    storage_id: Union[str, None] = None
    owner_id: Union[str, None] = None
    owner__email: Union[str, None] = None
    owner__simba_id: Union[str, None] = None
    owner__name: Union[str, None] = None


@dataclass
class GetOrgTasksQuery:
    page: int = 1
    size: int = 50
    order_by: Union[str, None] = '-created_at'
    type: Union[str, None] = None
    status: Union[str, None] = None


@dataclass
class GetOrgTransferQuery:
    role: str


@dataclass
class UpdateOrgTransferQuery:
    role: str


@dataclass
class GetOrgTransfersQuery:
    role: str
    order_by: Union[str, None] = '-created_at'
    completed: Union[bool, None] = None
    state: Union[str, None] = None
    page: int = 1
    size: int = 50


@dataclass
class GetOrgStoragesQuery:
    order_by: Union[str, None] = '-created_at'
    name: Union[str, None] = None
    enabled: Union[bool, None] = None
    page: int = 1
    size: int = 50


@dataclass
class GetSchemaDataQuery:
    data_type: resource_schemas.SchemaDataType


@dataclass
class GetResourceProofProfilesQuery:
    page: int = 1
    size: int = 50
    order_by: Union[str, None] = '-created_at'
    proof_type: Union[str, None] = None
    name: Union[str, None] = None


@dataclass
class GetResourceProofTasksQuery:
    page: int = 1
    size: int = 50
    order_by: Union[str, None] = '-created_at'
    type: Union[str, None] = None
    status: Union[str, None] = None


@dataclass
class GetResourceProofsQuery:
    page: int = 1
    size: int = 50
    order_by: Union[str, None] = '-created_at'
    proof: Union[str, None] = None
    proof_type: Union[str, None] = None
    resource_id: Union[str, None] = None
    owner_id: Union[str, None] = None
    owner__email: Union[str, None] = None
    owner__simba_id: Union[str, None] = None
    owner__name: Union[str, None] = None


@dataclass
class GetResourceProofEventsQuery:
    page: int = 1
    size: int = 50
    order_by: Union[str, None] = '-created_at'
    type: Union[str, None] = None
    transaction: Union[str, None] = None
    trigger: Union[str, None] = None
    resource_proof_id: Union[str, None] = None
    created_at__lt: Union[str, None] = None
    created_at__gt: Union[str, None] = None


@dataclass
class GetOrgResourceProofProfilesQuery:
    page: int = 1
    size: int = 50
    order_by: Union[str, None] = '-created_at'
    proof_type: Union[str, None] = None
    name: Union[str, None] = None


@dataclass
class GetOrgResourceProofTasksQuery:
    page: int = 1
    size: int = 50
    order_by: Union[str, None] = '-created_at'
    type: Union[str, None] = None
    status: Union[str, None] = None


@dataclass
class GetOrgResourceProofsQuery:
    page: int = 1
    size: int = 50
    order_by: Union[str, None] = '-created_at'
    proof: Union[str, None] = None
    proof_type: Union[str, None] = None
    resource_id: Union[str, None] = None
    owner_id: Union[str, None] = None
    owner__email: Union[str, None] = None
    owner__simba_id: Union[str, None] = None
    owner__name: Union[str, None] = None


@dataclass
class GetOrgResourceProofEventsQuery:
    page: int = 1
    size: int = 50
    order_by: Union[str, None] = '-created_at'
    type: Union[str, None] = None
    transaction: Union[str, None] = None
    trigger: Union[str, None] = None
    resource_proof_id: Union[str, None] = None
    created_at__lt: Union[str, None] = None
    created_at__gt: Union[str, None] = None


@dataclass
class GetAccessErrorsPaginatedQuery:
    order_by: Union[str, None] = '-created_at'
    resource_id: Union[str, None] = None
    page: int = 1
    size: int = 50


@dataclass
class GetDomainsQuery:
    order_by: Union[str, None] = '-created_at'
    name: Union[str, None] = None
    page: int = 1
    size: int = 50


@dataclass
class GetOrganisationsQuery:
    order_by: Union[str, None] = '-created_at'
    name: Union[str, None] = None
    page: int = 1
    size: int = 50


@dataclass
class GetStorageTypesQuery:
    order_by: Union[str, None] = '-created_at'
    name: Union[str, None] = None
    adapter: Union[str, None] = None
    page: int = 1
    size: int = 50


@dataclass
class GetUsersQuery:
    order_by: Union[str, None] = '-created_at'
    name: Union[str, None] = None
    simba_id: Union[str, None] = None
    email: Union[str, None] = None
    page: int = 1
    size: int = 50


@dataclass
class BrowseBundlesQuery:
    order_by: Union[str, None] = '-created_at'
    tags__in: Union[str, None] = None
    page: int = 1
    size: int = 50


@dataclass
class BrowsePublicBundlesQuery:
    order_by: Union[str, None] = '-created_at'
    tags__in: Union[str, None] = None
    page: int = 1
    size: int = 50


@dataclass
class GetTrustedAccessQuery:
    on_behalf_simba_id: str
    file_name: str


@dataclass
class GetTrustedFileAnnotationsQuery:
    on_behalf_simba_id: str
    token: Union[str, None] = None
    access_history_id: Union[str, None] = None


@dataclass
class GetAccessHistoryQuery:
    file_name: Union[str, None] = None


@dataclass
class GetAccessHistoryPaginatedQuery:
    order_by: Union[str, None] = '-created_at'
    resource_id: Union[str, None] = None
    name: Union[str, None] = None
    id: Union[str, None] = None
    is_trusted: Union[str, None] = None
    date_accessed: Union[str, None] = None
    page: int = 1
    size: int = 50


@dataclass
class GetResourceTokensPaginatedQuery:
    order_by: Union[str, None] = '-created_at'
    nonce: Union[str, None] = None
    resource_id: Union[str, None] = None
    value: Union[str, None] = None
    status: Union[resource_schemas.TokenStatus, None] = None
    expires_at: Union[str, None] = None
    page: int = 1
    size: int = 50

