# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2025-10-29T17:39:00+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union
from uuid import UUID

import datetime
from pydantic import BaseModel, Field, RootModel
from typing_extensions import Annotated


class Total(RootModel[int]):
    root: Annotated[int, Field(ge=0, title='Total')]


class Page(RootModel[int]):
    root: Annotated[int, Field(ge=1, title='Page')]


class Size(RootModel[int]):
    root: Annotated[int, Field(ge=1, title='Size')]


class Pages(RootModel[int]):
    root: Annotated[int, Field(ge=0, title='Pages')]


class ValidationError(BaseModel):
    loc: Annotated[List[Union[str, int]], Field(title='Location')]
    msg: Annotated[str, Field(title='Message')]
    type: Annotated[str, Field(title='Error Type')]


class WorkloadRequestedState(str, Enum):
    """
    Representation of the requested state of the Kube Workload resource
    """

    RUNNING = 'RUNNING'
    STOPPED = 'STOPPED'


class WorkloadState(str, Enum):
    """
    Representation of the actual state of the Kube Workload resource
    """

    PENDING = 'PENDING'
    BUILDING = 'BUILDING'
    READY = 'READY'
    SHUTDOWN = 'SHUTDOWN'
    ERRORED = 'ERRORED'


class WorkloadType(str, Enum):
    """
    Representation of the Kube resource type. Ex.: Job, Deployment, etc...
    """

    JOB = 'JOB'
    DEPLOYMENT = 'DEPLOYMENT'


class HTTPValidationError(BaseModel):
    detail: Annotated[Optional[List[ValidationError]], Field(None, title='Detail')]


class WorkloadRequestCreate(BaseModel):
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    workload_type: Optional[WorkloadType] = WorkloadType.JOB
    template: Annotated[str, Field(title='Template')]
    requested_state: WorkloadRequestedState
    ttl_in_seconds: Annotated[Optional[int], Field(600, title='Ttl In Seconds')]
    config: Annotated[Optional[Dict[str, str]], Field(None, title='Config')]


class WorkloadRequestPublic(BaseModel):
    deleted_at: Annotated[Optional[datetime.datetime], Field(None, title='Deleted At')]
    created_on: Annotated[Optional[datetime.datetime], Field(None, title='Created On')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    workload_type: Optional[WorkloadType] = WorkloadType.JOB
    template: Annotated[str, Field(title='Template')]
    requested_state: WorkloadRequestedState
    ttl_in_seconds: Annotated[Optional[int], Field(600, title='Ttl In Seconds')]
    config: Annotated[Optional[Dict[str, str]], Field(None, title='Config')]
    simba_identity_id: Annotated[str, Field(title='Simba Identity Id')]
    organisation_name: Annotated[Optional[str], Field(title='Organisation Name')]
    hostname: Annotated[Optional[str], Field(title='Hostname')]
    status: Optional[WorkloadState] = WorkloadState.PENDING


class WorkloadRequestStatusEvent(BaseModel):
    """
    An internal event to signal that a Kube Workload status has changed
    """

    id: Annotated[UUID, Field(title='Id')]
    workload_type: WorkloadType
    requested_state: WorkloadRequestedState
    current_state: WorkloadState
    hostname: Annotated[Optional[str], Field(None, title='Hostname')]


class WorkloadRequestUpdate(BaseModel):
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    template: Annotated[Optional[str], Field(None, title='Template')]
    requested_state: Optional[WorkloadRequestedState] = None
    config: Annotated[Optional[Dict[str, Any]], Field(None, title='Config')]
    ttl_in_seconds: Annotated[Optional[int], Field(None, title='Ttl In Seconds')]


class CloudEventModelWorkloadRequestStatusEvent(BaseModel):
    data: Optional[WorkloadRequestStatusEvent] = None
    datacontenttype: Annotated[str, Field(title='Datacontenttype')]
    id: Annotated[str, Field(title='Id')]
    pubsubname: Annotated[str, Field(title='Pubsubname')]
    source: Annotated[str, Field(title='Source')]
    specversion: Annotated[str, Field(title='Specversion')]
    topic: Annotated[str, Field(title='Topic')]
    traceid: Annotated[str, Field(title='Traceid')]
    traceparent: Annotated[str, Field(title='Traceparent')]
    tracestate: Annotated[str, Field(title='Tracestate')]
    type: Annotated[str, Field(title='Type')]


class PageWorkloadRequestPublic(BaseModel):
    items: Annotated[List[WorkloadRequestPublic], Field(title='Items')]
    total: Annotated[Optional[Total], Field(title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]
