# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2025-10-29T20:56:32+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union
from uuid import UUID

import datetime
from pydantic import BaseModel, EmailStr, Field, RootModel, SecretStr
from typing_extensions import Annotated


class AddDomainOrganisationInput(BaseModel):
    organisation_name: Annotated[str, Field(title='Organisation Name')]


class AddIdentityRolesInput(BaseModel):
    role_ids: Annotated[Optional[List[UUID]], Field([], title='Role Ids')]
    role_names: Annotated[Optional[List[str]], Field([], title='Role Names')]


class BodyCreateBulkUsersImportRequestBulkUsersImportRequestsPost(BaseModel):
    bulk_import_file: Annotated[bytes, Field(title='Bulk Import File')]


class BulkUsersImportTaskStatus(str, Enum):
    pending = 'pending'
    processing = 'processing'
    completed = 'completed'
    errored = 'errored'


class CreateClientCredentialInput(BaseModel):
    name: Annotated[str, Field(title='Name')]
    expire_at: Annotated[Optional[datetime.datetime], Field(None, title='Expire At')]
    sub_organisations: Annotated[
        Optional[List[str]],
        Field(
            [],
            description='List of sub organisation names for the domain',
            min_length=0,
            title='Sub Organisations',
        ),
    ]


class CreateDeviceAppInput(BaseModel):
    name: Annotated[
        str,
        Field(
            max_length=40, min_length=3, pattern='^[a-z0-9]+[a-z0-9-]+$', title='Name'
        ),
    ]
    role_names: Annotated[List[str], Field(title='Role Names')]


class CreateDeviceAppRegistration(BaseModel):
    device_info: Annotated[str, Field(title='Device Info')]
    app_info: Annotated[str, Field(title='App Info')]
    registrant_pub_key: Annotated[str, Field(title='Registrant Pub Key')]
    device_pub_key: Annotated[str, Field(title='Device Pub Key')]
    registrant_public_key_multicodec: Annotated[
        str, Field(title='Registrant Public Key Multicodec')
    ]
    device_public_key_multicodec: Annotated[
        str, Field(title='Device Public Key Multicodec')
    ]
    impersonate_user: Annotated[Optional[bool], Field(False, title='Impersonate User')]


class CreateDomainInput(BaseModel):
    display_name: Annotated[Optional[str], Field(None, title='Display Name')]
    default_role_names: Annotated[
        Optional[List[str]], Field(None, title='Default Role Names')
    ]
    name: Annotated[
        str,
        Field(
            max_length=40, min_length=3, pattern='^[a-z0-9]+[a-z0-9-]+$', title='Name'
        ),
    ]
    reference_domain: Annotated[Optional[str], Field(None, title='Reference Domain')]


class CreateImpersonateClientCredentialInput(BaseModel):
    name: Annotated[str, Field(title='Name')]
    expire_at: Annotated[Optional[datetime.datetime], Field(None, title='Expire At')]


class CreateInviteSubOrgsInput(BaseModel):
    organisation_name: Annotated[
        str,
        Field(
            description='The name of the sub organisation', title='Organisation Name'
        ),
    ]
    role_ids: Annotated[
        Optional[List[UUID]],
        Field(
            [],
            description='List of org role ids to assign to user for organisation',
            min_length=0,
            title='Role Ids',
        ),
    ]
    role_names: Annotated[
        Optional[List[str]],
        Field(
            [],
            description='List of org role names to assign to user for organisation',
            min_length=0,
            title='Role Names',
        ),
    ]


class CreateOrganisationInput(BaseModel):
    display_name: Annotated[Optional[str], Field(None, title='Display Name')]
    default_role_names: Annotated[
        Optional[List[str]], Field(None, title='Default Role Names')
    ]
    name: Annotated[
        str,
        Field(
            max_length=40, min_length=3, pattern='^[a-z0-9]+[a-z0-9-]+$', title='Name'
        ),
    ]


class CreateTemplateInput(BaseModel):
    name: Annotated[str, Field(title='Name')]
    template: Annotated[str, Field(title='Template')]
    parent_id: Annotated[Optional[UUID], Field(None, title='Parent Id')]


class DeviceAppRegistrationStatus(str, Enum):
    in_progress = 'in-progress'
    complete = 'complete'
    failed = 'failed'
    revoked = 'revoked'


class DeviceAppSlim(BaseModel):
    name: Annotated[str, Field(title='Name')]


class DomainConfiguration(BaseModel):
    member_service_did_id: Annotated[
        Optional[Union[str, UUID]], Field(None, title='Member Service Did Id')
    ]
    trust_profile: Annotated[Optional[str], Field(None, title='Trust Profile')]
    apps_claim_schema: Annotated[Optional[str], Field(None, title='Apps Claim Schema')]


class DomainConfigurationStatus(str, Enum):
    RUNNING = 'RUNNING'
    COMPLETED = 'COMPLETED'
    PARTIAL = 'PARTIAL'
    FAILED = 'FAILED'


class Effect(str, Enum):
    allow = 'allow'


class FreshClientCredential(BaseModel):
    """
    Only time the plain secret is provided, at it's creation
    """

    id: Annotated[UUID, Field(title='Id')]
    simba_id: Annotated[Optional[str], Field(None, title='Simba Id')]
    name: Annotated[str, Field(title='Name')]
    secret: Annotated[str, Field(title='Secret')]


class GenericConfigurationRequest(BaseModel):
    member_client_cred_id: Annotated[
        Optional[UUID], Field(None, title='Member Client Cred Id')
    ]
    member_client_cred_secret: Annotated[
        Optional[str], Field(None, title='Member Client Cred Secret')
    ]
    member_client_cred_simba_id: Annotated[
        Optional[str], Field(None, title='Member Client Cred Simba Id')
    ]
    status: DomainConfigurationStatus


class InviteStatus(str, Enum):
    PENDING = 'PENDING'
    ACCEPTED = 'ACCEPTED'
    REVOKED = 'REVOKED'
    REJECTED = 'REJECTED'


class Inviter(BaseModel):
    id: Annotated[UUID, Field(title='Id')]
    email: Annotated[EmailStr, Field(title='Email')]
    first_name: Annotated[str, Field(title='First Name')]
    last_name: Annotated[str, Field(title='Last Name')]


class Organisation(BaseModel):
    """
    A model representing an organisation.

    The field `name` is unique.
    """

    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    name: Annotated[str, Field(title='Name')]
    display_name: Annotated[str, Field(title='Display Name')]
    is_domain: Annotated[bool, Field(title='Is Domain')]


class OrganisationMinimal(BaseModel):
    id: Annotated[UUID, Field(title='Id')]
    name: Annotated[str, Field(title='Name')]


class OrganisationName(BaseModel):
    name: Annotated[
        str,
        Field(
            max_length=40, min_length=3, pattern='^[a-z0-9]+[a-z0-9-]+$', title='Name'
        ),
    ]


class Page(RootModel[int]):
    root: Annotated[int, Field(ge=1, title='Page')]


class Size(RootModel[int]):
    root: Annotated[int, Field(ge=1, title='Size')]


class Pages(RootModel[int]):
    root: Annotated[int, Field(ge=0, title='Pages')]


class PageOrganisation(BaseModel):
    items: Annotated[List[Organisation], Field(title='Items')]
    total: Annotated[int, Field(ge=0, title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]


class Permission(BaseModel):
    """
    A model representing a permission.
    """

    name: Annotated[str, Field(title='Name')]
    description: Annotated[str, Field(title='Description')]
    service: Annotated[str, Field(title='Service')]
    resource: Annotated[str, Field(title='Resource')]
    action: Annotated[str, Field(title='Action')]
    is_org_scoped: Annotated[bool, Field(title='Is Org Scoped')]
    resource_attributes: Annotated[Dict[str, Any], Field(title='Resource Attributes')]
    urls: Annotated[Optional[List[str]], Field([], title='Urls')]
    effect: Effect
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]


class PingResponse(BaseModel):
    component: Annotated[str, Field(title='Component')]
    success: Annotated[bool, Field(title='Success')]
    error: Annotated[Optional[str], Field(None, title='Error')]


class PingResponses(BaseModel):
    service: Annotated[str, Field(title='Service')]
    responses: Annotated[List[PingResponse], Field(title='Responses')]


class RedactedGenericConfiguration(BaseModel):
    member_client_cred_id: Annotated[
        Optional[UUID], Field(None, title='Member Client Cred Id')
    ]
    member_client_cred_secret: Annotated[
        Optional[Union[str, SecretStr]], Field(None, title='Member Client Cred Secret')
    ]
    member_client_cred_simba_id: Annotated[
        Optional[str], Field(None, title='Member Client Cred Simba Id')
    ]


class RemoveDomainOrganisationInput(BaseModel):
    organisation_name: Annotated[str, Field(title='Organisation Name')]


class RepublishEventChoices(str, Enum):
    organisation_added = 'organisation-added'
    domain_added = 'domain-added'
    identity_added = 'identity-added'
    identity_added_to_org_domain = 'identity-added-to-org-domain'


class RepublishEventsInput(BaseModel):
    event_choices: Annotated[
        List[RepublishEventChoices], Field(min_length=1, title='Event Choices')
    ]


class Role(BaseModel):
    """
    A model representing a role.
    """

    is_org_role: Annotated[bool, Field(title='Is Org Role')]
    is_domain_role: Annotated[bool, Field(title='Is Domain Role')]
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    name: Annotated[str, Field(title='Name')]
    is_global: Annotated[bool, Field(title='Is Global')]
    organisation: Optional[Organisation] = None
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    permissions: Annotated[List[Permission], Field(title='Permissions')]


class RoleMinimal(BaseModel):
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    name: Annotated[str, Field(title='Name')]


class RoleNamesInput(BaseModel):
    role_names: Annotated[Optional[List[str]], Field([], title='Role Names')]


class RoleWithFlags(BaseModel):
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    name: Annotated[str, Field(title='Name')]
    organisation: Optional[Organisation] = None
    is_org_role: Annotated[bool, Field(title='Is Org Role')]
    is_domain_role: Annotated[bool, Field(title='Is Domain Role')]
    is_global: Annotated[bool, Field(title='Is Global')]


class RoleWithoutPermissions(BaseModel):
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    name: Annotated[str, Field(title='Name')]
    organisation: Optional[Organisation] = None


class ServiceConfigurations(BaseModel):
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    name: Annotated[Optional[str], Field(None, title='Name')]
    config_status: Optional[DomainConfigurationStatus] = None
    config: Annotated[
        Optional[Union[DomainConfiguration, RedactedGenericConfiguration]],
        Field(None, title='Config'),
    ]
    state: Annotated[Optional[Dict[str, Any]], Field(None, title='State')]


class SystemTypes(str, Enum):
    ensure = 'ensure'
    build = 'build'


class Template(BaseModel):
    """
    A model representing a template.

    The field `name` is unique.
    """

    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    name: Annotated[str, Field(title='Name')]
    template: Annotated[str, Field(title='Template')]
    parent_id: Annotated[Optional[UUID], Field(None, title='Parent Id')]


class UpdateClientCredentialInput(BaseModel):
    name: Annotated[str, Field(title='Name')]


class UpdateDeviceAppRegistrationInput(BaseModel):
    status: Optional[DeviceAppRegistrationStatus] = DeviceAppRegistrationStatus.revoked


class UpdateDomainInput(BaseModel):
    display_name: Annotated[Optional[str], Field(None, title='Display Name')]
    default_role_names: Annotated[
        Optional[List[str]], Field(None, title='Default Role Names')
    ]


class UpdateIdentityRolesInput(BaseModel):
    role_ids: Annotated[Optional[List[UUID]], Field([], title='Role Ids')]
    role_names: Annotated[Optional[List[str]], Field([], title='Role Names')]


class UpdateOrganisationInput(BaseModel):
    display_name: Annotated[Optional[str], Field(None, title='Display Name')]
    default_role_names: Annotated[
        Optional[List[str]], Field(None, title='Default Role Names')
    ]


class UpdateTemplateInput(BaseModel):
    name: Annotated[str, Field(title='Name')]
    template: Annotated[str, Field(title='Template')]
    parent_id: Annotated[Optional[UUID], Field(None, title='Parent Id')]


class UpdateUserAccountInput(BaseModel):
    password: Annotated[Optional[str], Field(None, title='Password')]
    default_organisation_id: Annotated[
        Optional[UUID], Field(None, title='Default Organisation Id')
    ]


class UpdateUserProfileInput(BaseModel):
    first_name: Annotated[str, Field(description='First Name', title='First Name')]
    last_name: Annotated[str, Field(description='Last Name', title='Last Name')]


class UserInputBase(BaseModel):
    first_name: Annotated[str, Field(title='First Name')]
    last_name: Annotated[str, Field(title='Last Name')]
    password: Annotated[str, Field(title='Password')]


class UserMoniker(BaseModel):
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    email: Annotated[EmailStr, Field(title='Email')]


class UserProfile(BaseModel):
    """
    A model representing a user profile.
    """

    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    first_name: Annotated[str, Field(title='First Name')]
    last_name: Annotated[str, Field(title='Last Name')]
    user_account_id: Annotated[UUID, Field(title='User Account Id')]


class ValidationError(BaseModel):
    loc: Annotated[List[Union[str, int]], Field(title='Location')]
    msg: Annotated[str, Field(title='Message')]
    type: Annotated[str, Field(title='Error Type')]


class SubOrganisations(RootModel[List[CreateInviteSubOrgsInput]]):
    root: Annotated[
        List[CreateInviteSubOrgsInput],
        Field(
            description='List of sub organisations for the domain',
            min_length=0,
            title='Sub Organisations',
        ),
    ]


class AdminAddClientCredentialToOrgDomain(BaseModel):
    role_ids: Annotated[Optional[List[UUID]], Field([], title='Role Ids')]
    role_names: Annotated[Optional[List[str]], Field([], title='Role Names')]
    client_id: Annotated[UUID, Field(title='Client Id')]
    sub_organisations: Annotated[
        Optional[SubOrganisations],
        Field(
            None,
            description='List of sub organisations for the domain',
            title='Sub Organisations',
        ),
    ]


class AdminAddUserToOrgDomain(BaseModel):
    to_email: Annotated[
        EmailStr, Field(description='Email of the user', title='To Email')
    ]
    role_ids: Annotated[
        Optional[List[UUID]],
        Field(
            [],
            description='List of role ids to assign to user for the organisation/domain',
            min_length=0,
            title='Role Ids',
        ),
    ]
    role_names: Annotated[
        Optional[List[str]],
        Field(
            [],
            description='List of role names to assign to user for organisation or domain',
            min_length=0,
            title='Role Names',
        ),
    ]
    sub_organisations: Annotated[
        Optional[SubOrganisations],
        Field(
            None,
            description='List of sub organisations for the domain',
            title='Sub Organisations',
        ),
    ]
    user_info: Annotated[
        Optional[UpdateUserProfileInput],
        Field(None, description='Information of the user'),
    ]
    is_default_org: Annotated[
        Optional[bool],
        Field(
            None,
            description='Flag to specify default organisation for the user',
            title='Is Default Org',
        ),
    ]
    system_type: Annotated[
        SystemTypes, Field(description='Specify the system the user belongs to')
    ]


class BulkUsersImportRequest(BaseModel):
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    status: BulkUsersImportTaskStatus
    errors: Annotated[Optional[Dict[str, Any]], Field(None, title='Errors')]
    submitted_by: UserMoniker


class CreateInviteInput(BaseModel):
    to_email: Annotated[
        EmailStr, Field(description='Email of the user', title='To Email')
    ]
    role_ids: Annotated[
        Optional[List[UUID]],
        Field(
            [],
            description='List of role ids to assign to user for the organisation/domain',
            min_length=0,
            title='Role Ids',
        ),
    ]
    role_names: Annotated[
        Optional[List[str]],
        Field(
            [],
            description='List of role names to assign to user for organisation or domain',
            min_length=0,
            title='Role Names',
        ),
    ]
    sub_organisations: Annotated[
        Optional[SubOrganisations],
        Field(
            None,
            description='List of sub organisations for the domain',
            title='Sub Organisations',
        ),
    ]


class DeviceApp(BaseModel):
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    name: Annotated[str, Field(title='Name')]
    organisation: Organisation
    roles: Annotated[List[RoleWithoutPermissions], Field(title='Roles')]


class DeviceAppRegistration(BaseModel):
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    device_info: Annotated[str, Field(title='Device Info')]
    app_info: Annotated[str, Field(title='App Info')]
    registrant_pub_key: Annotated[str, Field(title='Registrant Pub Key')]
    device_pub_key: Annotated[str, Field(title='Device Pub Key')]
    registrant_public_key_multicodec: Annotated[
        str, Field(title='Registrant Public Key Multicodec')
    ]
    device_public_key_multicodec: Annotated[
        str, Field(title='Device Public Key Multicodec')
    ]
    impersonate_user: Annotated[Optional[bool], Field(False, title='Impersonate User')]
    device_app: DeviceAppSlim
    registrant_id: Annotated[UUID, Field(title='Registrant Id')]
    registrant_did_id: Annotated[Optional[str], Field(None, title='Registrant Did Id')]
    registrant_did: Annotated[
        Optional[Dict[str, Any]], Field(None, title='Registrant Did')
    ]
    device_did_id: Annotated[Optional[str], Field(None, title='Device Did Id')]
    device_did: Annotated[Optional[Dict[str, Any]], Field(None, title='Device Did')]
    vc_id: Annotated[Optional[str], Field(None, title='Vc Id')]
    vc: Annotated[Optional[Dict[str, Any]], Field(None, title='Vc')]
    status: DeviceAppRegistrationStatus
    device_public_key_hex: Annotated[str, Field(title='Device Public Key Hex')]
    registrant_public_key_hex: Annotated[str, Field(title='Registrant Public Key Hex')]
    errors: Annotated[Optional[Dict[str, Any]], Field({}, title='Errors')]


class Domain(BaseModel):
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    name: Annotated[str, Field(title='Name')]
    display_name: Annotated[str, Field(title='Display Name')]
    is_domain: Annotated[bool, Field(title='Is Domain')]
    reference_domain: Annotated[Optional[str], Field(None, title='Reference Domain')]
    organisations: Annotated[List[Organisation], Field(title='Organisations')]


class DomainConfigurationRequest(BaseModel):
    member_service_did_id: Annotated[
        Optional[Union[str, UUID]], Field(None, title='Member Service Did Id')
    ]
    trust_profile: Annotated[Optional[str], Field(None, title='Trust Profile')]
    apps_claim_schema: Annotated[Optional[str], Field(None, title='Apps Claim Schema')]
    status: DomainConfigurationStatus


class DomainWithDefaultRoles(BaseModel):
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    name: Annotated[str, Field(title='Name')]
    display_name: Annotated[str, Field(title='Display Name')]
    is_domain: Annotated[bool, Field(title='Is Domain')]
    default_roles: Annotated[
        Optional[List[RoleWithoutPermissions]], Field([], title='Default Roles')
    ]
    reference_domain: Annotated[Optional[str], Field(None, title='Reference Domain')]
    organisations: Annotated[List[Organisation], Field(title='Organisations')]


class HTTPValidationError(BaseModel):
    detail: Annotated[Optional[List[ValidationError]], Field(None, title='Detail')]


class InviteInfo(BaseModel):
    system_type: SystemTypes
    new_user: Annotated[bool, Field(title='New User')]
    org_domain: OrganisationMinimal


class OrganisationWithDefaultRoles(BaseModel):
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    name: Annotated[str, Field(title='Name')]
    display_name: Annotated[str, Field(title='Display Name')]
    is_domain: Annotated[bool, Field(title='Is Domain')]
    default_roles: Annotated[
        Optional[List[RoleWithoutPermissions]], Field([], title='Default Roles')
    ]


class OrganisationWithRoles(BaseModel):
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    name: Annotated[str, Field(title='Name')]
    display_name: Annotated[str, Field(title='Display Name')]
    is_domain: Annotated[bool, Field(title='Is Domain')]
    roles: Annotated[List[RoleMinimal], Field(title='Roles')]


class PageBulkUsersImportRequest(BaseModel):
    items: Annotated[List[BulkUsersImportRequest], Field(title='Items')]
    total: Annotated[int, Field(ge=0, title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]


class PageDeviceAppRegistration(BaseModel):
    items: Annotated[List[DeviceAppRegistration], Field(title='Items')]
    total: Annotated[int, Field(ge=0, title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]


class PageDeviceApp(BaseModel):
    items: Annotated[List[DeviceApp], Field(title='Items')]
    total: Annotated[int, Field(ge=0, title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]


class PageDomain(BaseModel):
    items: Annotated[List[Domain], Field(title='Items')]
    total: Annotated[int, Field(ge=0, title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]


class PagePermission(BaseModel):
    items: Annotated[List[Permission], Field(title='Items')]
    total: Annotated[int, Field(ge=0, title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]


class PageRoleWithFlags(BaseModel):
    items: Annotated[List[RoleWithFlags], Field(title='Items')]
    total: Annotated[int, Field(ge=0, title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]


class PageTemplate(BaseModel):
    items: Annotated[List[Template], Field(title='Items')]
    total: Annotated[int, Field(ge=0, title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]


class SubInvite(BaseModel):
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    invitee_email: Annotated[EmailStr, Field(title='Invitee Email')]
    status: InviteStatus
    expires_at: Annotated[datetime.datetime, Field(title='Expires At')]
    org_domain: OrganisationMinimal
    roles: Annotated[List[RoleMinimal], Field(title='Roles')]
    system_type: SystemTypes


class UserAccount(BaseModel):
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    email: Annotated[EmailStr, Field(title='Email')]
    email_verified: Annotated[bool, Field(title='Email Verified')]
    last_login: Annotated[Optional[datetime.datetime], Field(None, title='Last Login')]
    profile: Optional[UserProfile] = None
    simba_id: Annotated[Optional[str], Field(None, title='Simba Id')]
    default_organisation: Optional[Organisation] = None
    organisations: Annotated[
        Optional[List[OrganisationWithRoles]], Field([], title='Organisations')
    ]


class ClientCredential(BaseModel):
    secret: Annotated[str, Field(title='Secret')]
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    name: Annotated[str, Field(title='Name')]
    revoked: Annotated[bool, Field(title='Revoked')]
    expire_at: Annotated[datetime.datetime, Field(title='Expire At')]
    last_used: Annotated[Optional[datetime.datetime], Field(None, title='Last Used')]
    user_account_id: Annotated[UUID, Field(title='User Account Id')]
    organisation: Optional[Organisation] = None
    impersonate_user: Annotated[bool, Field(title='Impersonate User')]
    simba_id: Annotated[Optional[str], Field(None, title='Simba Id')]
    organisations: Annotated[
        Optional[List[OrganisationWithRoles]],
        Field(
            [], description='List of organisations', min_length=0, title='Organisations'
        ),
    ]


class CreateBulkInviteInput(BaseModel):
    system_type: Annotated[
        SystemTypes, Field(description='Specifies the system the users belong too.')
    ]
    invites: Annotated[
        List[CreateInviteInput],
        Field(description='List of invite to create', min_length=1, title='Invites'),
    ]


class Invite(BaseModel):
    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    inviter: Inviter
    invitee_email: Annotated[EmailStr, Field(title='Invitee Email')]
    status: InviteStatus
    expires_at: Annotated[datetime.datetime, Field(title='Expires At')]
    system_type: SystemTypes
    org_domain: OrganisationMinimal
    roles: Annotated[List[RoleMinimal], Field(title='Roles')]
    sub_invites: Annotated[Optional[List[SubInvite]], Field(None, title='Sub Invites')]


class OrgScopedUserAccount(BaseModel):
    """
    A model representing a organisation user account.

    The field `email` is unique.
    """

    id: Annotated[Optional[UUID], Field(None, title='Id')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    email: Annotated[EmailStr, Field(title='Email')]
    email_verified: Annotated[bool, Field(title='Email Verified')]
    last_login: Annotated[Optional[datetime.datetime], Field(None, title='Last Login')]
    profile: Optional[UserProfile] = None
    organisations: Annotated[
        Optional[List[OrganisationWithRoles]], Field([], title='Organisations')
    ]
    simba_id: Annotated[Optional[str], Field(None, title='Simba Id')]


class PageClientCredential(BaseModel):
    items: Annotated[List[ClientCredential], Field(title='Items')]
    total: Annotated[int, Field(ge=0, title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]


class PageInvite(BaseModel):
    items: Annotated[List[Invite], Field(title='Items')]
    total: Annotated[int, Field(ge=0, title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]


class PageOrgScopedUserAccount(BaseModel):
    items: Annotated[List[OrgScopedUserAccount], Field(title='Items')]
    total: Annotated[int, Field(ge=0, title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]
