# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2025-10-29T17:38:56+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union
from uuid import UUID

import datetime
from pydantic import BaseModel, EmailStr, Field, RootModel, SecretStr
from typing_extensions import Annotated, Literal


class AccountOwner(BaseModel):
    type: Annotated[Optional[str], Field(None, title='Type')]
    identifier: Annotated[Optional[str], Field(None, title='Identifier')]


class AdminCreateAccountHttp(BaseModel):
    trust_profile: Annotated[
        Optional[str],
        Field(
            None,
            examples=[
                'Optional[str] TrustProfile name to be used to look up the blockchain.'
            ],
            title='Trust Profile',
        ),
    ]
    nickname: Annotated[
        str, Field(examples=['[str] A name for your new account.'], title='Nickname')
    ]
    alias: Annotated[
        Optional[str],
        Field(
            None,
            examples=[
                'Optional[str] An alternate name by which this account will be known.'
            ],
            title='Alias',
        ),
    ]
    org: Annotated[
        Optional[str],
        Field(
            None,
            examples=['Optional[str] If set an Org-account will be created.'],
            title='Org',
        ),
    ]
    target_owner: Annotated[
        str,
        Field(examples=['simba_id of the intended DID owner.'], title='Target Owner'),
    ]


class BaseModelModel(BaseModel):
    pass


class BlocksAccount(BaseModel):
    id: Annotated[UUID, Field(title='Id')]
    owner: AccountOwner
    network_type: Annotated[Optional[str], Field(None, title='Network Type')]
    network_subtype: Annotated[Optional[str], Field(None, title='Network Subtype')]
    network: Annotated[str, Field(title='Network')]
    nickname: Annotated[str, Field(title='Nickname')]
    alias: Annotated[str, Field(title='Alias')]
    public_key: Annotated[str, Field(title='Public Key')]
    public_key_multicodec: Annotated[
        Optional[str],
        Field(
            None,
            examples=['zQ3shimdW4hBJNu19cyjVdYpzzAagjQB1eFZPofv22uSruHjZ'],
            title='Public Key Multicodec',
        ),
    ]
    created_by: Annotated[Optional[str], Field(None, title='Created By')]
    modified_by: Annotated[Optional[str], Field(None, title='Modified By')]
    created_on: Annotated[datetime.datetime, Field(title='Created On')]
    updated_on: Annotated[datetime.datetime, Field(title='Updated On')]


class ClaimAttribute(BaseModel):
    id: Annotated[str, Field(title='Id')]
    name: Annotated[str, Field(title='Name')]
    type: Annotated[str, Field(title='Type')]
    hash: Annotated[str, Field(title='Hash')]
    suggestedValues: Annotated[
        Optional[List[Union[str, int]]], Field(None, title='Suggestedvalues')
    ]


class ClaimSchemaInfo(BaseModel):
    name: Annotated[str, Field(title='Name')]
    id: Annotated[str, Field(title='Id')]
    hash: Annotated[str, Field(title='Hash')]
    attributes: Annotated[Optional[List[ClaimAttribute]], Field([], title='Attributes')]


class Classification(BaseModel):
    id: Annotated[
        str,
        Field(
            description='The globally unique URI representing the specific classifier value',
            title='Id',
        ),
    ]
    code: Annotated[
        str, Field(description='Classification code within the scheme', title='Code')
    ]
    name: Annotated[
        str,
        Field(
            description='Name of the classification represented by the code',
            title='Name',
        ),
    ]
    schemeID: Annotated[
        str, Field(description='Classification scheme ID', title='Schemeid')
    ]
    schemeName: Annotated[
        str,
        Field(description='The name of the classification scheme', title='Schemename'),
    ]


class ClientCredRequest(BaseModel):
    platform_api_base_uri: Annotated[str, Field(title='Platform Api Base Uri')]
    platform_auth_base_uri: Annotated[str, Field(title='Platform Auth Base Uri')]
    platform_client_id: Annotated[str, Field(title='Platform Client Id')]
    platform_client_secret: Annotated[
        Union[str, SecretStr], Field(title='Platform Client Secret')
    ]
    platform_auth_provider: Annotated[str, Field(title='Platform Auth Provider')]
    resource_base_url: Annotated[str, Field(title='Resource Base Url')]
    resource_client_id: Annotated[str, Field(title='Resource Client Id')]
    resource_client_secret: Annotated[
        Union[str, SecretStr], Field(title='Resource Client Secret')
    ]


class ConformityTopicCode(str, Enum):
    environment_energy = 'environment.energy'
    environment_emissions = 'environment.emissions'
    environment_water = 'environment.water'
    environment_waste = 'environment.waste'
    environment_deforestation = 'environment.deforestation'
    environment_biodiversity = 'environment.biodiversity'
    circularity_content = 'circularity.content'
    circularity_design = 'circularity.design'
    social_labour = 'social.labour'
    social_rights = 'social.rights'
    social_community = 'social.community'
    social_safety = 'social.safety'
    governance_ethics = 'governance.ethics'
    governance_compliance = 'governance.compliance'
    governance_transparency = 'governance.transparency'


class CountryCode(str, Enum):
    AD = 'AD'
    AE = 'AE'
    AF = 'AF'
    AG = 'AG'
    AI = 'AI'
    AL = 'AL'
    AM = 'AM'
    AO = 'AO'
    AQ = 'AQ'
    AR = 'AR'
    AS = 'AS'
    AT = 'AT'
    AU = 'AU'
    AW = 'AW'
    AX = 'AX'
    AZ = 'AZ'
    BA = 'BA'
    BB = 'BB'
    BD = 'BD'
    BE = 'BE'
    BF = 'BF'
    BG = 'BG'
    BH = 'BH'
    BI = 'BI'
    BJ = 'BJ'
    BL = 'BL'
    BM = 'BM'
    BN = 'BN'
    BO = 'BO'
    BQ = 'BQ'
    BR = 'BR'
    BS = 'BS'
    BT = 'BT'
    BV = 'BV'
    BW = 'BW'
    BY = 'BY'
    BZ = 'BZ'
    CA = 'CA'
    CC = 'CC'
    CD = 'CD'
    CF = 'CF'
    CG = 'CG'
    CH = 'CH'
    CI = 'CI'
    CK = 'CK'
    CL = 'CL'
    CM = 'CM'
    CN = 'CN'
    CO = 'CO'
    CR = 'CR'
    CU = 'CU'
    CV = 'CV'
    CW = 'CW'
    CX = 'CX'
    CY = 'CY'
    CZ = 'CZ'
    DE = 'DE'
    DJ = 'DJ'
    DK = 'DK'
    DM = 'DM'
    DO = 'DO'
    DZ = 'DZ'
    EC = 'EC'
    EE = 'EE'
    EG = 'EG'
    EH = 'EH'
    ER = 'ER'
    ES = 'ES'
    ET = 'ET'
    FI = 'FI'
    FJ = 'FJ'
    FK = 'FK'
    FM = 'FM'
    FO = 'FO'
    FR = 'FR'
    GA = 'GA'
    GB = 'GB'
    GD = 'GD'
    GE = 'GE'
    GF = 'GF'
    GG = 'GG'
    GH = 'GH'
    GI = 'GI'
    GL = 'GL'
    GM = 'GM'
    GN = 'GN'
    GP = 'GP'
    GQ = 'GQ'
    GR = 'GR'
    GS = 'GS'
    GT = 'GT'
    GU = 'GU'
    GW = 'GW'
    GY = 'GY'
    HK = 'HK'
    HM = 'HM'
    HN = 'HN'
    HR = 'HR'
    HT = 'HT'
    HU = 'HU'
    ID = 'ID'
    IE = 'IE'
    IL = 'IL'
    IM = 'IM'
    IN = 'IN'
    IO = 'IO'
    IQ = 'IQ'
    IR = 'IR'
    IS = 'IS'
    IT = 'IT'
    JE = 'JE'
    JM = 'JM'
    JO = 'JO'
    JP = 'JP'
    KE = 'KE'
    KG = 'KG'
    KH = 'KH'
    KI = 'KI'
    KM = 'KM'
    KN = 'KN'
    KP = 'KP'
    KR = 'KR'
    KW = 'KW'
    KY = 'KY'
    KZ = 'KZ'
    LA = 'LA'
    LB = 'LB'
    LC = 'LC'
    LI = 'LI'
    LK = 'LK'
    LR = 'LR'
    LS = 'LS'
    LT = 'LT'
    LU = 'LU'
    LV = 'LV'
    LY = 'LY'
    MA = 'MA'
    MC = 'MC'
    MD = 'MD'
    ME = 'ME'
    MF = 'MF'
    MG = 'MG'
    MH = 'MH'
    MK = 'MK'
    ML = 'ML'
    MM = 'MM'
    MN = 'MN'
    MO = 'MO'
    MP = 'MP'
    MQ = 'MQ'
    MR = 'MR'
    MS = 'MS'
    MT = 'MT'
    MU = 'MU'
    MV = 'MV'
    MW = 'MW'
    MX = 'MX'
    MY = 'MY'
    MZ = 'MZ'
    NA = 'NA'
    NC = 'NC'
    NE = 'NE'
    NF = 'NF'
    NG = 'NG'
    NI = 'NI'
    NL = 'NL'
    NO = 'NO'
    NP = 'NP'
    NR = 'NR'
    NU = 'NU'
    NZ = 'NZ'
    OM = 'OM'
    PA = 'PA'
    PE = 'PE'
    PF = 'PF'
    PG = 'PG'
    PH = 'PH'
    PK = 'PK'
    PL = 'PL'
    PM = 'PM'
    PN = 'PN'
    PR = 'PR'
    PS = 'PS'
    PT = 'PT'
    PW = 'PW'
    PY = 'PY'
    QA = 'QA'
    RE = 'RE'
    RO = 'RO'
    RS = 'RS'
    RU = 'RU'
    RW = 'RW'
    SA = 'SA'
    SB = 'SB'
    SC = 'SC'
    SD = 'SD'
    SE = 'SE'
    SG = 'SG'
    SH = 'SH'
    SI = 'SI'
    SJ = 'SJ'
    SK = 'SK'
    SL = 'SL'
    SM = 'SM'
    SN = 'SN'
    SO = 'SO'
    SR = 'SR'
    SS = 'SS'
    ST = 'ST'
    SV = 'SV'
    SX = 'SX'
    SY = 'SY'
    SZ = 'SZ'
    TC = 'TC'
    TD = 'TD'
    TF = 'TF'
    TG = 'TG'
    TH = 'TH'
    TJ = 'TJ'
    TK = 'TK'
    TL = 'TL'
    TM = 'TM'
    TN = 'TN'
    TO = 'TO'
    TR = 'TR'
    TT = 'TT'
    TV = 'TV'
    TW = 'TW'
    TZ = 'TZ'
    UA = 'UA'
    UG = 'UG'
    UM = 'UM'
    UY = 'UY'
    UZ = 'UZ'
    VA = 'VA'
    VC = 'VC'
    VE = 'VE'
    VG = 'VG'
    VI = 'VI'
    VN = 'VN'
    VU = 'VU'
    WF = 'WF'
    WS = 'WS'
    YE = 'YE'
    YT = 'YT'
    ZA = 'ZA'
    ZM = 'ZM'
    ZW = 'ZW'


class CreateAccountHttp(BaseModel):
    trust_profile: Annotated[
        Optional[str],
        Field(
            None,
            examples=[
                'Optional[str] TrustProfile name to be used to look up the blockchain.'
            ],
            title='Trust Profile',
        ),
    ]
    nickname: Annotated[
        str, Field(examples=['[str] A name for your new account.'], title='Nickname')
    ]
    alias: Annotated[
        Optional[str],
        Field(
            None,
            examples=[
                'Optional[str] An alternate name by which this account will be known.'
            ],
            title='Alias',
        ),
    ]
    org: Annotated[
        Optional[str],
        Field(
            None,
            examples=['Optional[str] If set an Org-account will be created.'],
            title='Org',
        ),
    ]
    domain: Annotated[
        str,
        Field(
            examples=['[str] Domain name to be used to look up the blockchain.'],
            title='Domain',
        ),
    ]


class CreateVPHttp(BaseModel):
    """
    Input model for create_vp:

    - `vc_id`: the MongoDB ObjectID of the [VC][credential_service.domain.models.VerifiableCredential] being presented.
    - `proof_type`: The type of cryptographic proof that should be generated.
    - `material`: Proof challenge inputs, used to add the proof to the VP.
    - `claims`: An optional set of claims to include in the VP.
    """

    vc_id: Annotated[str, Field(title='Vc Id')]
    material: Annotated[Optional[Dict[str, Any]], Field({}, title='Material')]
    proof_in_sig: Annotated[Optional[bool], Field(False, title='Proof In Sig')]
    verification_key: Annotated[
        Optional[str],
        Field(None, examples=['#1', 'did:example:123#1'], title='Verification Key'),
    ]
    id: Annotated[
        Optional[str],
        Field(
            'urn:uuid:17ad874f-8a13-4b85-b2c8-c72449a87b0b',
            examples=[
                'http://university.example/credentials/1872',
                'urn:uuid:8d6f054d-9916-4466-815b-0ebad54b4bd0',
            ],
            title='Id',
        ),
    ]


class CredReg(str, Enum):
    inmemory = 'inmemory'
    FederatedRegistry = 'FederatedRegistry'
    MSCRegistry = 'MSCRegistry'
    NFTRegistry = 'NFTRegistry'
    STDRegistry = 'STDRegistry'
    WalletRegistry = 'WalletRegistry'


class CredentialSchema(BaseModel):
    """
    both the @context and credentialSchema properties in a VC
    say where the definitions of VC properties can be found on the internet.
    credential_schema may be preferable to @context for non JSON-LD users
    """

    id: Annotated[str, Field(title='Id')]
    type: Annotated[str, Field(title='Type')]


class CredentialStatus(BaseModel):
    """
    id: property is the unique URL for this credential status instance:
        it is where the verifier can get the status information for this VC
    type: states the type of credential status, which in turn dictates
        what other properties this property should have
        NOTE: in actual object, this is called "type"
    """

    id: Annotated[str, Field(title='Id')]
    type: Annotated[str, Field(title='Type')]


class CredentialSubjectInput(BaseModel):
    """
    This object contains the actual claims in a verifiable credential

    id: id of the subject of the credential
    current_status: this is mainly used for disputes, eg "Disputed"
    status_reason: this is main used for disputes, and explains reason for current_status

    NOTE: many more fields are allowable in CredentialSubject
    """

    id: Annotated[
        str,
        Field(
            description='The unique ID of the subject as a URI, e.g. this can be a DID, URN, URL etc.',
            title='Id',
        ),
    ]
    type: Annotated[
        Optional[Union[List[str], str]],
        Field(
            None,
            description='The type of the subject. Can be a string or a list of strings.',
            title='Type',
        ),
    ]
    currentStatus: Annotated[Optional[str], Field(None, title='Currentstatus')]
    statusReason: Annotated[Optional[str], Field(None, title='Statusreason')]
    claims: Annotated[
        Optional[Dict[str, Union[Dict[str, Any], str, int, bool, List]]],
        Field({}, title='Claims'),
    ]


class CredentialSubjectOutput(RootModel[Union[Dict[str, Any], str, int, bool, List]]):
    root: Union[Dict[str, Any], str, int, bool, List]


class DIDResponseType(str, Enum):
    """
    Enum:
        - `SIMPLE`: Includes, DID-String, nickname, public_name and, if requested, usage counts.
        - `DETAILED`: Returns the full DID object and, if requested, usage counts.
    """

    SIMPLE = 'SIMPLE'
    DETAILED = 'DETAILED'


class DIDService(BaseModel):
    """
    id: must confirm to DID syntax
    type: different constraints depending on context
    service_endpoint: The value of the serviceEndpoint property MUST be a string, a map, or a set composed of one or more strings and/or maps. All string values MUST be valid URIs conforming to [RFC3986] and normalized according to the Normalization and Comparison rules in RFC3986 and to any normalization rules in its applicable URI scheme specification.s
    """

    id: Annotated[str, Field(title='Id')]
    type: Annotated[Union[str, List[str]], Field(title='Type')]
    serviceEndpoint: Annotated[
        Union[str, Dict[str, Any], List[str]], Field(title='Serviceendpoint')
    ]


class DidDocStatus(str, Enum):
    """
    Enum:
        - `PRE`: Initial state of a DID in the process of being created.
        - `ACCEPTED`: Request to create a DID accepted.
        - `SUBMITTED`: Create DID request submitted.
        - `ACTIVE`: DID has been successfully created and published to the registry.
        - `SUSPENDED`: DID is suspended on chain.
        - `UNSIGNED`: A DID operation requires signing to be executed.
        - `REVOKE_UNSIGNED`: A revoke DID operation requires signing to be executed.
        - `REVOKED`: DID has been revoked.
        - `REVOKE_FAILED`: Revoking a DID failed. Different status so it's more clear.
    """

    PRE = 'PRE'
    ACCEPTED = 'ACCEPTED'
    SUBMITTED = 'SUBMITTED'
    ACTIVE = 'ACTIVE'
    FAILED = 'FAILED'
    SUSPENDED = 'SUSPENDED'
    UNSIGNED = 'UNSIGNED'
    REVOKE_UNSIGNED = 'REVOKE_UNSIGNED'
    REVOKED = 'REVOKED'
    REVOKE_FAILED = 'REVOKE_FAILED'


class DidPermission(str, Enum):
    """
    Enum: Defines the type of operations the DID can participate in.
        - `ISSUER`: DIDs can be used to issue VCs and be the credentialSubject of a VC.
        - `HOLDER`: DIDs can only be used is the credentialSubject/object of a VC.
    """

    HOLDER = 'HOLDER'
    ISSUER = 'ISSUER'


class DigestInput(BaseModel):
    vm_id: Annotated[str, Field(title='Vm Id')]
    digest: Annotated[Union[bytes, str], Field(title='Digest')]
    public_key: Annotated[str, Field(title='Public Key')]


class DigestOutput(BaseModel):
    vm_id: Annotated[str, Field(title='Vm Id')]
    digest: Annotated[Any, Field(title='Digest')]
    public_key: Annotated[str, Field(title='Public Key')]


class DomainConfigStatus(str, Enum):
    RUNNING = 'RUNNING'
    COMPLETED = 'COMPLETED'
    PARTIAL = 'PARTIAL'
    FAILED = 'FAILED'


class DomainConfigurationRequest(BaseModel):
    platform_connection_timeout: Annotated[
        Optional[float], Field(5.0, title='Platform Connection Timeout')
    ]
    platform_org: Annotated[Optional[str], Field(None, title='Platform Org')]
    trust_profiles_status: Annotated[
        Optional[str], Field(None, title='Trust Profiles Status')
    ]
    admin_account_alias: Annotated[
        Optional[str], Field(None, title='Admin Account Alias')
    ]
    admin_account_address: Annotated[
        Optional[str], Field(None, title='Admin Account Address')
    ]
    admin_account_org: Annotated[Optional[str], Field(None, title='Admin Account Org')]
    blockchain: Annotated[Optional[str], Field(None, title='Blockchain')]
    schema_registry_type: Annotated[
        Optional[str], Field(None, title='Schema Registry Type')
    ]
    schema_registry_url: Annotated[
        Optional[str], Field(None, title='Schema Registry Url')
    ]
    schema_registry_default_domain: Annotated[
        Optional[str], Field('e616', title='Schema Registry Default Domain')
    ]
    github_org: Annotated[Optional[str], Field('SIMBAChain', title='Github Org')]
    github_repo: Annotated[Optional[str], Field('context', title='Github Repo')]
    github_secret: Annotated[
        Optional[Union[str, SecretStr]], Field(None, title='Github Secret')
    ]
    credential_app: Annotated[Optional[str], Field(None, title='Credential App')]
    contract_libraries: Annotated[
        Optional[Dict[str, str]], Field(None, title='Contract Libraries')
    ]
    fed_contract: Annotated[Optional[str], Field(None, title='Fed Contract')]
    fed_contract_address: Annotated[
        Optional[str], Field(None, title='Fed Contract Address')
    ]
    fed_contract_design_id: Annotated[
        Optional[str], Field(None, title='Fed Contract Design Id')
    ]
    std_contract: Annotated[Optional[str], Field(None, title='Std Contract')]
    std_contract_address: Annotated[
        Optional[str], Field(None, title='Std Contract Address')
    ]
    std_contract_design_id: Annotated[
        Optional[str], Field(None, title='Std Contract Design Id')
    ]
    msc_contract: Annotated[Optional[str], Field(None, title='Msc Contract')]
    msc_contract_address: Annotated[
        Optional[str], Field(None, title='Msc Contract Address')
    ]
    msc_contract_design_id: Annotated[
        Optional[str], Field(None, title='Msc Contract Design Id')
    ]
    nft_contract: Annotated[Optional[str], Field(None, title='Nft Contract')]
    nft_contract_address: Annotated[
        Optional[str], Field(None, title='Nft Contract Address')
    ]
    nft_contract_design_id: Annotated[
        Optional[str], Field(None, title='Nft Contract Design Id')
    ]
    status: DomainConfigStatus


class DomainRegistry(BaseModel):
    schemas: Annotated[Dict[str, ClaimSchemaInfo], Field(title='Schemas')]


class EncryptionMethodCode(str, Enum):
    AES = 'AES'


class Evidence(BaseModel):
    """
    Designed for the issuer to help the verifier determine level of confidence
    it can have in claims inside the VC. Basically the VC version of a level of assurance (LOA)
    in a more traditional authentication system

    type (type): determines what type of evidence it is, eg "IssuerPolicy"
    id: should point to where more information about evidence can be found
    verifier: eg "https://example.edu/issuers/14"
    evidence_document: eg "DriverLicense"
    subject_presenec: eg "Physical"
    document_presence: eg "Physical"
    """

    type: Annotated[List[str], Field(title='Type')]
    id: Annotated[Optional[str], Field(None, title='Id')]
    verifier: Annotated[Optional[str], Field(None, title='Verifier')]
    evidenceDocument: Annotated[Optional[str], Field(None, title='Evidencedocument')]
    subjectPresence: Annotated[Optional[str], Field(None, title='Subjectpresence')]
    documentPresence: Annotated[Optional[str], Field(None, title='Documentpresence')]


class GranularityCode(str, Enum):
    item = 'item'
    batch = 'batch'
    model = 'model'


class HashMethodCode(str, Enum):
    SHA_256 = 'SHA-256'
    SHA_1 = 'SHA-1'


class IdentifierSchemeInput(BaseModel):
    id: Annotated[
        str,
        Field(
            description='The globally unique identifier of the registration scheme. The scheme should be registered and discoverable from vocabulary.uncefact.org/identifierSchemes',
            title='Id',
        ),
    ]
    name: Annotated[
        str, Field(description='The name of the identifier scheme.', title='Name')
    ]


class IdentifierSchemeOutput(BaseModel):
    id: Annotated[
        str,
        Field(
            description='The globally unique identifier of the registration scheme. The scheme should be registered and discoverable from vocabulary.uncefact.org/identifierSchemes',
            title='Id',
        ),
    ]
    name: Annotated[
        str, Field(description='The name of the identifier scheme.', title='Name')
    ]
    type: Annotated[List[str], Field(title='Type')]


class LinkInput(BaseModel):
    linkURL: Annotated[
        str, Field(description='The URL of the target resource.', title='Linkurl')
    ]
    linkName: Annotated[
        str,
        Field(description='A display name for the target resource', title='Linkname'),
    ]
    linkType: Annotated[
        str,
        Field(
            description='The type of the target resource - drawn from a controlled vocabulary',
            title='Linktype',
        ),
    ]


class LinkOutput(BaseModel):
    linkURL: Annotated[
        str, Field(description='The URL of the target resource.', title='Linkurl')
    ]
    linkName: Annotated[
        str,
        Field(description='A display name for the target resource', title='Linkname'),
    ]
    linkType: Annotated[
        str,
        Field(
            description='The type of the target resource - drawn from a controlled vocabulary',
            title='Linktype',
        ),
    ]
    type: Annotated[List[str], Field(title='Type')]


class ListAccounts(BaseModel):
    count: Annotated[Optional[int], Field(0, title='Count')]
    next: Annotated[Optional[str], Field(None, title='Next')]
    previous: Annotated[Optional[str], Field(None, title='Previous')]
    results: Annotated[Optional[List[BlocksAccount]], Field(None, title='Results')]


class OperationalScopeCode(str, Enum):
    CradleToGate = 'CradleToGate'
    CradleToGrave = 'CradleToGrave'


class Page(RootModel[int]):
    root: Annotated[int, Field(ge=1, title='Page')]


class Size(RootModel[int]):
    root: Annotated[int, Field(ge=1, title='Size')]


class Pages(RootModel[int]):
    root: Annotated[int, Field(ge=0, title='Pages')]


class PageStr(BaseModel):
    items: Annotated[List[str], Field(title='Items')]
    total: Annotated[int, Field(ge=0, title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]


class PendingTxn(BaseModel):
    """
    Object containing txn_id and raw_txn for a blocks blockchain txn

    We make both fields optional so that we can return an empty object when nothing is pending
    """

    txn_id: Annotated[Optional[str], Field(None, title='Txn Id')]
    raw_txn: Annotated[Optional[Dict[str, Any]], Field(None, title='Raw Txn')]


class PingResponse(BaseModel):
    component: Annotated[str, Field(title='Component')]
    success: Annotated[bool, Field(title='Success')]
    error: Annotated[Optional[str], Field(None, title='Error')]


class PingResponses(BaseModel):
    service: Annotated[str, Field(title='Service')]
    responses: Annotated[List[PingResponse], Field(title='Responses')]


class ProductOutput(RootModel[Union[Dict[str, Any], str, int, bool, List]]):
    root: Union[Dict[str, Any], str, int, bool, List]


class Prohibition(BaseModel):
    """
    Need to research
    """

    assigner: Annotated[str, Field(title='Assigner')]
    assignee: Annotated[str, Field(title='Assignee')]
    target: Annotated[str, Field(title='Target')]
    action: Annotated[List[str], Field(title='Action')]


class ProofInput(BaseModel):
    """
    spec: https://www.w3.org/TR/vc-data-model/#proofs-signatures
    """

    type: Annotated[
        str, Field(description='String identifying the proof type.', title='Type')
    ]
    created: Annotated[
        datetime.datetime, Field(description='When the proof was created.', title='Created')
    ]
    proofPurpose: Annotated[
        str,
        Field(
            description='The purpose of the proof. Typically this is `assertionMethod` which means the proof is used to assert a proof value.',
            title='Proofpurpose',
        ),
    ]
    verificationMethod: Annotated[
        str,
        Field(
            description='DID url pointing to a public key in a DID document to use in verifying this proof.',
            title='Verificationmethod',
        ),
    ]
    cryptosuite: Annotated[Optional[str], Field(None, title='Cryptosuite')]


class ProofOutput(BaseModel):
    """
    spec: https://www.w3.org/TR/vc-data-model/#proofs-signatures
    """

    type: Annotated[
        str, Field(description='String identifying the proof type.', title='Type')
    ]
    created: Annotated[
        str, Field(description='When the proof was created.', title='Created')
    ]
    proofPurpose: Annotated[
        str,
        Field(
            description='The purpose of the proof. Typically this is `assertionMethod` which means the proof is used to assert a proof value.',
            title='Proofpurpose',
        ),
    ]
    verificationMethod: Annotated[
        str,
        Field(
            description='DID url pointing to a public key in a DID document to use in verifying this proof.',
            title='Verificationmethod',
        ),
    ]
    cryptosuite: Annotated[Optional[str], Field(None, title='Cryptosuite')]


class ProofDigest(BaseModel):
    vm_id: Annotated[Optional[str], Field(None, title='Vm Id')]
    digest: Annotated[Optional[Union[bytes, str]], Field(None, title='Digest')]
    proof_in_sig: Annotated[Optional[bool], Field(False, title='Proof In Sig')]
    public_key: Annotated[Optional[str], Field(None, title='Public Key')]


class PublicKeyInfo(BaseModel):
    """
    A Helper class to describe the type of PublicKey contained in a payload:
    - `type`: PublicKey type.
    - `public_key`: PublicKey value.
    """

    type: Annotated[str, Field(description='PublicKey type.', title='Type')]
    public_key: Annotated[
        str, Field(description='PublicKey value.', title='Public Key')
    ]


class RedactedClientCreds(BaseModel):
    platform_api_base_uri: Annotated[str, Field(title='Platform Api Base Uri')]
    platform_auth_base_uri: Annotated[str, Field(title='Platform Auth Base Uri')]
    platform_client_id: Annotated[str, Field(title='Platform Client Id')]
    platform_client_secret: Annotated[
        Optional[Union[str, SecretStr]], Field(None, title='Platform Client Secret')
    ]
    platform_auth_provider: Annotated[str, Field(title='Platform Auth Provider')]
    resource_base_url: Annotated[str, Field(title='Resource Base Url')]
    resource_client_id: Annotated[str, Field(title='Resource Client Id')]
    resource_client_secret: Annotated[
        Optional[Union[str, SecretStr]], Field(None, title='Resource Client Secret')
    ]


class RedactedDomainConfiguration(BaseModel):
    platform_connection_timeout: Annotated[
        Optional[float], Field(5.0, title='Platform Connection Timeout')
    ]
    platform_org: Annotated[Optional[str], Field(None, title='Platform Org')]
    trust_profiles_status: Annotated[
        Optional[str], Field(None, title='Trust Profiles Status')
    ]
    admin_account_alias: Annotated[
        Optional[str], Field(None, title='Admin Account Alias')
    ]
    admin_account_address: Annotated[
        Optional[str], Field(None, title='Admin Account Address')
    ]
    admin_account_org: Annotated[Optional[str], Field(None, title='Admin Account Org')]
    blockchain: Annotated[Optional[str], Field(None, title='Blockchain')]
    schema_registry_type: Annotated[
        Optional[str], Field(None, title='Schema Registry Type')
    ]
    schema_registry_url: Annotated[
        Optional[str], Field(None, title='Schema Registry Url')
    ]
    schema_registry_default_domain: Annotated[
        Optional[str], Field('e616', title='Schema Registry Default Domain')
    ]
    github_org: Annotated[Optional[str], Field('SIMBAChain', title='Github Org')]
    github_repo: Annotated[Optional[str], Field('context', title='Github Repo')]
    github_secret: Annotated[
        Optional[Union[str, SecretStr]], Field(None, title='Github Secret')
    ]
    credential_app: Annotated[Optional[str], Field(None, title='Credential App')]
    contract_libraries: Annotated[
        Optional[Dict[str, str]], Field(None, title='Contract Libraries')
    ]
    fed_contract: Annotated[Optional[str], Field(None, title='Fed Contract')]
    fed_contract_address: Annotated[
        Optional[str], Field(None, title='Fed Contract Address')
    ]
    fed_contract_design_id: Annotated[
        Optional[str], Field(None, title='Fed Contract Design Id')
    ]
    std_contract: Annotated[Optional[str], Field(None, title='Std Contract')]
    std_contract_address: Annotated[
        Optional[str], Field(None, title='Std Contract Address')
    ]
    std_contract_design_id: Annotated[
        Optional[str], Field(None, title='Std Contract Design Id')
    ]
    msc_contract: Annotated[Optional[str], Field(None, title='Msc Contract')]
    msc_contract_address: Annotated[
        Optional[str], Field(None, title='Msc Contract Address')
    ]
    msc_contract_design_id: Annotated[
        Optional[str], Field(None, title='Msc Contract Design Id')
    ]
    nft_contract: Annotated[Optional[str], Field(None, title='Nft Contract')]
    nft_contract_address: Annotated[
        Optional[str], Field(None, title='Nft Contract Address')
    ]
    nft_contract_design_id: Annotated[
        Optional[str], Field(None, title='Nft Contract Design Id')
    ]
    platform_api_base_uri: Annotated[
        Optional[str], Field(None, title='Platform Api Base Uri')
    ]
    platform_auth_base_uri: Annotated[
        Optional[str], Field(None, title='Platform Auth Base Uri')
    ]
    platform_client_id: Annotated[
        Optional[str], Field(None, title='Platform Client Id')
    ]
    platform_client_secret: Annotated[
        Optional[Union[str, SecretStr]], Field(None, title='Platform Client Secret')
    ]
    platform_auth_provider: Annotated[
        Optional[str], Field('PLAT', title='Platform Auth Provider')
    ]
    resource_base_url: Annotated[Optional[str], Field(None, title='Resource Base Url')]
    resource_client_id: Annotated[
        Optional[str], Field(None, title='Resource Client Id')
    ]
    resource_client_secret: Annotated[
        Optional[Union[str, SecretStr]], Field(None, title='Resource Client Secret')
    ]


class RefreshService(BaseModel):
    """
    Allows an issuer to control and provide details about how
    the current VC can be refreshed or updated

    There are issues with privacy and other matters with refreshService property;
    hence, the practice of including in a VC is discouraged

    id: URL where enquirer can obtain the refreshed VC
    type: says what type of refresh service this is, and controls
        what other properties the refresh_service property should contain
    """

    id: Annotated[str, Field(title='Id')]
    type: Annotated[str, Field(title='Type')]


class RenderMethodInput(BaseModel):
    context: Annotated[
        Optional[List[Union[str, Dict[str, Any]]]], Field(None, title='Context')
    ]
    field_type: Annotated[str, Field(alias='@type', title='@Type')]
    id: Annotated[Optional[str], Field(None, title='Id')]
    name: Annotated[Optional[str], Field(None, title='Name')]
    template: Annotated[Optional[str], Field(None, title='Template')]
    digestMultibase: Annotated[Optional[str], Field(None, title='Digestmultibase')]


class RenderMethodOutput(BaseModel):
    field_type: Annotated[str, Field(alias='@type', title='@Type')]
    id: Annotated[Optional[str], Field(None, title='Id')]
    name: Annotated[Optional[str], Field(None, title='Name')]
    template: Annotated[Optional[str], Field(None, title='Template')]
    digestMultibase: Annotated[Optional[str], Field(None, title='Digestmultibase')]


class SchemaTypes(str, Enum):
    string = 'string'
    int = 'int'
    boolean = 'boolean'
    uri = 'uri'
    date = 'date'
    date_time = 'date_time'


class SecureLink(BaseModel):
    linkURL: Annotated[
        str, Field(description='The URL of the target resource.', title='Linkurl')
    ]
    linkName: Annotated[
        str,
        Field(description='A display name for the target resource', title='Linkname'),
    ]
    linkType: Annotated[
        str,
        Field(
            description='The type of the target resource - drawn from a controlled vocabulary',
            title='Linktype',
        ),
    ]
    hashDigest: Annotated[
        str, Field(description='The hash of the file.', title='Hashdigest')
    ]
    hashMethod: Annotated[
        HashMethodCode,
        Field(
            description='The hashing algorithm used to create the target hash. SHA-265 is the recommended standard',
            examples=['SHA-256', 'SHA-1'],
        ),
    ]
    encryptionMethod: Annotated[
        Optional[EncryptionMethodCode],
        Field(
            None,
            description='The symmetric encryption algorithm used to encrypt the link target. AES is the recommended standard. Decryption keys are expected to be passed out of bounds.',
            examples=['AES'],
        ),
    ]


class SeedType(str, Enum):
    DidSeed = 'DidSeed'


class SignedTxn(BaseModel):
    rawTransaction: Annotated[str, Field(title='Rawtransaction')]
    hash: Annotated[str, Field(title='Hash')]
    r: Annotated[int, Field(title='R')]
    s: Annotated[int, Field(title='S')]
    v: Annotated[int, Field(title='V')]


class SubmitSignedCredentialHTTP(BaseModel):
    """
    Model for submitting a signed VC/proof:
        - `signature`: signature created by signing VC with private key
        - `domain`: not required, but can be specified by user

    NOTE: do NOT include other fields in this model, such as issuer or subject,
    since this model gets passed to update_vc and update_vp
    """

    signature: Annotated[str, Field(title='Signature')]
    domain: Annotated[Optional[str], Field(None, title='Domain')]


class TaskStatus(str, Enum):
    INITED = 'INITED'
    RUNNING = 'RUNNING'
    COMPLETED = 'COMPLETED'
    FAILED = 'FAILED'
    ABORTED = 'ABORTED'


class TaskType(str, Enum):
    SYNCHRONOUS_TASK = 'SYNCHRONOUS_TASK'
    UNPUBLISH_CLAIM = 'UNPUBLISH_CLAIM'
    PUBLISH_CLAIM = 'PUBLISH_CLAIM'
    CREATE_DID = 'CREATE_DID'
    CREATE_VC = 'CREATE_VC'
    CREATE_VP = 'CREATE_VP'
    UPDATE_DID = 'UPDATE_DID'
    REVOKE_DID = 'REVOKE_DID'
    REVOKE_VC = 'REVOKE_VC'
    VERIFY = 'VERIFY'


class TermsOfUse(BaseModel):
    """
    type (type): governs contents, eg "IssuerPolicy"
    id: should point to a web page where terms of use for VC or VP can be found
    profile: need to research
    prohibtion: need to research
    """

    type: Annotated[str, Field(title='Type')]
    id: Annotated[Optional[str], Field(None, title='Id')]
    profile: Annotated[Optional[str], Field(None, title='Profile')]
    prohibition: Annotated[
        Optional[List[Prohibition]], Field(None, title='Prohibition')
    ]


class TraceabilityPerformance(BaseModel):
    valueChainProcess: Annotated[
        str,
        Field(
            description='Human readable name for the industry specific value chain process representing this traceability data set.',
            title='Valuechainprocess',
        ),
    ]
    verifiedRatio: Annotated[
        Optional[float],
        Field(
            0.0,
            description='The proportion (0 to 1) of materials in this value chain process that have been traced using verifiable traceability event.',
            title='Verifiedratio',
        ),
    ]
    traceabilityEvent: Annotated[
        Optional[List[SecureLink]],
        Field(
            None,
            description='A list of secure links to digital traceability events that support this traceability performance statement. May be encrypted for confidentiality purposes.',
            title='Traceabilityevent',
        ),
    ]


class UnitOfMeasure(str, Enum):
    field_10 = '10'
    field_11 = '11'
    field_13 = '13'
    field_14 = '14'
    field_15 = '15'
    field_1I = '1I'
    field_20 = '20'
    field_21 = '21'
    field_22 = '22'
    field_23 = '23'
    field_24 = '24'
    field_25 = '25'
    field_27 = '27'
    field_28 = '28'
    field_2A = '2A'
    field_2B = '2B'
    field_2C = '2C'
    field_2G = '2G'
    field_2H = '2H'
    field_2I = '2I'
    field_2J = '2J'
    field_2K = '2K'
    field_2L = '2L'
    field_2M = '2M'
    field_2N = '2N'
    field_2P = '2P'
    field_2Q = '2Q'
    field_2R = '2R'
    field_2U = '2U'
    field_2X = '2X'
    field_2Y = '2Y'
    field_2Z = '2Z'
    field_33 = '33'
    field_34 = '34'
    field_35 = '35'
    field_37 = '37'
    field_38 = '38'
    field_3B = '3B'
    field_3C = '3C'
    field_40 = '40'
    field_41 = '41'
    field_4C = '4C'
    field_4G = '4G'
    field_4H = '4H'
    field_4K = '4K'
    field_4L = '4L'
    field_4M = '4M'
    field_4N = '4N'
    field_4O = '4O'
    field_4P = '4P'
    field_4Q = '4Q'
    field_4R = '4R'
    field_4T = '4T'
    field_4U = '4U'
    field_4W = '4W'
    field_4X = '4X'
    field_56 = '56'
    field_57 = '57'
    field_58 = '58'
    field_59 = '59'
    field_5A = '5A'
    field_5B = '5B'
    field_5E = '5E'
    field_5J = '5J'
    field_60 = '60'
    field_61 = '61'
    field_64 = '64'
    field_66 = '66'
    field_74 = '74'
    field_76 = '76'
    field_77 = '77'
    field_78 = '78'
    field_80 = '80'
    field_81 = '81'
    field_84 = '84'
    field_85 = '85'
    field_87 = '87'
    field_89 = '89'
    field_91 = '91'
    A1 = 'A1'
    A10 = 'A10'
    A11 = 'A11'
    A12 = 'A12'
    A13 = 'A13'
    A14 = 'A14'
    A15 = 'A15'
    A16 = 'A16'
    A17 = 'A17'
    A18 = 'A18'
    A19 = 'A19'
    A2 = 'A2'
    A20 = 'A20'
    A21 = 'A21'
    A22 = 'A22'
    A23 = 'A23'
    A24 = 'A24'
    A25 = 'A25'
    A26 = 'A26'
    A27 = 'A27'
    A28 = 'A28'
    A29 = 'A29'
    A3 = 'A3'
    A30 = 'A30'
    A31 = 'A31'
    A32 = 'A32'
    A33 = 'A33'
    A34 = 'A34'
    A35 = 'A35'
    A36 = 'A36'
    A37 = 'A37'
    A38 = 'A38'
    A39 = 'A39'
    A4 = 'A4'
    A40 = 'A40'
    A41 = 'A41'
    A42 = 'A42'
    A43 = 'A43'
    A44 = 'A44'
    A45 = 'A45'
    A47 = 'A47'
    A48 = 'A48'
    M83 = 'M83'
    A5 = 'A5'
    A50 = 'A50'
    A51 = 'A51'
    A52 = 'A52'
    A53 = 'A53'
    A54 = 'A54'
    A55 = 'A55'
    A56 = 'A56'
    A57 = 'A57'
    A58 = 'A58'
    A59 = 'A59'
    A6 = 'A6'
    A60 = 'A60'
    A61 = 'A61'
    A62 = 'A62'
    A63 = 'A63'
    A64 = 'A64'
    A65 = 'A65'
    A66 = 'A66'
    A67 = 'A67'
    A68 = 'A68'
    A69 = 'A69'
    A7 = 'A7'
    A70 = 'A70'
    A71 = 'A71'
    A73 = 'A73'
    A74 = 'A74'
    A75 = 'A75'
    A76 = 'A76'
    A77 = 'A77'
    A78 = 'A78'
    A79 = 'A79'
    A8 = 'A8'
    A80 = 'A80'
    A81 = 'A81'
    A82 = 'A82'
    A83 = 'A83'
    A84 = 'A84'
    A85 = 'A85'
    A86 = 'A86'
    A87 = 'A87'
    A88 = 'A88'
    A89 = 'A89'
    A9 = 'A9'
    A90 = 'A90'
    A91 = 'A91'
    A93 = 'A93'
    A94 = 'A94'
    A95 = 'A95'
    A96 = 'A96'
    A97 = 'A97'
    A98 = 'A98'
    A99 = 'A99'
    AA = 'AA'
    AB = 'AB'
    ACR = 'ACR'
    ACT = 'ACT'
    AD = 'AD'
    AE = 'AE'
    AH = 'AH'
    AI = 'AI'
    AK = 'AK'
    AL = 'AL'
    AMH = 'AMH'
    AMP = 'AMP'
    ANN = 'ANN'
    APZ = 'APZ'
    AQ = 'AQ'
    ARE = 'ARE'
    AS = 'AS'
    ASM = 'ASM'
    ASU = 'ASU'
    ATM = 'ATM'
    ATT = 'ATT'
    AWG = 'AWG'
    AY = 'AY'
    AZ = 'AZ'
    B1 = 'B1'
    B10 = 'B10'
    B11 = 'B11'
    B12 = 'B12'
    B13 = 'B13'
    B14 = 'B14'
    B15 = 'B15'
    B16 = 'B16'
    B17 = 'B17'
    B18 = 'B18'
    B19 = 'B19'
    B20 = 'B20'
    B21 = 'B21'
    B22 = 'B22'
    B23 = 'B23'
    B24 = 'B24'
    B25 = 'B25'
    B26 = 'B26'
    B27 = 'B27'
    B28 = 'B28'
    B29 = 'B29'
    B3 = 'B3'
    B30 = 'B30'
    B31 = 'B31'
    B32 = 'B32'
    B33 = 'B33'
    B34 = 'B34'
    B35 = 'B35'
    B36 = 'B36'
    B37 = 'B37'
    B38 = 'B38'
    B39 = 'B39'
    B4 = 'B4'
    B40 = 'B40'
    B41 = 'B41'
    B42 = 'B42'
    B43 = 'B43'
    B44 = 'B44'
    B45 = 'B45'
    B46 = 'B46'
    B47 = 'B47'
    B48 = 'B48'
    B49 = 'B49'
    B50 = 'B50'
    B51 = 'B51'
    B52 = 'B52'
    B53 = 'B53'
    B54 = 'B54'
    B55 = 'B55'
    B56 = 'B56'
    B57 = 'B57'
    B58 = 'B58'
    B59 = 'B59'
    B60 = 'B60'
    B61 = 'B61'
    B62 = 'B62'
    B63 = 'B63'
    B64 = 'B64'
    B65 = 'B65'
    B66 = 'B66'
    B67 = 'B67'
    B68 = 'B68'
    B69 = 'B69'
    B7 = 'B7'
    B70 = 'B70'
    B71 = 'B71'
    B72 = 'B72'
    B73 = 'B73'
    B74 = 'B74'
    B75 = 'B75'
    B76 = 'B76'
    B77 = 'B77'
    B78 = 'B78'
    B79 = 'B79'
    B8 = 'B8'
    B80 = 'B80'
    B81 = 'B81'
    B82 = 'B82'
    B83 = 'B83'
    B84 = 'B84'
    B85 = 'B85'
    B86 = 'B86'
    B87 = 'B87'
    B88 = 'B88'
    B89 = 'B89'
    B90 = 'B90'
    B91 = 'B91'
    B92 = 'B92'
    B93 = 'B93'
    B94 = 'B94'
    B95 = 'B95'
    B96 = 'B96'
    B97 = 'B97'
    B98 = 'B98'
    B99 = 'B99'
    BAR = 'BAR'
    BB = 'BB'
    BFT = 'BFT'
    BHP = 'BHP'
    BIL = 'BIL'
    BLD = 'BLD'
    BLL = 'BLL'
    BP = 'BP'
    BPM = 'BPM'
    BQL = 'BQL'
    BTU = 'BTU'
    BUA = 'BUA'
    BUI = 'BUI'
    C0 = 'C0'
    C10 = 'C10'
    C11 = 'C11'
    C12 = 'C12'
    C13 = 'C13'
    C14 = 'C14'
    C15 = 'C15'
    C16 = 'C16'
    C17 = 'C17'
    C18 = 'C18'
    C19 = 'C19'
    C20 = 'C20'
    C21 = 'C21'
    C22 = 'C22'
    C23 = 'C23'
    C24 = 'C24'
    C25 = 'C25'
    C26 = 'C26'
    C27 = 'C27'
    C28 = 'C28'
    C29 = 'C29'
    C3 = 'C3'
    C30 = 'C30'
    C31 = 'C31'
    C32 = 'C32'
    C33 = 'C33'
    C34 = 'C34'
    C35 = 'C35'
    C36 = 'C36'
    C37 = 'C37'
    C38 = 'C38'
    C39 = 'C39'
    C40 = 'C40'
    C41 = 'C41'
    C42 = 'C42'
    C43 = 'C43'
    C44 = 'C44'
    C45 = 'C45'
    C46 = 'C46'
    C47 = 'C47'
    C48 = 'C48'
    C49 = 'C49'
    C50 = 'C50'
    C51 = 'C51'
    C52 = 'C52'
    C53 = 'C53'
    C54 = 'C54'
    C55 = 'C55'
    C56 = 'C56'
    C57 = 'C57'
    C58 = 'C58'
    C59 = 'C59'
    C60 = 'C60'
    C61 = 'C61'
    C62 = 'C62'
    C63 = 'C63'
    C64 = 'C64'
    C65 = 'C65'
    C66 = 'C66'
    C67 = 'C67'
    C68 = 'C68'
    C69 = 'C69'
    C7 = 'C7'
    C70 = 'C70'
    C71 = 'C71'
    C72 = 'C72'
    C73 = 'C73'
    C74 = 'C74'
    C75 = 'C75'
    C76 = 'C76'
    C78 = 'C78'
    C79 = 'C79'
    C8 = 'C8'
    C80 = 'C80'
    C81 = 'C81'
    C82 = 'C82'
    C83 = 'C83'
    C84 = 'C84'
    C85 = 'C85'
    C86 = 'C86'
    C87 = 'C87'
    C88 = 'C88'
    C89 = 'C89'
    C9 = 'C9'
    C90 = 'C90'
    C91 = 'C91'
    C92 = 'C92'
    C93 = 'C93'
    C94 = 'C94'
    C95 = 'C95'
    C96 = 'C96'
    C97 = 'C97'
    C99 = 'C99'
    CCT = 'CCT'
    CDL = 'CDL'
    CEL = 'CEL'
    CEN = 'CEN'
    CF3 = 'CF3'
    CG = 'CG'
    CGM = 'CGM'
    CKG = 'CKG'
    CLF = 'CLF'
    CLT = 'CLT'
    CMK = 'CMK'
    CMQ = 'CMQ'
    CMT = 'CMT'
    CNP = 'CNP'
    CNT = 'CNT'
    COU = 'COU'
    CTG = 'CTG'
    CTM = 'CTM'
    CTN = 'CTN'
    CUR = 'CUR'
    CWA = 'CWA'
    CWI = 'CWI'
    D03 = 'D03'
    D04 = 'D04'
    D1 = 'D1'
    D10 = 'D10'
    D11 = 'D11'
    D12 = 'D12'
    D13 = 'D13'
    D15 = 'D15'
    D16 = 'D16'
    D17 = 'D17'
    D18 = 'D18'
    D19 = 'D19'
    D2 = 'D2'
    D20 = 'D20'
    D21 = 'D21'
    D22 = 'D22'
    D23 = 'D23'
    D24 = 'D24'
    D25 = 'D25'
    D26 = 'D26'
    D27 = 'D27'
    D29 = 'D29'
    D30 = 'D30'
    D31 = 'D31'
    D32 = 'D32'
    D33 = 'D33'
    D34 = 'D34'
    D35 = 'D35'
    D36 = 'D36'
    D37 = 'D37'
    D38 = 'D38'
    D39 = 'D39'
    D41 = 'D41'
    D42 = 'D42'
    D43 = 'D43'
    D44 = 'D44'
    D45 = 'D45'
    D46 = 'D46'
    D47 = 'D47'
    D48 = 'D48'
    D49 = 'D49'
    D5 = 'D5'
    D50 = 'D50'
    D51 = 'D51'
    D52 = 'D52'
    D53 = 'D53'
    D54 = 'D54'
    D55 = 'D55'
    D56 = 'D56'
    D57 = 'D57'
    D58 = 'D58'
    D59 = 'D59'
    D6 = 'D6'
    D60 = 'D60'
    D61 = 'D61'
    D62 = 'D62'
    D63 = 'D63'
    D65 = 'D65'
    D68 = 'D68'
    D69 = 'D69'
    D70 = 'D70'
    D71 = 'D71'
    D72 = 'D72'
    D73 = 'D73'
    D74 = 'D74'
    D75 = 'D75'
    D76 = 'D76'
    D77 = 'D77'
    D78 = 'D78'
    D80 = 'D80'
    D81 = 'D81'
    D82 = 'D82'
    D83 = 'D83'
    D85 = 'D85'
    D86 = 'D86'
    D87 = 'D87'
    D88 = 'D88'
    D89 = 'D89'
    D9 = 'D9'
    D91 = 'D91'
    D93 = 'D93'
    D94 = 'D94'
    D95 = 'D95'
    DAA = 'DAA'
    DAD = 'DAD'
    DAY = 'DAY'
    DB = 'DB'
    DBM = 'DBM'
    DBW = 'DBW'
    DD = 'DD'
    DEC = 'DEC'
    DG = 'DG'
    DJ = 'DJ'
    DLT = 'DLT'
    DMA = 'DMA'
    DMK = 'DMK'
    DMO = 'DMO'
    DMQ = 'DMQ'
    DMT = 'DMT'
    DN = 'DN'
    DPC = 'DPC'
    DPR = 'DPR'
    DPT = 'DPT'
    DRA = 'DRA'
    DRI = 'DRI'
    DRL = 'DRL'
    DT = 'DT'
    DTN = 'DTN'
    DU = 'DU'
    DWT = 'DWT'
    DX = 'DX'
    DZN = 'DZN'
    DZP = 'DZP'
    E01 = 'E01'
    E07 = 'E07'
    E08 = 'E08'
    E09 = 'E09'
    E10 = 'E10'
    E11 = 'E11'
    E12 = 'E12'
    E14 = 'E14'
    E15 = 'E15'
    E16 = 'E16'
    E17 = 'E17'
    E18 = 'E18'
    E19 = 'E19'
    E20 = 'E20'
    E21 = 'E21'
    E22 = 'E22'
    E23 = 'E23'
    E25 = 'E25'
    E27 = 'E27'
    E28 = 'E28'
    E30 = 'E30'
    E31 = 'E31'
    E32 = 'E32'
    E33 = 'E33'
    E34 = 'E34'
    E35 = 'E35'
    E36 = 'E36'
    E37 = 'E37'
    E38 = 'E38'
    E39 = 'E39'
    E4 = 'E4'
    E40 = 'E40'
    E41 = 'E41'
    E42 = 'E42'
    E43 = 'E43'
    E44 = 'E44'
    E45 = 'E45'
    E46 = 'E46'
    E47 = 'E47'
    E48 = 'E48'
    E49 = 'E49'
    E50 = 'E50'
    E51 = 'E51'
    E52 = 'E52'
    E53 = 'E53'
    E54 = 'E54'
    E55 = 'E55'
    E56 = 'E56'
    E57 = 'E57'
    E58 = 'E58'
    E59 = 'E59'
    E60 = 'E60'
    E61 = 'E61'
    E62 = 'E62'
    E63 = 'E63'
    E64 = 'E64'
    E65 = 'E65'
    E66 = 'E66'
    E67 = 'E67'
    E68 = 'E68'
    E69 = 'E69'
    E70 = 'E70'
    E71 = 'E71'
    E72 = 'E72'
    E73 = 'E73'
    E74 = 'E74'
    E75 = 'E75'
    E76 = 'E76'
    E77 = 'E77'
    E78 = 'E78'
    E79 = 'E79'
    E80 = 'E80'
    E81 = 'E81'
    E82 = 'E82'
    E83 = 'E83'
    E84 = 'E84'
    E85 = 'E85'
    E86 = 'E86'
    E87 = 'E87'
    E88 = 'E88'
    E89 = 'E89'
    E90 = 'E90'
    E91 = 'E91'
    E92 = 'E92'
    E93 = 'E93'
    E94 = 'E94'
    E95 = 'E95'
    E96 = 'E96'
    E97 = 'E97'
    E98 = 'E98'
    E99 = 'E99'
    EA = 'EA'
    EB = 'EB'
    EQ = 'EQ'
    F01 = 'F01'
    F02 = 'F02'
    F03 = 'F03'
    F04 = 'F04'
    F05 = 'F05'
    F06 = 'F06'
    F07 = 'F07'
    F08 = 'F08'
    F10 = 'F10'
    F11 = 'F11'
    F12 = 'F12'
    F13 = 'F13'
    F14 = 'F14'
    F15 = 'F15'
    F16 = 'F16'
    F17 = 'F17'
    F18 = 'F18'
    F19 = 'F19'
    F20 = 'F20'
    F21 = 'F21'
    F22 = 'F22'
    F23 = 'F23'
    F24 = 'F24'
    F25 = 'F25'
    F26 = 'F26'
    F27 = 'F27'
    F28 = 'F28'
    F29 = 'F29'
    F30 = 'F30'
    F31 = 'F31'
    F32 = 'F32'
    F33 = 'F33'
    F34 = 'F34'
    F35 = 'F35'
    F36 = 'F36'
    F37 = 'F37'
    F38 = 'F38'
    F39 = 'F39'
    F40 = 'F40'
    F41 = 'F41'
    F42 = 'F42'
    F43 = 'F43'
    F44 = 'F44'
    F45 = 'F45'
    F46 = 'F46'
    F47 = 'F47'
    F48 = 'F48'
    F49 = 'F49'
    F50 = 'F50'
    F51 = 'F51'
    F52 = 'F52'
    F53 = 'F53'
    F54 = 'F54'
    F55 = 'F55'
    F56 = 'F56'
    F57 = 'F57'
    F58 = 'F58'
    F59 = 'F59'
    F60 = 'F60'
    F61 = 'F61'
    F62 = 'F62'
    F63 = 'F63'
    F64 = 'F64'
    F65 = 'F65'
    F66 = 'F66'
    F67 = 'F67'
    F68 = 'F68'
    F69 = 'F69'
    F70 = 'F70'
    F71 = 'F71'
    F72 = 'F72'
    F73 = 'F73'
    F74 = 'F74'
    F75 = 'F75'
    F76 = 'F76'
    F77 = 'F77'
    F78 = 'F78'
    F79 = 'F79'
    F80 = 'F80'
    F81 = 'F81'
    F82 = 'F82'
    F83 = 'F83'
    F84 = 'F84'
    F85 = 'F85'
    F86 = 'F86'
    F87 = 'F87'
    F88 = 'F88'
    F89 = 'F89'
    F90 = 'F90'
    F91 = 'F91'
    F92 = 'F92'
    F93 = 'F93'
    F94 = 'F94'
    F95 = 'F95'
    F96 = 'F96'
    F97 = 'F97'
    F98 = 'F98'
    F99 = 'F99'
    FAH = 'FAH'
    FAR = 'FAR'
    FBM = 'FBM'
    FC = 'FC'
    FF = 'FF'
    FH = 'FH'
    FIT = 'FIT'
    FL = 'FL'
    FNU = 'FNU'
    FOT = 'FOT'
    FP = 'FP'
    FR = 'FR'
    FS = 'FS'
    FTK = 'FTK'
    FTQ = 'FTQ'
    G01 = 'G01'
    G04 = 'G04'
    G05 = 'G05'
    G06 = 'G06'
    G08 = 'G08'
    G09 = 'G09'
    G10 = 'G10'
    G11 = 'G11'
    G12 = 'G12'
    G13 = 'G13'
    G14 = 'G14'
    G15 = 'G15'
    G16 = 'G16'
    G17 = 'G17'
    G18 = 'G18'
    G19 = 'G19'
    G2 = 'G2'
    G20 = 'G20'
    G21 = 'G21'
    G23 = 'G23'
    G24 = 'G24'
    G25 = 'G25'
    G26 = 'G26'
    G27 = 'G27'
    G28 = 'G28'
    G29 = 'G29'
    G3 = 'G3'
    G30 = 'G30'
    G31 = 'G31'
    G32 = 'G32'
    G33 = 'G33'
    G34 = 'G34'
    G35 = 'G35'
    G36 = 'G36'
    G37 = 'G37'
    G38 = 'G38'
    G39 = 'G39'
    G40 = 'G40'
    G41 = 'G41'
    G42 = 'G42'
    G43 = 'G43'
    G44 = 'G44'
    G45 = 'G45'
    G46 = 'G46'
    G47 = 'G47'
    G48 = 'G48'
    G49 = 'G49'
    G50 = 'G50'
    G51 = 'G51'
    G52 = 'G52'
    G53 = 'G53'
    G54 = 'G54'
    G55 = 'G55'
    G56 = 'G56'
    G57 = 'G57'
    G58 = 'G58'
    G59 = 'G59'
    G60 = 'G60'
    G61 = 'G61'
    G62 = 'G62'
    G63 = 'G63'
    G64 = 'G64'
    G65 = 'G65'
    G66 = 'G66'
    G67 = 'G67'
    G68 = 'G68'
    G69 = 'G69'
    G70 = 'G70'
    G71 = 'G71'
    G72 = 'G72'
    G73 = 'G73'
    G74 = 'G74'
    G75 = 'G75'
    G76 = 'G76'
    G77 = 'G77'
    G78 = 'G78'
    G79 = 'G79'
    G80 = 'G80'
    G81 = 'G81'
    G82 = 'G82'
    G83 = 'G83'
    G84 = 'G84'
    G85 = 'G85'
    G86 = 'G86'
    G87 = 'G87'
    G88 = 'G88'
    G89 = 'G89'
    G90 = 'G90'
    G91 = 'G91'
    G92 = 'G92'
    G93 = 'G93'
    G94 = 'G94'
    G95 = 'G95'
    G96 = 'G96'
    G97 = 'G97'
    G98 = 'G98'
    G99 = 'G99'
    GB = 'GB'
    GBQ = 'GBQ'
    GDW = 'GDW'
    GE = 'GE'
    GF = 'GF'
    GFI = 'GFI'
    GGR = 'GGR'
    GIA = 'GIA'
    GIC = 'GIC'
    GII = 'GII'
    GIP = 'GIP'
    GJ = 'GJ'
    GL = 'GL'
    GLD = 'GLD'
    GLI = 'GLI'
    GLL = 'GLL'
    GM = 'GM'
    GO = 'GO'
    GP = 'GP'
    GQ = 'GQ'
    GRM = 'GRM'
    GRN = 'GRN'
    GRO = 'GRO'
    GRT = 'GRT'
    GT = 'GT'
    GV = 'GV'
    GWH = 'GWH'
    H03 = 'H03'
    H04 = 'H04'
    H05 = 'H05'
    H06 = 'H06'
    H07 = 'H07'
    H08 = 'H08'
    H09 = 'H09'
    H10 = 'H10'
    H11 = 'H11'
    H12 = 'H12'
    H13 = 'H13'
    H14 = 'H14'
    H15 = 'H15'
    H16 = 'H16'
    H18 = 'H18'
    H19 = 'H19'
    H20 = 'H20'
    H21 = 'H21'
    H22 = 'H22'
    H23 = 'H23'
    H24 = 'H24'
    H25 = 'H25'
    H26 = 'H26'
    H27 = 'H27'
    H28 = 'H28'
    H29 = 'H29'
    H30 = 'H30'
    H31 = 'H31'
    H32 = 'H32'
    H33 = 'H33'
    H34 = 'H34'
    H35 = 'H35'
    H36 = 'H36'
    H37 = 'H37'
    H38 = 'H38'
    H39 = 'H39'
    H40 = 'H40'
    H41 = 'H41'
    H42 = 'H42'
    H43 = 'H43'
    H44 = 'H44'
    H45 = 'H45'
    H46 = 'H46'
    H47 = 'H47'
    H48 = 'H48'
    H49 = 'H49'
    H50 = 'H50'
    H51 = 'H51'
    H52 = 'H52'
    H53 = 'H53'
    H54 = 'H54'
    H55 = 'H55'
    H56 = 'H56'
    H57 = 'H57'
    H58 = 'H58'
    H59 = 'H59'
    H60 = 'H60'
    H61 = 'H61'
    H62 = 'H62'
    H63 = 'H63'
    H64 = 'H64'
    H65 = 'H65'
    H66 = 'H66'
    H67 = 'H67'
    H68 = 'H68'
    H69 = 'H69'
    H70 = 'H70'
    H71 = 'H71'
    H72 = 'H72'
    H73 = 'H73'
    H74 = 'H74'
    H75 = 'H75'
    H76 = 'H76'
    H77 = 'H77'
    H78 = 'H78'
    H79 = 'H79'
    H80 = 'H80'
    H81 = 'H81'
    H82 = 'H82'
    H83 = 'H83'
    H84 = 'H84'
    H85 = 'H85'
    H87 = 'H87'
    H88 = 'H88'
    H89 = 'H89'
    H90 = 'H90'
    H91 = 'H91'
    H92 = 'H92'
    H93 = 'H93'
    H94 = 'H94'
    H95 = 'H95'
    H96 = 'H96'
    H98 = 'H98'
    H99 = 'H99'
    HA = 'HA'
    HAD = 'HAD'
    HAR = 'HAR'
    HBA = 'HBA'
    HBX = 'HBX'
    HC = 'HC'
    HDW = 'HDW'
    HEA = 'HEA'
    HGM = 'HGM'
    HH = 'HH'
    HIU = 'HIU'
    HJ = 'HJ'
    HKM = 'HKM'
    HLT = 'HLT'
    HM = 'HM'
    HMO = 'HMO'
    HMQ = 'HMQ'
    HMT = 'HMT'
    HN = 'HN'
    HP = 'HP'
    HPA = 'HPA'
    HTZ = 'HTZ'
    HUR = 'HUR'
    HWE = 'HWE'
    IA = 'IA'
    IE = 'IE'
    INH = 'INH'
    INK = 'INK'
    INQ = 'INQ'
    ISD = 'ISD'
    IU = 'IU'
    IV = 'IV'
    J10 = 'J10'
    J12 = 'J12'
    J13 = 'J13'
    J14 = 'J14'
    J15 = 'J15'
    J16 = 'J16'
    J17 = 'J17'
    J18 = 'J18'
    J19 = 'J19'
    J2 = 'J2'
    J20 = 'J20'
    J21 = 'J21'
    J22 = 'J22'
    J23 = 'J23'
    J24 = 'J24'
    J25 = 'J25'
    J26 = 'J26'
    J27 = 'J27'
    J28 = 'J28'
    J29 = 'J29'
    J30 = 'J30'
    J31 = 'J31'
    J32 = 'J32'
    J33 = 'J33'
    J34 = 'J34'
    J35 = 'J35'
    J36 = 'J36'
    J38 = 'J38'
    J39 = 'J39'
    J40 = 'J40'
    J41 = 'J41'
    J42 = 'J42'
    J43 = 'J43'
    J44 = 'J44'
    J45 = 'J45'
    J46 = 'J46'
    J47 = 'J47'
    J48 = 'J48'
    J49 = 'J49'
    J50 = 'J50'
    J51 = 'J51'
    J52 = 'J52'
    J53 = 'J53'
    J54 = 'J54'
    J55 = 'J55'
    J56 = 'J56'
    J57 = 'J57'
    J58 = 'J58'
    J59 = 'J59'
    J60 = 'J60'
    J61 = 'J61'
    J62 = 'J62'
    J63 = 'J63'
    J64 = 'J64'
    J65 = 'J65'
    J66 = 'J66'
    J67 = 'J67'
    J68 = 'J68'
    J69 = 'J69'
    J70 = 'J70'
    J71 = 'J71'
    J72 = 'J72'
    J73 = 'J73'
    J74 = 'J74'
    J75 = 'J75'
    J76 = 'J76'
    J78 = 'J78'
    J79 = 'J79'
    J81 = 'J81'
    J82 = 'J82'
    J83 = 'J83'
    J84 = 'J84'
    J85 = 'J85'
    J87 = 'J87'
    J89 = 'J89'
    J90 = 'J90'
    J91 = 'J91'
    J92 = 'J92'
    J93 = 'J93'
    J94 = 'J94'
    J95 = 'J95'
    J96 = 'J96'
    J97 = 'J97'
    J98 = 'J98'
    J99 = 'J99'
    JE = 'JE'
    JK = 'JK'
    JM = 'JM'
    JNT = 'JNT'
    JOU = 'JOU'
    JPS = 'JPS'
    JWL = 'JWL'
    K1 = 'K1'
    K10 = 'K10'
    K11 = 'K11'
    K12 = 'K12'
    K13 = 'K13'
    K14 = 'K14'
    K15 = 'K15'
    K16 = 'K16'
    K17 = 'K17'
    K18 = 'K18'
    K19 = 'K19'
    K2 = 'K2'
    K20 = 'K20'
    K21 = 'K21'
    K22 = 'K22'
    K23 = 'K23'
    K24 = 'K24'
    K25 = 'K25'
    K26 = 'K26'
    K27 = 'K27'
    K28 = 'K28'
    K3 = 'K3'
    K30 = 'K30'
    K31 = 'K31'
    K32 = 'K32'
    K33 = 'K33'
    K34 = 'K34'
    K35 = 'K35'
    K36 = 'K36'
    K37 = 'K37'
    K38 = 'K38'
    K39 = 'K39'
    K40 = 'K40'
    K41 = 'K41'
    K42 = 'K42'
    K43 = 'K43'
    K45 = 'K45'
    K46 = 'K46'
    K47 = 'K47'
    K48 = 'K48'
    K49 = 'K49'
    K5 = 'K5'
    K50 = 'K50'
    K51 = 'K51'
    K52 = 'K52'
    K53 = 'K53'
    K54 = 'K54'
    K55 = 'K55'
    K58 = 'K58'
    K59 = 'K59'
    K6 = 'K6'
    K60 = 'K60'
    K61 = 'K61'
    K62 = 'K62'
    K63 = 'K63'
    K64 = 'K64'
    K65 = 'K65'
    K66 = 'K66'
    K67 = 'K67'
    K68 = 'K68'
    K69 = 'K69'
    K70 = 'K70'
    K71 = 'K71'
    K73 = 'K73'
    K74 = 'K74'
    K75 = 'K75'
    K76 = 'K76'
    K77 = 'K77'
    K78 = 'K78'
    K79 = 'K79'
    K80 = 'K80'
    K81 = 'K81'
    K82 = 'K82'
    K83 = 'K83'
    K84 = 'K84'
    K85 = 'K85'
    K86 = 'K86'
    K87 = 'K87'
    K88 = 'K88'
    K89 = 'K89'
    K90 = 'K90'
    K91 = 'K91'
    K92 = 'K92'
    K93 = 'K93'
    K94 = 'K94'
    K95 = 'K95'
    K96 = 'K96'
    K97 = 'K97'
    K98 = 'K98'
    K99 = 'K99'
    KA = 'KA'
    KAT = 'KAT'
    KB = 'KB'
    KBA = 'KBA'
    KCC = 'KCC'
    KDW = 'KDW'
    KEL = 'KEL'
    KGM = 'KGM'
    KGS = 'KGS'
    KHY = 'KHY'
    KHZ = 'KHZ'
    KI = 'KI'
    KIC = 'KIC'
    KIP = 'KIP'
    KJ = 'KJ'
    KJO = 'KJO'
    KL = 'KL'
    KLK = 'KLK'
    KLX = 'KLX'
    KMA = 'KMA'
    KMH = 'KMH'
    KMK = 'KMK'
    KMQ = 'KMQ'
    KMT = 'KMT'
    KNI = 'KNI'
    KNM = 'KNM'
    KNS = 'KNS'
    KNT = 'KNT'
    KO = 'KO'
    KPA = 'KPA'
    KPH = 'KPH'
    KPO = 'KPO'
    KPP = 'KPP'
    KR = 'KR'
    KSD = 'KSD'
    KSH = 'KSH'
    KT = 'KT'
    KTN = 'KTN'
    KUR = 'KUR'
    KVA = 'KVA'
    KVR = 'KVR'
    KVT = 'KVT'
    KW = 'KW'
    KWH = 'KWH'
    KWN = 'KWN'
    KWO = 'KWO'
    KWS = 'KWS'
    KWT = 'KWT'
    KWY = 'KWY'
    KX = 'KX'
    L10 = 'L10'
    L11 = 'L11'
    L12 = 'L12'
    L13 = 'L13'
    L14 = 'L14'
    L15 = 'L15'
    L16 = 'L16'
    L17 = 'L17'
    L18 = 'L18'
    L19 = 'L19'
    L2 = 'L2'
    L20 = 'L20'
    L21 = 'L21'
    L23 = 'L23'
    L24 = 'L24'
    L25 = 'L25'
    L26 = 'L26'
    L27 = 'L27'
    L28 = 'L28'
    L29 = 'L29'
    L30 = 'L30'
    L31 = 'L31'
    L32 = 'L32'
    L33 = 'L33'
    L34 = 'L34'
    L35 = 'L35'
    L36 = 'L36'
    L37 = 'L37'
    L38 = 'L38'
    L39 = 'L39'
    L40 = 'L40'
    L41 = 'L41'
    L42 = 'L42'
    L43 = 'L43'
    L44 = 'L44'
    L45 = 'L45'
    L46 = 'L46'
    L47 = 'L47'
    L48 = 'L48'
    L49 = 'L49'
    L50 = 'L50'
    L51 = 'L51'
    L52 = 'L52'
    L53 = 'L53'
    L54 = 'L54'
    L55 = 'L55'
    L56 = 'L56'
    L57 = 'L57'
    L58 = 'L58'
    L59 = 'L59'
    L60 = 'L60'
    L63 = 'L63'
    L64 = 'L64'
    L65 = 'L65'
    L66 = 'L66'
    L67 = 'L67'
    L68 = 'L68'
    L69 = 'L69'
    L70 = 'L70'
    L71 = 'L71'
    L72 = 'L72'
    L73 = 'L73'
    L74 = 'L74'
    L75 = 'L75'
    L76 = 'L76'
    L77 = 'L77'
    L78 = 'L78'
    L79 = 'L79'
    L80 = 'L80'
    L81 = 'L81'
    L82 = 'L82'
    L83 = 'L83'
    L84 = 'L84'
    L85 = 'L85'
    L86 = 'L86'
    L87 = 'L87'
    L88 = 'L88'
    L89 = 'L89'
    L90 = 'L90'
    L91 = 'L91'
    L92 = 'L92'
    L93 = 'L93'
    L94 = 'L94'
    L95 = 'L95'
    L96 = 'L96'
    L98 = 'L98'
    L99 = 'L99'
    LA = 'LA'
    LAC = 'LAC'
    LBR = 'LBR'
    LBT = 'LBT'
    LD = 'LD'
    LEF = 'LEF'
    LF = 'LF'
    LH = 'LH'
    LK = 'LK'
    LM = 'LM'
    LN = 'LN'
    LO = 'LO'
    LP = 'LP'
    LPA = 'LPA'
    LR = 'LR'
    LS = 'LS'
    LTN = 'LTN'
    LTR = 'LTR'
    LUB = 'LUB'
    LUM = 'LUM'
    LUX = 'LUX'
    LY = 'LY'
    M1 = 'M1'
    M10 = 'M10'
    M11 = 'M11'
    M12 = 'M12'
    M13 = 'M13'
    M14 = 'M14'
    M15 = 'M15'
    M16 = 'M16'
    M17 = 'M17'
    M18 = 'M18'
    M19 = 'M19'
    M20 = 'M20'
    M21 = 'M21'
    M22 = 'M22'
    M23 = 'M23'
    M24 = 'M24'
    M25 = 'M25'
    M26 = 'M26'
    M27 = 'M27'
    M29 = 'M29'
    M30 = 'M30'
    M31 = 'M31'
    M32 = 'M32'
    M33 = 'M33'
    M34 = 'M34'
    M35 = 'M35'
    M36 = 'M36'
    M37 = 'M37'
    M38 = 'M38'
    M39 = 'M39'
    M4 = 'M4'
    M40 = 'M40'
    M41 = 'M41'
    M42 = 'M42'
    M43 = 'M43'
    M44 = 'M44'
    M45 = 'M45'
    M46 = 'M46'
    M47 = 'M47'
    M48 = 'M48'
    M49 = 'M49'
    M5 = 'M5'
    M50 = 'M50'
    M51 = 'M51'
    M52 = 'M52'
    M53 = 'M53'
    M55 = 'M55'
    M56 = 'M56'
    M57 = 'M57'
    M58 = 'M58'
    M59 = 'M59'
    M60 = 'M60'
    M61 = 'M61'
    M62 = 'M62'
    M63 = 'M63'
    M64 = 'M64'
    M65 = 'M65'
    M66 = 'M66'
    M67 = 'M67'
    M68 = 'M68'
    M69 = 'M69'
    M7 = 'M7'
    M70 = 'M70'
    M71 = 'M71'
    M72 = 'M72'
    M73 = 'M73'
    M74 = 'M74'
    M75 = 'M75'
    M76 = 'M76'
    M77 = 'M77'
    M78 = 'M78'
    M79 = 'M79'
    M80 = 'M80'
    M81 = 'M81'
    M82 = 'M82'
    M84 = 'M84'
    M85 = 'M85'
    M86 = 'M86'
    M87 = 'M87'
    M88 = 'M88'
    M89 = 'M89'
    M9 = 'M9'
    M90 = 'M90'
    M91 = 'M91'
    M92 = 'M92'
    M93 = 'M93'
    M94 = 'M94'
    M95 = 'M95'
    M96 = 'M96'
    M97 = 'M97'
    M98 = 'M98'
    M99 = 'M99'
    MAH = 'MAH'
    MAL = 'MAL'
    MAM = 'MAM'
    MAR = 'MAR'
    MAW = 'MAW'
    MBE = 'MBE'
    MBF = 'MBF'
    MBR = 'MBR'
    MC = 'MC'
    MCU = 'MCU'
    MD = 'MD'
    MGM = 'MGM'
    MHZ = 'MHZ'
    MIK = 'MIK'
    MIL = 'MIL'
    MIN = 'MIN'
    MIO = 'MIO'
    MIU = 'MIU'
    MKD = 'MKD'
    MKM = 'MKM'
    MKW = 'MKW'
    MLD = 'MLD'
    MLT = 'MLT'
    MMK = 'MMK'
    MMQ = 'MMQ'
    MMT = 'MMT'
    MND = 'MND'
    MNJ = 'MNJ'
    MON = 'MON'
    MPA = 'MPA'
    MQD = 'MQD'
    MQH = 'MQH'
    MQM = 'MQM'
    MQS = 'MQS'
    MQW = 'MQW'
    MRD = 'MRD'
    MRM = 'MRM'
    MRW = 'MRW'
    MSK = 'MSK'
    MTK = 'MTK'
    MTQ = 'MTQ'
    MTR = 'MTR'
    MTS = 'MTS'
    MTZ = 'MTZ'
    MVA = 'MVA'
    MWH = 'MWH'
    N1 = 'N1'
    N10 = 'N10'
    N11 = 'N11'
    N12 = 'N12'
    N13 = 'N13'
    N14 = 'N14'
    N15 = 'N15'
    N16 = 'N16'
    N17 = 'N17'
    N18 = 'N18'
    N19 = 'N19'
    N20 = 'N20'
    N21 = 'N21'
    N22 = 'N22'
    N23 = 'N23'
    N24 = 'N24'
    N25 = 'N25'
    N26 = 'N26'
    N27 = 'N27'
    N28 = 'N28'
    N29 = 'N29'
    N3 = 'N3'
    N30 = 'N30'
    N31 = 'N31'
    N32 = 'N32'
    N33 = 'N33'
    N34 = 'N34'
    N35 = 'N35'
    N36 = 'N36'
    N37 = 'N37'
    N38 = 'N38'
    N39 = 'N39'
    N40 = 'N40'
    N41 = 'N41'
    N42 = 'N42'
    N43 = 'N43'
    N44 = 'N44'
    N45 = 'N45'
    N46 = 'N46'
    N47 = 'N47'
    N48 = 'N48'
    N49 = 'N49'
    N50 = 'N50'
    N51 = 'N51'
    N52 = 'N52'
    N53 = 'N53'
    N54 = 'N54'
    N55 = 'N55'
    N56 = 'N56'
    N57 = 'N57'
    N58 = 'N58'
    N59 = 'N59'
    N60 = 'N60'
    N61 = 'N61'
    N62 = 'N62'
    N63 = 'N63'
    N64 = 'N64'
    N65 = 'N65'
    N66 = 'N66'
    N67 = 'N67'
    N68 = 'N68'
    N69 = 'N69'
    N70 = 'N70'
    N71 = 'N71'
    N72 = 'N72'
    N73 = 'N73'
    N74 = 'N74'
    N75 = 'N75'
    N76 = 'N76'
    N77 = 'N77'
    N78 = 'N78'
    N79 = 'N79'
    N80 = 'N80'
    N81 = 'N81'
    N82 = 'N82'
    N83 = 'N83'
    N84 = 'N84'
    N85 = 'N85'
    N86 = 'N86'
    N87 = 'N87'
    N88 = 'N88'
    N89 = 'N89'
    N90 = 'N90'
    N91 = 'N91'
    N92 = 'N92'
    N93 = 'N93'
    N94 = 'N94'
    N95 = 'N95'
    N96 = 'N96'
    N97 = 'N97'
    N98 = 'N98'
    N99 = 'N99'
    NAR = 'NAR'
    NCL = 'NCL'
    NEW = 'NEW'
    NF = 'NF'
    NIL = 'NIL'
    NIU = 'NIU'
    NL = 'NL'
    NM3 = 'NM3'
    NMI = 'NMI'
    NMP = 'NMP'
    NPR = 'NPR'
    NPT = 'NPT'
    NQ = 'NQ'
    NR = 'NR'
    NT = 'NT'
    NTT = 'NTT'
    NTU = 'NTU'
    NU = 'NU'
    NX = 'NX'
    OA = 'OA'
    ODE = 'ODE'
    ODG = 'ODG'
    ODK = 'ODK'
    ODM = 'ODM'
    OHM = 'OHM'
    ON = 'ON'
    ONZ = 'ONZ'
    OPM = 'OPM'
    OT = 'OT'
    OZ = 'OZ'
    OZA = 'OZA'
    OZI = 'OZI'
    P1 = 'P1'
    P10 = 'P10'
    P11 = 'P11'
    P12 = 'P12'
    P13 = 'P13'
    P14 = 'P14'
    P15 = 'P15'
    P16 = 'P16'
    P17 = 'P17'
    P18 = 'P18'
    P19 = 'P19'
    P2 = 'P2'
    P20 = 'P20'
    P21 = 'P21'
    P22 = 'P22'
    P23 = 'P23'
    P24 = 'P24'
    P25 = 'P25'
    P26 = 'P26'
    P27 = 'P27'
    P28 = 'P28'
    P29 = 'P29'
    P30 = 'P30'
    P31 = 'P31'
    P32 = 'P32'
    P33 = 'P33'
    P34 = 'P34'
    P35 = 'P35'
    P36 = 'P36'
    P37 = 'P37'
    P38 = 'P38'
    P39 = 'P39'
    P40 = 'P40'
    P41 = 'P41'
    P42 = 'P42'
    P43 = 'P43'
    P44 = 'P44'
    P45 = 'P45'
    P46 = 'P46'
    P47 = 'P47'
    P48 = 'P48'
    P49 = 'P49'
    P5 = 'P5'
    P50 = 'P50'
    P51 = 'P51'
    P52 = 'P52'
    P53 = 'P53'
    P54 = 'P54'
    P55 = 'P55'
    P56 = 'P56'
    P57 = 'P57'
    P58 = 'P58'
    P59 = 'P59'
    P60 = 'P60'
    P61 = 'P61'
    P62 = 'P62'
    P63 = 'P63'
    P64 = 'P64'
    P65 = 'P65'
    P66 = 'P66'
    P67 = 'P67'
    P68 = 'P68'
    P69 = 'P69'
    P70 = 'P70'
    P71 = 'P71'
    P72 = 'P72'
    P73 = 'P73'
    P74 = 'P74'
    P75 = 'P75'
    P76 = 'P76'
    P77 = 'P77'
    P78 = 'P78'
    P79 = 'P79'
    P80 = 'P80'
    P81 = 'P81'
    P82 = 'P82'
    P83 = 'P83'
    P84 = 'P84'
    P85 = 'P85'
    P86 = 'P86'
    P87 = 'P87'
    P88 = 'P88'
    P89 = 'P89'
    P90 = 'P90'
    P91 = 'P91'
    P92 = 'P92'
    P93 = 'P93'
    P94 = 'P94'
    P95 = 'P95'
    P96 = 'P96'
    P97 = 'P97'
    P98 = 'P98'
    P99 = 'P99'
    PAL = 'PAL'
    PD = 'PD'
    PFL = 'PFL'
    PGL = 'PGL'
    PI = 'PI'
    PLA = 'PLA'
    PO = 'PO'
    PQ = 'PQ'
    PR = 'PR'
    PS = 'PS'
    PT = 'PT'
    PTD = 'PTD'
    PTI = 'PTI'
    PTL = 'PTL'
    PTN = 'PTN'
    Q10 = 'Q10'
    Q11 = 'Q11'
    Q12 = 'Q12'
    Q13 = 'Q13'
    Q14 = 'Q14'
    Q15 = 'Q15'
    Q16 = 'Q16'
    Q17 = 'Q17'
    Q18 = 'Q18'
    Q19 = 'Q19'
    Q20 = 'Q20'
    Q21 = 'Q21'
    Q22 = 'Q22'
    Q23 = 'Q23'
    Q24 = 'Q24'
    Q25 = 'Q25'
    Q26 = 'Q26'
    Q27 = 'Q27'
    Q28 = 'Q28'
    Q29 = 'Q29'
    Q3 = 'Q3'
    Q30 = 'Q30'
    Q31 = 'Q31'
    Q32 = 'Q32'
    Q33 = 'Q33'
    Q34 = 'Q34'
    Q35 = 'Q35'
    Q36 = 'Q36'
    Q37 = 'Q37'
    Q38 = 'Q38'
    Q39 = 'Q39'
    Q40 = 'Q40'
    Q41 = 'Q41'
    Q42 = 'Q42'
    QA = 'QA'
    QAN = 'QAN'
    QB = 'QB'
    QR = 'QR'
    QT = 'QT'
    QTD = 'QTD'
    QTI = 'QTI'
    QTL = 'QTL'
    QTR = 'QTR'
    R1 = 'R1'
    R9 = 'R9'
    RH = 'RH'
    RM = 'RM'
    ROM = 'ROM'
    RP = 'RP'
    RPM = 'RPM'
    RPS = 'RPS'
    RT = 'RT'
    S3 = 'S3'
    S4 = 'S4'
    SAN = 'SAN'
    SCO = 'SCO'
    SCR = 'SCR'
    SEC = 'SEC'
    SET = 'SET'
    SG = 'SG'
    SHT = 'SHT'
    SIE = 'SIE'
    SM3 = 'SM3'
    SMI = 'SMI'
    SQ = 'SQ'
    SQR = 'SQR'
    SR = 'SR'
    STC = 'STC'
    STI = 'STI'
    STK = 'STK'
    STL = 'STL'
    STN = 'STN'
    STW = 'STW'
    SW = 'SW'
    SX = 'SX'
    SYR = 'SYR'
    T0 = 'T0'
    T3 = 'T3'
    TAH = 'TAH'
    TAN = 'TAN'
    TI = 'TI'
    TIC = 'TIC'
    TIP = 'TIP'
    TKM = 'TKM'
    TMS = 'TMS'
    TNE = 'TNE'
    TP = 'TP'
    TPI = 'TPI'
    TPR = 'TPR'
    TQD = 'TQD'
    TRL = 'TRL'
    TST = 'TST'
    TTS = 'TTS'
    U1 = 'U1'
    U2 = 'U2'
    UA = 'UA'
    UB = 'UB'
    UC = 'UC'
    UIG = 'UIG'
    VA = 'VA'
    VLT = 'VLT'
    VP = 'VP'
    W2 = 'W2'
    WA = 'WA'
    WB = 'WB'
    WCD = 'WCD'
    WE = 'WE'
    WEB = 'WEB'
    WEE = 'WEE'
    WG = 'WG'
    WHR = 'WHR'
    WM = 'WM'
    WSD = 'WSD'
    WTT = 'WTT'
    WW = 'WW'
    X1 = 'X1'
    YDK = 'YDK'
    YDQ = 'YDQ'
    YRD = 'YRD'
    Z11 = 'Z11'
    Z9 = 'Z9'
    ZP = 'ZP'
    ZZ = 'ZZ'


class Name(RootModel[str]):
    root: Annotated[str, Field(max_length=256, min_length=4, title='Name')]


class UpdateDIDMetadataFromUser(BaseModel):
    tags: Annotated[Optional[List[str]], Field(None, title='Tags')]
    name: Annotated[Optional[Name], Field(None, title='Name')]


class UpdateVcHttp(BaseModel):
    tags: Annotated[Optional[List[str]], Field(None, title='Tags')]
    is_public: Annotated[
        Optional[bool], Field(None, examples=['false | true'], title='Is Public')
    ]


class User(BaseModel):
    """
    Pydantic model for representing a User.

    - `member_svc_id`: member-service ID.
    - `email`: Email address
    - `permissions`: Users [permission][credential_service.domain.models.Holder] set.
    - `domains`: List of [Domains][credential_service.domain.models.Domain] to which the user belongs.
    """

    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    field_id: Annotated[
        Optional[str],
        Field(
            None,
            alias='_id',
            description='MongoDB ObjectID of this object.',
            title='Id',
        ),
    ]
    simba_id: Annotated[Optional[str], Field(None, title='Simba Id')]
    member_svc_id: Annotated[Optional[UUID], Field(None, title='Member Svc Id')]
    email: Annotated[
        EmailStr, Field(description="User's email address.", title='Email')
    ]
    permissions: Annotated[Optional[List[str]], Field(None, title='Permissions')]
    domains: Annotated[Optional[List[str]], Field(None, title='Domains')]


class ValidationError(BaseModel):
    loc: Annotated[List[Union[str, int]], Field(title='Location')]
    msg: Annotated[str, Field(title='Message')]
    type: Annotated[str, Field(title='Error Type')]


class VcStatus(str, Enum):
    """
    Enum:
        - `PRE`: Initial state of a VC in the process of being created.
        - `ACCEPTED`: Request to create a VC accepted.
        - `SUBMITTED`: Create VC request submitted.
        - `ACTIVE`: VC has been successfully created, published to the registry and accepted by the
        credentialSubject.
        - `FAILED`: An error occurred, and the VC was not created or published.
        - `PENDING`: The VC is initialized but waiting for the async generation of its proof/digest.
        - `SUBJECT_PENDING`: The VC is created and waiting for the credentialSubject to accept/acknowledge the VC.
        - `SUBJECT_ACCEPTED`: The VC has been accepted/acknowledged by the credentialSubject.
        - `SUBJECT_REJECTED`: The VC has been acknowledged but rejected by the credentialSubject.
        - `UNSIGNED`: The VC needs to be signed.
        - `REVOKE_UNSIGNED`: The VC needs to be signed as the result of a self signing revoke action.
        - `REVOKED`: The VC has been revoked.
        - `REVOKE_FAILED`: Revoking the VC has failed.
    """

    PRE = 'PRE'
    ACCEPTED = 'ACCEPTED'
    SUBMITTED = 'SUBMITTED'
    ACTIVE = 'ACTIVE'
    FAILED = 'FAILED'
    PENDING = 'PENDING'
    SUBJECT_PENDING = 'SUBJECT_PENDING'
    SUBJECT_ACCEPTED = 'SUBJECT_ACCEPTED'
    SUBJECT_REJECTED = 'SUBJECT_REJECTED'
    UNSIGNED = 'UNSIGNED'
    UNSIGNED_AUTO_ACCEPT = 'UNSIGNED_AUTO_ACCEPT'
    REVOKE_UNSIGNED = 'REVOKE_UNSIGNED'
    REVOKED = 'REVOKED'
    REVOKE_FAILED = 'REVOKE_FAILED'


class VerificationMethod(BaseModel):
    """
    specs: https://www.w3.org/TR/did-core/#verification-method-properties

    id must conform to DID syntax
    controller must conform to DID syntax
    - The value of the type property MUST be a string that references exactly one verification method type. In order to maximize global interoperability, the verification method type SHOULD be registered in the DID Specification Registries [DID-SPEC-REGISTRIES].
    public_key_jwk: A map representing a JSON Web Key that conforms to [RFC7517]. See definition of publicKeyJwk for additional constraints.
        - https://python-jose.readthedocs.io/en/latest/jwk/
    public_key_multibase: a string that conforms to a [MULTIBASE] encoded public key
    """

    id: Annotated[str, Field(title='Id')]
    controller: Annotated[str, Field(title='Controller')]
    type: Annotated[str, Field(title='Type')]


class VerificationResult(BaseModel):
    """
    Verification result:

    - `success`: True - successfully verified
    - `error`: Contains the error description when verify fails.
    - `proof_key`: PublicKey value.
    """

    success: Annotated[bool, Field(description='Verify pass or fail.', title='Success')]
    error: Annotated[
        Optional[str],
        Field(None, description='Error messages on Failure.', title='Error'),
    ]
    proof_key: Annotated[
        Optional[PublicKeyInfo], Field(None, description='PublicKey Value.')
    ]


class OwnerType(str, Enum):
    """
    OwnerID-Type.
    """

    SimbaIdentity = 'SimbaIdentity'
    Organisation = 'Organisation'


class VerificationResultVC(BaseModel):
    """
    Result of verifying the VC.
    """

    success: Annotated[bool, Field(description='Verify pass or fail.', title='Success')]
    error: Annotated[
        Optional[str],
        Field(None, description='Error messages on Failure.', title='Error'),
    ]
    proof_key: Annotated[
        Optional[PublicKeyInfo], Field(None, description='PublicKey Value.')
    ]
    owner: Annotated[
        Optional[str],
        Field(
            None,
            description='OwnerId.',
            examples=['u_bd71c8f7-f240-43de-a3c6-c47231eea61f', 'trust'],
            title='Owner',
        ),
    ]
    owner_type: Annotated[
        Optional[OwnerType],
        Field(
            None,
            description='OwnerID-Type.',
            examples=['SimbaIdentity', 'Organisation'],
            title='Owner Type',
        ),
    ]


class VerificationResultVP(BaseModel):
    """
    Result of verifying the VP.
    """

    success: Annotated[bool, Field(description='Verify pass or fail.', title='Success')]
    error: Annotated[
        Optional[str],
        Field(None, description='Error messages on Failure.', title='Error'),
    ]
    proof_key: Annotated[
        Optional[PublicKeyInfo], Field(None, description='PublicKey Value.')
    ]
    owner: Annotated[
        Optional[str],
        Field(
            None,
            description='OwnerId.',
            examples=['u_bd71c8f7-f240-43de-a3c6-c47231eea61f', 'trust'],
            title='Owner',
        ),
    ]
    owner_type: Annotated[
        Optional[OwnerType],
        Field(
            None,
            description='OwnerID-Type.',
            examples=['SimbaIdentity', 'Organisation'],
            title='Owner Type',
        ),
    ]
    vc_result: Annotated[
        Optional[VerificationResultVC],
        Field(
            None, description='Verification result of the embedded VC (issuer side).'
        ),
    ]


class VpMetadataInput(BaseModel):
    """
    Defines the metadata used by `credential-service` to manage VCs

    - `domain`: VPs are Domain scoped.
    - `owner`: The MongoDB ObjectID of the issuing entity (user_id or the Issuer DID).
    - `vc_ids`: A list of MongoDB ObjectIDs that point at the VCs contrained in this VP.
    """

    include: Annotated[Optional[Dict[str, Any]], Field(None, title='Include')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    domain: Annotated[str, Field(title='Domain')]
    owner: Annotated[str, Field(title='Owner')]
    vc_ids: Annotated[Optional[List[str]], Field([], title='Vc Ids')]
    proof_in_sig: Annotated[Optional[bool], Field(False, title='Proof In Sig')]
    digest: Optional[DigestInput] = None
    material: Annotated[Optional[Dict[str, Any]], Field(None, title='Material')]


class VpMetadataOutput(BaseModel):
    """
    Defines the metadata used by `credential-service` to manage VCs

    - `domain`: VPs are Domain scoped.
    - `owner`: The MongoDB ObjectID of the issuing entity (user_id or the Issuer DID).
    - `vc_ids`: A list of MongoDB ObjectIDs that point at the VCs contrained in this VP.
    """

    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    domain: Annotated[str, Field(title='Domain')]
    owner: Annotated[str, Field(title='Owner')]
    vc_ids: Annotated[Optional[List[str]], Field([], title='Vc Ids')]
    proof_in_sig: Annotated[Optional[bool], Field(False, title='Proof In Sig')]
    digest: Optional[Any] = None
    material: Annotated[Optional[Dict[str, Any]], Field(None, title='Material')]


class WalletType(str, Enum):
    EXTERNAL = 'EXTERNAL'
    CUSTODIAL_SERVER_SIGN = 'CUSTODIAL_SERVER_SIGN'
    CUSTODIAL_CLIENT_SIGN = 'CUSTODIAL_CLIENT_SIGN'


class WebTrustConfig(BaseModel):
    secondary_method: Annotated[Optional[str], Field('local', title='Secondary Method')]
    max_create_wait_time: Annotated[
        Optional[int], Field(90, title='Max Create Wait Time')
    ]
    interval_wait_time: Annotated[Optional[int], Field(1, title='Interval Wait Time')]
    config_type: Annotated[Literal['web'], Field('web', title='Config Type')]


class VerifiablePresentation(BaseModel):
    """
    A Verifiable Presentation (VP) is a digital communication method by which a holder can prove to a verifier that they
    possess certain Verifiable Credentials (VCs) without necessarily disclosing the credentials themselves. It is a
    critical component in the Self-Sovereign Identity (SSI) ecosystem, enabling individuals to share proof of their
    identity or other claims in a privacy-preserving and secure manner. Verifiable Presentations leverage Decentralized
    Identifiers (DIDs) and cryptographic proofs to ensure the integrity, authenticity, and selective disclosure of the
    information they convey.

    ##Intended Use:

    - **Privacy-Preserving Verification**: VPs allow credential holders to share evidence of their qualifications, rights,
    or personal attributes without revealing the actual information contained in their Verifiable Credentials. This
    supports data minimization and privacy by only disclosing the information that is strictly necessary for the
    verification process.
    - **Secure and Trustworthy Transactions**: By providing a mechanism for individuals to prove the authenticity of
    their claims cryptographically, VPs facilitate secure and trustworthy interactions online, bridging the trust gap
    in digital communications.
    - **Interoperability Across Different Systems**: The use of standardized formats and protocols (such as DIDs and
    VC data models) enables VPs to be used across various platforms and services, enhancing their utility and adoption
    in diverse applications from finance and education to healthcare and beyond.

    ##Modus Operandi:

    - **Holder Generates VP**: The holder, who is the subject of one or more Verifiable Credentials, constructs a
    Verifiable Presentation. This process involves selecting which credentials or parts thereof to present and applying
    a cryptographic proof that links the VP to their DID, thereby asserting control and legitimacy.
    - **Selective Disclosure**: VPs can be tailored to include only the specific attributes or claims required by the
    verifier, rather than sharing the full content of the underlying VCs. This selective disclosure is facilitated by
    zero-knowledge proofs or similar cryptographic techniques, further protecting the holder's privacy.
    - **Verification by the Recipient**: Upon receiving a VP, the verifier uses the cryptographic proof contained within
    it, along with the public DID documents of the issuer and holder, to verify the authenticity of the presentation.
    This includes confirming that the VP has not been tampered with, that it was indeed created by the holder, and that
    the underlying VCs were issued by a trusted authority.

    Verifiable Presentations thus serve as a powerful tool in the SSI landscape, enabling secure, privacy-respecting,
    and verifiable sharing of credentials in digital environments. They embody the shift towards more user-centric
    models of identity and personal data management, where trust and control are paramount.

    ## Model details

    The model consists of two parts,

    - `metadata`: Used for credential-service management of the VP
    - `vp`: Implements the W3C [VerifiablePresentation](https://www.w3.org/TR/vc-data-model-2.0/#presentations) model.

    ### Metadata
    - `domain`: VPs are Domain scoped.
    - `owner`: The MongoDB ObjectID of the user that owns the credentialSubject DID in the VC from which this VP
    is generated.
    - `vc_ids`: A list of the MongoDB ObjectIDs contained in this VP.


    ### VerifiablePresentation model

    A [VerifiablePresentation](https://www.w3.org/TR/vc-data-model-2.0/#presentations) wraps one or more
    VerifiableCredentials that can be revised or redacted.

    VP fields are,

    - [@context property](https://www.w3.org/TR/vc-data-model/#contexts) A list of IRIs that define the JSON-LD schema
    definitions used by this VP.
    - A [VP proof][vp-proof] signed by the credentialSubject DID's private key.
    - `type`: Optional a list of identifiers that detail the type of this `verifiablePresentation`. Defaults to
    `["VerifiablePresentation"]`.
    - `verifiableCredential`: A list of, possibly redacted,
    [verifiableCredentials][credential_service.domain.models.VerifiableCredential] including their associated
    [VC proofs][vc-proof].

    Example:
    ```
    {
      "@context": [
        "https://www.w3.org/2018/credentials/v1",
        "https://www.w3.org/2018/credentials/examples/v1"
      ],
      "proof": {
        "type": "SparseMerkleTreePresentationMethod2023",
        "created": "2024-03-17T23:09:36.793120+00:00",
        "proofPurpose": "assertionMethod",
        "verificationMethod": "did:smb1:1337:0xfc98c982ca22ea0141c3452325c372ff728e9ccd:28679616904316701770790799279165101395297571430403036280334086149810916751023#1",
        "proofValue": "0xeea446e34172e3979c37f893cdbdf3fad5edb04bf6f0d915802b84679d06c8e26de27ab444a90f8302caa2fadb55026933782cc5a7ad7a8a59fa304b81f6abbe1b",
        "challenge": "0x18",
        "domain": "0x8d242e4bc081e2eeD5eb9d6BF734DdF5d2F435e0",
        "signedRoot": "0x534f17403e949df6c957aada7e2573ef48ac8f5a4adbbe2f848909122d1f44ca5ac4fb9abe0edc04554dab0ca039630d264134b965cad55c81c7743e268f1d3b1c",
        "presentationTime": 1698232514
      },
      "type": ["VerifiablePresentation"],
      "verifiableCredential": [
        {
          "@context": [
            len(dids.items),
            "https://www.w3.org/2018/credentials/examples/v1"
          ],
          "credentialSubject": {
            "id": "did:smb1:1337:0xfc98c982ca22ea0141c3452325c372ff728e9ccd:28679616904316701770790799279165101395297571430403036280334086149810916751023",
            "degree": {
              "type": "BachelorDegree",
              "name": "Bachelor of Science and Arts"
            }
          },
          "issuer": "did:smb1:1337:0xfc98c982ca22ea0141c3452325c372ff728e9ccd:39517405560208510513658073967297468008711112795722749167466577185994559263742",
          "proof": {
            "type": "SparseMerkleTreeMethod2023",
            "created": "2024-03-17T23:08:55.437921+00:00",
            "proofPurpose": "assertionMethod",
            "verificationMethod": "did:smb1:1337:0xfc98c982ca22ea0141c3452325c372ff728e9ccd:39517405560208510513658073967297468008711112795722749167466577185994559263742#1",
            "root": "0x5dfaa3e1b5af69c3a2a51a7707b6b7990353d38314afd4403affbf5c2cdef70c",
            "proofValue": "0x534f17403e949df6c957aada7e2573ef48ac8f5a4adbbe2f848909122d1f44ca5ac4fb9abe0edc04554dab0ca039630d264134b965cad55c81c7743e268f1d3b1c",
            "blockchainMaterial": {
              "root": 5865698791693812260658107850804060579880447127172688873622067536095890111069,
              "issuer": 39517405560208510513658073967297468008711112795722749167466577185994559263742,
              "subject": 28679616904316701770790799279165101395297571430403036280334086149810916751023,
              "validFrom": 1692197338,
              "validTo": 1756392538,
              "0xe40583ebbd9fcb6fa3f43180c2c7f5ed": "Bachelor of Science and Arts",
              "circomProof": {
                "pA": [1, 2],
                "pB": [[1, 2], [1, 2]],
                "pC": [1, 2]
              },
              "circuitName": "SMTInclusionSingleClaim"
            }
          },
          "type": ["VerifiableCredential"],
          "validFrom": "2023-08-16T14:48:58.980888+00:00",
          "validUntil": "2025-08-28T14:48:58.980888+00:00"
        }
      ]
    }
    ```
    """

    field_id: Annotated[
        Optional[str],
        Field(
            None,
            alias='_id',
            description='MongoDB ObjectID of this object.',
            title='Id',
        ),
    ]
    vp: Union[Dict[str, Any], str, int, bool, List]
    metadata: VpMetadataOutput


class DidlibModelsVcVerifiableCredential(BaseModel):
    """
    see following for data model: https://www.w3.org/TR/vc-data-model-2.0/
    id:
        if present:
            The id property MUST express an identifier that others are expected to use when expressing statements about a specific thing identified by that identifier.
            The id property MUST NOT have more than one value.
            The value of the id property MUST be a URL which MAY be dereferenced.
    type:
        The value of the type property MUST be, or map to (through interpretation of the @context property), one or more URIs. If more than one URI is provided, the URIs MUST be interpreted as an unordered set. Syntactic conveniences SHOULD be used to ease developer usage. Such conveniences might include JSON-LD terms. It is RECOMMENDED that each URI in the type be one which, if dereferenced, results in a document containing machine-readable information about the type.
    issuer:
        The value of the issuer property MUST be either a URI or an object containing an id property. It is RECOMMENDED that the URI in the issuer or its id be one which, if dereferenced, results in a document containing machine-readable information about the issuer that can be used to verify the information expressed in the credential.

        The value of the issuer property can also be a JWK (for example, "https://example.com/keys/foo.jwk") or a DID (for example, "did:example:abfe13f712120431c276e12ecab").
    validFrom
        If present, the value of the validFrom property MUST be an [XMLSCHEMA11-2] dateTimeStamp string value representing the date and time the credential becomes valid, which could be a date and time in the future. Note that this value represents the earliest point in time at which the information associated with the credentialSubject property becomes valid.
    validUntil
        If present, the value of the validUntil property MUST be an [XMLSCHEMA11-2] dateTimeStamp string value representing the date and time the credential ceases to be valid, which could be a date and time in the past. Note that this value represents the latest point in time at which the information associated with the credentialSubject property is valid. If a validFrom value exists, the validUntil value MUST be temporally greater than the validFrom value.
    credential_status:
        If present, the value of the credentialStatus property MUST include the following:
            - id property, which MUST be a URI.
            - type property, which expresses the credential status type (also referred to as the credential status method). It is expected that the value will provide enough information to determine the current status of the credential and that machine readable information needs to be retrievable from the URI. For example, the object could contain a link to an external document noting whether or not the credential is suspended or revoked.
    terms_of_use:
        The value of the termsOfUse property MUST specify one or more terms of use policies under which the creator issued the credential or presentation. If the recipient (a holder or verifier) is not willing to adhere to the specified terms of use, then they do so on their own responsibility and might incur legal liability if they violate the stated terms of use. Each termsOfUse value MUST specify its type, for example, IssuerPolicy, and MAY specify its instance id. The precise contents of each term of use is determined by the specific termsOfUse type definition.
    credential_schema:
        The value of the credentialSchema property MUST be one or more data schemas that provide verifiers with enough information to determine if the provided data conforms to the provided schema. Each credentialSchema MUST specify its type (for example, JsonSchemaValidator2018), and an id property that MUST be a URI identifying the schema file. The precise contents of each data schema is determined by the specific type definition.
    evidence:
        The value of the evidence property MUST be one or more evidence schemes providing enough information for a verifier to determine whether the evidence gathered by the issuer meets its confidence requirements for relying on the credential. Each evidence scheme is identified by its type. The id property is optional, but if present, SHOULD contain a URL that points to where more information about this instance of evidence can be found. The precise content of each evidence scheme is determined by the specific evidence type definition.
    refresh_service:
        The value of the refreshService property MUST be one or more refresh services that provides enough information to the recipient's software such that the recipient can refresh the verifiable credential. Each refreshService value MUST specify its type (for example, ManualRefreshService2018) and its id, which is the URI of the service. There is an expectation that machine readable information needs to be retrievable from the URI. The precise content of each refresh service is determined by the specific refreshService type definition.
    """

    field_context: Annotated[
        Optional[List[Union[str, Dict[str, Any]]]],
        Field(
            ['https://www.w3.org/2018/credentials/v1'],
            alias='@context',
            title='@Context',
        ),
    ]
    proof: Optional[ProofInput] = None
    id: Annotated[Optional[str], Field(None, title='Id')]
    type: Annotated[
        Optional[Union[List[str], str]], Field(['VerifiableCredential'], title='Type')
    ]
    issuer: Annotated[Union[str, Dict[str, Any], BaseModelModel], Field(title='Issuer')]
    credentialSubject: Optional[CredentialSubjectInput] = None
    validFrom: Annotated[Optional[datetime.datetime], Field(None, title='Validfrom')]
    validUntil: Annotated[Optional[datetime.datetime], Field(None, title='Validuntil')]
    credentialStatus: Optional[CredentialStatus] = None
    termsOfUse: Optional[TermsOfUse] = None
    credentialSchema: Optional[CredentialSchema] = None
    evidence: Annotated[Optional[List[Evidence]], Field(None, title='Evidence')]
    refreshService: Optional[RefreshService] = None
    name: Annotated[Optional[str], Field(None, title='Name')]
    relatedLink: Annotated[
        Optional[List[Dict[str, Any]]], Field(None, title='Relatedlink')
    ]
    render: Annotated[Optional[List[RenderMethodInput]], Field(None, title='Render')]


class DidlibModelsVcVerifiableCredentialOutput(BaseModel):
    """
    see following for data model: https://www.w3.org/TR/vc-data-model-2.0/
    id:
        if present:
            The id property MUST express an identifier that others are expected to use when expressing statements about a specific thing identified by that identifier.
            The id property MUST NOT have more than one value.
            The value of the id property MUST be a URL which MAY be dereferenced.
    type:
        The value of the type property MUST be, or map to (through interpretation of the @context property), one or more URIs. If more than one URI is provided, the URIs MUST be interpreted as an unordered set. Syntactic conveniences SHOULD be used to ease developer usage. Such conveniences might include JSON-LD terms. It is RECOMMENDED that each URI in the type be one which, if dereferenced, results in a document containing machine-readable information about the type.
    issuer:
        The value of the issuer property MUST be either a URI or an object containing an id property. It is RECOMMENDED that the URI in the issuer or its id be one which, if dereferenced, results in a document containing machine-readable information about the issuer that can be used to verify the information expressed in the credential.

        The value of the issuer property can also be a JWK (for example, "https://example.com/keys/foo.jwk") or a DID (for example, "did:example:abfe13f712120431c276e12ecab").
    validFrom
        If present, the value of the validFrom property MUST be an [XMLSCHEMA11-2] dateTimeStamp string value representing the date and time the credential becomes valid, which could be a date and time in the future. Note that this value represents the earliest point in time at which the information associated with the credentialSubject property becomes valid.
    validUntil
        If present, the value of the validUntil property MUST be an [XMLSCHEMA11-2] dateTimeStamp string value representing the date and time the credential ceases to be valid, which could be a date and time in the past. Note that this value represents the latest point in time at which the information associated with the credentialSubject property is valid. If a validFrom value exists, the validUntil value MUST be temporally greater than the validFrom value.
    credential_status:
        If present, the value of the credentialStatus property MUST include the following:
            - id property, which MUST be a URI.
            - type property, which expresses the credential status type (also referred to as the credential status method). It is expected that the value will provide enough information to determine the current status of the credential and that machine readable information needs to be retrievable from the URI. For example, the object could contain a link to an external document noting whether or not the credential is suspended or revoked.
    terms_of_use:
        The value of the termsOfUse property MUST specify one or more terms of use policies under which the creator issued the credential or presentation. If the recipient (a holder or verifier) is not willing to adhere to the specified terms of use, then they do so on their own responsibility and might incur legal liability if they violate the stated terms of use. Each termsOfUse value MUST specify its type, for example, IssuerPolicy, and MAY specify its instance id. The precise contents of each term of use is determined by the specific termsOfUse type definition.
    credential_schema:
        The value of the credentialSchema property MUST be one or more data schemas that provide verifiers with enough information to determine if the provided data conforms to the provided schema. Each credentialSchema MUST specify its type (for example, JsonSchemaValidator2018), and an id property that MUST be a URI identifying the schema file. The precise contents of each data schema is determined by the specific type definition.
    evidence:
        The value of the evidence property MUST be one or more evidence schemes providing enough information for a verifier to determine whether the evidence gathered by the issuer meets its confidence requirements for relying on the credential. Each evidence scheme is identified by its type. The id property is optional, but if present, SHOULD contain a URL that points to where more information about this instance of evidence can be found. The precise content of each evidence scheme is determined by the specific evidence type definition.
    refresh_service:
        The value of the refreshService property MUST be one or more refresh services that provides enough information to the recipient's software such that the recipient can refresh the verifiable credential. Each refreshService value MUST specify its type (for example, ManualRefreshService2018) and its id, which is the URI of the service. There is an expectation that machine readable information needs to be retrievable from the URI. The precise content of each refresh service is determined by the specific refreshService type definition.
    """

    field_context: Annotated[
        Optional[List[Union[str, Dict[str, Any]]]],
        Field(
            ['https://www.w3.org/2018/credentials/v1'],
            alias='@context',
            title='@Context',
        ),
    ]
    proof: Optional[ProofOutput] = None
    id: Annotated[Optional[str], Field(None, title='Id')]
    type: Annotated[
        Optional[Union[List[str], str]], Field(['VerifiableCredential'], title='Type')
    ]
    issuer: Annotated[Union[str, Dict[str, Any], BaseModelModel], Field(title='Issuer')]
    credentialSubject: Optional[CredentialSubjectOutput] = None
    validFrom: Annotated[Optional[str], Field(None, title='Validfrom')]
    validUntil: Annotated[Optional[str], Field(None, title='Validuntil')]
    credentialStatus: Optional[CredentialStatus] = None
    termsOfUse: Optional[TermsOfUse] = None
    credentialSchema: Optional[CredentialSchema] = None
    evidence: Annotated[Optional[List[Evidence]], Field(None, title='Evidence')]
    refreshService: Optional[RefreshService] = None
    name: Annotated[Optional[str], Field(None, title='Name')]
    relatedLink: Annotated[
        Optional[List[Dict[str, Any]]], Field(None, title='Relatedlink')
    ]
    render: Annotated[Optional[List[RenderMethodOutput]], Field(None, title='Render')]


class DidlibModelsVcVerifiablePresentation(BaseModel):
    """
    see here for @context property: https://www.w3.org/TR/vc-data-model/#contexts

    VerifiablePresentation will contain revised/redacted version of a
    verifiable credential
    """

    field_context: Annotated[
        Optional[List[Union[str, Dict[str, Any]]]],
        Field(
            ['https://www.w3.org/2018/credentials/v1'],
            alias='@context',
            title='@Context',
        ),
    ]
    proof: Optional[ProofInput] = None
    id: Annotated[Optional[str], Field(None, title='Id')]
    type: Annotated[
        Optional[List[str]], Field(['VerifiablePresentation'], title='Type')
    ]
    verifiableCredential: Annotated[
        Optional[List[DidlibModelsVcVerifiableCredential]],
        Field(None, title='Verifiablecredential'),
    ]


class AdminDomain(BaseModel):
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    name: Annotated[str, Field(title='Name')]
    config_status: Optional[DomainConfigStatus] = None
    config: Optional[RedactedDomainConfiguration] = None
    state: Annotated[Optional[Dict[str, Any]], Field(None, title='State')]


class AttributeValue(BaseModel):
    schema_type: SchemaTypes
    description: Annotated[Optional[str], Field(None, title='Description')]
    suggested_values: Annotated[
        Optional[List[Union[str, int]]], Field(None, title='Suggested Values')
    ]


class BaseDIDDocument(BaseModel):
    """
    id: must conform to DID syntax
        - specs: https://www.w3.org/TR/did-core/#did-subject
        - The id property only denotes the DID of the DID subject when it is present in the topmost map of the DID document.
        - a DID subject is the entity identified by a DID and described by a DID document
    controller: must conform to DID syntax
    verification_method: The verificationMethod property is OPTIONAL. If present, the value MUST be a set of verification methods, where each verification
        method is expressed using a map. The verification method map MUST include the id, type, controller, and specific verification material properties that are determined by the value of type and are defined in 5.2.1 Verification Material. A verification method MAY include additional properties. Verification methods SHOULD be registered in the DID Specification Registries [DID-SPEC-REGISTRIES].
    authentication: The authentication verification relationship is used to specify how the DID subject is expected to be authenticated, for purposes such as logging into a website or engaging in any sort of challenge-response protocol. If present, the associated value MUST be a set of one or more verification methods. Each verification method MAY be embedded or referenced.
        - see https://www.w3.org/TR/did-core/#authentication
    assertion_method: A set of either Verification Method maps that conform to the rules in Verification Method properties) or strings that conform to the rules in 3.2 DID URL Syntax.
    key_agreement: The keyAgreement property is OPTIONAL. If present, the associated value MUST be a set of one or more verification methods. Each verification method MAY be embedded or referenced.
    capability_invocation: If present, the associated value MUST be a set of one or more verification methods. Each verification method MAY be embedded or referenced.
    capability_delegation: If present, the associated value MUST be a set of one or more verification methods. Each verification method MAY be embedded or referenced.
    service: A set of Service Endpoint maps that conform to the rules in Service properties.
    """

    field_context: Annotated[
        Optional[Union[List[str], str]], Field(alias='@context', title='@Context')
    ]
    id: Annotated[Optional[str], Field(None, title='Id')]
    alsoKnownAs: Annotated[Optional[List[str]], Field(None, title='Alsoknownas')]
    controller: Annotated[
        Optional[Union[List[str], str]], Field(None, title='Controller')
    ]
    verificationMethod: Annotated[
        Optional[List[VerificationMethod]], Field(None, title='Verificationmethod')
    ]
    authentication: Annotated[
        Optional[List[Union[str, VerificationMethod]]],
        Field(None, title='Authentication'),
    ]
    assertionMethod: Annotated[
        Optional[List[Union[str, VerificationMethod]]],
        Field(None, title='Assertionmethod'),
    ]
    keyAgreement: Annotated[
        Optional[List[Union[str, VerificationMethod]]],
        Field(None, title='Keyagreement'),
    ]
    capabilityInvocation: Annotated[
        Optional[List[Union[str, VerificationMethod]]],
        Field(None, title='Capabilityinvocation'),
    ]
    capabilityDelegation: Annotated[
        Optional[List[Union[str, VerificationMethod]]],
        Field(None, title='Capabilitydelegation'),
    ]
    service: Annotated[Optional[List[DIDService]], Field(None, title='Service')]


class BlockchainTrustConfig(BaseModel):
    secondary_method: Annotated[Optional[str], Field(None, title='Secondary Method')]
    max_create_wait_time: Annotated[
        Optional[int], Field(90, title='Max Create Wait Time')
    ]
    interval_wait_time: Annotated[Optional[int], Field(1, title='Interval Wait Time')]
    config_type: Annotated[
        Literal['blockchain'], Field('blockchain', title='Config Type')
    ]
    org: Annotated[Optional[str], Field('trust', title='Org')]
    app: Annotated[Optional[str], Field('registry', title='App')]
    contract_api: Annotated[str, Field(title='Contract Api')]
    blockchain: Annotated[str, Field(title='Blockchain')]
    blockchain_type: Annotated[str, Field(title='Blockchain Type')]
    blockchain_subtype: Annotated[str, Field(title='Blockchain Subtype')]
    registrar_address: Annotated[str, Field(title='Registrar Address')]
    registrar_alias: Annotated[str, Field(title='Registrar Alias')]
    registrar_org: Annotated[Optional[str], Field(None, title='Registrar Org')]
    registry_type: Annotated[
        Optional[CredReg],
        Field(
            CredReg.inmemory,
            examples=['STDRegistry', 'FederatedRegistry', 'MSCRegistry', 'NFTRegistry'],
        ),
    ]


class CircularityPerformance(BaseModel):
    recyclingInformation: Annotated[
        LinkInput,
        Field(description='A URI pointing to recycling information for the product.'),
    ]
    repairInformation: Annotated[
        LinkInput,
        Field(description='A URI pointing to repair instructions for this product.'),
    ]
    recyclableContent: Annotated[
        float,
        Field(
            description='The fraction of the this product (my mass) that has been designed to be recyclable / re-usable. This will be be the total fraction that can avoid waste / landfill.',
            title='Recyclablecontent',
        ),
    ]
    recycledContent: Annotated[
        float,
        Field(
            description='The fraction (by mass) of recycled / repurposed, repaired content in this product. This will be the total virgin content fraction.',
            title='Recycledcontent',
        ),
    ]
    utilityFactor: Annotated[
        float,
        Field(
            description='An indicator of durability defined as the lifetime (typically measures as usage cycles) for this product divided by the industry average. For example a battery with a 10,000 cycle lifetime where industry average is 5,000 cycles will have a durability factor of 2. If unknown set to 1 or omit.',
            title='Utilityfactor',
        ),
    ]
    materialCircularityIndicator: Annotated[
        float,
        Field(
            description='The overall circularity performance indicator for this product. Calculated as 1 - (V+W)/2D where - V = Virgin material proportion by mass (will be 1- recycled content) - W = Waste leakage proportion by mass (will be 1 - recyclableContent) - D = Utility factor (set to 1 if unknown).',
            title='Materialcircularityindicator',
        ),
    ]


class CreateSchemaHttp(BaseModel):
    schema_name: Annotated[str, Field(title='Schema Name')]
    schema_description: Annotated[
        Optional[str], Field(None, title='Schema Description')
    ]
    attributes: Annotated[Dict[str, AttributeValue], Field(title='Attributes')]


class CreateTrustProfileInput(BaseModel):
    """
    Used to create new TrustProfiles. TrustProfiles are scoped by `Domain` which is sent as a pass parameter.
    The TrustProfile contains the information necessary to define and configure a ProfileService
    instance that controls the type of DID created and subsequent operations on the DID/DIDDocument, VCs and VPs.

    - `name`: Name of the TrustProfile (unique within a Domain).
    - `domain`: Name of the Domain to which this TrustProfile belongs.
    - `did_method`: The name of DID infrastructures used for DID/VC/VP operations.
    - `cryptosuite`: The crypto suite used by this did_method.
    - `config`: did_method specific constants and implementation info used by this did_method.
    """

    name: Annotated[str, Field(examples=['SMB1-ERC191-STD'], title='Name')]
    did_method: Annotated[str, Field(examples=['smb1', 'web'], title='Did Method')]
    cryptosuite: Annotated[
        str,
        Field(
            examples=[
                'ERC191Key2023',
                'SparseMerkleTreeMethod2023',
                'EcdsaSecp256k1VerificationKey2019',
            ],
            title='Cryptosuite',
        ),
    ]
    config: Annotated[
        Union[BlockchainTrustConfig, WebTrustConfig],
        Field(
            discriminator='config_type',
            examples=[
                {
                    'app': 'registry',
                    'blockchain': 'quorum-impartial-reindeer',
                    'blockchain_subtype': 'quorum',
                    'blockchain_type': 'ethereum',
                    'config_type': 'blockchain',
                    'contract_api': 'std-2025-4',
                    'interval_wait_time': 1,
                    'max_create_wait_time': 90,
                    'org': 'trust',
                    'registrar_address': '0xD2688B20ee5e0742c9419f262390Dbea4b60a728',
                    'registrar_alias': 'QuorumDevNewCopy-tsqaYmqp',
                    'registry_type': 'STDRegistry',
                },
                {
                    'config_type': 'web',
                    'interval_wait_time': 1,
                    'max_create_wait_time': 90,
                    'secondary_method': 'local',
                },
            ],
            title='Config',
        ),
    ]


class DIDDocument(BaseModel):
    field_context: Annotated[
        Union[List[str], str], Field(alias='@context', title='@Context')
    ]
    id: Annotated[Optional[str], Field(None, title='Id')]
    alsoKnownAs: Annotated[Optional[List[str]], Field(None, title='Alsoknownas')]
    controller: Annotated[
        Optional[Union[List[str], str]], Field(None, title='Controller')
    ]
    verificationMethod: Annotated[
        Optional[List[VerificationMethod]], Field(None, title='Verificationmethod')
    ]
    authentication: Annotated[
        Optional[List[Union[str, VerificationMethod]]],
        Field(None, title='Authentication'),
    ]
    assertionMethod: Annotated[
        Optional[List[Union[str, VerificationMethod]]],
        Field(None, title='Assertionmethod'),
    ]
    keyAgreement: Annotated[
        Optional[List[Union[str, VerificationMethod]]],
        Field(None, title='Keyagreement'),
    ]
    capabilityInvocation: Annotated[
        Optional[List[Union[str, VerificationMethod]]],
        Field(None, title='Capabilityinvocation'),
    ]
    capabilityDelegation: Annotated[
        Optional[List[Union[str, VerificationMethod]]],
        Field(None, title='Capabilitydelegation'),
    ]
    service: Annotated[Optional[List[DIDService]], Field(None, title='Service')]


class DIDMetadataOptionalInput(BaseModel):
    """
    The `DIDMetadata` provides additional context and status information about the DID within the ecosystem and
    includes,

    - `nickname`:  Owner's familiar DID name. Must be case-insensitive unique for this user.
    - `public_name`: The public name of the entity represented by this DID. Must be case-insensitive unique for this user.
    - `owner`: The entity that owns this DID.
    - `trust_profile`: TrustProfile name, determines the type of DID created and controls subsequent DID operations on DIDS, VCs and VPs.
    - `permission`: Defines the DID's capabilities. An ISSUER DID can be used to create VCs. A HOLDER DID can be used as the credentialSubject in a VC.
    - `domain`: The domain within which this DID operates or is recognized.
    - `alias`: A human-readable name or identifier for this DID.
    - `seed`: A cryptographic seed from which keys associated with this DID can be derived.
    - `tags`: Tags are lower-case keywords used to aid object searching and grouping.
    - `status`: Enumerated field indicating the current status of the DID Document.
        - `PRE`: Default state of a DID in the process of being created.
        - `ACCEPTED`: Request to create a DID accepted.
        - `SUBMITTED`: Create DID request submitted.
        - `ACTIVE`: The DID has been successfully created and published to the registry.
        - `FAILED`: An error occurred, and the DID was not created or published.
        - `SUSPENDED`: The DID has been suspended on chain
        - `REVOKED`: The DID has been revoked
        - `REVOKE_FAILED`: Revoking the DID failed.
    - `account_verified`: A boolean indicating whether the DID owner's account has been verified.
    """

    include: Annotated[Optional[Dict[str, Any]], Field(None, title='Include')]
    tags: Annotated[Optional[List[str]], Field(None, title='Tags')]
    status: Annotated[
        Optional[DidDocStatus],
        Field(
            None,
            examples=[
                'default=PRE | ACCEPTED | SUBMITTED | ACTIVE | FAILED | SUSPENDED | UNSIGNED | REVOKE_UNSIGNED | REVOKED | REVOKE_FAILED'
            ],
        ),
    ]
    account_verified: Annotated[Optional[bool], Field(None, title='Account Verified')]
    permission: Optional[DidPermission] = None
    holder_count: Annotated[Optional[int], Field(None, title='Holder Count')]
    issuer_count: Annotated[Optional[int], Field(None, title='Issuer Count')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    name: Annotated[Optional[str], Field(None, title='Name')]
    owner: Annotated[Optional[str], Field(None, title='Owner')]
    domain: Annotated[Optional[str], Field(None, title='Domain')]
    alias: Annotated[Optional[str], Field(None, title='Alias')]
    seed: Annotated[Optional[str], Field(None, title='Seed')]


class DIDMetadataOptionalOutput(BaseModel):
    """
    The `DIDMetadata` provides additional context and status information about the DID within the ecosystem and
    includes,

    - `nickname`:  Owner's familiar DID name. Must be case-insensitive unique for this user.
    - `public_name`: The public name of the entity represented by this DID. Must be case-insensitive unique for this user.
    - `owner`: The entity that owns this DID.
    - `trust_profile`: TrustProfile name, determines the type of DID created and controls subsequent DID operations on DIDS, VCs and VPs.
    - `permission`: Defines the DID's capabilities. An ISSUER DID can be used to create VCs. A HOLDER DID can be used as the credentialSubject in a VC.
    - `domain`: The domain within which this DID operates or is recognized.
    - `alias`: A human-readable name or identifier for this DID.
    - `seed`: A cryptographic seed from which keys associated with this DID can be derived.
    - `tags`: Tags are lower-case keywords used to aid object searching and grouping.
    - `status`: Enumerated field indicating the current status of the DID Document.
        - `PRE`: Default state of a DID in the process of being created.
        - `ACCEPTED`: Request to create a DID accepted.
        - `SUBMITTED`: Create DID request submitted.
        - `ACTIVE`: The DID has been successfully created and published to the registry.
        - `FAILED`: An error occurred, and the DID was not created or published.
        - `SUSPENDED`: The DID has been suspended on chain
        - `REVOKED`: The DID has been revoked
        - `REVOKE_FAILED`: Revoking the DID failed.
    - `account_verified`: A boolean indicating whether the DID owner's account has been verified.
    """

    tags: Annotated[Optional[List[str]], Field(None, title='Tags')]
    status: Annotated[
        Optional[DidDocStatus],
        Field(
            None,
            examples=[
                'default=PRE | ACCEPTED | SUBMITTED | ACTIVE | FAILED | SUSPENDED | UNSIGNED | REVOKE_UNSIGNED | REVOKED | REVOKE_FAILED'
            ],
        ),
    ]
    account_verified: Annotated[Optional[bool], Field(None, title='Account Verified')]
    permission: Optional[DidPermission] = None
    holder_count: Annotated[Optional[int], Field(None, title='Holder Count')]
    issuer_count: Annotated[Optional[int], Field(None, title='Issuer Count')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    name: Annotated[Optional[str], Field(None, title='Name')]
    owner: Annotated[Optional[str], Field(None, title='Owner')]
    domain: Annotated[Optional[str], Field(None, title='Domain')]
    alias: Annotated[Optional[str], Field(None, title='Alias')]
    seed: Annotated[Optional[str], Field(None, title='Seed')]


class DIDResponseModelInput(BaseModel):
    include: Annotated[Optional[Dict[str, Any]], Field(None, title='Include')]
    field_id: Annotated[
        Optional[str],
        Field(
            None,
            alias='_id',
            description='MongoDB ObjectID of this object.',
            title='Id',
        ),
    ]
    did_document: BaseDIDDocument
    metadata: DIDMetadataOptionalInput


class DIDResponseModelOutput(BaseModel):
    field_id: Annotated[
        Optional[str],
        Field(
            None,
            alias='_id',
            description='MongoDB ObjectID of this object.',
            title='Id',
        ),
    ]
    did_document: BaseDIDDocument
    metadata: DIDMetadataOptionalOutput


class DIDSignedTxn(BaseModel):
    """
    Object to be submitted when signing a DID transaction or revoking a VC:
        - `txn_id`: Not required. The txn_id is stored in DID metadata. txn_id is allowed to be included here because there may be cases in which a user knows the txn_id of a pending transaction that needs to be submitted, and they can actually sign and submit a transaction for that id if they know it
        - `signed_txn`: SignedTxn object, which contains the signed, raw transaction
    """

    txn_id: Annotated[Optional[str], Field(None, title='Txn Id')]
    signed_txn: SignedTxn


class HTTPValidationError(BaseModel):
    detail: Annotated[Optional[List[ValidationError]], Field(None, title='Detail')]


class IdentifierInput(BaseModel):
    id: Annotated[
        str,
        Field(
            description='The globally unique ID of the entity as a resolvable URL according to ISO 18975.',
            examples=[
                'Product - id.gs1.org/01/09520123456788/21/12345',
                'Party - abr.business.gov.au/ABN/View?abn=90664869327',
                'Facility - did:web:facilities.example-company.com:123',
            ],
            title='Id',
        ),
    ]
    name: Annotated[
        str,
        Field(
            description='The registered name of the entity within the identifier scheme.',
            examples=[
                'Product - EV battery 300Ah',
                'Party - Sample Company Pty Ltd',
                'Facility - Green Acres battery factory',
            ],
            title='Name',
        ),
    ]
    registeredId: Annotated[
        str,
        Field(
            description='The registration number (alphanumeric) of the entity within the register. Unique within the register.',
            title='Registeredid',
        ),
    ]
    idScheme: Annotated[
        IdentifierSchemeInput,
        Field(
            description='The identifier scheme.',
            examples=[
                'Product - id.gs1.org/01',
                'Party - business.gov.au/abn',
                'Facility - did:web:facilities.acme.com.',
            ],
        ),
    ]


class IdentifierOutput(BaseModel):
    id: Annotated[
        str,
        Field(
            description='The globally unique ID of the entity as a resolvable URL according to ISO 18975.',
            examples=[
                'Product - id.gs1.org/01/09520123456788/21/12345',
                'Party - abr.business.gov.au/ABN/View?abn=90664869327',
                'Facility - did:web:facilities.example-company.com:123',
            ],
            title='Id',
        ),
    ]
    name: Annotated[
        str,
        Field(
            description='The registered name of the entity within the identifier scheme.',
            examples=[
                'Product - EV battery 300Ah',
                'Party - Sample Company Pty Ltd',
                'Facility - Green Acres battery factory',
            ],
            title='Name',
        ),
    ]
    registeredId: Annotated[
        str,
        Field(
            description='The registration number (alphanumeric) of the entity within the register. Unique within the register.',
            title='Registeredid',
        ),
    ]
    idScheme: Annotated[
        IdentifierSchemeOutput,
        Field(
            description='The identifier scheme.',
            examples=[
                'Product - id.gs1.org/01',
                'Party - business.gov.au/abn',
                'Facility - did:web:facilities.acme.com.',
            ],
        ),
    ]
    type: Annotated[List[str], Field(title='Type')]


class MeasureInput(BaseModel):
    value: Annotated[
        Optional[float],
        Field(0.0, description='The numeric value of the measure', title='Value'),
    ]
    unit: Annotated[
        UnitOfMeasure,
        Field(
            description='Unit of measure drawn from the UNECE Rec20 measure code list.'
        ),
    ]


class MeasureOutput(BaseModel):
    value: Annotated[
        Optional[float],
        Field(0.0, description='The numeric value of the measure', title='Value'),
    ]
    unit: Annotated[
        UnitOfMeasure,
        Field(
            description='Unit of measure drawn from the UNECE Rec20 measure code list.'
        ),
    ]
    type: Annotated[List[str], Field(title='Type')]


class Metric(BaseModel):
    metricName: Annotated[
        str,
        Field(
            description='A human readable name for this metric',
            examples=['Tensile Strength'],
            title='Metricname',
        ),
    ]
    metricValue: Annotated[
        MeasureInput,
        Field(
            description='A numeric value and unit of measure for this metric. Could be a measured value or a specified threshold. Example is the tensile strength of structural steel.',
            examples=[{'unit': 'MPA', 'value': 400}],
        ),
    ]
    score: Annotated[
        str,
        Field(
            description='A score or rank associated with this measured metric.',
            title='Score',
        ),
    ]
    accuracy: Annotated[
        float,
        Field(
            description='A percentage represented as a numeric between 0 and 1 indicating the rage of accuracy of the claimed value (eg 0.05 means that the actual value is within 5% of the claimed value.)',
            title='Accuracy',
        ),
    ]


class PageDIDResponseModel(BaseModel):
    items: Annotated[List[DIDResponseModelOutput], Field(title='Items')]
    total: Annotated[int, Field(ge=0, title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]


class PageVerifiablePresentation(BaseModel):
    items: Annotated[
        List[CredentialServiceDomainModelsVerifiablePresentation], Field(title='Items')
    ]
    total: Annotated[int, Field(ge=0, title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]


class PubKeyAccountInfo(BaseModel):
    """
    Input model to be used when creating a DID:
        - `public_key`: public key to use for DID (ETH address)
        - `public_key_multicodec`: hex verifying key (compressed/uncompressed) OR pre-made multibase (z...)
        - `multicodec_to_multibase`: Default=True, convert hex verifying key to multibase (base58btc)
        - `org`, `alias`, `wallet_type`, `is_client_sign_key`: as before
    """

    public_key: Annotated[
        str,
        Field(
            examples=['0xa508dD875f10C33C52a8abb20E16fc68E981F186'], title='Public Key'
        ),
    ]
    multicodec_to_multibase: Annotated[
        Optional[bool], Field(True, title='Multicodec To Multibase')
    ]
    public_key_multicodec: Annotated[
        Optional[str],
        Field(
            None,
            examples=['zQ3shimdW4hBJNu19cyjVdYpzzAagjQB1eFZPofv22uSruHjZ'],
            title='Public Key Multicodec',
        ),
    ]
    org: Annotated[
        Optional[str], Field(None, examples=['organization_example_2'], title='Org')
    ]
    alias: Annotated[
        Optional[str], Field(None, examples=['alias_example'], title='Alias')
    ]
    wallet_type: Optional[WalletType] = WalletType.CUSTODIAL_SERVER_SIGN
    is_client_sign_key: Annotated[
        Optional[bool], Field(None, title='Is Client Sign Key')
    ]


class Regulation(BaseModel):
    id: Annotated[
        str,
        Field(
            description='The globally unique identifier of this regulation.', title='Id'
        ),
    ]
    name: Annotated[
        str, Field(description='The name of the regulation or act.', title='Name')
    ]
    jurisdictionCountry: Annotated[
        CountryCode,
        Field(
            description='The legal jurisdiction (country) under which the regulation is issued.'
        ),
    ]
    administeredBy: Annotated[
        IdentifierInput,
        Field(
            description='The issuing body of the regulation.',
            examples=[
                'Australian Government Department of Climate Change, Energy, the Environment and Water'
            ],
        ),
    ]
    effectiveDate: Annotated[
        datetime.datetime,
        Field(
            description='The date at which the regulation came into effect.',
            title='Effectivedate',
        ),
    ]


class SMB1MSCDIDDocCreationParams(BaseModel):
    verification_doc: Optional[DIDDocument] = None
    self_sign: Annotated[Optional[bool], Field(False, title='Self Sign')]
    creation_type: Annotated[Literal['msc'], Field('msc', title='Creation Type')]
    signers: Annotated[List[str], Field(title='Signers')]
    threshold: Annotated[int, Field(title='Threshold')]


class SMB1NFTDIDDocCreationParams(BaseModel):
    verification_doc: Optional[DIDDocument] = None
    self_sign: Annotated[Optional[bool], Field(False, title='Self Sign')]
    creation_type: Annotated[Literal['nft'], Field('nft', title='Creation Type')]
    collection: Annotated[str, Field(title='Collection')]
    token_id: Annotated[int, Field(title='Token Id')]


class SMB1STDDIDDocCreationParams(BaseModel):
    verification_doc: Optional[DIDDocument] = None
    self_sign: Annotated[Optional[bool], Field(False, title='Self Sign')]
    creation_type: Annotated[Literal['std'], Field('std', title='Creation Type')]
    controller: Annotated[Optional[str], Field(None, title='Controller')]
    controller_seed: Annotated[Optional[str], Field(None, title='Controller Seed')]
    controller_did_id: Annotated[Optional[int], Field(None, title='Controller Did Id')]


class Standard(BaseModel):
    id: Annotated[
        str,
        Field(
            description='A unique identifier for the standard',
            examples=['https://www.iso.org/standard/60857.html'],
            title='Id',
        ),
    ]
    name: Annotated[str, Field(description='The name of the standard', title='Name')]
    issuingParty: Annotated[
        IdentifierInput, Field(description='The party that issued the standard')
    ]
    issueDate: Annotated[
        datetime.datetime,
        Field(description='The date when the standard was issued.', title='Issuedate'),
    ]


class Task(BaseModel):
    field_id: Annotated[
        Optional[str],
        Field(
            None,
            alias='_id',
            description='MongoDB ObjectID of this object.',
            title='Id',
        ),
    ]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    object_id: Annotated[
        Optional[str], Field('6900a7a921527e86d54277e2', title='Object Id')
    ]
    domain: Annotated[str, Field(title='Domain')]
    owner: Annotated[str, Field(title='Owner')]
    type: TaskType
    error: Annotated[Optional[str], Field(None, title='Error')]
    error_details: Annotated[
        Optional[Dict[str, Any]],
        Field({}, description='Error details on failure.', title='Error Details'),
    ]
    result: Annotated[Optional[Dict[str, Any]], Field(None, title='Result')]
    status: Optional[TaskStatus] = TaskStatus.INITED
    data: Annotated[Optional[Dict[str, Any]], Field(None, title='Data')]


class TrustProfile(BaseModel):
    """
    TrustProfiles are scoped by `Domain` and contain the information necessary to define and configure a ProfileService
    instance that controls the type of DID created and subsequent operations on the DID/DIDDocument, VCs and VPs.

    - `name`: Name of the TrustProfile (unique within a Domain).
    - `domain`: Name of the Domain to which this TrustProfile belongs.
    - `did_method`: The name of DID infrastructures used for DID/VC/VP operations.
    - `cryptosuite`: The crypto suite used by this did_method.
    - `config`: did_method specific constants and implementation info used by this did_method.
    """

    name: Annotated[str, Field(examples=['SMB1-ERC191-STD'], title='Name')]
    did_method: Annotated[str, Field(examples=['smb1', 'web'], title='Did Method')]
    cryptosuite: Annotated[
        str,
        Field(
            examples=[
                'ERC191Key2023',
                'SparseMerkleTreeMethod2023',
                'EcdsaSecp256k1VerificationKey2019',
            ],
            title='Cryptosuite',
        ),
    ]
    config: Annotated[
        Union[BlockchainTrustConfig, WebTrustConfig],
        Field(
            discriminator='config_type',
            examples=[
                {
                    'app': 'registry',
                    'blockchain': 'quorum-impartial-reindeer',
                    'blockchain_subtype': 'quorum',
                    'blockchain_type': 'ethereum',
                    'config_type': 'blockchain',
                    'contract_api': 'std-2025-4',
                    'interval_wait_time': 1,
                    'max_create_wait_time': 90,
                    'org': 'trust',
                    'registrar_address': '0xD2688B20ee5e0742c9419f262390Dbea4b60a728',
                    'registrar_alias': 'QuorumDevNewCopy-tsqaYmqp',
                    'registry_type': 'STDRegistry',
                },
                {
                    'config_type': 'web',
                    'interval_wait_time': 1,
                    'max_create_wait_time': 90,
                    'secondary_method': 'local',
                },
            ],
            title='Config',
        ),
    ]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    field_id: Annotated[
        Optional[str],
        Field(
            None,
            alias='_id',
            description='MongoDB ObjectID of this object.',
            title='Id',
        ),
    ]
    domain: Annotated[
        str,
        Field(
            description='Name of the Domain to which this TrustProfile belongs.',
            title='Domain',
        ),
    ]


class UpdateTrustProfileInput(BaseModel):
    config: Annotated[
        Union[BlockchainTrustConfig, WebTrustConfig],
        Field(
            discriminator='config_type',
            examples=[
                {
                    'app': 'registry',
                    'blockchain': 'quorum-impartial-reindeer',
                    'blockchain_subtype': 'quorum',
                    'blockchain_type': 'ethereum',
                    'config_type': 'blockchain',
                    'contract_api': 'std-2025-4',
                    'interval_wait_time': 1,
                    'max_create_wait_time': 90,
                    'org': 'trust',
                    'registrar_address': '0xD2688B20ee5e0742c9419f262390Dbea4b60a728',
                    'registrar_alias': 'QuorumDevNewCopy-tsqaYmqp',
                    'registry_type': 'STDRegistry',
                },
                {
                    'config_type': 'web',
                    'interval_wait_time': 1,
                    'max_create_wait_time': 90,
                    'secondary_method': 'local',
                },
            ],
            title='Config',
        ),
    ]


class VcMetaDataInput(BaseModel):
    """
    Defines the metadata used by `credential-service` to manage VCs

    - `domain`: VCs are Domain scoped.
    - `owner`: The MongoDB ObjectID of the issuing entity (user_id or the Issuer DID).
    - `holder`: The MongoDB ObjectID of the entity to which this VC's claims are attested (the user_id of the
    - `owner_alias`: The `DID.alais` of the issuing entity.
    - `holder_alias`: The `DID.alais` of the entity to which this VC's claims are attested.
    - `tags`: Tags are lower-case keywords used to aid object searching and grouping.
    - `digest`: digest is what gets signed when self-signing a proof
    - `status`: Enumerated field indicating the current status of the VC document, see
    [VcStatus][credential_service.domain.models.VcStatus].
        - `PRE`:Default state of a VC in the process of being created.
        - `ACCEPTED`: Request to create a VC accepted.
        - `SUBMITTED`: Create VC request submitted.
        - `ACTIVE`: VC has been successfully created and published to the registry.
        - `FAILED`: An error occurred, and the VC was not created or published.
        - `SUBJECT_PENDING`: The VC is created and waiting for the credentialSubject to accept it.
        - `SUBJECT_ACCEPTED`: The VC has been accepted/acknowledged by the credentialSubject.
        - `SUBJECT_REJECTED`: The VC has been accepted/acknowledged by the credentialSubject.
        - `REVOKED`: The VC has been revoked.
        - `REVOKE_UNSIGNED`: The VC requires a txn to complete revocation.
        - `REVOKE_FAILED`: The revoke operation failed for the VC.
    - `issuer_name`: The name of the did that issued this VC.
    - `subject_name`: The name of the did that received this VC.
    - `proof_in_sig`: True or False if the VC was created with this setting.
    - `is_public`: True if the VC can be retrieved from a public endpoint.
    """

    include: Annotated[Optional[Dict[str, Any]], Field(None, title='Include')]
    tags: Annotated[Optional[List[str]], Field(None, title='Tags')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    domain: Annotated[str, Field(title='Domain')]
    owner: Annotated[str, Field(title='Owner')]
    holder: Annotated[str, Field(title='Holder')]
    owner_alias: Annotated[str, Field(title='Owner Alias')]
    holder_alias: Annotated[str, Field(title='Holder Alias')]
    status: Annotated[
        Optional[VcStatus],
        Field(
            VcStatus.PENDING,
            examples=[
                'PRE | ACCEPTED | SUBMITTED | ACTIVE | FAILED | default=PENDING | SUBJECT_default=PENDING | SUBJECT_ACCEPTED | SUBJECT_REJECTED | UNSIGNED | UNSIGNED_AUTO_ACCEPT | REVOKE_UNSIGNED | REVOKED | REVOKE_FAILED'
            ],
        ),
    ]
    issuer_name: Annotated[Optional[str], Field(None, title='Issuer Name')]
    subject_name: Annotated[Optional[str], Field(None, title='Subject Name')]
    proof_in_sig: Annotated[Optional[bool], Field(False, title='Proof In Sig')]
    digest: Optional[DigestInput] = None
    material: Annotated[Optional[Dict[str, Any]], Field(None, title='Material')]
    pending_transaction: Annotated[
        Optional[Dict[str, Any]], Field({}, title='Pending Transaction')
    ]
    is_public: Annotated[Optional[bool], Field(None, title='Is Public')]


class VcMetaDataOutput(BaseModel):
    """
    Defines the metadata used by `credential-service` to manage VCs

    - `domain`: VCs are Domain scoped.
    - `owner`: The MongoDB ObjectID of the issuing entity (user_id or the Issuer DID).
    - `holder`: The MongoDB ObjectID of the entity to which this VC's claims are attested (the user_id of the
    - `owner_alias`: The `DID.alais` of the issuing entity.
    - `holder_alias`: The `DID.alais` of the entity to which this VC's claims are attested.
    - `tags`: Tags are lower-case keywords used to aid object searching and grouping.
    - `digest`: digest is what gets signed when self-signing a proof
    - `status`: Enumerated field indicating the current status of the VC document, see
    [VcStatus][credential_service.domain.models.VcStatus].
        - `PRE`:Default state of a VC in the process of being created.
        - `ACCEPTED`: Request to create a VC accepted.
        - `SUBMITTED`: Create VC request submitted.
        - `ACTIVE`: VC has been successfully created and published to the registry.
        - `FAILED`: An error occurred, and the VC was not created or published.
        - `SUBJECT_PENDING`: The VC is created and waiting for the credentialSubject to accept it.
        - `SUBJECT_ACCEPTED`: The VC has been accepted/acknowledged by the credentialSubject.
        - `SUBJECT_REJECTED`: The VC has been accepted/acknowledged by the credentialSubject.
        - `REVOKED`: The VC has been revoked.
        - `REVOKE_UNSIGNED`: The VC requires a txn to complete revocation.
        - `REVOKE_FAILED`: The revoke operation failed for the VC.
    - `issuer_name`: The name of the did that issued this VC.
    - `subject_name`: The name of the did that received this VC.
    - `proof_in_sig`: True or False if the VC was created with this setting.
    - `is_public`: True if the VC can be retrieved from a public endpoint.
    """

    tags: Annotated[Optional[List[str]], Field(None, title='Tags')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    domain: Annotated[str, Field(title='Domain')]
    owner: Annotated[str, Field(title='Owner')]
    holder: Annotated[str, Field(title='Holder')]
    owner_alias: Annotated[str, Field(title='Owner Alias')]
    holder_alias: Annotated[str, Field(title='Holder Alias')]
    status: Annotated[
        Optional[VcStatus],
        Field(
            VcStatus.PENDING,
            examples=[
                'PRE | ACCEPTED | SUBMITTED | ACTIVE | FAILED | default=PENDING | SUBJECT_default=PENDING | SUBJECT_ACCEPTED | SUBJECT_REJECTED | UNSIGNED | UNSIGNED_AUTO_ACCEPT | REVOKE_UNSIGNED | REVOKED | REVOKE_FAILED'
            ],
        ),
    ]
    issuer_name: Annotated[Optional[str], Field(None, title='Issuer Name')]
    subject_name: Annotated[Optional[str], Field(None, title='Subject Name')]
    proof_in_sig: Annotated[Optional[bool], Field(False, title='Proof In Sig')]
    digest: Optional[DigestOutput] = None
    material: Annotated[Optional[Dict[str, Any]], Field(None, title='Material')]
    pending_transaction: Annotated[
        Optional[Dict[str, Any]], Field({}, title='Pending Transaction')
    ]
    is_public: Annotated[Optional[bool], Field(None, title='Is Public')]


class WebDIDDocCreationParams(BaseModel):
    verification_doc: Optional[DIDDocument] = None
    self_sign: Annotated[Optional[bool], Field(False, title='Self Sign')]
    creation_type: Annotated[Literal['web'], Field('web', title='Creation Type')]
    context: Annotated[
        Optional[List[Union[Dict[str, Any], str]]], Field(None, title='Context')
    ]
    controller: Annotated[Optional[str], Field(None, title='Controller')]
    aka: Annotated[Optional[str], Field(None, title='Aka')]
    did_service: Annotated[Optional[List[DIDService]], Field(None, title='Did Service')]
    key_name: Annotated[Optional[str], Field(None, title='Key Name')]
    required_diddoc_fields: Annotated[
        Optional[List[str]], Field(['id', 'context'], title='Required Diddoc Fields')
    ]


class VerifiableCredential(BaseModel):
    """
    A W3C Verifiable Credential (VC) is a cornerstone in the Self-Sovereign Identity (SSI) ecosystem, offering a
    mechanism for individuals or entities to securely and autonomously manage proofs of qualifications, affiliations,
    privileges, or competencies. These digital credentials are issued by trusted authorities and held by the credential
    subject, who can then share them as needed, retaining control over their personal data. The use of Decentralized
    Identifiers (DIDs) for both the issuer and credential subject underpins the decentralized nature of these
    credentials, promoting privacy, security, and interoperability.

    ##Intended Use:

    - **Supports the decentralization of identity management** by enabling individuals to control their identity
    attributes, share them securely, and prove their authenticity without constant reliance on the issuing authority.
    - **Applicable across diverse domains** such as education, employment, access rights, and identity verification,
    Verifiable Credentials are foundational to the realization of a user-centric digital world that prioritizes
    privacy and data minimization.

    ##Key Details:

    - **Issuer ID (DID)**: A Decentralized Identifier (DID) uniquely represents the issuer of the credential, ensuring
    the source's trustworthiness and facilitating verification without centralized registries.
    - **Credential Subject ID (DID)**: The DID associated with the credential subject enables self-sovereign control
    over identity and data, making it clear who or what the credential is about and ensuring the subject's autonomy in
    managing their credentials.
    - **Proof Mechanism**: Employs cryptographic proofs, such as digital signatures, to guarantee the credential's
    security and immutability. These proofs bind the credential to its issuer and subject through DIDs, safeguarding
    against unauthorized changes and asserting the authenticity of the credential in a decentralized manner.

    By leveraging DIDs, Verifiable Credentials embody the principles of Self-Sovereign Identity, empowering users with
    greater control over their personal information, enhancing privacy, and enabling a more secure and interoperable
    digital identity framework.

    ## Model details

    The model consists of two parts,

    - ` metadata`: Used for credential-service managment of the VC, see
    [VcMetaData][credential_service.domain.models.VcMetaData]
    - `vc`: Used to contain the W3C [VerificableCredential](https://www.w3.org/TR/vc-data-model-2.0/) claim details.

    ### Metadata
    - `domain`: VCs are Domain scoped.
    - `owner`: The MongoDB ObjectID of the issuing entity (user_id or the Issuer DID).
    - `holder`: The MongoDB ObjectID of the entity to which this VC's claims are attested (the user_id of the
    - `owner_alias`: The `DID.alais` of the issuing entity.
    - `holder_alias`: The `DID.alais` of the entity to which this VC's claims are attested.
    - `tags`: Tags are lower-case keywords used to aid object searching and grouping.
    - `issue_status`: Enumerated field indicating the current status of the VC document, see
    [VcStatus][credential_service.domain.models.VcStatus].
        - `PRE`:Default state of a VC in the process of being created.
        - `ACCEPTED`: Request to create a VC accepted.
        - `SUBMITTED`: Create VC request submitted.
        - `COMPLETED`: VC has been successfully created and published to the registry.
        - `FAILED`: An error occurred, and the VC was not created or published.
        - `SUBJECT_PENDING`: The VC is created and waiting for the credentialSubject to accept it.
        - `SUBJECT_ACCEPTED`: The VC has been accepted/acknowledged by the credentialSubject.
        - `SUBJECT_REJECTED`: The VC has been accepted/acknowledged by the credentialSubject.

    - `revoke_status`: Enumerated field indicating the current status of the VC document.
        - `PRE`:Default state, no revoke operations have been carried out on this VC.
        - `ACCEPTED`: Request to revoke the VC accepted.
        - `SUBMITTED`: Revoke VC request submitted.
        - `COMPLETED`: VC has been successfully revoked and is unusable in the future.
        - `FAILED`: An error occurred, and the VC was not created or published.
    - `draft_status`: Indicates whether the VC document is in a draft or final state.
        - `DRAFT`: The state of the VC is changing.
        - `FINAL`: The state of the VC is complete/valid.


    ### VerifiableCredential model

    See [specification details](https://www.w3.org/TR/vc-data-model-2.0/) for more information about the data model.

    - `id`: If present, the `id` property MUST express an identifier that others are expected to use when expressing
    statements about a specific thing identified by that identifier. The `id` property MUST NOT have more than one value.
    The value of the `id` property MUST be a URL which MAY be dereferenced.
    - `type`: The value of the type property MUST be, or map to (through interpretation of the @context property),
    one or more URIs. If more than one URI is provided, the URIs MUST be interpreted as an unordered set. Syntactic
    conveniences SHOULD be used to ease developer usage. Such conveniences might include JSON-LD terms. It is
    RECOMMENDED that each URI in the type be one which, if dereferenced, results in a document containing
    machine-readable information about the type.
    - `issuer`: The [DID identity][credential_service.domain.models.DID] of the trusted party that issued this VCs.
    - `credentialSubject`: This is a dictionary of Claims containing an `id` field which is the
    [DID identity][credential_service.domain.models.DID] of the entity to which the claims are being attested as
    well as a list of claims about the `credentialSubject` identified by the `id` field. For example,

    ```
    "credentialSubject":
        {
        "id": "did:smb1:1337:0xfc98c982ca22ea0141c3452325c372ff728e9ccd:18322500091651578819492444870201097984271428616569706638674662898632050307982",
        "degree": {
            "value": {
                "name": "Bachelor of Science and Arts",
                "type": "BachelorDegree",
            },
            "claim_schema": None,
        }
    }
    ```

    - `validFrom`: The date-time this VC is valid from.
    - `validUntil`: The expiry date-time of this VC.
    - `credentialStatus`: If present, the value of the credentialStatus property MUST include the following:

        - `id` property, which MUST be a URI.
        - `type` property, which expresses the credential status type (also referred to as the credential status method).
        It is expected that the value will provide enough information to determine the current status of the credential
        and that machine readable information needs to be retrievable from the URI. For example, the object could
        contain a link to an external document noting whether or not the credential is suspended or revoked.


    ## VC fields not currently implemented:
    - `termsOfUse`: The value of the termsOfUse property MUST specify one or more terms of use policies under which the
    creator issued the credential or presentation. If the recipient (a holder or verifier) is not willing to adhere to
    the specified terms of use, then they do so on their own responsibility and might incur legal liability if they
    violate the stated terms of use. Each termsOfUse value MUST specify its type, for example, IssuerPolicy, and MAY
    specify its instance id. The precise contents of each term of use is determined by the specific termsOfUse type
    definition.
    - `credential_schema`: The value of the credentialSchema property MUST be one or more data schemas that provide
    verifiers with enough information to determine if the provided data conforms to the provided schema. Each
    credentialSchema MUST specify its type (for example, JsonSchemaValidator2018), and an id property that MUST be a
    URI identifying the schema file. The precise contents of each data schema is determined by the specific type
    definition.
    - `evidence`: The value of the evidence property MUST be one or more evidence schemes providing enough information
    for a verifier to determine whether the evidence gathered by the issuer meets its confidence requirements for relying
    on the credential. Each evidence scheme is identified by its type. The id property is optional, but if present,
    SHOULD contain a URL that points to where more information about this instance of evidence can be found. The precise
    content of each evidence scheme is determined by the specific evidence type definition.
    - `refresh_service`: The value of the refreshService property MUST be one or more refresh services that provides
    enough information to the recipient's software such that the recipient can refresh the verifiable credential. Each
    refreshService value MUST specify its type (for example, ManualRefreshService2018) and its id, which is the URI of
    the service. There is an expectation that machine readable information needs to be retrievable from the URI. The
    precise content of each refresh service is determined by the specific refreshService type definition.
    """

    field_id: Annotated[
        Optional[str],
        Field(
            None,
            alias='_id',
            description='MongoDB ObjectID of this object.',
            title='Id',
        ),
    ]
    vc: Dict[str, Any]
    metadata: VcMetaDataOutput


class AdminCreateDidHttp(BaseModel):
    trust_profile: Annotated[str, Field(title='Trust Profile')]
    account: PubKeyAccountInfo
    permission: Annotated[
        Optional[DidPermission],
        Field(DidPermission.HOLDER, examples=['HOLDER | ISSUER']),
    ]
    alias: Annotated[str, Field(title='Alias')]
    did_doc_creation_params: Annotated[
        Optional[
            Union[
                SMB1STDDIDDocCreationParams,
                SMB1MSCDIDDocCreationParams,
                SMB1NFTDIDDocCreationParams,
                WebDIDDocCreationParams,
            ]
        ],
        Field(
            None,
            examples=[
                {
                    'signers': [
                        '0xd4039eB67CBB36429Ad9DD30187B94f6A5122215',
                        '0x7633Fe8542c2218B5A25777477F63D395aA5aFB4',
                        '0xd5cC383881D6d9A7dc1891A0235E11D03Cb992d3',
                    ],
                    'threshold': 2,
                },
                {
                    'collection': '0x2e3e124bc2Cc43Bc3A8FA8D87322057eD3bB4a5f',
                    'token_id': 1234,
                },
                {
                    'aka': 'did is also known as',
                    'controller': 'did:web:SIMBAChain.github.io:context:diddoc:5fb976f5697fe769a054f516377491c1eadd0f3e51bb58f26990035afa474465',
                    'key_name': 'public key name to use instead of just #1',
                },
                {
                    'controller': 'did:smb1:1337:0x1e1a08635650ba7dbf50e288ec6fe1f0cdd589c8:39963865611866724509013579633969640489790058083737555399194048102476795238657',
                    'controller_seed': 'some seed for controller',
                },
            ],
            title='Did Doc Creation Params',
        ),
    ]
    name: Annotated[Optional[str], Field(None, title='Name')]
    seed: Annotated[str, Field(title='Seed')]
    tags: Annotated[Optional[List[str]], Field(None, title='Tags')]
    seed_type: Annotated[Optional[str], Field('DidSeed', title='Seed Type')]
    target_owner: Annotated[
        str,
        Field(examples=['simba_id of the intended DID owner.'], title='Target Owner'),
    ]


class CreateDidHttp(BaseModel):
    """
    Input model for DID creation:
        - `trust_profile`: TrustProfile name, determines the type of DID created and controls subsequent DID operations
        on DIDS, VCs and VPs.
        - `account`: PubKeyAccountInfo, which inherits from Account in didlib. Can either contain JUST a public_key if it's for client side signing, or can contain info for Blocks account if using a client side signing key
        - `permission`: Defines the DID's capabilities. An ISSUER DID can be used to create VCs.
        A HOLDER DID can be used as the credentialSubject in a VC.
        - `alias`: A human-readable name or identifier for this DID.
        - `seed`: A user-defined seed to enhance DID uniqueness. Allows multiple DIDs per user+alias within this domain.
        Could be a document ID or part-number. Example: `document_id | part-number`
        - `tags`: Tags are lower-case keywords used to aid object searching and grouping.
        - `controller`: An existing **DID.id** that will act as the authorizer for changes to this new DID/DIDDocument.
        - `did_doc_creation_params`: not required when creating an SMB1 DID with STD registry. Optional for github DIDs. Required for all other method / registry combos. See examples below:

            Examples:

            ```
            {
                "signers": [
                    "0xd4039eB67CBB36429Ad9DD30187B94f6A5122215",
                    "0x7633Fe8542c2218B5A25777477F63D395aA5aFB4",
                    "0xd5cC383881D6d9A7dc1891A0235E11D03Cb992d3",
                ],
                "threshold": 2,
            },
            {
                "collection": "0x2e3e124bc2Cc43Bc3A8FA8D87322057eD3bB4a5f",
                "token_id": 1234,
            },
            {
                "controller": "did:web:SIMBAChain.github.io:context:diddoc:5fb976f5697fe769a054f516377491c1eadd0f3e51bb58f26990035afa474465",
                "aka": "did is also known as",
                "key_name": "public key name to use instead of just #1",
            }
            ```

                In the examples, the first example is for SMB1MSCDIDDocCreationParams, the second is for SMB1NFTDIDDocCreationParams, and the third is for GithubDIDDocCreationParams
    """

    trust_profile: Annotated[str, Field(title='Trust Profile')]
    account: PubKeyAccountInfo
    permission: Annotated[
        Optional[DidPermission],
        Field(DidPermission.HOLDER, examples=['HOLDER | ISSUER']),
    ]
    alias: Annotated[str, Field(title='Alias')]
    did_doc_creation_params: Annotated[
        Optional[
            Union[
                SMB1STDDIDDocCreationParams,
                SMB1MSCDIDDocCreationParams,
                SMB1NFTDIDDocCreationParams,
                WebDIDDocCreationParams,
            ]
        ],
        Field(
            None,
            examples=[
                {
                    'signers': [
                        '0xd4039eB67CBB36429Ad9DD30187B94f6A5122215',
                        '0x7633Fe8542c2218B5A25777477F63D395aA5aFB4',
                        '0xd5cC383881D6d9A7dc1891A0235E11D03Cb992d3',
                    ],
                    'threshold': 2,
                },
                {
                    'collection': '0x2e3e124bc2Cc43Bc3A8FA8D87322057eD3bB4a5f',
                    'token_id': 1234,
                },
                {
                    'aka': 'did is also known as',
                    'controller': 'did:web:SIMBAChain.github.io:context:diddoc:5fb976f5697fe769a054f516377491c1eadd0f3e51bb58f26990035afa474465',
                    'key_name': 'public key name to use instead of just #1',
                },
                {
                    'controller': 'did:smb1:1337:0x1e1a08635650ba7dbf50e288ec6fe1f0cdd589c8:39963865611866724509013579633969640489790058083737555399194048102476795238657',
                    'controller_seed': 'some seed for controller',
                },
            ],
            title='Did Doc Creation Params',
        ),
    ]
    name: Annotated[Optional[str], Field(None, title='Name')]
    seed: Annotated[str, Field(title='Seed')]
    tags: Annotated[Optional[List[str]], Field(None, title='Tags')]
    seed_type: Annotated[Optional[str], Field('DidSeed', title='Seed Type')]


class CredentialIssuerInput(BaseModel):
    id: Annotated[
        str,
        Field(
            description='The W3C DID of the issuer',
            examples=['did:web', 'did:tdw'],
            title='Id',
        ),
    ]
    name: Annotated[
        str,
        Field(
            description='The name of the issuer person or organisation', title='Name'
        ),
    ]
    otherIdentifiers: Annotated[
        Optional[List[IdentifierInput]],
        Field(
            None,
            description='An optional list of other registered identifiers for this credential issuer',
            title='Otheridentifiers',
        ),
    ]


class CredentialIssuerOutput(BaseModel):
    id: Annotated[
        str,
        Field(
            description='The W3C DID of the issuer',
            examples=['did:web', 'did:tdw'],
            title='Id',
        ),
    ]
    name: Annotated[
        str,
        Field(
            description='The name of the issuer person or organisation', title='Name'
        ),
    ]
    otherIdentifiers: Annotated[
        Optional[List[IdentifierOutput]],
        Field(
            None,
            description='An optional list of other registered identifiers for this credential issuer',
            title='Otheridentifiers',
        ),
    ]
    type: Annotated[List[str], Field(title='Type')]


class Criterion(BaseModel):
    id: Annotated[
        str,
        Field(
            description='A unique identifier for the criterion within the standard or regulation. For example CO2 emissions calculations for liquid fuel combustion.',
            title='Id',
        ),
    ]
    name: Annotated[
        str, Field(description='A name that describes this criteria', title='Name')
    ]
    thresholdValues: Annotated[
        Optional[List[Metric]],
        Field(
            None,
            description='A conformity threshold defined by the specification (eg minimum compressive strength)',
            title='Thresholdvalues',
        ),
    ]


class DIDMetadataInput(BaseModel):
    """
    The `DIDMetadata` provides additional context and status information about the DID within the ecosystem and
    includes,

    - `name`: The name of the entity represented by this DID. Must be case-insensitive unique for this user.
    - `owner`: The entity that owns this DID.
    - `trust_config`: TrustProfile config used to create the did. Either Blockchain or Web configs.
    - `permission`: Defines the DID's capabilities. An ISSUER DID can be used to create VCs. A HOLDER DID can be used as the credentialSubject in a VC.
    - `domain`: The domain within which this DID operates or is recognized.
    - `alias`: A human-readable name or identifier for this DID.
    - `seed`: A cryptographic seed from which keys associated with this DID can be derived.    - `status`: Enumerated field indicating the current status of the DID Document.
    - `tags`: Tags are lower-case keywords used to aid object searching and grouping.
    - `status`: Enumerated field indicating the current status of the DID Document.
        - `PRE`: Default state of a DID in the process of being created.
        - `ACCEPTED`: Request to create a DID accepted.
        - `SUBMITTED`: Create DID request submitted.
        - `ACTIVE`: The DID has been successfully created and published to the registry.
        - `FAILED`: An error occurred, and the DID was not created or published.
        - `SUSPENDED`: The DID has been suspended on chain
        - `REVOKED`: The DID has been revoked
        - `REVOKE_FAILED`: Revoking the DID failed.
    - `account_verified`: A boolean indicating whether the DID owner's account has been verified.
    - `pending_transaction`: transaction that needs to be completed before any other transactions
    - `controller_account`: used when we transfer control of DID, and an external public key is not used for the controller DID
    """

    include: Annotated[Optional[Dict[str, Any]], Field(None, title='Include')]
    tags: Annotated[Optional[List[str]], Field(None, title='Tags')]
    status: Annotated[
        Optional[DidDocStatus],
        Field(
            DidDocStatus.PRE,
            examples=[
                'default=PRE | ACCEPTED | SUBMITTED | ACTIVE | FAILED | SUSPENDED | UNSIGNED | REVOKE_UNSIGNED | REVOKED | REVOKE_FAILED'
            ],
        ),
    ]
    account_verified: Annotated[Optional[bool], Field(False, title='Account Verified')]
    permission: Optional[DidPermission] = DidPermission.HOLDER
    holder_count: Annotated[Optional[int], Field(None, title='Holder Count')]
    issuer_count: Annotated[Optional[int], Field(None, title='Issuer Count')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    name: Annotated[Optional[str], Field(None, title='Name')]
    owner: Annotated[str, Field(title='Owner')]
    account: PubKeyAccountInfo
    controller_user_id: Annotated[
        Optional[str], Field(None, title='Controller User Id')
    ]
    controller_account: Optional[PubKeyAccountInfo] = None
    domain: Annotated[str, Field(title='Domain')]
    alias: Annotated[str, Field(title='Alias')]
    seed: Annotated[str, Field(title='Seed')]
    registry_key: Annotated[Optional[str], Field(None, title='Registry Key')]
    trust_config: Annotated[
        Union[BlockchainTrustConfig, WebTrustConfig],
        Field(
            discriminator='config_type',
            examples=[
                {
                    'app': 'registry',
                    'blockchain': 'quorum-impartial-reindeer',
                    'blockchain_subtype': 'quorum',
                    'blockchain_type': 'ethereum',
                    'config_type': 'blockchain',
                    'contract_api': 'std-2025-4',
                    'interval_wait_time': 1,
                    'max_create_wait_time': 90,
                    'org': 'trust',
                    'registrar_address': '0xD2688B20ee5e0742c9419f262390Dbea4b60a728',
                    'registrar_alias': 'QuorumDevNewCopy-tsqaYmqp',
                    'registry_type': 'STDRegistry',
                },
                {
                    'config_type': 'web',
                    'interval_wait_time': 1,
                    'max_create_wait_time': 90,
                    'secondary_method': 'local',
                },
            ],
            title='Trust Config',
        ),
    ]
    pending_transaction: Annotated[
        Optional[Dict[str, Any]], Field({}, title='Pending Transaction')
    ]
    seed_type: Optional[SeedType] = SeedType.DidSeed


class DIDMetadataOutput(BaseModel):
    """
    The `DIDMetadata` provides additional context and status information about the DID within the ecosystem and
    includes,

    - `name`: The name of the entity represented by this DID. Must be case-insensitive unique for this user.
    - `owner`: The entity that owns this DID.
    - `trust_config`: TrustProfile config used to create the did. Either Blockchain or Web configs.
    - `permission`: Defines the DID's capabilities. An ISSUER DID can be used to create VCs. A HOLDER DID can be used as the credentialSubject in a VC.
    - `domain`: The domain within which this DID operates or is recognized.
    - `alias`: A human-readable name or identifier for this DID.
    - `seed`: A cryptographic seed from which keys associated with this DID can be derived.    - `status`: Enumerated field indicating the current status of the DID Document.
    - `tags`: Tags are lower-case keywords used to aid object searching and grouping.
    - `status`: Enumerated field indicating the current status of the DID Document.
        - `PRE`: Default state of a DID in the process of being created.
        - `ACCEPTED`: Request to create a DID accepted.
        - `SUBMITTED`: Create DID request submitted.
        - `ACTIVE`: The DID has been successfully created and published to the registry.
        - `FAILED`: An error occurred, and the DID was not created or published.
        - `SUSPENDED`: The DID has been suspended on chain
        - `REVOKED`: The DID has been revoked
        - `REVOKE_FAILED`: Revoking the DID failed.
    - `account_verified`: A boolean indicating whether the DID owner's account has been verified.
    - `pending_transaction`: transaction that needs to be completed before any other transactions
    - `controller_account`: used when we transfer control of DID, and an external public key is not used for the controller DID
    """

    tags: Annotated[Optional[List[str]], Field(None, title='Tags')]
    status: Annotated[
        Optional[DidDocStatus],
        Field(
            DidDocStatus.PRE,
            examples=[
                'default=PRE | ACCEPTED | SUBMITTED | ACTIVE | FAILED | SUSPENDED | UNSIGNED | REVOKE_UNSIGNED | REVOKED | REVOKE_FAILED'
            ],
        ),
    ]
    account_verified: Annotated[Optional[bool], Field(False, title='Account Verified')]
    permission: Optional[DidPermission] = DidPermission.HOLDER
    holder_count: Annotated[Optional[int], Field(None, title='Holder Count')]
    issuer_count: Annotated[Optional[int], Field(None, title='Issuer Count')]
    created_at: Annotated[Optional[datetime.datetime], Field(None, title='Created At')]
    updated_at: Annotated[Optional[datetime.datetime], Field(None, title='Updated At')]
    name: Annotated[Optional[str], Field(None, title='Name')]
    owner: Annotated[str, Field(title='Owner')]
    account: PubKeyAccountInfo
    controller_user_id: Annotated[
        Optional[str], Field(None, title='Controller User Id')
    ]
    controller_account: Optional[PubKeyAccountInfo] = None
    domain: Annotated[str, Field(title='Domain')]
    alias: Annotated[str, Field(title='Alias')]
    seed: Annotated[str, Field(title='Seed')]
    registry_key: Annotated[Optional[str], Field(None, title='Registry Key')]
    trust_config: Annotated[
        Union[BlockchainTrustConfig, WebTrustConfig],
        Field(
            discriminator='config_type',
            examples=[
                {
                    'app': 'registry',
                    'blockchain': 'quorum-impartial-reindeer',
                    'blockchain_subtype': 'quorum',
                    'blockchain_type': 'ethereum',
                    'config_type': 'blockchain',
                    'contract_api': 'std-2025-4',
                    'interval_wait_time': 1,
                    'max_create_wait_time': 90,
                    'org': 'trust',
                    'registrar_address': '0xD2688B20ee5e0742c9419f262390Dbea4b60a728',
                    'registrar_alias': 'QuorumDevNewCopy-tsqaYmqp',
                    'registry_type': 'STDRegistry',
                },
                {
                    'config_type': 'web',
                    'interval_wait_time': 1,
                    'max_create_wait_time': 90,
                    'secondary_method': 'local',
                },
            ],
            title='Trust Config',
        ),
    ]
    pending_transaction: Annotated[
        Optional[Dict[str, Any]], Field({}, title='Pending Transaction')
    ]
    seed_type: Optional[SeedType] = SeedType.DidSeed


class DigitalProductPassportOutput(BaseModel):
    """
    Context Examples: ["https://www.w3.org/ns/credentials/v2", "https://test.uncefact.org/vocabulary/untp/dpp/0.5.0/"]
    """

    field_context: Annotated[
        Optional[List[Union[str, Dict[str, Any]]]],
        Field(
            ['https://www.w3.org/2018/credentials/v1'],
            alias='@context',
            title='@Context',
        ),
    ]
    proof: Optional[ProofOutput] = None
    id: Annotated[Optional[str], Field(None, title='Id')]
    type: Annotated[
        Optional[Union[List[str], str]], Field(['VerifiableCredential'], title='Type')
    ]
    issuer: Annotated[
        CredentialIssuerOutput,
        Field(
            description='The organisation that is the issuer of this VC. Note that the "id" property MUST be a W3C DID. Other identifiers such as tax registration numbers can be listed in the "otherIdentifiers" property.'
        ),
    ]
    credentialSubject: Annotated[
        ProductOutput,
        Field(
            description='The subject of a digital product passport credential is the identified product.'
        ),
    ]
    validFrom: Annotated[Optional[str], Field(None, title='Validfrom')]
    validUntil: Annotated[Optional[str], Field(None, title='Validuntil')]
    credentialStatus: Optional[CredentialStatus] = None
    termsOfUse: Optional[TermsOfUse] = None
    credentialSchema: Optional[CredentialSchema] = None
    evidence: Annotated[Optional[List[Evidence]], Field(None, title='Evidence')]
    refreshService: Optional[RefreshService] = None
    name: Annotated[Optional[str], Field(None, title='Name')]
    relatedLink: Annotated[
        Optional[List[Dict[str, Any]]], Field(None, title='Relatedlink')
    ]
    render: Annotated[Optional[List[RenderMethodOutput]], Field(None, title='Render')]


class Dimension(BaseModel):
    weight: Annotated[
        MeasureInput,
        Field(
            description='The weight of the product.',
            examples=[{'unit': 'KGM', 'value': 10}],
        ),
    ]
    volume: Annotated[
        MeasureInput,
        Field(
            description='The displacement volume of the product.',
            examples=[{'unit': 'LTR', 'value': 7.5}],
        ),
    ]
    length: Annotated[
        Optional[MeasureInput],
        Field(
            None,
            description='The length of the product or packaging',
            examples=[{'unit': 'MMT', 'value': 840}],
        ),
    ]
    width: Annotated[
        Optional[MeasureInput],
        Field(
            None,
            description='The width of the product or packaging.',
            examples=[{'unit': 'MMT', 'value': 150}],
        ),
    ]
    height: Annotated[
        Optional[MeasureInput],
        Field(
            None,
            description='The height of the product or packaging.',
            examples=[{'unit': 'MMT', 'value': 220}],
        ),
    ]


class EmissionsPerformance(BaseModel):
    carbonFootprint: Annotated[
        float,
        Field(
            description='The carbon footprint of the product in KgCO2e per declared unit.',
            title='Carbonfootprint',
        ),
    ]
    declaredUnit: Annotated[
        UnitOfMeasure,
        Field(
            description='The unit of product (EA, KGM, LTR, etc) that is the basis for carbon footprint.',
            examples=['EA', 'KGM', 'LTR'],
        ),
    ]
    operationalScope: Annotated[
        Optional[OperationalScopeCode],
        Field(
            None,
            description='The operational scope of the emissions performance. Only scope 1 & 2, or including upstream scope 3 (cradle to gate) or upstream and downstream scope 3 (cradle to grave).',
        ),
    ]
    primarySourcedRatio: Annotated[
        float,
        Field(
            description='The ratio of emissions data from primary sources (ie from supplier / product specific information rather than secondary / industry averages).',
            title='Primarysourcedratio',
        ),
    ]
    reportingStandard: Annotated[
        Standard,
        Field(
            description='The reporting standard (eg GHG Protocol, IFRS S2, ESRS, etc) against which this product emissions performance is assessed.'
        ),
    ]


class Material(BaseModel):
    name: Annotated[
        str,
        Field(
            description='Name of this material',
            examples=['Egyptian Cotton'],
            title='Name',
        ),
    ]
    originCountry: Annotated[
        CountryCode,
        Field(
            description='A ISO 3166-1 code representing the country of origin of the component or ingredient.'
        ),
    ]
    materialType: Annotated[
        Classification,
        Field(
            description='The type of this material - as a value drawn from a controlled vocabulary eg from UN Framework Classification for Resources (UNFC).'
        ),
    ]
    massFraction: Annotated[
        float,
        Field(
            description='The mass fraction of the product represented by this material. The sum of all mass fraction values for a given passport should be 1.',
            title='Massfraction',
        ),
    ]
    massAmount: Annotated[
        MeasureInput, Field(description='The mass of the material component.')
    ]
    recycledAmount: Annotated[
        float,
        Field(
            description='Mass fraction of this material that is recycled',
            title='Recycledamount',
        ),
    ]
    hazardous: Annotated[
        Optional[bool],
        Field(
            False,
            description='Indicates whether this material is hazardous. If true then the materialSafetyInformation property must be present',
            title='Hazardous',
        ),
    ]
    symbol: Annotated[
        str,
        Field(
            description='Based 64 encoded binary used to represent a visual symbol for a given material.',
            title='Symbol',
        ),
    ]
    materialSafetyInformation: Annotated[
        LinkInput,
        Field(
            description='Reference to further information about safe handling of this hazardous material (for example a link to a material safety data sheet)'
        ),
    ]


class PageTask(BaseModel):
    items: Annotated[List[Task], Field(title='Items')]
    total: Annotated[int, Field(ge=0, title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]


class PageTrustProfile(BaseModel):
    items: Annotated[List[TrustProfile], Field(title='Items')]
    total: Annotated[int, Field(ge=0, title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]


class PageVerifiableCredential(BaseModel):
    items: Annotated[
        List[CredentialServiceDomainModelsVerifiableCredential], Field(title='Items')
    ]
    total: Annotated[int, Field(ge=0, title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]


class VcTypeOutput(
    RootModel[
        Union[DidlibModelsVcVerifiableCredentialOutput, DigitalProductPassportOutput]
    ]
):
    root: Union[DidlibModelsVcVerifiableCredentialOutput, DigitalProductPassportOutput]


class Claim(BaseModel):
    assessmentDate: Annotated[
        datetime.datetime,
        Field(
            description='The date on which this assessment was made.',
            title='Assessmentdate',
        ),
    ]
    declaredValue: Annotated[
        Optional[List[Metric]],
        Field(
            None,
            description='The list of specific values measured as part of this assessment (eg tensile strength)',
            title='Declaredvalue',
        ),
    ]
    id: Annotated[
        str,
        Field(
            description='A unique identifier for the declaration. Often this will be an extension of the product.id or attestation.id. But could be a UUID.',
            title='Id',
        ),
    ]
    referenceStandard: Annotated[
        Standard,
        Field(
            description='The reference to the standard that defines the specification / criteria'
        ),
    ]
    referenceRegulation: Annotated[
        Regulation,
        Field(
            description='The reference to the regulation that defines the assessment criteria'
        ),
    ]
    assessmentCriteria: Annotated[
        Optional[List[Criterion]],
        Field(
            None,
            description='The specification against which the assessment is made.',
            title='Assessmentcriteria',
        ),
    ]
    conformance: Annotated[
        bool,
        Field(
            description='An indicator of whether or not the claim or assesment conforms to the regulatory or standard criteria.',
            title='Conformance',
        ),
    ]
    conformityTopic: Annotated[
        ConformityTopicCode,
        Field(
            description='The conformity topic category for this assessment',
            examples=['environment.emissions'],
        ),
    ]
    conformityEvidence: Annotated[
        SecureLink,
        Field(
            description='A URI pointing to the evidence supporting the claim. SHOULD be a URL to a UNTP Digital Conformity Credential (DCC)'
        ),
    ]


class CreateVCHttp(BaseModel):
    """
    Input model for VC creation:

    - `auto_accept`: If `true` the VC is accepted immediately on behalf of the Holder. Note: setting true requires _Admin permission.
    - `tags`: Tags are lower-case keywords used to aid object searching and grouping.
    - `material`: Proof challenge inputs, used to add the proof to the VC:
    - `context`: A list of IRIs that define the JSON-LD schema definitions used by this VC, including the
    claim schemas for the included claims.
    - `issuer`: The issuer DID-string ID.
    - `subject`: The `credentialSubject` DID-string ID.
    - `valid_from`: Date-time from which this VC is valid.
    - `valid_until`: Expiry date-time of this VC.
    - `type`: Optional a list of identifiers that detail the type of this `verifiableCredential`. Defaults to `["VerifiableCredential"]`
    - `is_public`: Optional If `true` the VC can be read by anyone with access to the domain.
    - `claims`: A dictionary of `{property:` [ClaimValue][credential_service.domain.models.ClaimValue]`}` that represent
    individual claims about the `credentialSubject`. **Property** is the type of claim being made, e.g., **familyName**
    or **degree** and `ClaimValue` is the property's attribute value, (type: _bool_, _numeric_, _string_ or
    _Dict[str, str]_) and associated `claim_schema`.

        Example:

        ```
        "claims"={
            "degree": {
                "value": {
                "name": "Bachelor of Science and Arts",
                "type": "BachelorDegree"
              },
              "claim_schema": null
            }
        }
        ```
    """

    field_context: Annotated[
        Optional[List[Union[str, Dict[str, Any]]]],
        Field(
            ['https://www.w3.org/ns/credentials/v2'], alias='@context', title='@Context'
        ),
    ]
    id: Annotated[
        Optional[str],
        Field(
            None,
            examples=[
                'http://university.example/credentials/1872',
                'urn:uuid:8d6f054d-9916-4466-815b-0ebad54b4bd0',
            ],
            title='Id',
        ),
    ]
    subject: Annotated[
        str,
        Field(
            examples=[
                'did:smb1:1337:0xfc98c982ca22ea0141c3452325c372ff728e9ccd:18322500091651578819492444870201097984271428616569706638674662898632050307982'
            ],
            title='Subject',
        ),
    ]
    valid_from: Annotated[
        Optional[datetime.datetime],
        Field(
            '2025-10-28T11:23:21.132809+00:00',
            examples=['2024-03-08T01:37:35.899Z'],
            title='Valid From',
        ),
    ]
    valid_until: Annotated[
        Optional[datetime.datetime],
        Field(
            '9999-12-31T23:59:59.999999+00:00',
            examples=['2026-03-08T01:37:35.899Z'],
            title='Valid Until',
        ),
    ]
    type: Annotated[Optional[List[str]], Field(['VerifiableCredential'], title='Type')]
    is_public: Annotated[
        Optional[bool], Field(False, examples=['false | true'], title='Is Public')
    ]
    claims: Annotated[
        Optional[Dict[str, Dict[str, Any]]],
        Field(
            None,
            examples=[
                {
                    'https://www.w3.org/2018/credentials/examples/v1': {
                        'degree': {
                            'name': 'Bachelor of Science and Arts',
                            'type': 'BachelorDegree',
                        }
                    }
                }
            ],
            title='Claims',
        ),
    ]
    tags: Annotated[Optional[List[str]], Field(None, title='Tags')]
    auto_accept: Annotated[
        Optional[bool], Field(False, examples=['false | true'], title='Auto Accept')
    ]
    issuer: Annotated[
        Union[str, CredentialIssuerInput],
        Field(
            examples=[
                'did:smb1:1337:0xea0fc982ca22ea0141c3452325c372ff728e9ccd:18322500091651578819492444870201097984271428616569706638674662898632050307001',
                {
                    'id': 'did:smb1:1337:0xea0fc982ca22ea0141c3452325c372ff728e9ccd:18322500091651578819492444870201097984271428616569706638674662898632050307001',
                    'name': 'Grundfos',
                    'otherIdentifiers': [],
                },
            ],
            title='Issuer',
        ),
    ]
    material: Annotated[
        Optional[Dict[str, Any]], Field({}, examples=[{}], title='Material')
    ]
    verification_key: Annotated[
        Optional[str],
        Field(None, examples=['#1', 'did:example:123#1'], title='Verification Key'),
    ]
    proof_in_sig: Annotated[Optional[bool], Field(False, title='Proof In Sig')]


class DID(BaseModel):
    """
    The class represents a digital identity within a system that uses Decentralized Identifiers (DIDs) and DID Documents.
    DIDs and DID Documents are fundamental components in decentralized identity systems, facilitating a trust framework
    where entities such as individuals, organizations, resources, or physical objects can be uniquely identified and
    interact securely.

    ### What is a DID?

    A DID enables a verifiable, self-sovereign identity.  DIDs are fully under the control of the DID subject,
    independent of any centralized registry, identity provider, or certificate authority. DIDs are used to create
    a secure and interoperable identity layer for the internet.

    ### What is a DID Document?

    The DID Document is a JSON document that describes the DID subject and contains cryptographic material,
    such as public keys and service endpoints, which enable secure, direct communication with the DID subject.
    This document plays a critical role in the decentralized identity ecosystem, as it facilitates trust by ensuring
    that interactions with the DID subject can be authenticated and verified. The DID Document is stored in a public
    registry, for example, a blockchain, making it accessible for verification by anyone in the network.

    ### The `DID` Class Overview

    This class encapsulates a DIDDocument and associated metadata, defined by the `DIDMetadata` class.
    The `DIDMetadata` provides additional context and status information about the DID within the ecosystem and
    includes,

    - `name`: The name of the entity represented by this DID. Must be case-insensitive unique for this user.
    - `owner`: The entity that owns this DID.
    - `trust_config`: TrustProfile config used to create the did.
    - `permission`: Defines the DID's capabilities. An ISSUER DID can be used to create VCs. A HOLDER DID can be used as the credentialSubject in a VC.
    - `domain`: The domain within which this DID operates or is recognized.
    - `alias`: A human-readable name or identifier for this DID.
    - `seed`: A cryptographic seed from which keys associated with this DID can be derived.
    - `tags`: Tags are lower-case keywords used to aid object searching and grouping.
    - `status`: Enumerated field indicating the current status of the DID Document.
        - `PRE`: Default state of a DID in the process of being created.
        - `ACCEPTED`: Request to create a DID accepted.
        - `SUBMITTED`: Create DID request submitted.
        - `ACTIVE`: The DID has been successfully created and published to the registry.
        - `FAILED`: An error occurred, and the DID was not created or published.
        - `SUSPENDED`: The DID has been suspended on chain
        - `REVOKED`: The DID has been revoked
        - `REVOKE_FAILED`: Revoking the DID failed.
    - `account_verified`: A boolean indicating whether the DID owner's account has been verified.
    - `pending_transaction`: transaction that needs to be completed before any other transactions
    - `controller_account`: used when we transfer control of DID, and an external public key is not used for the controller DID

    ### Significance in a Trust System

    In a system of trust the DID and the associated DID Document serve as the primary representation
    of an entity. This setup enables a decentralized, secure, and verifiable method of identity assertion and
    interaction between entities. By leveraging cryptographic proofs, such as digital signatures,
    entities can prove control over their DIDs and the information within their DID Documents,
    thereby facilitating trusted interactions without the need for a central authority.
    """

    field_id: Annotated[
        Optional[str],
        Field(
            None,
            alias='_id',
            description='MongoDB ObjectID of this object.',
            title='Id',
        ),
    ]
    did_document: DIDDocument
    metadata: DIDMetadataOutput


class PageVcType(BaseModel):
    items: Annotated[List[VcTypeOutput], Field(title='Items')]
    total: Annotated[int, Field(ge=0, title='Total')]
    page: Annotated[Optional[Page], Field(title='Page')]
    size: Annotated[Optional[Size], Field(title='Size')]
    pages: Annotated[Optional[Pages], Field(None, title='Pages')]


class ProductInput(BaseModel):
    id: Annotated[
        str,
        Field(
            description='The unique ID of the subject as a URI, e.g. this can be a DID, URN, URL etc.',
            title='Id',
        ),
    ]
    type: Annotated[
        Optional[Union[List[str], str]],
        Field(
            None,
            description='The type of the subject. Can be a string or a list of strings.',
            title='Type',
        ),
    ]
    currentStatus: Annotated[Optional[str], Field(None, title='Currentstatus')]
    statusReason: Annotated[Optional[str], Field(None, title='Statusreason')]
    claims: Annotated[
        Optional[Dict[str, Union[Dict[str, Any], str, int, bool, List]]],
        Field({}, title='Claims'),
    ]
    name: Annotated[
        str,
        Field(
            description='The registered name of the product within the identifier scheme.',
            title='Name',
        ),
    ]
    registeredId: Annotated[
        str,
        Field(
            description='The registration number (alphanumeric) of the entity within the register. Unique within the register.',
            title='Registeredid',
        ),
    ]
    idScheme: Annotated[
        IdentifierSchemeInput,
        Field(
            description='The identifier scheme for this product. Eg a GS1 GTIN or an AU Livestock NLIS, or similar. If self issued then use the party ID of the issuer.'
        ),
    ]
    serialNumber: Annotated[
        str,
        Field(
            description='A number or code representing a specific serialised item of the product. Unique within product class.',
            title='Serialnumber',
        ),
    ]
    batchNumber: Annotated[
        str,
        Field(
            description='Identifier of the specific production batch of the product. Unique within the product class.',
            title='Batchnumber',
        ),
    ]
    productImage: Annotated[
        LinkInput,
        Field(
            description='Reference information (location, type, name) of an image of the product.'
        ),
    ]
    description: Annotated[
        str,
        Field(
            description='A textual description providing details about the product.',
            title='Description',
        ),
    ]
    productCategory: Annotated[
        Optional[List[Classification]],
        Field(
            None,
            description="A code representing the product's class, typically using the UN CPC (United Nations Central Product Classification) https://unstats.un.org/unsd/classifications/Econ/cpc",
            title='Productcategory',
        ),
    ]
    furtherInformation: Annotated[
        Optional[List[LinkInput]],
        Field(
            None,
            description='A URL pointing to further human readable information about the product.',
            title='Furtherinformation',
        ),
    ]
    producedByParty: Annotated[
        IdentifierInput,
        Field(description='The Party entity that manufactured the product.'),
    ]
    producedAtFacility: Annotated[
        IdentifierInput,
        Field(
            description='The Facility where the product batch was produced / manufactured.'
        ),
    ]
    dimensions: Annotated[
        Dimension,
        Field(
            description='The physical dimensions of the product. Not every dimension is relevant to every products. For example bulk materials may have weight and volume but not length, with, or height.'
        ),
    ]
    productionDate: Annotated[
        datetime.datetime,
        Field(
            description='The ISO 8601 date on which the product batch or individual serialised item was manufactured.',
            title='Productiondate',
        ),
    ]
    countryOfProduction: Annotated[
        CountryCode,
        Field(
            description='The country in which this item was produced / manufactured.'
        ),
    ]
    granularityLevel: Annotated[
        GranularityCode,
        Field(
            description='Code to indicate the granularity of this digital product passport - item level, batch level or product class level.'
        ),
    ]
    dueDiligenceDeclaration: Annotated[
        LinkInput,
        Field(
            description='The due diligence declaration that conforms with the regulations of the market into which the product is sold.'
        ),
    ]
    materialsProvenance: Annotated[
        Optional[List[Material]],
        Field(
            None,
            description='An array of Provenance objects providing details on the origin and mass fraction of components or ingredients of the product batch.',
            title='Materialsprovenance',
        ),
    ]
    conformityClaim: Annotated[
        Optional[List[Claim]],
        Field(
            None,
            description='An array of claim objects representing various product conformity claims about the product / batch. These can be sustainability claims, circularity claims, or any other claim type within the conformity topic list.',
            title='Conformityclaim',
        ),
    ]
    circularityScorecard: Annotated[
        CircularityPerformance, Field(description='A circularity performance scorecard')
    ]
    emissionsScorecard: Annotated[
        EmissionsPerformance, Field(description='An emissions performance scorecard')
    ]
    traceabilityInformation: Annotated[
        Optional[List[TraceabilityPerformance]],
        Field(
            None,
            description='An array of traceability events grouped by value chain process. Where actual traceability events are unavailable or carry sensitive information, passport publishers may specify the extent to which the traceability information has been independently verified.',
            title='Traceabilityinformation',
        ),
    ]


class DPPInput(BaseModel):
    """
    Input model for create_dpp:

    - `issuer`: A CredentialIssuer object, see dpp_models documentation.
    - `subject`: A Product object, see dpp_models documentation. This is the full credential subject.
    - `material`: Proof challenge inputs, used to add the proof to the VP.
    - `claims`: An optional set of claims to include in the VP.
    - `renderer`: An optional list of render input objects
    """

    tags: Annotated[Optional[List[str]], Field(None, title='Tags')]
    issuer: Annotated[
        CredentialIssuerInput,
        Field(
            examples=[
                {
                    'id': 'did:smb1:1337:0xea0fc982ca22ea0141c3452325c372ff728e9ccd:18322500091651578819492444870201097984271428616569706638674662898632050307001',
                    'name': 'Grundfos',
                    'otherIdentifiers': [],
                }
            ]
        ),
    ]
    subject: Annotated[
        ProductInput,
        Field(
            examples=[
                {
                    'batchNumber': '6789',
                    'circularityScorecard': {
                        'materialCircularityIndicator': 0.67,
                        'recyclableContent': 0.5,
                        'recycledContent': 0.3,
                        'recyclingInformation': {
                            'linkName': 'GBA rule book conformity certificate',
                            'linkType': 'https://test.uncefact.org/vocabulary/linkTypes/dcc',
                            'linkURL': 'https://files.example-certifier.com/1234567.json',
                            'type': ['Link'],
                        },
                        'repairInformation': {
                            'linkName': 'GBA rule book conformity certificate',
                            'linkType': 'https://test.uncefact.org/vocabulary/linkTypes/dcc',
                            'linkURL': 'https://files.example-certifier.com/1234567.json',
                            'type': ['Link'],
                        },
                        'type': ['CircularityPerformance'],
                        'utilityFactor': 1.2,
                    },
                    'conformityClaim': [
                        {
                            'assessmentCriteria': [
                                {
                                    'id': 'https://www.globalbattery.org/media/publications/gba-rulebook-v2.0-master.pdf#BatteryAssembly',
                                    'name': 'GBA Battery rule book v2.0 battery assembly guidelines.',
                                    'thresholdValues': [
                                        {
                                            'accuracy': 0.05,
                                            'metricName': 'GHG emissions intensity',
                                            'metricValue': {
                                                'type': ['Measure'],
                                                'unit': 'KGM',
                                                'value': 10.0,
                                            },
                                            'score': 'BB',
                                            'type': ['Metric'],
                                        },
                                        {
                                            'accuracy': 0.05,
                                            'metricName': 'GHG emissions intensity',
                                            'metricValue': {
                                                'type': ['Measure'],
                                                'unit': 'KGM',
                                                'value': 10.0,
                                            },
                                            'score': 'BB',
                                            'type': ['Metric'],
                                        },
                                    ],
                                    'type': ['Criterion'],
                                },
                                {
                                    'id': 'https://www.globalbattery.org/media/publications/gba-rulebook-v2.0-master.pdf#BatteryAssembly',
                                    'name': 'GBA Battery rule book v2.0 battery assembly guidelines.',
                                    'thresholdValues': [
                                        {
                                            'accuracy': 0.05,
                                            'metricName': 'GHG emissions intensity',
                                            'metricValue': {
                                                'type': ['Measure'],
                                                'unit': 'KGM',
                                                'value': 10.0,
                                            },
                                            'score': 'BB',
                                            'type': ['Metric'],
                                        },
                                        {
                                            'accuracy': 0.05,
                                            'metricName': 'GHG emissions intensity',
                                            'metricValue': {
                                                'type': ['Measure'],
                                                'unit': 'KGM',
                                                'value': 10.0,
                                            },
                                            'score': 'BB',
                                            'type': ['Metric'],
                                        },
                                    ],
                                    'type': ['Criterion'],
                                },
                            ],
                            'assessmentDate': '2024-03-15T00:00:00',
                            'conformance': True,
                            'conformityEvidence': {
                                'encryptionMethod': 'AES',
                                'hashDigest': '6239119',
                                'hashMethod': 'SHA-256',
                                'linkName': 'GBA rule book conformity certificate',
                                'linkType': 'https://test.uncefact.org/vocabulary/linkTypes/dcc',
                                'linkURL': 'https://files.example-certifier.com/1234567.json',
                                'type': ['SecureLink', 'Link'],
                            },
                            'conformityTopic': 'environment.emissions',
                            'declaredValue': [
                                {
                                    'accuracy': 0.05,
                                    'metricName': 'GHG emissions intensity',
                                    'metricValue': {
                                        'type': ['Measure'],
                                        'unit': 'KGM',
                                        'value': 10.0,
                                    },
                                    'score': 'BB',
                                    'type': ['Metric'],
                                },
                                {
                                    'accuracy': 0.05,
                                    'metricName': 'GHG emissions intensity',
                                    'metricValue': {
                                        'type': ['Measure'],
                                        'unit': 'KGM',
                                        'value': 10.0,
                                    },
                                    'score': 'BB',
                                    'type': ['Metric'],
                                },
                            ],
                            'id': 'https://products.example-company.com/09520123456788/declarations/12345',
                            'referenceRegulation': {
                                'administeredBy': {
                                    'id': 'https://id.gs1.org/01/09520123456788/21/12345',
                                    'idScheme': {
                                        'id': 'https://id.gs1.org/01/',
                                        'name': 'Global Trade Identification Number (GTIN)',
                                        'type': ['IdentifierScheme'],
                                    },
                                    'name': 'EV battery 300Ah.',
                                    'registeredId': '90664869327',
                                    'type': ['Identifier'],
                                },
                                'effectiveDate': '2024-03-20T00:00:00',
                                'id': 'https://www.legislation.gov.au/F2008L02309/latest/versions',
                                'jurisdictionCountry': 'AU',
                                'name': 'National Greenhouse and Energy Reporting (Measurement) Determination',
                                'type': ['Regulation'],
                            },
                            'referenceStandard': {
                                'id': 'https://www.globalbattery.org/media/publications/gba-rulebook-v2.0-master.pdf',
                                'issueDate': '2023-12-05T00:00:00',
                                'issuingParty': {
                                    'id': 'https://id.gs1.org/01/09520123456788/21/12345',
                                    'idScheme': {
                                        'id': 'https://id.gs1.org/01/',
                                        'name': 'Global Trade Identification Number (GTIN)',
                                        'type': ['IdentifierScheme'],
                                    },
                                    'name': 'EV battery 300Ah.',
                                    'registeredId': '90664869327',
                                    'type': ['Identifier'],
                                },
                                'name': 'GBA Battery Passport Greenhouse Gas Rulebook - V.2.0',
                                'type': ['Standard'],
                            },
                            'type': ['Claim'],
                        },
                        {
                            'assessmentCriteria': [
                                {
                                    'id': 'https://www.globalbattery.org/media/publications/gba-rulebook-v2.0-master.pdf#BatteryAssembly',
                                    'name': 'GBA Battery rule book v2.0 battery assembly guidelines.',
                                    'thresholdValues': [
                                        {
                                            'accuracy': 0.05,
                                            'metricName': 'GHG emissions intensity',
                                            'metricValue': {
                                                'type': ['Measure'],
                                                'unit': 'KGM',
                                                'value': 10.0,
                                            },
                                            'score': 'BB',
                                            'type': ['Metric'],
                                        },
                                        {
                                            'accuracy': 0.05,
                                            'metricName': 'GHG emissions intensity',
                                            'metricValue': {
                                                'type': ['Measure'],
                                                'unit': 'KGM',
                                                'value': 10.0,
                                            },
                                            'score': 'BB',
                                            'type': ['Metric'],
                                        },
                                    ],
                                    'type': ['Criterion'],
                                },
                                {
                                    'id': 'https://www.globalbattery.org/media/publications/gba-rulebook-v2.0-master.pdf#BatteryAssembly',
                                    'name': 'GBA Battery rule book v2.0 battery assembly guidelines.',
                                    'thresholdValues': [
                                        {
                                            'accuracy': 0.05,
                                            'metricName': 'GHG emissions intensity',
                                            'metricValue': {
                                                'type': ['Measure'],
                                                'unit': 'KGM',
                                                'value': 10.0,
                                            },
                                            'score': 'BB',
                                            'type': ['Metric'],
                                        },
                                        {
                                            'accuracy': 0.05,
                                            'metricName': 'GHG emissions intensity',
                                            'metricValue': {
                                                'type': ['Measure'],
                                                'unit': 'KGM',
                                                'value': 10.0,
                                            },
                                            'score': 'BB',
                                            'type': ['Metric'],
                                        },
                                    ],
                                    'type': ['Criterion'],
                                },
                            ],
                            'assessmentDate': '2024-03-15T00:00:00',
                            'conformance': True,
                            'conformityEvidence': {
                                'encryptionMethod': 'AES',
                                'hashDigest': '6239119',
                                'hashMethod': 'SHA-256',
                                'linkName': 'GBA rule book conformity certificate',
                                'linkType': 'https://test.uncefact.org/vocabulary/linkTypes/dcc',
                                'linkURL': 'https://files.example-certifier.com/1234567.json',
                                'type': ['SecureLink', 'Link'],
                            },
                            'conformityTopic': 'environment.emissions',
                            'declaredValue': [
                                {
                                    'accuracy': 0.05,
                                    'metricName': 'GHG emissions intensity',
                                    'metricValue': {
                                        'type': ['Measure'],
                                        'unit': 'KGM',
                                        'value': 10.0,
                                    },
                                    'score': 'BB',
                                    'type': ['Metric'],
                                },
                                {
                                    'accuracy': 0.05,
                                    'metricName': 'GHG emissions intensity',
                                    'metricValue': {
                                        'type': ['Measure'],
                                        'unit': 'KGM',
                                        'value': 10.0,
                                    },
                                    'score': 'BB',
                                    'type': ['Metric'],
                                },
                            ],
                            'id': 'https://products.example-company.com/09520123456788/declarations/12345',
                            'referenceRegulation': {
                                'administeredBy': {
                                    'id': 'https://id.gs1.org/01/09520123456788/21/12345',
                                    'idScheme': {
                                        'id': 'https://id.gs1.org/01/',
                                        'name': 'Global Trade Identification Number (GTIN)',
                                        'type': ['IdentifierScheme'],
                                    },
                                    'name': 'EV battery 300Ah.',
                                    'registeredId': '90664869327',
                                    'type': ['Identifier'],
                                },
                                'effectiveDate': '2024-03-20T00:00:00',
                                'id': 'https://www.legislation.gov.au/F2008L02309/latest/versions',
                                'jurisdictionCountry': 'AU',
                                'name': 'NNational Greenhouse and Energy Reporting (Measurement) Determination',
                                'type': ['Regulation'],
                            },
                            'referenceStandard': {
                                'id': 'https://www.globalbattery.org/media/publications/gba-rulebook-v2.0-master.pdf',
                                'issueDate': '2023-12-05T00:00:00',
                                'issuingParty': {
                                    'id': 'https://id.gs1.org/01/09520123456788/21/12345',
                                    'idScheme': {
                                        'id': 'https://id.gs1.org/01/',
                                        'name': 'Global Trade Identification Number (GTIN)',
                                        'type': ['IdentifierScheme'],
                                    },
                                    'name': 'EV battery 300Ah.',
                                    'registeredId': '90664869327',
                                    'type': ['Identifier'],
                                },
                                'name': 'GBA Battery Passport Greenhouse Gas Rulebook - V.2.0',
                                'type': ['Standard'],
                            },
                            'type': ['Claim'],
                        },
                    ],
                    'countryOfProduction': 'AU',
                    'description': '400Ah 24v LiFePO4 battery',
                    'dimensions': {
                        'height': {'type': ['Measure'], 'unit': 'KGM', 'value': 10.0},
                        'length': {'type': ['Measure'], 'unit': 'KGM', 'value': 10.0},
                        'type': ['Dimension'],
                        'volume': {'type': ['Measure'], 'unit': 'KGM', 'value': 10.0},
                        'weight': {'type': ['Measure'], 'unit': 'KGM', 'value': 10.0},
                        'width': {'type': ['Measure'], 'unit': 'KGM', 'value': 10.0},
                    },
                    'dueDiligenceDeclaration': {
                        'linkName': 'GBA rule book conformity certificate',
                        'linkType': 'https://test.uncefact.org/vocabulary/linkTypes/dcc',
                        'linkURL': 'https://files.example-certifier.com/1234567.json',
                        'type': ['Link'],
                    },
                    'emissionsScorecard': {
                        'carbonFootprint': 1.8,
                        'declaredUnit': 'KGM',
                        'operationalScope': 'CradleToGate',
                        'primarySourcedRatio': 0.3,
                        'reportingStandard': {
                            'id': 'https://www.globalbattery.org/media/publications/gba-rulebook-v2.0-master.pdf',
                            'issueDate': '2023-12-05T00:00:00',
                            'issuingParty': {
                                'id': 'https://id.gs1.org/01/09520123456788/21/12345',
                                'idScheme': {
                                    'id': 'https://id.gs1.org/01/',
                                    'name': 'Global Trade Identification Number (GTIN)',
                                    'type': ['IdentifierScheme'],
                                },
                                'name': 'EV battery 300Ah.',
                                'registeredId': '90664869327',
                                'type': ['Identifier'],
                            },
                            'name': 'GBA Battery Passport Greenhouse Gas Rulebook - V.2.0',
                            'type': ['Standard'],
                        },
                        'type': ['EmissionsPerformance'],
                    },
                    'furtherInformation': [
                        {
                            'linkName': 'GBA rule book conformity certificate',
                            'linkType': 'https://test.uncefact.org/vocabulary/linkTypes/dcc',
                            'linkURL': 'https://files.example-certifier.com/1234567.json',
                            'type': ['Link'],
                        },
                        {
                            'linkName': 'GBA rule book conformity certificate',
                            'linkType': 'https://test.uncefact.org/vocabulary/linkTypes/dcc',
                            'linkURL': 'https://files.example-certifier.com/1234567.json',
                            'type': ['Link'],
                        },
                    ],
                    'granularityLevel': 'batch',
                    'id': 'https://id.gs1.org/01/09520123456788/21/12345',
                    'idScheme': {
                        'id': 'https://id.gs1.org/01/',
                        'name': 'Global Trade Identification Number (GTIN)',
                        'type': ['IdentifierScheme'],
                    },
                    'materialsProvenance': [
                        {
                            'hazardous': False,
                            'massAmount': {
                                'type': ['Measure'],
                                'unit': 'KGM',
                                'value': 10.0,
                            },
                            'massFraction': 0.2,
                            'materialSafetyInformation': {
                                'linkName': 'GBA rule book conformity certificate',
                                'linkType': 'https://test.uncefact.org/vocabulary/linkTypes/dcc',
                                'linkURL': 'https://files.example-certifier.com/1234567.json',
                                'type': ['Link'],
                            },
                            'materialType': {
                                'code': '46410',
                                'id': 'https://unstats.un.org/unsd/classifications/Econ/cpc/46410',
                                'name': 'Primary cells and primary batteries',
                                'schemeID': 'https://unstats.un.org/unsd/classifications/Econ/cpc/',
                                'schemeName': 'UN Central Product Classification (CPC)',
                                'type': ['Classification'],
                            },
                            'name': 'Lithium Spodumene',
                            'originCountry': 'AU',
                            'recycledAmount': 0.5,
                            'symbol': 'undefined',
                            'type': ['Material'],
                        },
                        {
                            'hazardous': False,
                            'massAmount': {
                                'type': ['Measure'],
                                'unit': 'KGM',
                                'value': 10.0,
                            },
                            'massFraction': 0.2,
                            'materialSafetyInformation': {
                                'linkName': 'GBA rule book conformity certificate',
                                'linkType': 'https://test.uncefact.org/vocabulary/linkTypes/dcc',
                                'linkURL': 'https://files.example-certifier.com/1234567.json',
                                'type': ['Link'],
                            },
                            'materialType': {
                                'code': '46410',
                                'id': 'https://unstats.un.org/unsd/classifications/Econ/cpc/46410',
                                'name': 'Primary cells and primary batteries',
                                'schemeID': 'https://unstats.un.org/unsd/classifications/Econ/cpc/',
                                'schemeName': 'UN Central Product Classification (CPC)',
                                'type': ['Classification'],
                            },
                            'name': 'Lithium Spodumene',
                            'originCountry': 'AU',
                            'recycledAmount': 0.5,
                            'symbol': 'undefined',
                            'type': ['Material'],
                        },
                    ],
                    'name': 'EV battery 300Ah.',
                    'producedAtFacility': {
                        'id': 'https://id.gs1.org/01/09520123456788/21/12345',
                        'idScheme': {
                            'id': 'https://id.gs1.org/01/',
                            'name': 'Global Trade Identification Number (GTIN)',
                            'type': ['IdentifierScheme'],
                        },
                        'name': 'EV battery 300Ah.',
                        'registeredId': '90664869327',
                        'type': ['Identifier'],
                    },
                    'producedByParty': {
                        'id': 'https://id.gs1.org/01/09520123456788/21/12345',
                        'idScheme': {
                            'id': 'https://id.gs1.org/01/',
                            'name': 'Global Trade Identification Number (GTIN)',
                            'type': ['IdentifierScheme'],
                        },
                        'name': 'EV battery 300Ah.',
                        'registeredId': '90664869327',
                        'type': ['Identifier'],
                    },
                    'productCategory': [
                        {
                            'code': '46410',
                            'id': 'https://unstats.un.org/unsd/classifications/Econ/cpc/46410',
                            'name': 'Primary cells and primary batteries',
                            'schemeID': 'https://unstats.un.org/unsd/classifications/Econ/cpc/',
                            'schemeName': 'UN Central Product Classification (CPC)',
                            'type': ['Classification'],
                        },
                        {
                            'code': '46410',
                            'id': 'https://unstats.un.org/unsd/classifications/Econ/cpc/46410',
                            'name': 'Primary cells and primary batteries',
                            'schemeID': 'https://unstats.un.org/unsd/classifications/Econ/cpc/',
                            'schemeName': 'UN Central Product Classification (CPC)',
                            'type': ['Classification'],
                        },
                    ],
                    'productImage': {
                        'linkName': 'GBA rule book conformity certificate',
                        'linkType': 'https://test.uncefact.org/vocabulary/linkTypes/dcc',
                        'linkURL': 'https://files.example-certifier.com/1234567.json',
                        'type': ['Link'],
                    },
                    'productionDate': '2024-04-25T00:00:00',
                    'registeredId': '09520123456788.21.12345',
                    'serialNumber': '12345678',
                    'traceabilityInformation': [
                        {
                            'traceabilityEvent': [
                                {
                                    'encryptionMethod': 'AES',
                                    'hashDigest': '6239119',
                                    'hashMethod': 'SHA-256',
                                    'linkName': 'GBA rule book conformity certificate',
                                    'linkType': 'https://test.uncefact.org/vocabulary/linkTypes/dcc',
                                    'linkURL': 'https://files.example-certifier.com/1234567.json',
                                    'type': ['SecureLink', 'Link'],
                                },
                                {
                                    'encryptionMethod': 'AES',
                                    'hashDigest': '6239119',
                                    'hashMethod': 'SHA-256',
                                    'linkName': 'GBA rule book conformity certificate',
                                    'linkType': 'https://test.uncefact.org/vocabulary/linkTypes/dcc',
                                    'linkURL': 'https://files.example-certifier.com/1234567.json',
                                    'type': ['SecureLink', 'Link'],
                                },
                            ],
                            'type': ['TraceabilityPerformance'],
                            'valueChainProcess': 'Spinning',
                            'verifiedRatio': 0.5,
                        }
                    ],
                    'type': ['Product'],
                }
            ]
        ),
    ]
    valid_from: Annotated[
        Optional[datetime.datetime],
        Field(
            '2025-10-28T11:23:21.438154+00:00',
            examples=['2024-03-08T01:37:35.899Z'],
            title='Valid From',
        ),
    ]
    valid_until: Annotated[
        Optional[datetime.datetime],
        Field(
            '9999-12-31T23:59:59.999999+00:00',
            examples=['2026-03-08T01:37:35.899Z'],
            title='Valid Until',
        ),
    ]
    credential_id: Annotated[Optional[str], Field(None, title='Credential Id')]
    material: Annotated[Optional[Dict[str, Any]], Field({}, title='Material')]


class DigitalProductPassportInput(BaseModel):
    """
    Context Examples: ["https://www.w3.org/ns/credentials/v2", "https://test.uncefact.org/vocabulary/untp/dpp/0.5.0/"]
    """

    field_context: Annotated[
        Optional[List[Union[str, Dict[str, Any]]]],
        Field(
            ['https://www.w3.org/2018/credentials/v1'],
            alias='@context',
            title='@Context',
        ),
    ]
    proof: Optional[ProofInput] = None
    id: Annotated[Optional[str], Field(None, title='Id')]
    type: Annotated[
        Optional[Union[List[str], str]], Field(['VerifiableCredential'], title='Type')
    ]
    issuer: Annotated[
        CredentialIssuerInput,
        Field(
            description='The organisation that is the issuer of this VC. Note that the "id" property MUST be a W3C DID. Other identifiers such as tax registration numbers can be listed in the "otherIdentifiers" property.'
        ),
    ]
    credentialSubject: Annotated[
        ProductInput,
        Field(
            description='The subject of a digital product passport credential is the identified product.'
        ),
    ]
    validFrom: Annotated[Optional[datetime.datetime], Field(None, title='Validfrom')]
    validUntil: Annotated[Optional[datetime.datetime], Field(None, title='Validuntil')]
    credentialStatus: Optional[CredentialStatus] = None
    termsOfUse: Optional[TermsOfUse] = None
    credentialSchema: Optional[CredentialSchema] = None
    evidence: Annotated[Optional[List[Evidence]], Field(None, title='Evidence')]
    refreshService: Optional[RefreshService] = None
    name: Annotated[Optional[str], Field(None, title='Name')]
    relatedLink: Annotated[
        Optional[List[Dict[str, Any]]], Field(None, title='Relatedlink')
    ]
    render: Annotated[Optional[List[RenderMethodInput]], Field(None, title='Render')]


class VcTypeInput(
    RootModel[Union[DidlibModelsVcVerifiableCredential, DigitalProductPassportInput]]
):
    root: Union[DidlibModelsVcVerifiableCredential, DigitalProductPassportInput]


class AddVCHttp(BaseModel):
    tags: Annotated[Optional[List[str]], Field(None, title='Tags')]
    is_public: Annotated[
        Optional[bool], Field(False, examples=['false | true'], title='Is Public')
    ]
    auto_accept: Annotated[
        Optional[bool], Field(False, examples=['false | true'], title='Auto Accept')
    ]
    material: Annotated[
        Optional[Dict[str, Any]], Field({}, examples=[{}], title='Material')
    ]
    verification_key: Annotated[
        Optional[str],
        Field(
            None,
            examples=['Optional, #1 | did:example:123#1'],
            title='Verification Key',
        ),
    ]
    proof_in_sig: Annotated[Optional[bool], Field(False, title='Proof In Sig')]
    vc: Annotated[
        VcTypeInput,
        Field(
            examples=[
                '\n            {\n                "@context": [\n                    "https://www.w3.org/2018/credentials/v1",\n                    "https://www.w3.org/2018/credentials/examples/v1",\n                    "https://simbachain.github.io/context/crypto/ERC191Suite2023.jsonld"\n                ],\n                "proof": {\n                    "type": "ERC191Signature2023",\n                    "created": "2025-03-19T21:04:56.713415+00:00",\n                    "proofPurpose": "assertionMethod",\n                    "verificationMethod": "did:smb1:1337:0x1e1a08635650ba7dbf50e288ec6fe1f0cdd589c8:87846783959889227866580749686625002103301015674329220177929364676842176513793#1",\n                    "proofValue": "0x8e7aae674f27107211b7f5bb7338ce2c5fa2a66595be29ffdb1cdec2e54be7d5108dc89bfdf689bacfde8e7bf5ff49cd6a6323b9778069e8529f4ed03a5319641c"\n                },\n                "id": "urn:uuid:df5e1fac-2b0e-4e13-88a4-f0b6f9097bdb",\n                "type": [\n                    "VerifiableCredential"\n                ],\n                "issuer": "did:smb1:1337:0x1e1a08635650ba7dbf50e288ec6fe1f0cdd589c8:87846783959889227866580749686625002103301015674329220177929364676842176513793",\n                "credentialSubject": {\n                    "id": "did:smb1:1337:0x1e1a08635650ba7dbf50e288ec6fe1f0cdd589c8:30232190550540842924946097596550793492175973526398728801684738755048631459073",\n                    "degree": {\n                        "type": "BachelorDegree",\n                        "name": "Bachelor of Science and Arts"\n                    }\n                },\n                "validFrom": "2024-03-08T01:37:35.899000+00:00",\n                "validUntil": "2026-03-08T01:37:35.899000+00:00"\n            }\n        '
            ]
        ),
    ]


class CreateIdentityVcHttp(BaseModel):
    tags: Annotated[Optional[List[str]], Field(None, title='Tags')]
    auto_accept: Annotated[
        Optional[bool], Field(False, examples=['false | true'], title='Auto Accept')
    ]
    verification_key: Annotated[
        Optional[str],
        Field(
            None,
            examples=['Optional, #1 | did:example:123#1'],
            title='Verification Key',
        ),
    ]
    vc: Annotated[
        VcTypeInput,
        Field(
            examples=[
                '\n            {\n                "@context": [\n                    "https://www.w3.org/2018/credentials/v1",\n                    "https://schema.org/docs/jsonldcontext.json",\n                    "https://simbachain.github.io/context/crypto/ERC191Suite2023.jsonld"\n                    ],\n                "proof": {\n                  "type": "ERC191Signature2023",\n                  "created": "2025-09-05T15:23:21.286303+00:00",\n                  "proofPurpose": "assertionMethod",\n                  "verificationMethod": "did:smb1:1337:0xa66e54b269caf81b43fc686d1ce30e85c2a9cca0:59603963407621253754755933812115921696450068540607519011391708061411704941313#1",\n                  "proofValue": "0x352a544742e1fc4b0aa8b925890215e8227932437ac4ec1915d1e8a43c085e29790d19141f4660692859e971177318b20356fa7032a149892c7f4858bff603741b"\n                },\n                "id": "urn:uuid:f082ad18-4ce9-41ec-9b66-7a0f0d72f586",\n                "type": [\n                  "VerifiableCredential"\n                ],\n                "issuer": "did:smb1:1337:0xa66e54b269caf81b43fc686d1ce30e85c2a9cca0:59603963407621253754755933812115921696450068540607519011391708061411704941313",\n                "credentialSubject": {\n                  "id": "did:smb1:1337:0xa66e54b269caf81b43fc686d1ce30e85c2a9cca0:59603963407621253754755933812115921696450068540607519011391708061411704941313" ,\n                  "type": "Organisation",\n                  "name": "Acme Inc.",\n                  "address": {\n                    "type": "PostalAddress",\n                    "addressLocality": "Seattle",\n                    "addressRegion": "WA",\n                    "postalCode": "98052",\n                    "streetAddress": "20341 Whitworth Institute 405 N. Whitworth",\n                    "addressCountry": "US"\n                  },\n                  "identifier": [\n                    {\n                      "type": "PropertyValue",\n                      "propertyID": "OCoLC",\n                      "value": "889647468"\n                    },\n                    {\n                      "type": "PropertyValue",\n                      "propertyID": "GTI",\n                      "value": "1234"\n                    }\n                  ]\n                },\n                "validFrom": "2010-06-15T21:24:10.768473+00:00",\n                "validUntil": "2050-06-15T21:24:10.768473+00:00"\n              }\n        '
            ]
        ),
    ]

# --- Alias mappings: resolve generated long names to proper SDK model names ---
CredentialServiceDomainModelsVerifiableCredential = VerifiableCredential
CredentialServiceDomainModelsVerifiablePresentation = VerifiablePresentation
