# wodby
Wodby Developer Documentation https://wodby.com/docs/dev

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 3.0.12
- Package version: 3.0.dev72
- Build package: io.swagger.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import wodby 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import wodby
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import wodby
from wodby.rest import ApiException
from pprint import pprint

# Configure API key authorization: ApiKeyAuth
configuration = wodby.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = wodby.ApplicationApi(wodby.ApiClient(configuration))
data = wodby.RequestAppCreate() # RequestAppCreate | 

try:
    api_response = api_instance.create_app(data)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ApplicationApi->create_app: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://api.wodby.com/api/v3*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ApplicationApi* | [**create_app**](docs/ApplicationApi.md#create_app) | **POST** /apps | 
*ApplicationApi* | [**delete_app**](docs/ApplicationApi.md#delete_app) | **DELETE** /apps/{id} | 
*ApplicationApi* | [**get_app**](docs/ApplicationApi.md#get_app) | **GET** /apps/{id} | 
*ApplicationApi* | [**get_app_drush_aliases**](docs/ApplicationApi.md#get_app_drush_aliases) | **GET** /apps/{id}/drush-aliases | 
*ApplicationApi* | [**get_apps**](docs/ApplicationApi.md#get_apps) | **GET** /apps | 
*BackupApi* | [**get_backup**](docs/BackupApi.md#get_backup) | **GET** /backups/{id} | 
*BackupApi* | [**get_backups**](docs/BackupApi.md#get_backups) | **GET** /backups | 
*DomainApi* | [**get_domain**](docs/DomainApi.md#get_domain) | **GET** /domains/{id} | 
*DomainApi* | [**get_domains**](docs/DomainApi.md#get_domains) | **GET** /domains | 
*GitRepositoryApi* | [**get_git_repo**](docs/GitRepositoryApi.md#get_git_repo) | **GET** /git-repo/{id} | 
*GitRepositoryApi* | [**get_git_repos**](docs/GitRepositoryApi.md#get_git_repos) | **GET** /git-repo | 
*InstanceApi* | [**create_instance**](docs/InstanceApi.md#create_instance) | **POST** /instances | 
*InstanceApi* | [**delete_instance**](docs/InstanceApi.md#delete_instance) | **DELETE** /instances/{id} | 
*InstanceApi* | [**deploy_instance**](docs/InstanceApi.md#deploy_instance) | **POST** /instances/{id}/deploy | 
*InstanceApi* | [**deploy_instance_codebase**](docs/InstanceApi.md#deploy_instance_codebase) | **POST** /instances/{id}/deploy-codebase | 
*InstanceApi* | [**get_instance**](docs/InstanceApi.md#get_instance) | **GET** /instances/{id} | 
*InstanceApi* | [**get_instances**](docs/InstanceApi.md#get_instances) | **GET** /instances | 
*InstanceApi* | [**upgrade_instance**](docs/InstanceApi.md#upgrade_instance) | **POST** /instances/{id}/upgrade | 
*InstanceApi* | [**upgrade_instances**](docs/InstanceApi.md#upgrade_instances) | **POST** /instances/upgrade | 
*OrganizationApi* | [**get_org**](docs/OrganizationApi.md#get_org) | **GET** /orgs/{id} | 
*OrganizationApi* | [**get_orgs**](docs/OrganizationApi.md#get_orgs) | **GET** /orgs | 
*ServerApi* | [**get_server**](docs/ServerApi.md#get_server) | **GET** /servers/{id} | 
*ServerApi* | [**get_servers**](docs/ServerApi.md#get_servers) | **GET** /servers | 
*StackApi* | [**get_stack**](docs/StackApi.md#get_stack) | **GET** /stacks/{id} | 
*StackApi* | [**get_stacks**](docs/StackApi.md#get_stacks) | **GET** /stacks | 
*StackApi* | [**update_stack_from_upstream**](docs/StackApi.md#update_stack_from_upstream) | **POST** /stacks/{id}/update | 
*StackApi* | [**update_stacks_from_upstream**](docs/StackApi.md#update_stacks_from_upstream) | **POST** /stacks/update | 
*TaskApi* | [**get_task**](docs/TaskApi.md#get_task) | **GET** /tasks/{id} | 
*TaskApi* | [**get_tasks**](docs/TaskApi.md#get_tasks) | **GET** /tasks | 
*UserApi* | [**get_authenticated_user**](docs/UserApi.md#get_authenticated_user) | **GET** /user | 


## Documentation For Models

 - [App](docs/App.md)
 - [Backup](docs/Backup.md)
 - [BackupFile](docs/BackupFile.md)
 - [BackupFiles](docs/BackupFiles.md)
 - [Domain](docs/Domain.md)
 - [GitRepo](docs/GitRepo.md)
 - [Instance](docs/Instance.md)
 - [InstanceType](docs/InstanceType.md)
 - [Org](docs/Org.md)
 - [RequestAppCreate](docs/RequestAppCreate.md)
 - [RequestAppCreateGit](docs/RequestAppCreateGit.md)
 - [RequestAppCreateServices](docs/RequestAppCreateServices.md)
 - [RequestInstanceCreate](docs/RequestInstanceCreate.md)
 - [RequestInstanceCreateGit](docs/RequestInstanceCreateGit.md)
 - [RequestInstanceDeploy](docs/RequestInstanceDeploy.md)
 - [RequestInstanceDeployCodebase](docs/RequestInstanceDeployCodebase.md)
 - [RequestInstancesUpgrade](docs/RequestInstancesUpgrade.md)
 - [RequestStacksUpdate](docs/RequestStacksUpdate.md)
 - [ResponseTask](docs/ResponseTask.md)
 - [ResponseTaskApp](docs/ResponseTaskApp.md)
 - [ResponseTaskInstance](docs/ResponseTaskInstance.md)
 - [Server](docs/Server.md)
 - [Stack](docs/Stack.md)
 - [StackService](docs/StackService.md)
 - [StackServiceImplementation](docs/StackServiceImplementation.md)
 - [Task](docs/Task.md)
 - [User](docs/User.md)


## Documentation For Authorization


## ApiKeyAuth

- **Type**: API key
- **API key parameter name**: X-API-KEY
- **Location**: HTTP header


## Author



