/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Channel;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ChannelCredentials;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ExperimentalApi;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Status;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.HandshakerServiceChannel;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.InternalCheckGcpEnvironment;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.alts.internal.AltsProtocolNegotiator;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.ObjectPool;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.internal.SharedResourcePool;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty.GrpcHttp2ConnectionHandler;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty.InternalNettyChannelCredentials;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.channel.ChannelHandlerAdapter;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.netty.shaded.io.netty.util.AsciiString;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4151")
public final class AltsChannelCredentials {
    private static final Logger logger = Logger.getLogger(AltsChannelCredentials.class.getName());
    private static final AsciiString SCHEME = AsciiString.of("https");

    private AltsChannelCredentials() {
    }

    public static ChannelCredentials create() {
        return AltsChannelCredentials.newBuilder().build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static final class FailingProtocolNegotiator
    implements InternalProtocolNegotiator.ProtocolNegotiator {
        private final Status status;

        public FailingProtocolNegotiator(Status status) {
            this.status = status;
        }

        @Override
        public AsciiString scheme() {
            return SCHEME;
        }

        @Override
        public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
            return new ChannelHandlerAdapter(){

                @Override
                public void handlerAdded(ChannelHandlerContext ctx) {
                    ctx.fireExceptionCaught(FailingProtocolNegotiator.this.status.asRuntimeException());
                }
            };
        }

        @Override
        public void close() {
        }
    }

    private static final class FailingProtocolNegotiatorFactory
    implements InternalProtocolNegotiator.ClientFactory {
        private final Status status;

        public FailingProtocolNegotiatorFactory(Status status) {
            this.status = status;
        }

        @Override
        public InternalProtocolNegotiator.ProtocolNegotiator newNegotiator() {
            return new FailingProtocolNegotiator(this.status);
        }

        @Override
        public int getDefaultPort() {
            return 443;
        }
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4151")
    public static final class Builder {
        private final ImmutableList.Builder<String> targetServiceAccountsBuilder = ImmutableList.builder();
        private ObjectPool<Channel> handshakerChannelPool = SharedResourcePool.forResource(HandshakerServiceChannel.SHARED_HANDSHAKER_CHANNEL);
        private boolean enableUntrustedAlts;

        public Builder addTargetServiceAccount(String targetServiceAccount) {
            this.targetServiceAccountsBuilder.add((Object)targetServiceAccount);
            return this;
        }

        public Builder enableUntrustedAltsForTesting() {
            this.enableUntrustedAlts = true;
            return this;
        }

        public Builder setHandshakerAddressForTesting(String handshakerAddress) {
            this.handshakerChannelPool = SharedResourcePool.forResource(HandshakerServiceChannel.getHandshakerChannelForTesting(handshakerAddress));
            return this;
        }

        public ChannelCredentials build() {
            return InternalNettyChannelCredentials.create(this.buildProtocolNegotiatorFactory());
        }

        InternalProtocolNegotiator.ClientFactory buildProtocolNegotiatorFactory() {
            if (!InternalCheckGcpEnvironment.isOnGcp()) {
                if (this.enableUntrustedAlts) {
                    logger.log(Level.WARNING, "Untrusted ALTS mode is enabled and we cannot guarantee the trustworthiness of the ALTS handshaker service");
                } else {
                    Status status = Status.INTERNAL.withDescription("ALTS is only allowed to run on Google Cloud Platform");
                    return new FailingProtocolNegotiatorFactory(status);
                }
            }
            return new AltsProtocolNegotiator.ClientAltsProtocolNegotiatorFactory((List<String>)((Object)this.targetServiceAccountsBuilder.build()), this.handshakerChannelPool);
        }
    }
}

