# coding: utf-8

"""
    NetSuite REST API

    NetSuite REST Record API generated 2023-01-18 at 19:40:11 UTC for account 472052, user will@theapiguys.com with role Keap Integration.  # noqa: E501

    OpenAPI spec version: v1
    Contact: info@netsuite.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from netsuite.swagger_client.api_client import ApiClient


class CustomerApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def customer_get(self, **kwargs):  # noqa: E501
        """Get list of records.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.customer_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str prefer: The server behavior requested by the client. Use 'respond-async' to execute the request asynchronously. If the request is executed asynchronously, 'Preference-applied: respond-async' is returned in the response.
        :param str x_net_suite_idempotency_key: A user-defined unique idempotency key that is applied to every asynchronous requests to ensure that the request is executed only once. Only one request can be executed with every unique idempotency key. Use UUID in string format as defined by RFC 4122. If the request is executed synchronously, this value is ignored.
        :param str q: The search query that is used to filter results.
        :param int limit: The limit used to specify the number of results on a single page.
        :param int offset: The offset used for selecting a specific page of results.
        :return: CustomerCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.customer_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.customer_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def customer_get_with_http_info(self, **kwargs):  # noqa: E501
        """Get list of records.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.customer_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str prefer: The server behavior requested by the client. Use 'respond-async' to execute the request asynchronously. If the request is executed asynchronously, 'Preference-applied: respond-async' is returned in the response.
        :param str x_net_suite_idempotency_key: A user-defined unique idempotency key that is applied to every asynchronous requests to ensure that the request is executed only once. Only one request can be executed with every unique idempotency key. Use UUID in string format as defined by RFC 4122. If the request is executed synchronously, this value is ignored.
        :param str q: The search query that is used to filter results.
        :param int limit: The limit used to specify the number of results on a single page.
        :param int offset: The offset used for selecting a specific page of results.
        :return: CustomerCollection
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prefer', 'x_net_suite_idempotency_key', 'q', 'limit', 'offset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method customer_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'q' in params:
            query_params.append(('q', params['q']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501

        header_params = {}
        if 'prefer' in params:
            header_params['Prefer'] = params['prefer']  # noqa: E501
        if 'x_net_suite_idempotency_key' in params:
            header_params['X-NetSuite-Idempotency-Key'] = params['x_net_suite_idempotency_key']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.oracle.resource+json; type=collection', 'application/vnd.oracle.resource+json; type=error'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oAuth2ClientCredentials']  # noqa: E501

        return self.api_client.call_api(
            '/customer', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerCollection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def customer_id_delete(self, id, **kwargs):  # noqa: E501
        """Remove record.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.customer_id_delete(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Internal identifier. (required)
        :param str prefer: The server behavior requested by the client. Use 'respond-async' to execute the request asynchronously. If the request is executed asynchronously, 'Preference-applied: respond-async' is returned in the response.
        :param str x_net_suite_idempotency_key: A user-defined unique idempotency key that is applied to every asynchronous requests to ensure that the request is executed only once. Only one request can be executed with every unique idempotency key. Use UUID in string format as defined by RFC 4122. If the request is executed synchronously, this value is ignored.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.customer_id_delete_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.customer_id_delete_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def customer_id_delete_with_http_info(self, id, **kwargs):  # noqa: E501
        """Remove record.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.customer_id_delete_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Internal identifier. (required)
        :param str prefer: The server behavior requested by the client. Use 'respond-async' to execute the request asynchronously. If the request is executed asynchronously, 'Preference-applied: respond-async' is returned in the response.
        :param str x_net_suite_idempotency_key: A user-defined unique idempotency key that is applied to every asynchronous requests to ensure that the request is executed only once. Only one request can be executed with every unique idempotency key. Use UUID in string format as defined by RFC 4122. If the request is executed synchronously, this value is ignored.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'prefer', 'x_net_suite_idempotency_key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method customer_id_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `customer_id_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'prefer' in params:
            header_params['Prefer'] = params['prefer']  # noqa: E501
        if 'x_net_suite_idempotency_key' in params:
            header_params['X-NetSuite-Idempotency-Key'] = params['x_net_suite_idempotency_key']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.oracle.resource+json; type=error'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oAuth2ClientCredentials']  # noqa: E501

        return self.api_client.call_api(
            '/customer/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def customer_id_get(self, id, **kwargs):  # noqa: E501
        """Get record.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.customer_id_get(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Internal identifier. (required)
        :param str prefer: The server behavior requested by the client. Use 'respond-async' to execute the request asynchronously. If the request is executed asynchronously, 'Preference-applied: respond-async' is returned in the response.
        :param str x_net_suite_idempotency_key: A user-defined unique idempotency key that is applied to every asynchronous requests to ensure that the request is executed only once. Only one request can be executed with every unique idempotency key. Use UUID in string format as defined by RFC 4122. If the request is executed synchronously, this value is ignored.
        :param bool expand_sub_resources: Set to 'true' to automatically expand all sublists, sublist lines, and subrecords on this record.
        :param bool simple_enum_format: Set to true to return enumeration values in a format that only shows the internal ID value.
        :param str fields: The names of the fields and sublists on the record. Only the selected fields and sublists will be returned in the response.
        :return: Customer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.customer_id_get_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.customer_id_get_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def customer_id_get_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get record.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.customer_id_get_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Internal identifier. (required)
        :param str prefer: The server behavior requested by the client. Use 'respond-async' to execute the request asynchronously. If the request is executed asynchronously, 'Preference-applied: respond-async' is returned in the response.
        :param str x_net_suite_idempotency_key: A user-defined unique idempotency key that is applied to every asynchronous requests to ensure that the request is executed only once. Only one request can be executed with every unique idempotency key. Use UUID in string format as defined by RFC 4122. If the request is executed synchronously, this value is ignored.
        :param bool expand_sub_resources: Set to 'true' to automatically expand all sublists, sublist lines, and subrecords on this record.
        :param bool simple_enum_format: Set to true to return enumeration values in a format that only shows the internal ID value.
        :param str fields: The names of the fields and sublists on the record. Only the selected fields and sublists will be returned in the response.
        :return: Customer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'prefer', 'x_net_suite_idempotency_key', 'expand_sub_resources', 'simple_enum_format', 'fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method customer_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `customer_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'expand_sub_resources' in params:
            query_params.append(('expandSubResources', params['expand_sub_resources']))  # noqa: E501
        if 'simple_enum_format' in params:
            query_params.append(('simpleEnumFormat', params['simple_enum_format']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501

        header_params = {}
        if 'prefer' in params:
            header_params['Prefer'] = params['prefer']  # noqa: E501
        if 'x_net_suite_idempotency_key' in params:
            header_params['X-NetSuite-Idempotency-Key'] = params['x_net_suite_idempotency_key']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.oracle.resource+json; type=singular', 'application/vnd.oracle.resource+json; type=error'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oAuth2ClientCredentials']  # noqa: E501

        return self.api_client.call_api(
            '/customer/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Customer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def customer_id_patch(self, body, id, **kwargs):  # noqa: E501
        """Update record.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.customer_id_patch(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Customer body: Request body. (required)
        :param int id: Internal identifier. (required)
        :param str prefer: The server behavior requested by the client. Use 'respond-async' to execute the request asynchronously. If the request is executed asynchronously, 'Preference-applied: respond-async' is returned in the response.
        :param str x_net_suite_idempotency_key: A user-defined unique idempotency key that is applied to every asynchronous requests to ensure that the request is executed only once. Only one request can be executed with every unique idempotency key. Use UUID in string format as defined by RFC 4122. If the request is executed synchronously, this value is ignored.
        :param str x_net_suite_property_name_validation: Sets the strictness of property name validation.
        :param str x_net_suite_property_value_validation: Sets the strictness of property value validation.
        :param str replace: The names of sublists on this record. All sublist lines will be replaced with lines specified in the request. The names are delimited by comma.
        :param bool replace_selected_fields: If set to 'true', all fields that should be deleted in the update request, including body fields, must be included in the 'replace' query parameter.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.customer_id_patch_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.customer_id_patch_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def customer_id_patch_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Update record.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.customer_id_patch_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Customer body: Request body. (required)
        :param int id: Internal identifier. (required)
        :param str prefer: The server behavior requested by the client. Use 'respond-async' to execute the request asynchronously. If the request is executed asynchronously, 'Preference-applied: respond-async' is returned in the response.
        :param str x_net_suite_idempotency_key: A user-defined unique idempotency key that is applied to every asynchronous requests to ensure that the request is executed only once. Only one request can be executed with every unique idempotency key. Use UUID in string format as defined by RFC 4122. If the request is executed synchronously, this value is ignored.
        :param str x_net_suite_property_name_validation: Sets the strictness of property name validation.
        :param str x_net_suite_property_value_validation: Sets the strictness of property value validation.
        :param str replace: The names of sublists on this record. All sublist lines will be replaced with lines specified in the request. The names are delimited by comma.
        :param bool replace_selected_fields: If set to 'true', all fields that should be deleted in the update request, including body fields, must be included in the 'replace' query parameter.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id', 'prefer', 'x_net_suite_idempotency_key', 'x_net_suite_property_name_validation', 'x_net_suite_property_value_validation', 'replace', 'replace_selected_fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method customer_id_patch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `customer_id_patch`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `customer_id_patch`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'replace' in params:
            query_params.append(('replace', params['replace']))  # noqa: E501
        if 'replace_selected_fields' in params:
            query_params.append(('replaceSelectedFields', params['replace_selected_fields']))  # noqa: E501

        header_params = {}
        if 'prefer' in params:
            header_params['Prefer'] = params['prefer']  # noqa: E501
        if 'x_net_suite_idempotency_key' in params:
            header_params['X-NetSuite-Idempotency-Key'] = params['x_net_suite_idempotency_key']  # noqa: E501
        if 'x_net_suite_property_name_validation' in params:
            header_params['X-NetSuite-PropertyNameValidation'] = params['x_net_suite_property_name_validation']  # noqa: E501
        if 'x_net_suite_property_value_validation' in params:
            header_params['X-NetSuite-PropertyValueValidation'] = params['x_net_suite_property_value_validation']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.oracle.resource+json; type=error'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/vnd.oracle.resource+json; type=singular'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oAuth2ClientCredentials']  # noqa: E501

        return self.api_client.call_api(
            '/customer/{id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def customer_id_put(self, body, id, **kwargs):  # noqa: E501
        """Insert or update record.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.customer_id_put(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Customer body: Request body. (required)
        :param str id: External identifier. (required)
        :param str prefer: The server behavior requested by the client. Use 'respond-async' to execute the request asynchronously. If the request is executed asynchronously, 'Preference-applied: respond-async' is returned in the response.
        :param str x_net_suite_idempotency_key: A user-defined unique idempotency key that is applied to every asynchronous requests to ensure that the request is executed only once. Only one request can be executed with every unique idempotency key. Use UUID in string format as defined by RFC 4122. If the request is executed synchronously, this value is ignored.
        :param str x_net_suite_property_name_validation: Sets the strictness of property name validation.
        :param str x_net_suite_property_value_validation: Sets the strictness of property value validation.
        :param str replace: The names of sublists on this record. All sublist lines will be replaced with lines specified in the request. The names are delimited by comma.
        :param bool replace_selected_fields: If set to 'true', all fields that should be deleted in the update request, including body fields, must be included in the 'replace' query parameter.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.customer_id_put_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.customer_id_put_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def customer_id_put_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Insert or update record.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.customer_id_put_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Customer body: Request body. (required)
        :param str id: External identifier. (required)
        :param str prefer: The server behavior requested by the client. Use 'respond-async' to execute the request asynchronously. If the request is executed asynchronously, 'Preference-applied: respond-async' is returned in the response.
        :param str x_net_suite_idempotency_key: A user-defined unique idempotency key that is applied to every asynchronous requests to ensure that the request is executed only once. Only one request can be executed with every unique idempotency key. Use UUID in string format as defined by RFC 4122. If the request is executed synchronously, this value is ignored.
        :param str x_net_suite_property_name_validation: Sets the strictness of property name validation.
        :param str x_net_suite_property_value_validation: Sets the strictness of property value validation.
        :param str replace: The names of sublists on this record. All sublist lines will be replaced with lines specified in the request. The names are delimited by comma.
        :param bool replace_selected_fields: If set to 'true', all fields that should be deleted in the update request, including body fields, must be included in the 'replace' query parameter.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id', 'prefer', 'x_net_suite_idempotency_key', 'x_net_suite_property_name_validation', 'x_net_suite_property_value_validation', 'replace', 'replace_selected_fields']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method customer_id_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `customer_id_put`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `customer_id_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'replace' in params:
            query_params.append(('replace', params['replace']))  # noqa: E501
        if 'replace_selected_fields' in params:
            query_params.append(('replaceSelectedFields', params['replace_selected_fields']))  # noqa: E501

        header_params = {}
        if 'prefer' in params:
            header_params['Prefer'] = params['prefer']  # noqa: E501
        if 'x_net_suite_idempotency_key' in params:
            header_params['X-NetSuite-Idempotency-Key'] = params['x_net_suite_idempotency_key']  # noqa: E501
        if 'x_net_suite_property_name_validation' in params:
            header_params['X-NetSuite-PropertyNameValidation'] = params['x_net_suite_property_name_validation']  # noqa: E501
        if 'x_net_suite_property_value_validation' in params:
            header_params['X-NetSuite-PropertyValueValidation'] = params['x_net_suite_property_value_validation']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.oracle.resource+json; type=error'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/vnd.oracle.resource+json; type=singular'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oAuth2ClientCredentials']  # noqa: E501

        return self.api_client.call_api(
            '/customer/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def customer_idtransform_cash_sale_post(self, body, id, **kwargs):  # noqa: E501
        """Transform to cashSale.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.customer_idtransform_cash_sale_post(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NsResource body: Request body. (required)
        :param int id: Internal identifier. (required)
        :param str prefer: The server behavior requested by the client. Use 'respond-async' to execute the request asynchronously. If the request is executed asynchronously, 'Preference-applied: respond-async' is returned in the response.
        :param str x_net_suite_idempotency_key: A user-defined unique idempotency key that is applied to every asynchronous requests to ensure that the request is executed only once. Only one request can be executed with every unique idempotency key. Use UUID in string format as defined by RFC 4122. If the request is executed synchronously, this value is ignored.
        :param str x_net_suite_property_name_validation: Sets the strictness of property name validation.
        :param str x_net_suite_property_value_validation: Sets the strictness of property value validation.
        :param str replace: The names of sublists on this record. All sublist lines will be replaced with lines specified in the request. The names are delimited by comma.
        :return: NsResource
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.customer_idtransform_cash_sale_post_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.customer_idtransform_cash_sale_post_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def customer_idtransform_cash_sale_post_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Transform to cashSale.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.customer_idtransform_cash_sale_post_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NsResource body: Request body. (required)
        :param int id: Internal identifier. (required)
        :param str prefer: The server behavior requested by the client. Use 'respond-async' to execute the request asynchronously. If the request is executed asynchronously, 'Preference-applied: respond-async' is returned in the response.
        :param str x_net_suite_idempotency_key: A user-defined unique idempotency key that is applied to every asynchronous requests to ensure that the request is executed only once. Only one request can be executed with every unique idempotency key. Use UUID in string format as defined by RFC 4122. If the request is executed synchronously, this value is ignored.
        :param str x_net_suite_property_name_validation: Sets the strictness of property name validation.
        :param str x_net_suite_property_value_validation: Sets the strictness of property value validation.
        :param str replace: The names of sublists on this record. All sublist lines will be replaced with lines specified in the request. The names are delimited by comma.
        :return: NsResource
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id', 'prefer', 'x_net_suite_idempotency_key', 'x_net_suite_property_name_validation', 'x_net_suite_property_value_validation', 'replace']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method customer_idtransform_cash_sale_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `customer_idtransform_cash_sale_post`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `customer_idtransform_cash_sale_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'replace' in params:
            query_params.append(('replace', params['replace']))  # noqa: E501

        header_params = {}
        if 'prefer' in params:
            header_params['Prefer'] = params['prefer']  # noqa: E501
        if 'x_net_suite_idempotency_key' in params:
            header_params['X-NetSuite-Idempotency-Key'] = params['x_net_suite_idempotency_key']  # noqa: E501
        if 'x_net_suite_property_name_validation' in params:
            header_params['X-NetSuite-PropertyNameValidation'] = params['x_net_suite_property_name_validation']  # noqa: E501
        if 'x_net_suite_property_value_validation' in params:
            header_params['X-NetSuite-PropertyValueValidation'] = params['x_net_suite_property_value_validation']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.oracle.resource+json; type=singular', 'application/vnd.oracle.resource+json; type=error'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/vnd.oracle.resource+json; type=singular'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oAuth2ClientCredentials']  # noqa: E501

        return self.api_client.call_api(
            '/customer/{id}/!transform/cashSale', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NsResource',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def customer_idtransform_invoice_post(self, body, id, **kwargs):  # noqa: E501
        """Transform to invoice.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.customer_idtransform_invoice_post(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NsResource body: Request body. (required)
        :param int id: Internal identifier. (required)
        :param str prefer: The server behavior requested by the client. Use 'respond-async' to execute the request asynchronously. If the request is executed asynchronously, 'Preference-applied: respond-async' is returned in the response.
        :param str x_net_suite_idempotency_key: A user-defined unique idempotency key that is applied to every asynchronous requests to ensure that the request is executed only once. Only one request can be executed with every unique idempotency key. Use UUID in string format as defined by RFC 4122. If the request is executed synchronously, this value is ignored.
        :param str x_net_suite_property_name_validation: Sets the strictness of property name validation.
        :param str x_net_suite_property_value_validation: Sets the strictness of property value validation.
        :param str replace: The names of sublists on this record. All sublist lines will be replaced with lines specified in the request. The names are delimited by comma.
        :return: NsResource
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.customer_idtransform_invoice_post_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.customer_idtransform_invoice_post_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def customer_idtransform_invoice_post_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Transform to invoice.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.customer_idtransform_invoice_post_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NsResource body: Request body. (required)
        :param int id: Internal identifier. (required)
        :param str prefer: The server behavior requested by the client. Use 'respond-async' to execute the request asynchronously. If the request is executed asynchronously, 'Preference-applied: respond-async' is returned in the response.
        :param str x_net_suite_idempotency_key: A user-defined unique idempotency key that is applied to every asynchronous requests to ensure that the request is executed only once. Only one request can be executed with every unique idempotency key. Use UUID in string format as defined by RFC 4122. If the request is executed synchronously, this value is ignored.
        :param str x_net_suite_property_name_validation: Sets the strictness of property name validation.
        :param str x_net_suite_property_value_validation: Sets the strictness of property value validation.
        :param str replace: The names of sublists on this record. All sublist lines will be replaced with lines specified in the request. The names are delimited by comma.
        :return: NsResource
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id', 'prefer', 'x_net_suite_idempotency_key', 'x_net_suite_property_name_validation', 'x_net_suite_property_value_validation', 'replace']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method customer_idtransform_invoice_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `customer_idtransform_invoice_post`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `customer_idtransform_invoice_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'replace' in params:
            query_params.append(('replace', params['replace']))  # noqa: E501

        header_params = {}
        if 'prefer' in params:
            header_params['Prefer'] = params['prefer']  # noqa: E501
        if 'x_net_suite_idempotency_key' in params:
            header_params['X-NetSuite-Idempotency-Key'] = params['x_net_suite_idempotency_key']  # noqa: E501
        if 'x_net_suite_property_name_validation' in params:
            header_params['X-NetSuite-PropertyNameValidation'] = params['x_net_suite_property_name_validation']  # noqa: E501
        if 'x_net_suite_property_value_validation' in params:
            header_params['X-NetSuite-PropertyValueValidation'] = params['x_net_suite_property_value_validation']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.oracle.resource+json; type=singular', 'application/vnd.oracle.resource+json; type=error'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/vnd.oracle.resource+json; type=singular'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oAuth2ClientCredentials']  # noqa: E501

        return self.api_client.call_api(
            '/customer/{id}/!transform/invoice', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NsResource',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def customer_idtransform_sales_order_post(self, body, id, **kwargs):  # noqa: E501
        """Transform to salesOrder.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.customer_idtransform_sales_order_post(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NsResource body: Request body. (required)
        :param int id: Internal identifier. (required)
        :param str prefer: The server behavior requested by the client. Use 'respond-async' to execute the request asynchronously. If the request is executed asynchronously, 'Preference-applied: respond-async' is returned in the response.
        :param str x_net_suite_idempotency_key: A user-defined unique idempotency key that is applied to every asynchronous requests to ensure that the request is executed only once. Only one request can be executed with every unique idempotency key. Use UUID in string format as defined by RFC 4122. If the request is executed synchronously, this value is ignored.
        :param str x_net_suite_property_name_validation: Sets the strictness of property name validation.
        :param str x_net_suite_property_value_validation: Sets the strictness of property value validation.
        :param str replace: The names of sublists on this record. All sublist lines will be replaced with lines specified in the request. The names are delimited by comma.
        :return: NsResource
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.customer_idtransform_sales_order_post_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.customer_idtransform_sales_order_post_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def customer_idtransform_sales_order_post_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Transform to salesOrder.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.customer_idtransform_sales_order_post_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NsResource body: Request body. (required)
        :param int id: Internal identifier. (required)
        :param str prefer: The server behavior requested by the client. Use 'respond-async' to execute the request asynchronously. If the request is executed asynchronously, 'Preference-applied: respond-async' is returned in the response.
        :param str x_net_suite_idempotency_key: A user-defined unique idempotency key that is applied to every asynchronous requests to ensure that the request is executed only once. Only one request can be executed with every unique idempotency key. Use UUID in string format as defined by RFC 4122. If the request is executed synchronously, this value is ignored.
        :param str x_net_suite_property_name_validation: Sets the strictness of property name validation.
        :param str x_net_suite_property_value_validation: Sets the strictness of property value validation.
        :param str replace: The names of sublists on this record. All sublist lines will be replaced with lines specified in the request. The names are delimited by comma.
        :return: NsResource
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id', 'prefer', 'x_net_suite_idempotency_key', 'x_net_suite_property_name_validation', 'x_net_suite_property_value_validation', 'replace']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method customer_idtransform_sales_order_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `customer_idtransform_sales_order_post`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `customer_idtransform_sales_order_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'replace' in params:
            query_params.append(('replace', params['replace']))  # noqa: E501

        header_params = {}
        if 'prefer' in params:
            header_params['Prefer'] = params['prefer']  # noqa: E501
        if 'x_net_suite_idempotency_key' in params:
            header_params['X-NetSuite-Idempotency-Key'] = params['x_net_suite_idempotency_key']  # noqa: E501
        if 'x_net_suite_property_name_validation' in params:
            header_params['X-NetSuite-PropertyNameValidation'] = params['x_net_suite_property_name_validation']  # noqa: E501
        if 'x_net_suite_property_value_validation' in params:
            header_params['X-NetSuite-PropertyValueValidation'] = params['x_net_suite_property_value_validation']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.oracle.resource+json; type=singular', 'application/vnd.oracle.resource+json; type=error'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/vnd.oracle.resource+json; type=singular'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oAuth2ClientCredentials']  # noqa: E501

        return self.api_client.call_api(
            '/customer/{id}/!transform/salesOrder', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NsResource',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def customer_idtransform_vendor_post(self, body, id, **kwargs):  # noqa: E501
        """Transform to vendor.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.customer_idtransform_vendor_post(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NsResource body: Request body. (required)
        :param int id: Internal identifier. (required)
        :param str prefer: The server behavior requested by the client. Use 'respond-async' to execute the request asynchronously. If the request is executed asynchronously, 'Preference-applied: respond-async' is returned in the response.
        :param str x_net_suite_idempotency_key: A user-defined unique idempotency key that is applied to every asynchronous requests to ensure that the request is executed only once. Only one request can be executed with every unique idempotency key. Use UUID in string format as defined by RFC 4122. If the request is executed synchronously, this value is ignored.
        :param str x_net_suite_property_name_validation: Sets the strictness of property name validation.
        :param str x_net_suite_property_value_validation: Sets the strictness of property value validation.
        :param str replace: The names of sublists on this record. All sublist lines will be replaced with lines specified in the request. The names are delimited by comma.
        :return: NsResource
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.customer_idtransform_vendor_post_with_http_info(body, id, **kwargs)  # noqa: E501
        else:
            (data) = self.customer_idtransform_vendor_post_with_http_info(body, id, **kwargs)  # noqa: E501
            return data

    def customer_idtransform_vendor_post_with_http_info(self, body, id, **kwargs):  # noqa: E501
        """Transform to vendor.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.customer_idtransform_vendor_post_with_http_info(body, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param NsResource body: Request body. (required)
        :param int id: Internal identifier. (required)
        :param str prefer: The server behavior requested by the client. Use 'respond-async' to execute the request asynchronously. If the request is executed asynchronously, 'Preference-applied: respond-async' is returned in the response.
        :param str x_net_suite_idempotency_key: A user-defined unique idempotency key that is applied to every asynchronous requests to ensure that the request is executed only once. Only one request can be executed with every unique idempotency key. Use UUID in string format as defined by RFC 4122. If the request is executed synchronously, this value is ignored.
        :param str x_net_suite_property_name_validation: Sets the strictness of property name validation.
        :param str x_net_suite_property_value_validation: Sets the strictness of property value validation.
        :param str replace: The names of sublists on this record. All sublist lines will be replaced with lines specified in the request. The names are delimited by comma.
        :return: NsResource
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'id', 'prefer', 'x_net_suite_idempotency_key', 'x_net_suite_property_name_validation', 'x_net_suite_property_value_validation', 'replace']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method customer_idtransform_vendor_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `customer_idtransform_vendor_post`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `customer_idtransform_vendor_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'replace' in params:
            query_params.append(('replace', params['replace']))  # noqa: E501

        header_params = {}
        if 'prefer' in params:
            header_params['Prefer'] = params['prefer']  # noqa: E501
        if 'x_net_suite_idempotency_key' in params:
            header_params['X-NetSuite-Idempotency-Key'] = params['x_net_suite_idempotency_key']  # noqa: E501
        if 'x_net_suite_property_name_validation' in params:
            header_params['X-NetSuite-PropertyNameValidation'] = params['x_net_suite_property_name_validation']  # noqa: E501
        if 'x_net_suite_property_value_validation' in params:
            header_params['X-NetSuite-PropertyValueValidation'] = params['x_net_suite_property_value_validation']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.oracle.resource+json; type=singular', 'application/vnd.oracle.resource+json; type=error'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/vnd.oracle.resource+json; type=singular'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oAuth2ClientCredentials']  # noqa: E501

        return self.api_client.call_api(
            '/customer/{id}/!transform/vendor', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NsResource',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def customer_post(self, body, **kwargs):  # noqa: E501
        """Insert record.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.customer_post(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Customer body: Request body. (required)
        :param str prefer: The server behavior requested by the client. Use 'respond-async' to execute the request asynchronously. If the request is executed asynchronously, 'Preference-applied: respond-async' is returned in the response.
        :param str x_net_suite_idempotency_key: A user-defined unique idempotency key that is applied to every asynchronous requests to ensure that the request is executed only once. Only one request can be executed with every unique idempotency key. Use UUID in string format as defined by RFC 4122. If the request is executed synchronously, this value is ignored.
        :param str x_net_suite_property_name_validation: Sets the strictness of property name validation.
        :param str x_net_suite_property_value_validation: Sets the strictness of property value validation.
        :param str replace: The names of sublists on this record. All sublist lines will be replaced with lines specified in the request. The names are delimited by comma.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.customer_post_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.customer_post_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def customer_post_with_http_info(self, body, **kwargs):  # noqa: E501
        """Insert record.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.customer_post_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Customer body: Request body. (required)
        :param str prefer: The server behavior requested by the client. Use 'respond-async' to execute the request asynchronously. If the request is executed asynchronously, 'Preference-applied: respond-async' is returned in the response.
        :param str x_net_suite_idempotency_key: A user-defined unique idempotency key that is applied to every asynchronous requests to ensure that the request is executed only once. Only one request can be executed with every unique idempotency key. Use UUID in string format as defined by RFC 4122. If the request is executed synchronously, this value is ignored.
        :param str x_net_suite_property_name_validation: Sets the strictness of property name validation.
        :param str x_net_suite_property_value_validation: Sets the strictness of property value validation.
        :param str replace: The names of sublists on this record. All sublist lines will be replaced with lines specified in the request. The names are delimited by comma.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'prefer', 'x_net_suite_idempotency_key', 'x_net_suite_property_name_validation', 'x_net_suite_property_value_validation', 'replace']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method customer_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `customer_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'replace' in params:
            query_params.append(('replace', params['replace']))  # noqa: E501

        header_params = {}
        if 'prefer' in params:
            header_params['Prefer'] = params['prefer']  # noqa: E501
        if 'x_net_suite_idempotency_key' in params:
            header_params['X-NetSuite-Idempotency-Key'] = params['x_net_suite_idempotency_key']  # noqa: E501
        if 'x_net_suite_property_name_validation' in params:
            header_params['X-NetSuite-PropertyNameValidation'] = params['x_net_suite_property_name_validation']  # noqa: E501
        if 'x_net_suite_property_value_validation' in params:
            header_params['X-NetSuite-PropertyValueValidation'] = params['x_net_suite_property_value_validation']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.oracle.resource+json; type=error'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/vnd.oracle.resource+json; type=singular'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oAuth2ClientCredentials']  # noqa: E501

        return self.api_client.call_api(
            '/customer', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
