# Github Enterprise cloud migration tool

This tool helps you do the below tasks

[Github Migration](#github-migration)

[Jenkins BMX Migration](#jenkins-migration)

[Make repos private](#make-repos-private)

[Update topics](#update-topics-on-repos)

[Find new git URL for CI/CD changes (SNOW)](#find-new-urls-for-cicd-template-update)

## Github Migration

Migrates provided github repos from source org to target organization

#### Generate Github Personal Access Token 

- Follow the steps [here](https://docs.github.com/en/github/authenticating-to-github/keeping-your-account-and-data-secure/creating-a-personal-access-token) to generate personal access token. Copy the token.
- For github enterprise cloud, the token should be enabled with SAML SSO
- Follow the steps [here](https://docs.github.com/en/github/authenticating-to-github/authenticating-with-saml-single-sign-on/authorizing-a-personal-access-token-for-use-with-saml-single-sign-on)

### Access Needed 

- The user who is running this tool, should be an admin on the source organization. 

### Make Repos private

Before running the tool for migration make all the repos private. You have to be an admin on the organization to do so

```
Github Migration
? What do you want to do?  Make repos private
? Organization Name  nike-platform-fulfillment
? github personal access token  ****************************************
tesactions is internal, making it private
Made tesactions private for transfer
tesactions is internal, making it private

```

#### Running the tool

- Install python3 
    - On MAC OS - ```brew install python3```
    - On Windows, download the installer from [here](https://www.python.org/downloads/windows/)


Run the below command to install the github migration tool

```pip3 install --upgrade ghec-migration```

Invoke the tool by running ```ghec-migration```

Output of the tool

```shell script

➜  ~ ghec-migration
Github Migration
? What do you want to do?  Github Migration
? Source github org  nike-platform-fulfillment
? Target github org  nike-internal
? Target Team Slug  fulfillment-squad-artemis
? Target Team Admin Slug  fulfillment-admins
? Team Prefix  fulfillment
? Github access token  <token>
? How do you want to get the repos?  Provide list of Repos
? Provide the file with the repo names to be migrated  /Users/vmari2/repos.txt

#output

Logged in as user vmari2_nike
Reading repos from /Users/vmari2/repos.txt

Transferring publishgempoc to target organization
Adding user vmari2_nike as adming to repo publishgempoc
User vmari2_nike added as admin to the repo publishgempoc
Renaming publishgempoc to fulfillment.publishgempoc
Renamed successfully
Renaming master to main
Renamed master to main
Transferring repo publishgempoc to nike-internal
Transfer completed for repo publishgempoc
changing team level access
Changed fulfillment to be a push
Changed fulfillment-squad-artemis to be a maintain
Changed fulfillment-admins to be a admin
Changed fulfillment-external-contributors to be a push
Made publishgempoc internal after transfer
Removing user vmari2_nike as adming to repo publishgempoc
User vmari2_nike removed as admin to the repo publishgempoc
Completed transfer for publishgempoc



```


### Jenkins Migration

We can change the github url in the bmx job using this tool

Generate a jenkins following the steps [here](https://support.cloudbees.com/hc/en-us/articles/115003090592-How-to-re-generate-my-Jenkins-user-token)

You can provide the list of jobs you want to change. Create a text file with all the jobs you want to reconfigure. Example can be found [here](jobs.txt)

if you don't provide the list of jobs, all the jobs in the jenkins instance will be reconfigured

```shell script
Github Migration
? What do you want to do?  Jenkins BMX Migration
? Provide the jenkins url  https://logistics.jenkins.bmx.nikecloud.com/
? Provide the file with the list of jobs. Leave blank if you want to reconfigure all jobs in the jenkins instance  jobs.txt
? Jenkins Token  **********************************
? Jenkins Username  Vamsikrishna.Maringanti@nike.com
? New Github Org  nike-internal
? Old Github Org(s). Provide comma separated values   gflsdrepo
? Team Prefix  fulfillment
? Provide the new credentials to Change credentials id. Leave blank if not changing   
```

### Update Topics on repos

This script finds the repos on which the given team has the provided access levels. For example, if you want to update topics on repos where **```fulfillment-squad-artemis```** has **```maintain```** access provide the below information

#### Arguments

| Postion | Argument          | Description                                                                                              |
|---------|-------------------|----------------------------------------------------------------------------------------------------------|
| 1       | Source_Org        | the github organization name Ex nike-internal                                                                             |
| 2       | team_slug         | the team slug Ex: fulfillment-squad-artemis                                                                                            |
| 3       | access_level      | the access level for the provided team - can take values ["push", "pull", "maintain", "admin", "triage"] |
| 4       | token             | github access token                                                                                      |
| 5       | Additional Topics | Provide common separated topics ex: fulfillment,services                                                 |


```shell script
Github Migration
? What do you want to do?  Update topics
? Organization Name  nike-internal
? Team Slug  fulfillment-squad-artemis
? Select the permission level  maintain
? Additional topics, comma separated  artemis
? github personal access token  ****************************************

```

### Find new urls for CI/CD template update

As part of bulk migration, the CICD templates are updated with intermediate organization ex ```nike-platform-logistics```. You can use this tool to get the new URLs for the repos after migration

To run this, you will need the list of old repo URLS. This can be exported from [service now](https://niketech.service-now.com/nav_to.do?uri=%2Fu_cd_template_mapping_list.do%3Fsysparm_view%3D%26sysparm_first_row%3D1%26sysparm_query%3Du_active%253Dtrue%255Eu_cd_template%253Dtrue%255Eu_template%253Df04e470a13952bc0ea05b3b12244b063%26sysparm_clear_stack%3Dtrue)

Create a text [file](old_urls.txt) with repo URLs. Run the tool selecting the right options

```shell script
? What do you want to do?  Find new git URL for CI/CD changes (SNOW)
? Source github organization  nike-platform-fulfillment
? File path for the list of Old URLs  old_urls.txt
? Github Token  ****************************************
Getting new url for orderstatus
Getting new url for nikeidboxlabel
Getting new url for goodsissue
Getting new url for fgwschedulers
Completed process. The new git Urls can be found at new_references.csv

```

### What this tool will not do

- update QMA config in service now
- Update ```master``` references to ```main``` in Code like Jenkinsfile, etc
- If you use build flows based on the branch, you have to update them accordingly
- Doesn't organize bmx jobs into folders
- It can't skip bmx jobs

TODO

- [x] Add branch protection rules and status checks
- [ ] Update Scan@Source metadata
