/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.util;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.config.Configurator;

public final class Logger {
    private static final String LOG_NAME = "Moonlight Log";
    private static volatile Logger instance;
    private final org.apache.logging.log4j.Logger log4jLogger = LogManager.getLogger((String)"Moonlight Log");

    private Logger(String level) {
        this.setLevel(level);
    }

    public void setLevel(String levelName) {
        Configurator.setLevel((String)LOG_NAME, (Level)(switch (levelName) {
            case "off" -> Level.OFF;
            case "fatal" -> Level.FATAL;
            case "error" -> Level.ERROR;
            case "warning" -> Level.WARN;
            case "info" -> Level.INFO;
            case "debug" -> Level.DEBUG;
            case "trace" -> Level.TRACE;
            default -> Level.ALL;
        }));
        this.info("Logger level set to 'ALL'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger() {
        Logger local = instance;
        if (local != null) {
            return local;
        }
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            if (instance == null) {
                instance = new Logger("all");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public void fatal(String message) {
        this.log4jLogger.fatal(message);
    }

    public void error(String message) {
        this.log4jLogger.error(message);
    }

    public void warn(String message) {
        this.log4jLogger.warn(message);
    }

    public void info(String message) {
        this.log4jLogger.info(message);
    }

    public void debug(String message) {
        this.log4jLogger.debug(message);
    }

    public void trace(String message) {
        this.log4jLogger.trace(message);
    }
}

