/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.online.algorithms;

import eu.quanticol.moonlight.core.signal.Sample;
import eu.quanticol.moonlight.core.space.DistanceStructure;
import eu.quanticol.moonlight.core.space.LocationService;
import eu.quanticol.moonlight.core.space.SpaceIterator;
import eu.quanticol.moonlight.core.space.SpatialModel;
import eu.quanticol.moonlight.online.signal.TimeChain;
import eu.quanticol.moonlight.online.signal.Update;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;

public class SpatialOp<T extends Comparable<T>, S, R extends Comparable<R>> {
    private final SpaceIterator<T, S> spaceIterator;
    private final BiFunction<IntFunction<R>, DistanceStructure<S, ?>, IntFunction<R>> op;
    private List<Update<T, List<R>>> results;
    private int locations;

    public SpatialOp(@NotNull LocationService<T, S> locationService, Function<SpatialModel<S>, DistanceStructure<S, ?>> distance, BiFunction<IntFunction<R>, DistanceStructure<S, ?>, IntFunction<R>> operator) {
        this.op = operator;
        this.checkLocationServiceValidity(locationService);
        this.spaceIterator = new SpaceIterator<T, S>(locationService, distance);
    }

    private void checkLocationServiceValidity(LocationService<T, S> locSvc) {
        if (locSvc.isEmpty()) {
            throw new UnsupportedOperationException("The location Service must not be empty!");
        }
    }

    public List<Update<T, List<R>>> computeUnary(Update<T, List<R>> u) {
        this.locations = u.getValue().size();
        T t = u.getStart();
        this.spaceIterator.init(t);
        T tNext = this.spaceIterator.fromNextSpaceOrFallback(u.getEnd());
        this.doCompute(t, tNext, u.getValue());
        return this.results;
    }

    protected void doCompute(T t, T tNext, List<R> value) {
        DistanceStructure<S, ?> f = this.spaceIterator.generateDistanceStructure();
        tNext = this.spaceIterator.fromNextSpaceOrFallback(tNext);
        this.results = new ArrayList<Update<T, List<R>>>();
        this.addResult(t, tNext, this.op.apply(value::get, f));
        T finalTNext = tNext;
        this.spaceIterator.forEach((Comparable)tNext, (BiConsumer<Comparable, DistanceStructure<S, ?>>)((BiConsumer<Comparable, DistanceStructure>)(itT, itDs) -> this.addResult(itT, finalTNext, this.op.apply(value::get, (DistanceStructure<S, ?>)itDs))));
    }

    protected void addResult(T start, T end, IntFunction<R> value) {
        this.results.add(new Update<T, List<R>>(start, end, this.computeSS(value, this.locations)));
    }

    private List<R> computeSS(IntFunction<R> spatialSignal, int size) {
        return IntStream.range(0, size).boxed().map(spatialSignal::apply).toList();
    }

    public TimeChain<T, List<R>> computeUnaryChain(TimeChain<T, List<R>> ups) {
        TimeChain resultsChain = new TimeChain(ups.getEnd());
        int LAST = ups.size() - 1;
        this.locations = ups.getFirst().getValue().size();
        this.spaceIterator.init(ups.getStart());
        for (int i = 0; i < ups.size(); ++i) {
            Sample<T, List<R>> up = ups.get(i);
            T t = up.getStart();
            T tNext = i != LAST ? ups.get(i + 1).getStart() : ups.getEnd();
            this.doCompute(t, tNext, up.getValue());
            Update.asTimeChain(this.results).forEach(resultsChain::add);
        }
        return resultsChain;
    }
}

