/*
 * Decompiled with CFR 0.152.
 */
package eu.quanticol.moonlight.offline.signal;

import eu.quanticol.moonlight.offline.algorithms.BooleanOp;
import eu.quanticol.moonlight.offline.signal.ParallelSignalCursor;
import eu.quanticol.moonlight.offline.signal.Signal;
import eu.quanticol.moonlight.offline.signal.mfr.MfrSignal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.ToDoubleFunction;
import java.util.stream.IntStream;

public class SpatialTemporalSignal<T>
extends MfrSignal<T> {
    public SpatialTemporalSignal(int size) {
        this(size, i -> new Signal());
    }

    public SpatialTemporalSignal(int size, IntFunction<Signal<T>> f) {
        super(size, f);
    }

    public <R> SpatialTemporalSignal<R> apply(BiFunction<T, T, R> f, SpatialTemporalSignal<T> s) {
        BooleanOp op = new BooleanOp();
        return this.generate(s, i -> op.applyBinary(this.getSignalAtLocation(i), f, s.getSignalAtLocation(i)));
    }

    private <R> SpatialTemporalSignal<R> generate(SpatialTemporalSignal<T> s, IntFunction<Signal<R>> f) {
        this.checkSize(s.getNumberOfLocations());
        return new SpatialTemporalSignal<T>(this.getNumberOfLocations(), f);
    }

    @Override
    public Signal<T> getSignalAtLocation(int location) {
        return this.getSignals().get(location);
    }

    public <R> SpatialTemporalSignal<R> applyToSignal(SpatialTemporalSignal<T> s, BiFunction<Signal<T>, Signal<T>, Signal<R>> f) {
        return this.generate(s, i -> (Signal)f.apply(this.getSignalAtLocation(i), s.getSignalAtLocation(i)));
    }

    public void add(double t, T[] values) {
        this.checkSize(values.length);
        this.add(t, (int i) -> values[i]);
    }

    public void add(double t, IntFunction<T> f) {
        for (int i = 0; i < this.getNumberOfLocations(); ++i) {
            this.getSignalAtLocation(i).add(t, f.apply(i));
        }
    }

    public void add(double time, List<T> values) {
        this.checkSize(values.size());
        this.add(time, values::get);
    }

    @Override
    public <R> SpatialTemporalSignal<R> apply(Function<T, R> f) {
        BooleanOp booleanOp = new BooleanOp();
        return new SpatialTemporalSignal<T>(this.getNumberOfLocations(), i -> booleanOp.applyUnary(this.getSignalAtLocation(i), f));
    }

    public <R> MfrSignal<R> selectApply(Function<T, R> f, int[] filter) {
        BooleanOp booleanOp = new BooleanOp();
        IntFunction timeSignal = i -> booleanOp.applyUnary(this.getSignals().get(i), f);
        return new MfrSignal(this.getNumberOfLocations(), timeSignal, filter);
    }

    public List<T> valuesAtT(double t) {
        ArrayList values = new ArrayList(this.getNumberOfLocations());
        this.getSignals().forEach(s -> values.add(s.getValueAt(t)));
        return values;
    }

    public <R> SpatialTemporalSignal<R> applyToSignal(Function<Signal<T>, Signal<R>> f) {
        return new SpatialTemporalSignal<T>(this.getNumberOfLocations(), i -> (Signal)f.apply(this.getSignalAtLocation(i)));
    }

    @Override
    public ParallelSignalCursor<T> getSignalCursor(boolean forward) {
        return new ParallelSignalCursor(this.getNumberOfLocations(), i -> this.getSignalAtLocation(i).getIterator(forward));
    }

    public double start() {
        double start = Double.NEGATIVE_INFINITY;
        for (Signal signal : this.getSignals()) {
            start = Math.max(start, signal.getStart());
        }
        return start;
    }

    public double end() {
        double end = Double.POSITIVE_INFINITY;
        for (Signal signal : this.getSignals()) {
            end = Math.min(end, signal.getEnd());
        }
        return end;
    }

    public double[][][] toArray(ToDoubleFunction<T> f) {
        int locs = this.getNumberOfLocations();
        double[] timePoints = this.getTimeArray();
        double[][][] toReturn = new double[locs][][];
        IntStream.range(0, locs).forEach(i -> {
            toReturn[i] = this.getSignalAtLocation(i).arrayOf(timePoints, f);
        });
        return toReturn;
    }

    public double[] getTimeArray() {
        HashSet timeSet = new HashSet();
        this.getSignals().forEach(s -> timeSet.addAll(s.getTimeSet()));
        return timeSet.stream().sorted().distinct().mapToDouble(d -> d).toArray();
    }

    public <R> void fill(double[] timePoints, R[][] data, Function<T, R> f) {
        for (int i = 0; i < this.getNumberOfLocations(); ++i) {
            this.getSignalAtLocation(i).fill(timePoints, data[i], f);
        }
    }
}

