# Sunday

**Sunday** 是一款基于插件驱动的开发工具包, 旨降低程序员工具开发的复杂度, 目标向集环境、代理、工具等全面的开发框架.

```python
>>> from sunday.core import Logger
>>> logger = Logger('sunday').getLogger()
>>> logger.info('haha')
[17:45:01.770] INFO   : <sunday> haha
```

## 安装

**sunday**基于python3开发

### pip安装

`python3 -m pip install pysunday`

### 源码安装

```console
python setup.py install
```

sunday安装成功后默认的根目录在`~/.sunday`, 可修改根目录路径

设置根目录: export SUNDAY_ROOT=/path/to

配置PATH: export PATH=$SUNDAY_ROOT/bin:$PATH

## Docker安装

1. 当前目录运行构建image: `docker build -t sunday ./`
2. 以守护进程方式运行启动: `docker run -d --restart always --name sunday -p 5000:5000 -v $HOME/.ssh:/root/.ssh sunday /bin/bash -c 'while true; do echo sunday runing; sleep 10;done'`
3. 执行sunday命令, 如: `docker exec sunday sunday_install ssh://git@code.paic.com.cn:8009/yqb-travelpluginh5/car_board.git#tools-badao`、`docker exec sunday worktime -h`
4. 使用alias设置便捷命令: `echo "alias sunday='docker exec -it sunday'" >> ~/.bashrc; source ~/.bashrc`

## sunday支持及未来支持

- 其它linux系便捷命令
- 敏捷工具开发核心库
- 日志系统集成
- 持久化登录态
- 内部工具插件
- 开发环境一键配置
- 开发代理工具
- 自动化测试工具
- ...

## 基础函数

基础函数分为核心基础函数和工具函数

### Logger

日志函数

```python
from sunday.core import Logger
logger = Logger('sunday').getLogger()
logger.info('log info')
```

日志等级: debug error info log warning

### cmdexec

用于执行shell命令, 传入命令及超时时间, 返回code、成功输出、失败输出, 其中code为0表示执行成功否则执行命令失败

```python
from sunday.core import cmdexec
code, stdout, stderr = cmdexec('ls', 10000)
```

## 插件开发

插件主要指工具插件, 其它配套支持登录插件.

如A开发了一个网站的登录插件, 此后B和C可基于该登录插件开发工具插件

插件必须包含package.json的描述文件, 该文件配置如下:

1. name: 工具名称
2. type: login(登录)/tools(工具)
3. depend: 程序依赖，依赖包git地址的集合
4. keywords: 关键词
5. author: 作者

## 公共配置文件

新建文件`$SUNDAY_ROOT/config.ini`

配置格式如下:

```ini
# config.ini
[NAME1]
key1 = value
key2 = value

[NAME2]
key1 = value
key2 = value
```

### LOGGING

控制日志输出

#### key: level

控制程序日志输出级别, 默认级别为ERROR, 及只输出报错日志

### key: format

日志输出格式控制, 本人使用格式: `format = %%(blue)s[%%(asctime)s.%%(msecs)-3d] %%(log_color)s%%(levelname)-7s: %%(purple)s<%%(name)s> %%(log_color)s%%(message)s`

### PROXY

代理配置, 未设置时, 程序中的请求根据网络配置走系统的pac代理文件, 否则当设置了值后程序中的网络请求不走pac仅走配置的代理

#### key: proxy

配置程序中的请求是否走代理, 代理配置格式如`proxy = 127.0.0.1:8888`

## 发布

打包: `python setup.py sdist build`

查看: `tar --list -f dist/filename.tar.gz`

发布: `twine upload dist/*`

更新: `pip install --upgrade sunday`

## 命令

### sunday_install

用于安装sunday插件

```console
usage: sunday_install [-v] [-h] [--giturl GIT_URL_BASE] MODULE_URLS) [MODULE_URL(S ...]

安装sunday模块

Positionals:
  MODULE_URL(S)          安装模块的本地模块路径或者git地址, 支持传多个, 可混搭git仓库, 分支请用#字符拼接

Optional:
  -v, --version          当前程序版本
  -h, --help             打印帮助说明
  --giturl GIT_URL_BASE  git元地址, 当存在该地址时则最终地址为giturl+module

使用案例:
    sunday_install https://website.com/sunday/name1.git https://website.com/sunday/name2.git
    sunday_install --giturl https://website.com sunday/name1.git https://website.com/sunday/name2.git sunday/name3.git https://website.com/sunday/name4.git
    sunday_install /path/to/package
```

## 插件收录

1. (common)[https://github.com/zhenxianluo/command-pysunday]: 提供好用的命令行命令, 安装: `sunday_install https://github.com/zhenxianluo/command-pysunday.git#main`

## 插件功能

命令名 | 来自插件 | 功能 | 是否需要登录
------ | -------- | ---- | ------------
`sd_getip` | common | 查看本机ip | 否
`sd_getport` | common | 查看端口的占用情况 | 否
`sd_chrome` | common | 命令行启动chrome | 否
`sd_grepn` | common | 带行号的命令行搜索，过滤模块包目录、打包目录等 | 否
