[![yotron](https://www.yotron.de/img/logo-yotron.png)](https://www.yotron.de)

# Kuberentes-Ready RAD (K(SRAD))
Rapid Application Development is a software development principle to use pre-given frequently needed components of an software application to accelerate the software development
process massively.
These components are for example functions for user authentication and authorization, user management (self-registration of a user, deactivating an account)
but also application designs. With the usage of pre-given component a lot of development tasks are omitted which rapidly accelerates the software development.

YOTRON put this development principles one step ahead and uses a **Kubernetes-ready Rapid Application Development** framework.
The Kubernetes deployment is integrated part of the software development, means the software we provide for you is Kubernetes-Ready out-of-the-box.

This is the default application, which is the starting point of the Rapid Application Development. Please see the [description](https://www.yotron.de/blog/k8srad/).

## URLs
The project contains code, build packages, container ... . Below an overview:

| Type                  | Provider                        | URL                                                            |
|-----------------------|---------------------------------|----------------------------------------------------------------|
| Kuberentes-Ready RAD  | yotron.de                       | https://www.yotron.de/blog/kuberentesreadyrad/                 |
| Container             | hub.docker.com                  | https://hub.docker.com/r/yotronpublic/k8srad                   | 
| Python Package (PyPi) | pypi.org                        | https://pypi.org/project/k8srad/                               |  
| HELM package          | artifacthub.io / helm.yotron.de | https://artifacthub.io/packages/helm/yotron-helm-charts/k8srad |

## Installation
We provide two installation methods. A native installation on any OS which supports Python3 and a installation in Kubernetes via HELM.
Per default, K8SRAD runs on a sqlite database. Sqlite is recommended only for testing and on a standalone installation.

In production, you should use a PostgreSQL database for a better data persistency and to allow a HA setup with more K8SRAD nodes.

The K8SRAD has no TLS-termination ("https"). We recommend to use a Reverse Proxy like NGINX or Apache Web Server in front of K8SRAD Web App for TLS termination.

The HELM project of K8SRAD for Kubernetes contains all needed and recommended components. You can optionally install a NGINX Reverse Proxy and a PostgreSQL database with the project,
but you can also use separated applications.

### Native
#### Prerequisites
- [Python3](https://www.python.org/)
- [Python-pip](https://pip.pypa.io) for dependency installation
- OpenLDAP for LDAP authentication
- SSL for secured LDAP authentication
- recommended: python3-venv to create a virtual environment for Python3
- recommended: [PostgreSQL](https://www.postgresql.org/) database for the K8SRAD metadata
- recommended: A reverse proxy with TLS termination (e.g. NGINX).

#### Prerequisites Python and pip
K8SRAD supports all current Python3 versions. It is tested with Python 3.9.x and 3.10.x

To check which Python version is running:
```
vagrant@bullseye:~$ python3 -V
Python 3.9.2
``` 
To check which Pip version is running:
``` 
vagrant@bullseye:~$ pip3 -V
pip 20.3.4 from /home/vagrant/k8srad/lib/python3.9/site-packages/pip (python 3.9)
``` 

It is possible, that in your distribution Python must be called with `python` and `pip`.

If you need a Python installation from the scratch. Python3, Pip3 and python3-venv are available in the main OS distribution.

For Debian/Ubuntu:
`sudo apt-get install python3 python3-pip python3-venv`

For RedHat/CentOS:
`sudo yum install python3 python3-pip python3-venv`

#### Prerequisites OpenLDAP and SSL
For authentication packages for authentication like OpenLDAP and SSL are needed  
For Debian/Ubuntu:
`sudo apt-get install libsasl2-dev python-dev libldap2-dev libssl-dev`

For RedHat/CentOS:
`sudo yum install python-devel openldap-devel`

#### Installation
There are a lot of variants how to start a Python web project. We use a Python virtual environment for setting up K8SRAD on a virtual environment. 
Depend on your environment and knowledge in Python the process can be different.

1. Create a virtual environment of Python
 
   1. Create a virtual environment for K8SRAD
   
      ```
      vagrant@bullseye:~$ python3 -m venv venv
      ```

   2. Activate your virtual environment

      This steps is to repeat every time you want to restart K8SRAD.
   
      ```
      vagrant@bullseye:~$ source venv/bin/activate
      (venv) vagrant@bullseye:~$
      ```

3. Install all Python dependencies needed for the project:

   ```   
   (k8srad) vagrant@bullseye:~$ pip install k8srad --upgrade
   ```

4. Start K8SRAD server
   ```   
   (k8srad) vagrant@bullseye:~$ k8srad-run --host=0.0.0.0 --port=8080
   2022-10-06 15:21:07,382:INFO:flask_appbuilder.base:Registering class View on menu 
   ...
   2022-10-10 11:18:22,385:INFO:flask_appbuilder.baseviews:Registering route / ('GET',)
   2022-10-10 11:18:22,424:INFO:waitress:Serving on http://0.0.0.0:8080
   ```

4. Open Browser and start K8SRAD with one of the IPs mentioned above:

   ![Login Site of K8SRAD](https://www.yotron.de/k8srad/login.png)

   Your will automatically redirected to http://x.x.x.x:8080/login

5. Login as a admin user
   
   The default credentials for the admin user are:
 
   **Username**: admin

   **Password**: admin

   ![Dashboard of K8SRAD](https://www.yotron.de/k8srad/dashboard_item_empty.png)

   Please see the [manual](https://www.yotron.de/k8srad/) to allow access to buckets.


### HELM
You find the installation instructions for Kubernetes [here](https://artifacthub.io/packages/helm/yotron-helm-charts/k8srad)

## Manual
The manual for K8SRAD you find [here](https://www.yotron.de/blog/k8srad/)

## Configuration
### The dotenv file and `K8SRAD_CONF_FILE` variable
You can customize K8SRAD with a setting defined in a dotenv file. The dotenv file can be chosen freely and you can put the file in a folder of your choice but 
the file must be reachable by the K8SRAD App. 

Additionally, you need a environment variable `K8SRAD_CONF_FILE` with the path to your config file.

For example, for Linux you can set the environment variable with:
```
export K8SRAD_CONF_FILE=/etc/k8srad/.k8srad
```
with `.k8srad` as the dotenv file name.

The file contains setting to the following topics:
- customization of your K8SRAD
- Authentication

### The parameter of the config file
#### Kubernetes RAD

| name                   | example                              | description                                                                                                            | possible values                    | default |
|------------------------|--------------------------------------|------------------------------------------------------------------------------------------------------------------------|------------------------------------|---------|
| K8SRAD_APP_NAME        | My Fancy Kuberrentes App             | The name of your K8SRAD. It is display in the head of your application.                                                |                                    |         |
| K8SRAD_APP_ICON        | https://myserver.com/my_own_logo.svg | The icon of your K8SRAD as a html link. It is display in the head of your application.                                 |                                    |         |
| K8SRAD_LOG_LEVEL       | info                                 | LogLevel for the Logging.                                                                                              | fatal, error, warning, info, debug | info    |
| K8SRAD_LOG_FILE        | /var/log/k8srad.log                  | When set logs are written to the mentioned file. If not set it is written to console (stdout).                         |                                    | not set |
| K8SRAD_DB_TYPE         | postgresql                           | Type of database to use. Can be a SQLite or a PostgreSQL Database                                                      | sqlite, postgres                   | sqlite  |
| K8SRAD_PG_DB_HOST      | k8s-1.mydatabse.com                  | Only if db-type postgres: Host name of the PostresSQL server.                                                          |                                    |         |
| K8SRAD_PG_DB_PORT      | 5432                                 | Only if db-type postgres: Port number of the PostresSQL server.                                                        |                                    | 5432    |
| K8SRAD_PG_DB_NAME      | k8srad                               | Only if db-type postgres: Name of the PostgreSQL Database.                                                             |                                    |         |
| K8SRAD_PG_DB_USER_NAME | k8srad                               | Only if db-type postgres: Username to authenticate against the PostgreSQL Database                                     |                                    |         |                      
| K8SRAD_PG_DB_USER_PW   | k8srad                               | Only if db-type postgres: Password to authenticate against the PostgreSQL Database                                     |                                    |         |
| K8SRAD_SECRET_KEY      | thisIsMyHiddenSecretKey              | A key which used to sign session cookies for protection against cookie data tampering. In production please change it. |                                    |         |

#### Authentication general

| name                        | example  | description                                                                                                                             | possible values | default   |
|-----------------------------|----------|-----------------------------------------------------------------------------------------------------------------------------------------|-----------------|-----------|
| K8SRAD_AUTH_TYPE            | database | Parameter to define the authentication method. It can be an authentication via LDAP or via the default database with name and password. | ldap, database  | database  |
| AUTH_USER_REGISTRATION      |          | Parameter to define if a user can self registrate to K8SRAD. With LDAP it must be set to True.                                          | True, False     | False     |
| AUTH_USER_REGISTRATION_ROLE |          | Default role a user, when registered or authenticated via LDAP firstly.                                                                 | Public, Admin   | Public    |
| AUTH_ROLES_MAPPING          |          | Mapping a LDAP group onto a K8SRAD role `Admin` and `Public`.                                                                           |                 |           |
| K8SRAD_SESSION_LIFETIME     | 1800     | Seconds of inactivity after which a user must re-login.                                                                                 |                 | 600       |

Example of a role mapping
```
AUTH_ROLES_MAPPING = {
    "cn=k8suser,ou=groups,dc=example,dc=com": ["Public"],
    "cn=k8sradadmins,ou=groups,dc=example,dc=com": ["Admin"],
}
```

#### Authentication LDAP
To allow authentication with LDAP, a LDAP group must be mapped onto one the K8SRAD Role `Public` or `Admin` .

| name                      | example                                         | description                                                                                               | possible values | default |
|---------------------------|-------------------------------------------------|-----------------------------------------------------------------------------------------------------------|-----------------|---------|
| AUTH_LDAP_SERVER          | ldap://ldap.example.com                         | The URL of the LDAP server.                                                                               |                 |         |
| AUTH_LDAP_USE_TLS         | False                                           | If the LDAP server allows TLS secured communication set to True.                                          | True, False     |         |
| AUTH_LDAP_FIRSTNAME_FIELD | givenName                                       | Name of the field of the person LDAP entity with the given name.                                          |                 |         |
| AUTH_LDAP_LASTNAME_FIELD  | sn                                              | Name of the field of the person LDAP entity with the last name.                                           |                 |         |
| AUTH_LDAP_EMAIL_FIELD     | email                                           | Name of the field of the person LDAP entity with the email address.                                       |                 |         |
| AUTH_LDAP_USERNAME_FORMAT | uid=%s,ou=users,dc=example,dc=com               | Distinguished name of the user to authenticate. `%s` will be replaced by the username of the K8SRAD login. |                 |         |
| AUTH_LDAP_APPEND_DOMAIN   | example.com                                     | When a username always has a domain appendix.                                                             |                 |         |
| AUTH_LDAP_SEARCH          | ou=users,dc=example,dc=com                      | LDAP search string if a user is part of an organizational unit.                                           |                 |         |
| AUTH_LDAP_UID_FIELD       | uid                                             | When using a LDAP search the filed name with the username of the organizational unit.                     |                 |         |
| AUTH_LDAP_BIND_USER       | ldapadmin                                       | The bind user used for authentication against LDAP.                                                       |                 |         |
| AUTH_LDAP_BIND_PASSWORD   | myHiddenPassword                                | The password of the bin user sed for authentication against LDAP.                                         |                 |         |
| AUTH_LDAP_SEARCH_FILTER   | (memberOf=cn=myTeam,ou=teams,dc=example,dc=com) | Filter the user which are allowed to access K8SRAD generally.                                              |                 |         |
| AUTH_LDAP_GROUP_FIELD     | memberOf                                        | When using AUTH_ROLES_MAPPING the name of the field with the role DN.                                     |                 |         |

You find further information about how to configure LDAP against Microsoft AD or OpenLDAP [here](https://flask-appbuilder.readthedocs.io/en/latest/security.html#authentication-ldap).

## The start parameter
To start of the K8SRAD server simply call `k8srad-run` as shown above. You have has the following parameter:

| name     | short        | example   | description                            | default   |
|----------|--------------|-----------|----------------------------------------|-----------|
| HOST     | -s, --host   | 127.0.0.1 | Listener Host IP. 0.0.0.0 for all IPs. | 0.0.0.0   |
| PORT     | -P, --port   | 8090      | Listener Host Port                     | 8080      |
| THREADS  | -t --threads | 1         | Threads for parallelization            | 4         |

With `k8srad-run -h` you get the possible configuration: 

```
(k8srad) vagrant@bullseye:~$ k8srad-run -h
...
usage: k8srad-run [-h] [-s HOST] [-p PORT] [-t THREADS]
Start parameter for the K8SRAD web server.
optional arguments:
-h, --help            show this help message and exit
-s HOST, --host HOST  Listener Host IP. Default: 0.0.0.0
-p PORT, --port PORT  Listener Host Port. Default: 8080.
-t THREADS, --threads THREADS  Threads for parallelization. Default: 4.
```
   