# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetAccessPointResult',
    'AwaitableGetAccessPointResult',
    'get_access_point',
    'get_access_point_output',
]

@pulumi.output_type
class GetAccessPointResult:
    def __init__(__self__, alias=None, arn=None, network_origin=None, policy=None, policy_status=None):
        if alias and not isinstance(alias, str):
            raise TypeError("Expected argument 'alias' to be a str")
        pulumi.set(__self__, "alias", alias)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if network_origin and not isinstance(network_origin, str):
            raise TypeError("Expected argument 'network_origin' to be a str")
        pulumi.set(__self__, "network_origin", network_origin)
        if policy and not isinstance(policy, dict):
            raise TypeError("Expected argument 'policy' to be a dict")
        pulumi.set(__self__, "policy", policy)
        if policy_status and not isinstance(policy_status, dict):
            raise TypeError("Expected argument 'policy_status' to be a dict")
        pulumi.set(__self__, "policy_status", policy_status)

    @property
    @pulumi.getter
    def alias(self) -> Optional[str]:
        """
        The alias of this Access Point. This alias can be used for compatibility purposes with other AWS services and third-party applications.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the specified accesspoint.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="networkOrigin")
    def network_origin(self) -> Optional['AccessPointNetworkOrigin']:
        """
        Indicates whether this Access Point allows access from the public Internet. If VpcConfiguration is specified for this Access Point, then NetworkOrigin is VPC, and the Access Point doesn't allow access from the public Internet. Otherwise, NetworkOrigin is Internet, and the Access Point allows access from the public Internet, subject to the Access Point and bucket access policies.
        """
        return pulumi.get(self, "network_origin")

    @property
    @pulumi.getter
    def policy(self) -> Optional[Any]:
        """
        The Access Point Policy you want to apply to this access point.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="policyStatus")
    def policy_status(self) -> Optional['outputs.PolicyStatusProperties']:
        return pulumi.get(self, "policy_status")


class AwaitableGetAccessPointResult(GetAccessPointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccessPointResult(
            alias=self.alias,
            arn=self.arn,
            network_origin=self.network_origin,
            policy=self.policy,
            policy_status=self.policy_status)


def get_access_point(name: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccessPointResult:
    """
    The AWS::S3::AccessPoint resource is an Amazon S3 resource type that you can use to access buckets.


    :param str name: The name you want to assign to this Access Point. If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID for the access point name.
    """
    __args__ = dict()
    __args__['name'] = name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:s3:getAccessPoint', __args__, opts=opts, typ=GetAccessPointResult).value

    return AwaitableGetAccessPointResult(
        alias=__ret__.alias,
        arn=__ret__.arn,
        network_origin=__ret__.network_origin,
        policy=__ret__.policy,
        policy_status=__ret__.policy_status)


@_utilities.lift_output_func(get_access_point)
def get_access_point_output(name: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAccessPointResult]:
    """
    The AWS::S3::AccessPoint resource is an Amazon S3 resource type that you can use to access buckets.


    :param str name: The name you want to assign to this Access Point. If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID for the access point name.
    """
    ...
