# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetSegmentResult',
    'AwaitableGetSegmentResult',
    'get_segment',
    'get_segment_output',
]

@pulumi.output_type
class GetSegmentResult:
    def __init__(__self__, arn=None, dimensions=None, name=None, segment_groups=None, segment_id=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if dimensions and not isinstance(dimensions, dict):
            raise TypeError("Expected argument 'dimensions' to be a dict")
        pulumi.set(__self__, "dimensions", dimensions)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if segment_groups and not isinstance(segment_groups, dict):
            raise TypeError("Expected argument 'segment_groups' to be a dict")
        pulumi.set(__self__, "segment_groups", segment_groups)
        if segment_id and not isinstance(segment_id, str):
            raise TypeError("Expected argument 'segment_id' to be a str")
        pulumi.set(__self__, "segment_id", segment_id)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def dimensions(self) -> Optional['outputs.SegmentDimensions']:
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="segmentGroups")
    def segment_groups(self) -> Optional['outputs.SegmentGroups']:
        return pulumi.get(self, "segment_groups")

    @property
    @pulumi.getter(name="segmentId")
    def segment_id(self) -> Optional[str]:
        return pulumi.get(self, "segment_id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Any]:
        return pulumi.get(self, "tags")


class AwaitableGetSegmentResult(GetSegmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSegmentResult(
            arn=self.arn,
            dimensions=self.dimensions,
            name=self.name,
            segment_groups=self.segment_groups,
            segment_id=self.segment_id,
            tags=self.tags)


def get_segment(segment_id: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSegmentResult:
    """
    Resource Type definition for AWS::Pinpoint::Segment
    """
    __args__ = dict()
    __args__['segmentId'] = segment_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:pinpoint:getSegment', __args__, opts=opts, typ=GetSegmentResult).value

    return AwaitableGetSegmentResult(
        arn=__ret__.arn,
        dimensions=__ret__.dimensions,
        name=__ret__.name,
        segment_groups=__ret__.segment_groups,
        segment_id=__ret__.segment_id,
        tags=__ret__.tags)


@_utilities.lift_output_func(get_segment)
def get_segment_output(segment_id: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSegmentResult]:
    """
    Resource Type definition for AWS::Pinpoint::Segment
    """
    ...
