# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VPNGatewayArgs', 'VPNGateway']

@pulumi.input_type
class VPNGatewayArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 amazon_side_asn: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['VPNGatewayTagArgs']]]] = None):
        """
        The set of arguments for constructing a VPNGateway resource.
        :param pulumi.Input[str] type: The type of VPN connection the virtual private gateway supports.
        :param pulumi.Input[int] amazon_side_asn: The private Autonomous System Number (ASN) for the Amazon side of a BGP session.
        :param pulumi.Input[Sequence[pulumi.Input['VPNGatewayTagArgs']]] tags: Any tags assigned to the virtual private gateway.
        """
        pulumi.set(__self__, "type", type)
        if amazon_side_asn is not None:
            pulumi.set(__self__, "amazon_side_asn", amazon_side_asn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of VPN connection the virtual private gateway supports.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="amazonSideAsn")
    def amazon_side_asn(self) -> Optional[pulumi.Input[int]]:
        """
        The private Autonomous System Number (ASN) for the Amazon side of a BGP session.
        """
        return pulumi.get(self, "amazon_side_asn")

    @amazon_side_asn.setter
    def amazon_side_asn(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "amazon_side_asn", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VPNGatewayTagArgs']]]]:
        """
        Any tags assigned to the virtual private gateway.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VPNGatewayTagArgs']]]]):
        pulumi.set(self, "tags", value)


class VPNGateway(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 amazon_side_asn: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPNGatewayTagArgs']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Schema for EC2 VPN Gateway

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] amazon_side_asn: The private Autonomous System Number (ASN) for the Amazon side of a BGP session.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPNGatewayTagArgs']]]] tags: Any tags assigned to the virtual private gateway.
        :param pulumi.Input[str] type: The type of VPN connection the virtual private gateway supports.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VPNGatewayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Schema for EC2 VPN Gateway

        :param str resource_name: The name of the resource.
        :param VPNGatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VPNGatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 amazon_side_asn: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['VPNGatewayTagArgs']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VPNGatewayArgs.__new__(VPNGatewayArgs)

            __props__.__dict__["amazon_side_asn"] = amazon_side_asn
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["v_pn_gateway_id"] = None
        super(VPNGateway, __self__).__init__(
            'aws-native:ec2:VPNGateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'VPNGateway':
        """
        Get an existing VPNGateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = VPNGatewayArgs.__new__(VPNGatewayArgs)

        __props__.__dict__["amazon_side_asn"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        __props__.__dict__["v_pn_gateway_id"] = None
        return VPNGateway(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="amazonSideAsn")
    def amazon_side_asn(self) -> pulumi.Output[Optional[int]]:
        """
        The private Autonomous System Number (ASN) for the Amazon side of a BGP session.
        """
        return pulumi.get(self, "amazon_side_asn")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.VPNGatewayTag']]]:
        """
        Any tags assigned to the virtual private gateway.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of VPN connection the virtual private gateway supports.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vPNGatewayId")
    def v_pn_gateway_id(self) -> pulumi.Output[str]:
        """
        VPN Gateway ID generated by service
        """
        return pulumi.get(self, "v_pn_gateway_id")

