# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LocalGatewayRouteTableVPCAssociationArgs', 'LocalGatewayRouteTableVPCAssociation']

@pulumi.input_type
class LocalGatewayRouteTableVPCAssociationArgs:
    def __init__(__self__, *,
                 local_gateway_route_table_id: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['LocalGatewayRouteTableVPCAssociationTagArgs']]]] = None):
        """
        The set of arguments for constructing a LocalGatewayRouteTableVPCAssociation resource.
        :param pulumi.Input[str] local_gateway_route_table_id: The ID of the local gateway route table.
        :param pulumi.Input[str] vpc_id: The ID of the VPC.
        :param pulumi.Input[Sequence[pulumi.Input['LocalGatewayRouteTableVPCAssociationTagArgs']]] tags: The tags for the association.
        """
        pulumi.set(__self__, "local_gateway_route_table_id", local_gateway_route_table_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="localGatewayRouteTableId")
    def local_gateway_route_table_id(self) -> pulumi.Input[str]:
        """
        The ID of the local gateway route table.
        """
        return pulumi.get(self, "local_gateway_route_table_id")

    @local_gateway_route_table_id.setter
    def local_gateway_route_table_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "local_gateway_route_table_id", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LocalGatewayRouteTableVPCAssociationTagArgs']]]]:
        """
        The tags for the association.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LocalGatewayRouteTableVPCAssociationTagArgs']]]]):
        pulumi.set(self, "tags", value)


class LocalGatewayRouteTableVPCAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 local_gateway_route_table_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LocalGatewayRouteTableVPCAssociationTagArgs']]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Describes an association between a local gateway route table and a VPC.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] local_gateway_route_table_id: The ID of the local gateway route table.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LocalGatewayRouteTableVPCAssociationTagArgs']]]] tags: The tags for the association.
        :param pulumi.Input[str] vpc_id: The ID of the VPC.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LocalGatewayRouteTableVPCAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Describes an association between a local gateway route table and a VPC.

        :param str resource_name: The name of the resource.
        :param LocalGatewayRouteTableVPCAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LocalGatewayRouteTableVPCAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 local_gateway_route_table_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LocalGatewayRouteTableVPCAssociationTagArgs']]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LocalGatewayRouteTableVPCAssociationArgs.__new__(LocalGatewayRouteTableVPCAssociationArgs)

            if local_gateway_route_table_id is None and not opts.urn:
                raise TypeError("Missing required property 'local_gateway_route_table_id'")
            __props__.__dict__["local_gateway_route_table_id"] = local_gateway_route_table_id
            __props__.__dict__["tags"] = tags
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["local_gateway_id"] = None
            __props__.__dict__["local_gateway_route_table_vpc_association_id"] = None
            __props__.__dict__["state"] = None
        super(LocalGatewayRouteTableVPCAssociation, __self__).__init__(
            'aws-native:ec2:LocalGatewayRouteTableVPCAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'LocalGatewayRouteTableVPCAssociation':
        """
        Get an existing LocalGatewayRouteTableVPCAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = LocalGatewayRouteTableVPCAssociationArgs.__new__(LocalGatewayRouteTableVPCAssociationArgs)

        __props__.__dict__["local_gateway_id"] = None
        __props__.__dict__["local_gateway_route_table_id"] = None
        __props__.__dict__["local_gateway_route_table_vpc_association_id"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["vpc_id"] = None
        return LocalGatewayRouteTableVPCAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="localGatewayId")
    def local_gateway_id(self) -> pulumi.Output[str]:
        """
        The ID of the local gateway.
        """
        return pulumi.get(self, "local_gateway_id")

    @property
    @pulumi.getter(name="localGatewayRouteTableId")
    def local_gateway_route_table_id(self) -> pulumi.Output[str]:
        """
        The ID of the local gateway route table.
        """
        return pulumi.get(self, "local_gateway_route_table_id")

    @property
    @pulumi.getter(name="localGatewayRouteTableVpcAssociationId")
    def local_gateway_route_table_vpc_association_id(self) -> pulumi.Output[str]:
        """
        The ID of the association.
        """
        return pulumi.get(self, "local_gateway_route_table_vpc_association_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The state of the association.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.LocalGatewayRouteTableVPCAssociationTag']]]:
        """
        The tags for the association.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

