# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetGatewayRouteTableAssociationResult',
    'AwaitableGetGatewayRouteTableAssociationResult',
    'get_gateway_route_table_association',
    'get_gateway_route_table_association_output',
]

@pulumi.output_type
class GetGatewayRouteTableAssociationResult:
    def __init__(__self__, association_id=None, route_table_id=None):
        if association_id and not isinstance(association_id, str):
            raise TypeError("Expected argument 'association_id' to be a str")
        pulumi.set(__self__, "association_id", association_id)
        if route_table_id and not isinstance(route_table_id, str):
            raise TypeError("Expected argument 'route_table_id' to be a str")
        pulumi.set(__self__, "route_table_id", route_table_id)

    @property
    @pulumi.getter(name="associationId")
    def association_id(self) -> Optional[str]:
        """
        The route table association ID.
        """
        return pulumi.get(self, "association_id")

    @property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> Optional[str]:
        """
        The ID of the route table.
        """
        return pulumi.get(self, "route_table_id")


class AwaitableGetGatewayRouteTableAssociationResult(GetGatewayRouteTableAssociationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGatewayRouteTableAssociationResult(
            association_id=self.association_id,
            route_table_id=self.route_table_id)


def get_gateway_route_table_association(gateway_id: Optional[str] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGatewayRouteTableAssociationResult:
    """
    Associates a gateway with a route table. The gateway and route table must be in the same VPC. This association causes the incoming traffic to the gateway to be routed according to the routes in the route table.


    :param str gateway_id: The ID of the gateway.
    """
    __args__ = dict()
    __args__['gatewayId'] = gateway_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:ec2:getGatewayRouteTableAssociation', __args__, opts=opts, typ=GetGatewayRouteTableAssociationResult).value

    return AwaitableGetGatewayRouteTableAssociationResult(
        association_id=__ret__.association_id,
        route_table_id=__ret__.route_table_id)


@_utilities.lift_output_func(get_gateway_route_table_association)
def get_gateway_route_table_association_output(gateway_id: Optional[pulumi.Input[str]] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetGatewayRouteTableAssociationResult]:
    """
    Associates a gateway with a route table. The gateway and route table must be in the same VPC. This association causes the incoming traffic to the gateway to be routed according to the routes in the route table.


    :param str gateway_id: The ID of the gateway.
    """
    ...
