# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InsightRuleArgs', 'InsightRule']

@pulumi.input_type
class InsightRuleArgs:
    def __init__(__self__, *,
                 rule_body: pulumi.Input[str],
                 rule_name: pulumi.Input[str],
                 rule_state: pulumi.Input[str],
                 tags: Optional[pulumi.Input['InsightRuleTagsArgs']] = None):
        """
        The set of arguments for constructing a InsightRule resource.
        """
        pulumi.set(__self__, "rule_body", rule_body)
        pulumi.set(__self__, "rule_name", rule_name)
        pulumi.set(__self__, "rule_state", rule_state)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="ruleBody")
    def rule_body(self) -> pulumi.Input[str]:
        return pulumi.get(self, "rule_body")

    @rule_body.setter
    def rule_body(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_body", value)

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_name", value)

    @property
    @pulumi.getter(name="ruleState")
    def rule_state(self) -> pulumi.Input[str]:
        return pulumi.get(self, "rule_state")

    @rule_state.setter
    def rule_state(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_state", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input['InsightRuleTagsArgs']]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input['InsightRuleTagsArgs']]):
        pulumi.set(self, "tags", value)


warnings.warn("""InsightRule is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""", DeprecationWarning)


class InsightRule(pulumi.CustomResource):
    warnings.warn("""InsightRule is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 rule_body: Optional[pulumi.Input[str]] = None,
                 rule_name: Optional[pulumi.Input[str]] = None,
                 rule_state: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[pulumi.InputType['InsightRuleTagsArgs']]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::CloudWatch::InsightRule

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InsightRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::CloudWatch::InsightRule

        :param str resource_name: The name of the resource.
        :param InsightRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InsightRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 rule_body: Optional[pulumi.Input[str]] = None,
                 rule_name: Optional[pulumi.Input[str]] = None,
                 rule_state: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[pulumi.InputType['InsightRuleTagsArgs']]] = None,
                 __props__=None):
        pulumi.log.warn("""InsightRule is deprecated: InsightRule is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""")
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InsightRuleArgs.__new__(InsightRuleArgs)

            if rule_body is None and not opts.urn:
                raise TypeError("Missing required property 'rule_body'")
            __props__.__dict__["rule_body"] = rule_body
            if rule_name is None and not opts.urn:
                raise TypeError("Missing required property 'rule_name'")
            __props__.__dict__["rule_name"] = rule_name
            if rule_state is None and not opts.urn:
                raise TypeError("Missing required property 'rule_state'")
            __props__.__dict__["rule_state"] = rule_state
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
        super(InsightRule, __self__).__init__(
            'aws-native:cloudwatch:InsightRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'InsightRule':
        """
        Get an existing InsightRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = InsightRuleArgs.__new__(InsightRuleArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["rule_body"] = None
        __props__.__dict__["rule_name"] = None
        __props__.__dict__["rule_state"] = None
        __props__.__dict__["tags"] = None
        return InsightRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="ruleBody")
    def rule_body(self) -> pulumi.Output[str]:
        return pulumi.get(self, "rule_body")

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "rule_name")

    @property
    @pulumi.getter(name="ruleState")
    def rule_state(self) -> pulumi.Output[str]:
        return pulumi.get(self, "rule_state")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional['outputs.InsightRuleTags']]:
        return pulumi.get(self, "tags")

