# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetAuthorizerResult',
    'AwaitableGetAuthorizerResult',
    'get_authorizer',
    'get_authorizer_output',
]

@pulumi.output_type
class GetAuthorizerResult:
    def __init__(__self__, auth_type=None, authorizer_credentials=None, authorizer_id=None, authorizer_result_ttl_in_seconds=None, authorizer_uri=None, identity_source=None, identity_validation_expression=None, name=None, provider_arns=None, type=None):
        if auth_type and not isinstance(auth_type, str):
            raise TypeError("Expected argument 'auth_type' to be a str")
        pulumi.set(__self__, "auth_type", auth_type)
        if authorizer_credentials and not isinstance(authorizer_credentials, str):
            raise TypeError("Expected argument 'authorizer_credentials' to be a str")
        pulumi.set(__self__, "authorizer_credentials", authorizer_credentials)
        if authorizer_id and not isinstance(authorizer_id, str):
            raise TypeError("Expected argument 'authorizer_id' to be a str")
        pulumi.set(__self__, "authorizer_id", authorizer_id)
        if authorizer_result_ttl_in_seconds and not isinstance(authorizer_result_ttl_in_seconds, int):
            raise TypeError("Expected argument 'authorizer_result_ttl_in_seconds' to be a int")
        pulumi.set(__self__, "authorizer_result_ttl_in_seconds", authorizer_result_ttl_in_seconds)
        if authorizer_uri and not isinstance(authorizer_uri, str):
            raise TypeError("Expected argument 'authorizer_uri' to be a str")
        pulumi.set(__self__, "authorizer_uri", authorizer_uri)
        if identity_source and not isinstance(identity_source, str):
            raise TypeError("Expected argument 'identity_source' to be a str")
        pulumi.set(__self__, "identity_source", identity_source)
        if identity_validation_expression and not isinstance(identity_validation_expression, str):
            raise TypeError("Expected argument 'identity_validation_expression' to be a str")
        pulumi.set(__self__, "identity_validation_expression", identity_validation_expression)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if provider_arns and not isinstance(provider_arns, list):
            raise TypeError("Expected argument 'provider_arns' to be a list")
        pulumi.set(__self__, "provider_arns", provider_arns)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[str]:
        """
        Optional customer-defined field, used in OpenAPI imports and exports without functional impact.
        """
        return pulumi.get(self, "auth_type")

    @property
    @pulumi.getter(name="authorizerCredentials")
    def authorizer_credentials(self) -> Optional[str]:
        """
        Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer.
        """
        return pulumi.get(self, "authorizer_credentials")

    @property
    @pulumi.getter(name="authorizerId")
    def authorizer_id(self) -> Optional[str]:
        return pulumi.get(self, "authorizer_id")

    @property
    @pulumi.getter(name="authorizerResultTtlInSeconds")
    def authorizer_result_ttl_in_seconds(self) -> Optional[int]:
        """
        The TTL in seconds of cached authorizer results.
        """
        return pulumi.get(self, "authorizer_result_ttl_in_seconds")

    @property
    @pulumi.getter(name="authorizerUri")
    def authorizer_uri(self) -> Optional[str]:
        """
        Specifies the authorizer's Uniform Resource Identifier (URI).
        """
        return pulumi.get(self, "authorizer_uri")

    @property
    @pulumi.getter(name="identitySource")
    def identity_source(self) -> Optional[str]:
        """
        The identity source for which authorization is requested.
        """
        return pulumi.get(self, "identity_source")

    @property
    @pulumi.getter(name="identityValidationExpression")
    def identity_validation_expression(self) -> Optional[str]:
        """
        A validation expression for the incoming identity token.
        """
        return pulumi.get(self, "identity_validation_expression")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the authorizer.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="providerARNs")
    def provider_arns(self) -> Optional[Sequence[str]]:
        """
        A list of the Amazon Cognito user pool ARNs for the COGNITO_USER_POOLS authorizer.
        """
        return pulumi.get(self, "provider_arns")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The authorizer type.
        """
        return pulumi.get(self, "type")


class AwaitableGetAuthorizerResult(GetAuthorizerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAuthorizerResult(
            auth_type=self.auth_type,
            authorizer_credentials=self.authorizer_credentials,
            authorizer_id=self.authorizer_id,
            authorizer_result_ttl_in_seconds=self.authorizer_result_ttl_in_seconds,
            authorizer_uri=self.authorizer_uri,
            identity_source=self.identity_source,
            identity_validation_expression=self.identity_validation_expression,
            name=self.name,
            provider_arns=self.provider_arns,
            type=self.type)


def get_authorizer(authorizer_id: Optional[str] = None,
                   rest_api_id: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAuthorizerResult:
    """
    Represents an authorization layer for methods. If enabled on a method, API Gateway will activate the authorizer when a client calls the method.


    :param str rest_api_id: The identifier of the API.
    """
    __args__ = dict()
    __args__['authorizerId'] = authorizer_id
    __args__['restApiId'] = rest_api_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:apigateway:getAuthorizer', __args__, opts=opts, typ=GetAuthorizerResult).value

    return AwaitableGetAuthorizerResult(
        auth_type=__ret__.auth_type,
        authorizer_credentials=__ret__.authorizer_credentials,
        authorizer_id=__ret__.authorizer_id,
        authorizer_result_ttl_in_seconds=__ret__.authorizer_result_ttl_in_seconds,
        authorizer_uri=__ret__.authorizer_uri,
        identity_source=__ret__.identity_source,
        identity_validation_expression=__ret__.identity_validation_expression,
        name=__ret__.name,
        provider_arns=__ret__.provider_arns,
        type=__ret__.type)


@_utilities.lift_output_func(get_authorizer)
def get_authorizer_output(authorizer_id: Optional[pulumi.Input[str]] = None,
                          rest_api_id: Optional[pulumi.Input[str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAuthorizerResult]:
    """
    Represents an authorization layer for methods. If enabled on a method, API Gateway will activate the authorizer when a client calls the method.


    :param str rest_api_id: The identifier of the API.
    """
    ...
