# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from ._enums import *

__all__ = [
    'ProviderAssumeRoleArgs',
    'ProviderDefaultTagsArgs',
    'ProviderEndpointArgs',
    'ProviderIgnoreTagsArgs',
]

@pulumi.input_type
class ProviderAssumeRoleArgs:
    def __init__(__self__, *,
                 duration_seconds: Optional[pulumi.Input[int]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 session_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 transitive_tag_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The configuration for a Provider to assume a role.
        :param pulumi.Input[int] duration_seconds: Number of seconds to restrict the assume role session duration.
        :param pulumi.Input[str] external_id: External identifier to use when assuming the role.
        :param pulumi.Input[str] policy: IAM Policy JSON describing further restricting permissions for the IAM Role being assumed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policy_arns: Set of Amazon Resource Names (ARNs) of IAM Policies describing further restricting permissions for the role.
        :param pulumi.Input[str] role_arn: Amazon Resource Name (ARN) of the IAM Role to assume.
        :param pulumi.Input[str] session_name: Session name to use when assuming the role.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Map of assume role session tags.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] transitive_tag_keys: A list of keys for session tags that you want to set as transitive. If you set a tag key as transitive, the corresponding key and value passes to subsequent sessions in a role chain.
        """
        if duration_seconds is not None:
            pulumi.set(__self__, "duration_seconds", duration_seconds)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if policy_arns is not None:
            pulumi.set(__self__, "policy_arns", policy_arns)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if session_name is not None:
            pulumi.set(__self__, "session_name", session_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transitive_tag_keys is not None:
            pulumi.set(__self__, "transitive_tag_keys", transitive_tag_keys)

    @property
    @pulumi.getter(name="durationSeconds")
    def duration_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Number of seconds to restrict the assume role session duration.
        """
        return pulumi.get(self, "duration_seconds")

    @duration_seconds.setter
    def duration_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "duration_seconds", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[str]]:
        """
        External identifier to use when assuming the role.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[str]]:
        """
        IAM Policy JSON describing further restricting permissions for the IAM Role being assumed.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter(name="policyArns")
    def policy_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of Amazon Resource Names (ARNs) of IAM Policies describing further restricting permissions for the role.
        """
        return pulumi.get(self, "policy_arns")

    @policy_arns.setter
    def policy_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "policy_arns", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) of the IAM Role to assume.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="sessionName")
    def session_name(self) -> Optional[pulumi.Input[str]]:
        """
        Session name to use when assuming the role.
        """
        return pulumi.get(self, "session_name")

    @session_name.setter
    def session_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "session_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of assume role session tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="transitiveTagKeys")
    def transitive_tag_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of keys for session tags that you want to set as transitive. If you set a tag key as transitive, the corresponding key and value passes to subsequent sessions in a role chain.
        """
        return pulumi.get(self, "transitive_tag_keys")

    @transitive_tag_keys.setter
    def transitive_tag_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "transitive_tag_keys", value)


@pulumi.input_type
class ProviderDefaultTagsArgs:
    def __init__(__self__, *,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The configuration with resource tag settings to apply across all resources handled by this provider. This is designed to replace redundant per-resource `tags` configurations. Provider tags can be overridden with new values, but not excluded from specific resources. To override provider tag values, use the `tags` argument within a resource to configure new tag values for matching keys.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A group of tags to set across all resources.
        """
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A group of tags to set across all resources.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class ProviderEndpointArgs:
    def __init__(__self__, *,
                 accessanalyzer: Optional[pulumi.Input[str]] = None,
                 acm: Optional[pulumi.Input[str]] = None,
                 acmpca: Optional[pulumi.Input[str]] = None,
                 amplify: Optional[pulumi.Input[str]] = None,
                 appconfig: Optional[pulumi.Input[str]] = None,
                 applicationautoscaling: Optional[pulumi.Input[str]] = None,
                 applicationinsights: Optional[pulumi.Input[str]] = None,
                 appmesh: Optional[pulumi.Input[str]] = None,
                 apprunner: Optional[pulumi.Input[str]] = None,
                 appstream: Optional[pulumi.Input[str]] = None,
                 appsync: Optional[pulumi.Input[str]] = None,
                 athena: Optional[pulumi.Input[str]] = None,
                 auditmanager: Optional[pulumi.Input[str]] = None,
                 autoscaling: Optional[pulumi.Input[str]] = None,
                 backup: Optional[pulumi.Input[str]] = None,
                 batch: Optional[pulumi.Input[str]] = None,
                 budgets: Optional[pulumi.Input[str]] = None,
                 chime: Optional[pulumi.Input[str]] = None,
                 cloud9: Optional[pulumi.Input[str]] = None,
                 cloudformation: Optional[pulumi.Input[str]] = None,
                 cloudfront: Optional[pulumi.Input[str]] = None,
                 cloudhsm: Optional[pulumi.Input[str]] = None,
                 cloudsearch: Optional[pulumi.Input[str]] = None,
                 cloudtrail: Optional[pulumi.Input[str]] = None,
                 cloudwatch: Optional[pulumi.Input[str]] = None,
                 cloudwatchevents: Optional[pulumi.Input[str]] = None,
                 cloudwatchlogs: Optional[pulumi.Input[str]] = None,
                 codeartifact: Optional[pulumi.Input[str]] = None,
                 codebuild: Optional[pulumi.Input[str]] = None,
                 codecommit: Optional[pulumi.Input[str]] = None,
                 codedeploy: Optional[pulumi.Input[str]] = None,
                 codepipeline: Optional[pulumi.Input[str]] = None,
                 codestarconnections: Optional[pulumi.Input[str]] = None,
                 cognitoidentity: Optional[pulumi.Input[str]] = None,
                 configservice: Optional[pulumi.Input[str]] = None,
                 connect: Optional[pulumi.Input[str]] = None,
                 cur: Optional[pulumi.Input[str]] = None,
                 dataexchange: Optional[pulumi.Input[str]] = None,
                 datapipeline: Optional[pulumi.Input[str]] = None,
                 datasync: Optional[pulumi.Input[str]] = None,
                 dax: Optional[pulumi.Input[str]] = None,
                 detective: Optional[pulumi.Input[str]] = None,
                 devicefarm: Optional[pulumi.Input[str]] = None,
                 directconnect: Optional[pulumi.Input[str]] = None,
                 dlm: Optional[pulumi.Input[str]] = None,
                 dms: Optional[pulumi.Input[str]] = None,
                 docdb: Optional[pulumi.Input[str]] = None,
                 ds: Optional[pulumi.Input[str]] = None,
                 dynamodb: Optional[pulumi.Input[str]] = None,
                 ec2: Optional[pulumi.Input[str]] = None,
                 ecr: Optional[pulumi.Input[str]] = None,
                 ecrpublic: Optional[pulumi.Input[str]] = None,
                 ecs: Optional[pulumi.Input[str]] = None,
                 efs: Optional[pulumi.Input[str]] = None,
                 eks: Optional[pulumi.Input[str]] = None,
                 elasticache: Optional[pulumi.Input[str]] = None,
                 elasticbeanstalk: Optional[pulumi.Input[str]] = None,
                 elastictranscoder: Optional[pulumi.Input[str]] = None,
                 elb: Optional[pulumi.Input[str]] = None,
                 elbv2: Optional[pulumi.Input[str]] = None,
                 emr: Optional[pulumi.Input[str]] = None,
                 emrcontainers: Optional[pulumi.Input[str]] = None,
                 es: Optional[pulumi.Input[str]] = None,
                 firehose: Optional[pulumi.Input[str]] = None,
                 fms: Optional[pulumi.Input[str]] = None,
                 forecast: Optional[pulumi.Input[str]] = None,
                 fsx: Optional[pulumi.Input[str]] = None,
                 gamelift: Optional[pulumi.Input[str]] = None,
                 glacier: Optional[pulumi.Input[str]] = None,
                 globalaccelerator: Optional[pulumi.Input[str]] = None,
                 glue: Optional[pulumi.Input[str]] = None,
                 greengrass: Optional[pulumi.Input[str]] = None,
                 guardduty: Optional[pulumi.Input[str]] = None,
                 iam: Optional[pulumi.Input[str]] = None,
                 identitystore: Optional[pulumi.Input[str]] = None,
                 imagebuilder: Optional[pulumi.Input[str]] = None,
                 inspector: Optional[pulumi.Input[str]] = None,
                 iot: Optional[pulumi.Input[str]] = None,
                 iotanalytics: Optional[pulumi.Input[str]] = None,
                 iotevents: Optional[pulumi.Input[str]] = None,
                 kafka: Optional[pulumi.Input[str]] = None,
                 kinesis: Optional[pulumi.Input[str]] = None,
                 kinesisanalytics: Optional[pulumi.Input[str]] = None,
                 kinesisanalyticsv2: Optional[pulumi.Input[str]] = None,
                 kinesisvideo: Optional[pulumi.Input[str]] = None,
                 kms: Optional[pulumi.Input[str]] = None,
                 lakeformation: Optional[pulumi.Input[str]] = None,
                 lambda_: Optional[pulumi.Input[str]] = None,
                 lexmodels: Optional[pulumi.Input[str]] = None,
                 licensemanager: Optional[pulumi.Input[str]] = None,
                 lightsail: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 macie: Optional[pulumi.Input[str]] = None,
                 macie2: Optional[pulumi.Input[str]] = None,
                 managedblockchain: Optional[pulumi.Input[str]] = None,
                 marketplacecatalog: Optional[pulumi.Input[str]] = None,
                 mediaconnect: Optional[pulumi.Input[str]] = None,
                 mediaconvert: Optional[pulumi.Input[str]] = None,
                 medialive: Optional[pulumi.Input[str]] = None,
                 mediapackage: Optional[pulumi.Input[str]] = None,
                 mediastore: Optional[pulumi.Input[str]] = None,
                 mediastoredata: Optional[pulumi.Input[str]] = None,
                 memorydb: Optional[pulumi.Input[str]] = None,
                 mq: Optional[pulumi.Input[str]] = None,
                 mwaa: Optional[pulumi.Input[str]] = None,
                 neptune: Optional[pulumi.Input[str]] = None,
                 networkfirewall: Optional[pulumi.Input[str]] = None,
                 networkmanager: Optional[pulumi.Input[str]] = None,
                 opsworks: Optional[pulumi.Input[str]] = None,
                 organizations: Optional[pulumi.Input[str]] = None,
                 outposts: Optional[pulumi.Input[str]] = None,
                 personalize: Optional[pulumi.Input[str]] = None,
                 pinpoint: Optional[pulumi.Input[str]] = None,
                 pricing: Optional[pulumi.Input[str]] = None,
                 qldb: Optional[pulumi.Input[str]] = None,
                 quicksight: Optional[pulumi.Input[str]] = None,
                 ram: Optional[pulumi.Input[str]] = None,
                 rds: Optional[pulumi.Input[str]] = None,
                 redshift: Optional[pulumi.Input[str]] = None,
                 resourcegroups: Optional[pulumi.Input[str]] = None,
                 resourcegroupstaggingapi: Optional[pulumi.Input[str]] = None,
                 route53: Optional[pulumi.Input[str]] = None,
                 route53domains: Optional[pulumi.Input[str]] = None,
                 route53recoverycontrolconfig: Optional[pulumi.Input[str]] = None,
                 route53recoveryreadiness: Optional[pulumi.Input[str]] = None,
                 route53resolver: Optional[pulumi.Input[str]] = None,
                 s3: Optional[pulumi.Input[str]] = None,
                 s3control: Optional[pulumi.Input[str]] = None,
                 s3outposts: Optional[pulumi.Input[str]] = None,
                 sagemaker: Optional[pulumi.Input[str]] = None,
                 schemas: Optional[pulumi.Input[str]] = None,
                 sdb: Optional[pulumi.Input[str]] = None,
                 secretsmanager: Optional[pulumi.Input[str]] = None,
                 securityhub: Optional[pulumi.Input[str]] = None,
                 serverlessrepo: Optional[pulumi.Input[str]] = None,
                 servicecatalog: Optional[pulumi.Input[str]] = None,
                 servicediscovery: Optional[pulumi.Input[str]] = None,
                 servicequotas: Optional[pulumi.Input[str]] = None,
                 ses: Optional[pulumi.Input[str]] = None,
                 shield: Optional[pulumi.Input[str]] = None,
                 signer: Optional[pulumi.Input[str]] = None,
                 sns: Optional[pulumi.Input[str]] = None,
                 sqs: Optional[pulumi.Input[str]] = None,
                 ssm: Optional[pulumi.Input[str]] = None,
                 ssoadmin: Optional[pulumi.Input[str]] = None,
                 stepfunctions: Optional[pulumi.Input[str]] = None,
                 storagegateway: Optional[pulumi.Input[str]] = None,
                 sts: Optional[pulumi.Input[str]] = None,
                 swf: Optional[pulumi.Input[str]] = None,
                 synthetics: Optional[pulumi.Input[str]] = None,
                 timestreamwrite: Optional[pulumi.Input[str]] = None,
                 transfer: Optional[pulumi.Input[str]] = None,
                 waf: Optional[pulumi.Input[str]] = None,
                 wafregional: Optional[pulumi.Input[str]] = None,
                 wafv2: Optional[pulumi.Input[str]] = None,
                 worklink: Optional[pulumi.Input[str]] = None,
                 workmail: Optional[pulumi.Input[str]] = None,
                 workspaces: Optional[pulumi.Input[str]] = None,
                 xray: Optional[pulumi.Input[str]] = None):
        """
        The configuration for for customizing service endpoints.
        :param pulumi.Input[str] accessanalyzer: Override the default endpoint for AWS Access Analyzer
        :param pulumi.Input[str] acm: Override the default endpoint for AWS Certificate Manager
        :param pulumi.Input[str] acmpca: Override the default endpoint for AWS Certificate Manager Private Certificate Authority
        :param pulumi.Input[str] amplify: Override the default endpoint for AWS Amplify Console
        :param pulumi.Input[str] appconfig: Override the default endpoint for AWS AppConfig
        :param pulumi.Input[str] applicationautoscaling: Override the default endpoint for AWS Application Auto Scaling
        :param pulumi.Input[str] applicationinsights: Override the default endpoint for AWS CloudWatch Application Insights
        :param pulumi.Input[str] appmesh: Override the default endpoint for AWS App Mesh
        :param pulumi.Input[str] apprunner: Override the default endpoint for AWS App Runner
        :param pulumi.Input[str] appstream: Override the default endpoint for AWS AppStream 2.0
        :param pulumi.Input[str] appsync: Override the default endpoint for AWS AppSync
        :param pulumi.Input[str] athena: Override the default endpoint for AWS Athena
        :param pulumi.Input[str] auditmanager: Override the default endpoint for AWS Audit Manager
        :param pulumi.Input[str] autoscaling: Override the default endpoint for AWS Auto Scaling
        :param pulumi.Input[str] backup: Override the default endpoint for AWS Backup
        :param pulumi.Input[str] batch: Override the default endpoint for AWS Batch
        :param pulumi.Input[str] budgets: Override the default endpoint for AWS Budgets
        :param pulumi.Input[str] chime: Override the default endpoint for Amazon Chime
        :param pulumi.Input[str] cloud9: Override the default endpoint for AWS Cloud9
        :param pulumi.Input[str] cloudformation: Override the default endpoint for AWS CloudFormation
        :param pulumi.Input[str] cloudfront: Override the default endpoint for AWS CloudFront
        :param pulumi.Input[str] cloudhsm: Override the default endpoint for AWS CloudHSM
        :param pulumi.Input[str] cloudsearch: Override the default endpoint for AWS CloudSearch
        :param pulumi.Input[str] cloudtrail: Override the default endpoint for AWS CloudTrail
        :param pulumi.Input[str] cloudwatch: Override the default endpoint for AWS CloudWatch
        :param pulumi.Input[str] cloudwatchevents: Override the default endpoint for AWS CloudWatch Events
        :param pulumi.Input[str] cloudwatchlogs: Override the default endpoint for AWS CloudWatch Logs
        :param pulumi.Input[str] codeartifact: Override the default endpoint for AWS CodeArtifact
        :param pulumi.Input[str] codebuild: Override the default endpoint for AWS CodeBuild
        :param pulumi.Input[str] codecommit: Override the default endpoint for AWS CodeCommit
        :param pulumi.Input[str] codedeploy: Override the default endpoint for AWS CodeDeploy
        :param pulumi.Input[str] codepipeline: Override the default endpoint for AWS CodePipeline
        :param pulumi.Input[str] codestarconnections: Override the default endpoint for AWS CodeStart Connections
        :param pulumi.Input[str] cognitoidentity: Override the default endpoint for Amazon Cognito
        :param pulumi.Input[str] configservice: Override the default endpoint for AWS Config
        :param pulumi.Input[str] connect: Override the default endpoint for Amazon Connect
        :param pulumi.Input[str] cur: Override the default endpoint for AWS Cost and Usage Reports
        :param pulumi.Input[str] dataexchange: Override the default endpoint for AWS Data Exchange
        :param pulumi.Input[str] datapipeline: Override the default endpoint for AWS Data Pipeline
        :param pulumi.Input[str] datasync: Override the default endpoint for AWS DataSync
        :param pulumi.Input[str] dax: Override the default endpoint for AWS DynamoDB Accelerator
        :param pulumi.Input[str] detective: Override the default endpoint for AWS Detective
        :param pulumi.Input[str] devicefarm: Override the default endpoint for AWS Device Farm
        :param pulumi.Input[str] directconnect: Override the default endpoint for AWS Direct Connect
        :param pulumi.Input[str] dlm: Override the default endpoint for AWS Data Lifecycle Manager
        :param pulumi.Input[str] dms: Override the default endpoint for AWS Database Migration Service
        :param pulumi.Input[str] docdb: Override the default endpoint for AWS DocumentDB
        :param pulumi.Input[str] ds: Override the default endpoint for AWS Directory Service
        :param pulumi.Input[str] dynamodb: Override the default endpoint for AWS DynamoDB
        :param pulumi.Input[str] ec2: Override the default endpoint for AWS Elastic Compute Cloud (EC2)
        :param pulumi.Input[str] ecr: Override the default endpoint for AWS Elastic Container Registry (ECR)
        :param pulumi.Input[str] ecrpublic: Override the default endpoint for AWS Elastic Container Registry (ECR) Public
        :param pulumi.Input[str] ecs: Override the default endpoint for AWS Elastic Container Service (ECS)
        :param pulumi.Input[str] efs: Override the default endpoint for AWS Elastic File System (EFS)
        :param pulumi.Input[str] eks: Override the default endpoint for AWS Elastic Kubernetes Service (EKS)
        :param pulumi.Input[str] elasticache: Override the default endpoint for AWS ElastiCache
        :param pulumi.Input[str] elasticbeanstalk: Override the default endpoint for AWS Elastic Beanstalk
        :param pulumi.Input[str] elastictranscoder: Override the default endpoint for AWS Elastic Transcoder
        :param pulumi.Input[str] elb: Override the default endpoint for AWS Elastic Load Balancing
        :param pulumi.Input[str] elbv2: Override the default endpoint for AWS Elastic Load Balancing V2
        :param pulumi.Input[str] emr: Override the default endpoint for AWS EMR
        :param pulumi.Input[str] emrcontainers: Override the default endpoint for AWS EMR on EKS
        :param pulumi.Input[str] es: Override the default endpoint for AWS OpenSearch Service (formerly Elasticsearch)
        :param pulumi.Input[str] firehose: Override the default endpoint for AWS Kinesis Data Firehose
        :param pulumi.Input[str] fms: Override the default endpoint for AWS Firewall Manager
        :param pulumi.Input[str] forecast: Override the default endpoint for Amazon Forecast
        :param pulumi.Input[str] fsx: Override the default endpoint for AWS FSx
        :param pulumi.Input[str] gamelift: Override the default endpoint for AWS GameLift
        :param pulumi.Input[str] glacier: Override the default endpoint for Amazon S3 Glacier
        :param pulumi.Input[str] globalaccelerator: Override the default endpoint for AWS Global Accelerator
        :param pulumi.Input[str] glue: Override the default endpoint for AWS Glue
        :param pulumi.Input[str] greengrass: Override the default endpoint for AWS IoT Greengrass
        :param pulumi.Input[str] guardduty: Override the default endpoint for AWS GuardDuty
        :param pulumi.Input[str] iam: Override the default endpoint for AWS Identity and Access Management
        :param pulumi.Input[str] identitystore: Override the default endpoint for AWS Single Sign-On (SSO) Identity Store
        :param pulumi.Input[str] imagebuilder: Override the default endpoint for AWS Image Builder
        :param pulumi.Input[str] inspector: Override the default endpoint for Amazon Inspector
        :param pulumi.Input[str] iot: Override the default endpoint for AWS IoT
        :param pulumi.Input[str] iotanalytics: Override the default endpoint for AWS IoT Analytics
        :param pulumi.Input[str] iotevents: Override the default endpoint for AWS IoT Events
        :param pulumi.Input[str] kafka: Override the default endpoint for Amazon Managed Streaming for Apache Kafka (MSK)
        :param pulumi.Input[str] kinesis: Override the default endpoint for Amazon Kinesis
        :param pulumi.Input[str] kinesisanalytics: Override the default endpoint for Amazon Kinesis Data Analytics
        :param pulumi.Input[str] kinesisanalyticsv2: Override the default endpoint for Amazon Kinesis Data Analytics V2
        :param pulumi.Input[str] kinesisvideo: Override the default endpoint for Amazon Kinesis Video Streams
        :param pulumi.Input[str] kms: Override the default endpoint for AWS Key Management Service
        :param pulumi.Input[str] lakeformation: Override the default endpoint for AWS Lake Formation
        :param pulumi.Input[str] lambda_: Override the default endpoint for AWS Lambda
        :param pulumi.Input[str] lexmodels: Override the default endpoint for Amazon Lex
        :param pulumi.Input[str] licensemanager: Override the default endpoint for AWS License Manager
        :param pulumi.Input[str] lightsail: Override the default endpoint for Amazon Lightsail
        :param pulumi.Input[str] location: Override the default endpoint for Amazon Location
        :param pulumi.Input[str] macie: Override the default endpoint for Amazon Macie
        :param pulumi.Input[str] macie2: Override the default endpoint for Amazon Macie V2
        :param pulumi.Input[str] managedblockchain: Override the default endpoint for Amazon Managed Blockchain
        :param pulumi.Input[str] marketplacecatalog: Override the default endpoint for AWS Marketplace Catalog
        :param pulumi.Input[str] mediaconnect: Override the default endpoint for AWS MediaConnect
        :param pulumi.Input[str] mediaconvert: Override the default endpoint for AWS MediaConvert
        :param pulumi.Input[str] medialive: Override the default endpoint for AWS MediaLive
        :param pulumi.Input[str] mediapackage: Override the default endpoint for AWS MediaPackage
        :param pulumi.Input[str] mediastore: Override the default endpoint for AWS Elemental MediaStore container
        :param pulumi.Input[str] mediastoredata: Override the default endpoint for AWS Elemental MediaStore asset
        :param pulumi.Input[str] memorydb: Override the default endpoint for AWS MemoryDB for Redis
        :param pulumi.Input[str] mq: Override the default endpoint for Amazon MQ
        :param pulumi.Input[str] mwaa: Override the default endpoint for Amazon Managed Workflows for Apache Airflow
        :param pulumi.Input[str] neptune: Override the default endpoint for Amazon Neptune
        :param pulumi.Input[str] networkfirewall: Override the default endpoint for AWS Network Firewall
        :param pulumi.Input[str] networkmanager: Override the default endpoint for AWS Network Manager
        :param pulumi.Input[str] opsworks: Override the default endpoint for AWS OpsWorks
        :param pulumi.Input[str] organizations: Override the default endpoint for AWS Organizations
        :param pulumi.Input[str] outposts: Override the default endpoint for AWS Outposts
        :param pulumi.Input[str] personalize: Override the default endpoint for Amazon Personalize
        :param pulumi.Input[str] pinpoint: Override the default endpoint for Amazon Pinpoint
        :param pulumi.Input[str] pricing: Override the default endpoint for Amazon Web Services Price List Service
        :param pulumi.Input[str] qldb: Override the default endpoint for Amazon QLDB
        :param pulumi.Input[str] quicksight: Override the default endpoint for Amazon QuickSight
        :param pulumi.Input[str] ram: Override the default endpoint for AWS Resource Access Manager
        :param pulumi.Input[str] rds: Override the default endpoint for Amazon Relational Database Service
        :param pulumi.Input[str] redshift: Override the default endpoint for Amazon Redshift
        :param pulumi.Input[str] resourcegroups: Override the default endpoint for AWS Resource Groups
        :param pulumi.Input[str] resourcegroupstaggingapi: Override the default endpoint for AWS Resource Groups Tagging API
        :param pulumi.Input[str] route53: Override the default endpoint for Amazon Route 53
        :param pulumi.Input[str] route53domains: Override the default endpoint for Amazon Route 53 Domains
        :param pulumi.Input[str] route53recoverycontrolconfig: Override the default endpoint for Amazon Route 53 Recovery Control
        :param pulumi.Input[str] route53recoveryreadiness: Override the default endpoint for Amazon Route 53 Recovery Readiness
        :param pulumi.Input[str] route53resolver: Override the default endpoint for Amazon Route 53 Resolver
        :param pulumi.Input[str] s3: Override the default endpoint for Amazon Simple Storage Service (S3)
        :param pulumi.Input[str] s3control: Override the default endpoint for Amazon Simple Storage Service (S3) Control
        :param pulumi.Input[str] s3outposts: Override the default endpoint for Amazon S3 on Outposts
        :param pulumi.Input[str] sagemaker: Override the default endpoint for AWS SageMaker
        :param pulumi.Input[str] schemas: Override the default endpoint for Amazon EventBridge Schema Registry
        :param pulumi.Input[str] sdb: Override the default endpoint for Amazon SimpleDB
        :param pulumi.Input[str] secretsmanager: Override the default endpoint for AWS Secrets Manager
        :param pulumi.Input[str] securityhub: Override the default endpoint for AWS Security Hub
        :param pulumi.Input[str] serverlessrepo: Override the default endpoint for AWS Serverless Application Repository
        :param pulumi.Input[str] servicecatalog: Override the default endpoint for AWS Service Catalog
        :param pulumi.Input[str] servicediscovery: Override the default endpoint for AWS Cloud Map
        :param pulumi.Input[str] servicequotas: Override the default endpoint for AWS Service Quotas
        :param pulumi.Input[str] ses: Override the default endpoint for Amazon Simple Email Service (SES)
        :param pulumi.Input[str] shield: Override the default endpoint for AWS Shield Advanced API
        :param pulumi.Input[str] signer: Override the default endpoint for AWS Signer
        :param pulumi.Input[str] sns: Override the default endpoint for Amazon Simple Notification Service (SNS)
        :param pulumi.Input[str] sqs: Override the default endpoint for Amazon Simple Queue Service (SQS)
        :param pulumi.Input[str] ssm: Override the default endpoint for AWS Systems Manager
        :param pulumi.Input[str] ssoadmin: Override the default endpoint for AWS Single Sign On (SSO)
        :param pulumi.Input[str] stepfunctions: Override the default endpoint for AWS Step Functions
        :param pulumi.Input[str] storagegateway: Override the default endpoint for AWS Storage Gateway
        :param pulumi.Input[str] sts: Override the default endpoint for AWS Security Token Service (STS)
        :param pulumi.Input[str] swf: Override the default endpoint for Amazon Simple Workflow Service (SWF)
        :param pulumi.Input[str] synthetics: Override the default endpoint for Amazon CloudWatch Synthetics
        :param pulumi.Input[str] timestreamwrite: Override the default endpoint for Amazon Timestream
        :param pulumi.Input[str] transfer: Override the default endpoint for AWS Transfer Family
        :param pulumi.Input[str] waf: Override the default endpoint for AWS WAF Classic
        :param pulumi.Input[str] wafregional: Override the default endpoint for AWS WAF Regional Classic
        :param pulumi.Input[str] wafv2: Override the default endpoint for AWS WAF V2
        :param pulumi.Input[str] worklink: Override the default endpoint for Amazon WorkLink
        :param pulumi.Input[str] workmail: Override the default endpoint for Amazon WorkMail
        :param pulumi.Input[str] workspaces: Override the default endpoint for Amazon WorkSpaces
        :param pulumi.Input[str] xray: Override the default endpoint for AWS X-Ray
        """
        if accessanalyzer is not None:
            pulumi.set(__self__, "accessanalyzer", accessanalyzer)
        if acm is not None:
            pulumi.set(__self__, "acm", acm)
        if acmpca is not None:
            pulumi.set(__self__, "acmpca", acmpca)
        if amplify is not None:
            pulumi.set(__self__, "amplify", amplify)
        if appconfig is not None:
            pulumi.set(__self__, "appconfig", appconfig)
        if applicationautoscaling is not None:
            pulumi.set(__self__, "applicationautoscaling", applicationautoscaling)
        if applicationinsights is not None:
            pulumi.set(__self__, "applicationinsights", applicationinsights)
        if appmesh is not None:
            pulumi.set(__self__, "appmesh", appmesh)
        if apprunner is not None:
            pulumi.set(__self__, "apprunner", apprunner)
        if appstream is not None:
            pulumi.set(__self__, "appstream", appstream)
        if appsync is not None:
            pulumi.set(__self__, "appsync", appsync)
        if athena is not None:
            pulumi.set(__self__, "athena", athena)
        if auditmanager is not None:
            pulumi.set(__self__, "auditmanager", auditmanager)
        if autoscaling is not None:
            pulumi.set(__self__, "autoscaling", autoscaling)
        if backup is not None:
            pulumi.set(__self__, "backup", backup)
        if batch is not None:
            pulumi.set(__self__, "batch", batch)
        if budgets is not None:
            pulumi.set(__self__, "budgets", budgets)
        if chime is not None:
            pulumi.set(__self__, "chime", chime)
        if cloud9 is not None:
            pulumi.set(__self__, "cloud9", cloud9)
        if cloudformation is not None:
            pulumi.set(__self__, "cloudformation", cloudformation)
        if cloudfront is not None:
            pulumi.set(__self__, "cloudfront", cloudfront)
        if cloudhsm is not None:
            pulumi.set(__self__, "cloudhsm", cloudhsm)
        if cloudsearch is not None:
            pulumi.set(__self__, "cloudsearch", cloudsearch)
        if cloudtrail is not None:
            pulumi.set(__self__, "cloudtrail", cloudtrail)
        if cloudwatch is not None:
            pulumi.set(__self__, "cloudwatch", cloudwatch)
        if cloudwatchevents is not None:
            pulumi.set(__self__, "cloudwatchevents", cloudwatchevents)
        if cloudwatchlogs is not None:
            pulumi.set(__self__, "cloudwatchlogs", cloudwatchlogs)
        if codeartifact is not None:
            pulumi.set(__self__, "codeartifact", codeartifact)
        if codebuild is not None:
            pulumi.set(__self__, "codebuild", codebuild)
        if codecommit is not None:
            pulumi.set(__self__, "codecommit", codecommit)
        if codedeploy is not None:
            pulumi.set(__self__, "codedeploy", codedeploy)
        if codepipeline is not None:
            pulumi.set(__self__, "codepipeline", codepipeline)
        if codestarconnections is not None:
            pulumi.set(__self__, "codestarconnections", codestarconnections)
        if cognitoidentity is not None:
            pulumi.set(__self__, "cognitoidentity", cognitoidentity)
        if configservice is not None:
            pulumi.set(__self__, "configservice", configservice)
        if connect is not None:
            pulumi.set(__self__, "connect", connect)
        if cur is not None:
            pulumi.set(__self__, "cur", cur)
        if dataexchange is not None:
            pulumi.set(__self__, "dataexchange", dataexchange)
        if datapipeline is not None:
            pulumi.set(__self__, "datapipeline", datapipeline)
        if datasync is not None:
            pulumi.set(__self__, "datasync", datasync)
        if dax is not None:
            pulumi.set(__self__, "dax", dax)
        if detective is not None:
            pulumi.set(__self__, "detective", detective)
        if devicefarm is not None:
            pulumi.set(__self__, "devicefarm", devicefarm)
        if directconnect is not None:
            pulumi.set(__self__, "directconnect", directconnect)
        if dlm is not None:
            pulumi.set(__self__, "dlm", dlm)
        if dms is not None:
            pulumi.set(__self__, "dms", dms)
        if docdb is not None:
            pulumi.set(__self__, "docdb", docdb)
        if ds is not None:
            pulumi.set(__self__, "ds", ds)
        if dynamodb is not None:
            pulumi.set(__self__, "dynamodb", dynamodb)
        if ec2 is not None:
            pulumi.set(__self__, "ec2", ec2)
        if ecr is not None:
            pulumi.set(__self__, "ecr", ecr)
        if ecrpublic is not None:
            pulumi.set(__self__, "ecrpublic", ecrpublic)
        if ecs is not None:
            pulumi.set(__self__, "ecs", ecs)
        if efs is not None:
            pulumi.set(__self__, "efs", efs)
        if eks is not None:
            pulumi.set(__self__, "eks", eks)
        if elasticache is not None:
            pulumi.set(__self__, "elasticache", elasticache)
        if elasticbeanstalk is not None:
            pulumi.set(__self__, "elasticbeanstalk", elasticbeanstalk)
        if elastictranscoder is not None:
            pulumi.set(__self__, "elastictranscoder", elastictranscoder)
        if elb is not None:
            pulumi.set(__self__, "elb", elb)
        if elbv2 is not None:
            pulumi.set(__self__, "elbv2", elbv2)
        if emr is not None:
            pulumi.set(__self__, "emr", emr)
        if emrcontainers is not None:
            pulumi.set(__self__, "emrcontainers", emrcontainers)
        if es is not None:
            pulumi.set(__self__, "es", es)
        if firehose is not None:
            pulumi.set(__self__, "firehose", firehose)
        if fms is not None:
            pulumi.set(__self__, "fms", fms)
        if forecast is not None:
            pulumi.set(__self__, "forecast", forecast)
        if fsx is not None:
            pulumi.set(__self__, "fsx", fsx)
        if gamelift is not None:
            pulumi.set(__self__, "gamelift", gamelift)
        if glacier is not None:
            pulumi.set(__self__, "glacier", glacier)
        if globalaccelerator is not None:
            pulumi.set(__self__, "globalaccelerator", globalaccelerator)
        if glue is not None:
            pulumi.set(__self__, "glue", glue)
        if greengrass is not None:
            pulumi.set(__self__, "greengrass", greengrass)
        if guardduty is not None:
            pulumi.set(__self__, "guardduty", guardduty)
        if iam is not None:
            pulumi.set(__self__, "iam", iam)
        if identitystore is not None:
            pulumi.set(__self__, "identitystore", identitystore)
        if imagebuilder is not None:
            pulumi.set(__self__, "imagebuilder", imagebuilder)
        if inspector is not None:
            pulumi.set(__self__, "inspector", inspector)
        if iot is not None:
            pulumi.set(__self__, "iot", iot)
        if iotanalytics is not None:
            pulumi.set(__self__, "iotanalytics", iotanalytics)
        if iotevents is not None:
            pulumi.set(__self__, "iotevents", iotevents)
        if kafka is not None:
            pulumi.set(__self__, "kafka", kafka)
        if kinesis is not None:
            pulumi.set(__self__, "kinesis", kinesis)
        if kinesisanalytics is not None:
            pulumi.set(__self__, "kinesisanalytics", kinesisanalytics)
        if kinesisanalyticsv2 is not None:
            pulumi.set(__self__, "kinesisanalyticsv2", kinesisanalyticsv2)
        if kinesisvideo is not None:
            pulumi.set(__self__, "kinesisvideo", kinesisvideo)
        if kms is not None:
            pulumi.set(__self__, "kms", kms)
        if lakeformation is not None:
            pulumi.set(__self__, "lakeformation", lakeformation)
        if lambda_ is not None:
            pulumi.set(__self__, "lambda_", lambda_)
        if lexmodels is not None:
            pulumi.set(__self__, "lexmodels", lexmodels)
        if licensemanager is not None:
            pulumi.set(__self__, "licensemanager", licensemanager)
        if lightsail is not None:
            pulumi.set(__self__, "lightsail", lightsail)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if macie is not None:
            pulumi.set(__self__, "macie", macie)
        if macie2 is not None:
            pulumi.set(__self__, "macie2", macie2)
        if managedblockchain is not None:
            pulumi.set(__self__, "managedblockchain", managedblockchain)
        if marketplacecatalog is not None:
            pulumi.set(__self__, "marketplacecatalog", marketplacecatalog)
        if mediaconnect is not None:
            pulumi.set(__self__, "mediaconnect", mediaconnect)
        if mediaconvert is not None:
            pulumi.set(__self__, "mediaconvert", mediaconvert)
        if medialive is not None:
            pulumi.set(__self__, "medialive", medialive)
        if mediapackage is not None:
            pulumi.set(__self__, "mediapackage", mediapackage)
        if mediastore is not None:
            pulumi.set(__self__, "mediastore", mediastore)
        if mediastoredata is not None:
            pulumi.set(__self__, "mediastoredata", mediastoredata)
        if memorydb is not None:
            pulumi.set(__self__, "memorydb", memorydb)
        if mq is not None:
            pulumi.set(__self__, "mq", mq)
        if mwaa is not None:
            pulumi.set(__self__, "mwaa", mwaa)
        if neptune is not None:
            pulumi.set(__self__, "neptune", neptune)
        if networkfirewall is not None:
            pulumi.set(__self__, "networkfirewall", networkfirewall)
        if networkmanager is not None:
            pulumi.set(__self__, "networkmanager", networkmanager)
        if opsworks is not None:
            pulumi.set(__self__, "opsworks", opsworks)
        if organizations is not None:
            pulumi.set(__self__, "organizations", organizations)
        if outposts is not None:
            pulumi.set(__self__, "outposts", outposts)
        if personalize is not None:
            pulumi.set(__self__, "personalize", personalize)
        if pinpoint is not None:
            pulumi.set(__self__, "pinpoint", pinpoint)
        if pricing is not None:
            pulumi.set(__self__, "pricing", pricing)
        if qldb is not None:
            pulumi.set(__self__, "qldb", qldb)
        if quicksight is not None:
            pulumi.set(__self__, "quicksight", quicksight)
        if ram is not None:
            pulumi.set(__self__, "ram", ram)
        if rds is not None:
            pulumi.set(__self__, "rds", rds)
        if redshift is not None:
            pulumi.set(__self__, "redshift", redshift)
        if resourcegroups is not None:
            pulumi.set(__self__, "resourcegroups", resourcegroups)
        if resourcegroupstaggingapi is not None:
            pulumi.set(__self__, "resourcegroupstaggingapi", resourcegroupstaggingapi)
        if route53 is not None:
            pulumi.set(__self__, "route53", route53)
        if route53domains is not None:
            pulumi.set(__self__, "route53domains", route53domains)
        if route53recoverycontrolconfig is not None:
            pulumi.set(__self__, "route53recoverycontrolconfig", route53recoverycontrolconfig)
        if route53recoveryreadiness is not None:
            pulumi.set(__self__, "route53recoveryreadiness", route53recoveryreadiness)
        if route53resolver is not None:
            pulumi.set(__self__, "route53resolver", route53resolver)
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)
        if s3control is not None:
            pulumi.set(__self__, "s3control", s3control)
        if s3outposts is not None:
            pulumi.set(__self__, "s3outposts", s3outposts)
        if sagemaker is not None:
            pulumi.set(__self__, "sagemaker", sagemaker)
        if schemas is not None:
            pulumi.set(__self__, "schemas", schemas)
        if sdb is not None:
            pulumi.set(__self__, "sdb", sdb)
        if secretsmanager is not None:
            pulumi.set(__self__, "secretsmanager", secretsmanager)
        if securityhub is not None:
            pulumi.set(__self__, "securityhub", securityhub)
        if serverlessrepo is not None:
            pulumi.set(__self__, "serverlessrepo", serverlessrepo)
        if servicecatalog is not None:
            pulumi.set(__self__, "servicecatalog", servicecatalog)
        if servicediscovery is not None:
            pulumi.set(__self__, "servicediscovery", servicediscovery)
        if servicequotas is not None:
            pulumi.set(__self__, "servicequotas", servicequotas)
        if ses is not None:
            pulumi.set(__self__, "ses", ses)
        if shield is not None:
            pulumi.set(__self__, "shield", shield)
        if signer is not None:
            pulumi.set(__self__, "signer", signer)
        if sns is not None:
            pulumi.set(__self__, "sns", sns)
        if sqs is not None:
            pulumi.set(__self__, "sqs", sqs)
        if ssm is not None:
            pulumi.set(__self__, "ssm", ssm)
        if ssoadmin is not None:
            pulumi.set(__self__, "ssoadmin", ssoadmin)
        if stepfunctions is not None:
            pulumi.set(__self__, "stepfunctions", stepfunctions)
        if storagegateway is not None:
            pulumi.set(__self__, "storagegateway", storagegateway)
        if sts is not None:
            pulumi.set(__self__, "sts", sts)
        if swf is not None:
            pulumi.set(__self__, "swf", swf)
        if synthetics is not None:
            pulumi.set(__self__, "synthetics", synthetics)
        if timestreamwrite is not None:
            pulumi.set(__self__, "timestreamwrite", timestreamwrite)
        if transfer is not None:
            pulumi.set(__self__, "transfer", transfer)
        if waf is not None:
            pulumi.set(__self__, "waf", waf)
        if wafregional is not None:
            pulumi.set(__self__, "wafregional", wafregional)
        if wafv2 is not None:
            pulumi.set(__self__, "wafv2", wafv2)
        if worklink is not None:
            pulumi.set(__self__, "worklink", worklink)
        if workmail is not None:
            pulumi.set(__self__, "workmail", workmail)
        if workspaces is not None:
            pulumi.set(__self__, "workspaces", workspaces)
        if xray is not None:
            pulumi.set(__self__, "xray", xray)

    @property
    @pulumi.getter
    def accessanalyzer(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Access Analyzer
        """
        return pulumi.get(self, "accessanalyzer")

    @accessanalyzer.setter
    def accessanalyzer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accessanalyzer", value)

    @property
    @pulumi.getter
    def acm(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Certificate Manager
        """
        return pulumi.get(self, "acm")

    @acm.setter
    def acm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acm", value)

    @property
    @pulumi.getter
    def acmpca(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Certificate Manager Private Certificate Authority
        """
        return pulumi.get(self, "acmpca")

    @acmpca.setter
    def acmpca(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acmpca", value)

    @property
    @pulumi.getter
    def amplify(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Amplify Console
        """
        return pulumi.get(self, "amplify")

    @amplify.setter
    def amplify(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "amplify", value)

    @property
    @pulumi.getter
    def appconfig(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS AppConfig
        """
        return pulumi.get(self, "appconfig")

    @appconfig.setter
    def appconfig(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "appconfig", value)

    @property
    @pulumi.getter
    def applicationautoscaling(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Application Auto Scaling
        """
        return pulumi.get(self, "applicationautoscaling")

    @applicationautoscaling.setter
    def applicationautoscaling(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "applicationautoscaling", value)

    @property
    @pulumi.getter
    def applicationinsights(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS CloudWatch Application Insights
        """
        return pulumi.get(self, "applicationinsights")

    @applicationinsights.setter
    def applicationinsights(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "applicationinsights", value)

    @property
    @pulumi.getter
    def appmesh(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS App Mesh
        """
        return pulumi.get(self, "appmesh")

    @appmesh.setter
    def appmesh(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "appmesh", value)

    @property
    @pulumi.getter
    def apprunner(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS App Runner
        """
        return pulumi.get(self, "apprunner")

    @apprunner.setter
    def apprunner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "apprunner", value)

    @property
    @pulumi.getter
    def appstream(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS AppStream 2.0
        """
        return pulumi.get(self, "appstream")

    @appstream.setter
    def appstream(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "appstream", value)

    @property
    @pulumi.getter
    def appsync(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS AppSync
        """
        return pulumi.get(self, "appsync")

    @appsync.setter
    def appsync(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "appsync", value)

    @property
    @pulumi.getter
    def athena(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Athena
        """
        return pulumi.get(self, "athena")

    @athena.setter
    def athena(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "athena", value)

    @property
    @pulumi.getter
    def auditmanager(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Audit Manager
        """
        return pulumi.get(self, "auditmanager")

    @auditmanager.setter
    def auditmanager(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auditmanager", value)

    @property
    @pulumi.getter
    def autoscaling(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Auto Scaling
        """
        return pulumi.get(self, "autoscaling")

    @autoscaling.setter
    def autoscaling(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "autoscaling", value)

    @property
    @pulumi.getter
    def backup(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Backup
        """
        return pulumi.get(self, "backup")

    @backup.setter
    def backup(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup", value)

    @property
    @pulumi.getter
    def batch(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Batch
        """
        return pulumi.get(self, "batch")

    @batch.setter
    def batch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "batch", value)

    @property
    @pulumi.getter
    def budgets(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Budgets
        """
        return pulumi.get(self, "budgets")

    @budgets.setter
    def budgets(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "budgets", value)

    @property
    @pulumi.getter
    def chime(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon Chime
        """
        return pulumi.get(self, "chime")

    @chime.setter
    def chime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "chime", value)

    @property
    @pulumi.getter
    def cloud9(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Cloud9
        """
        return pulumi.get(self, "cloud9")

    @cloud9.setter
    def cloud9(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud9", value)

    @property
    @pulumi.getter
    def cloudformation(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS CloudFormation
        """
        return pulumi.get(self, "cloudformation")

    @cloudformation.setter
    def cloudformation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloudformation", value)

    @property
    @pulumi.getter
    def cloudfront(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS CloudFront
        """
        return pulumi.get(self, "cloudfront")

    @cloudfront.setter
    def cloudfront(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloudfront", value)

    @property
    @pulumi.getter
    def cloudhsm(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS CloudHSM
        """
        return pulumi.get(self, "cloudhsm")

    @cloudhsm.setter
    def cloudhsm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloudhsm", value)

    @property
    @pulumi.getter
    def cloudsearch(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS CloudSearch
        """
        return pulumi.get(self, "cloudsearch")

    @cloudsearch.setter
    def cloudsearch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloudsearch", value)

    @property
    @pulumi.getter
    def cloudtrail(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS CloudTrail
        """
        return pulumi.get(self, "cloudtrail")

    @cloudtrail.setter
    def cloudtrail(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloudtrail", value)

    @property
    @pulumi.getter
    def cloudwatch(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS CloudWatch
        """
        return pulumi.get(self, "cloudwatch")

    @cloudwatch.setter
    def cloudwatch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloudwatch", value)

    @property
    @pulumi.getter
    def cloudwatchevents(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS CloudWatch Events
        """
        return pulumi.get(self, "cloudwatchevents")

    @cloudwatchevents.setter
    def cloudwatchevents(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloudwatchevents", value)

    @property
    @pulumi.getter
    def cloudwatchlogs(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS CloudWatch Logs
        """
        return pulumi.get(self, "cloudwatchlogs")

    @cloudwatchlogs.setter
    def cloudwatchlogs(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloudwatchlogs", value)

    @property
    @pulumi.getter
    def codeartifact(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS CodeArtifact
        """
        return pulumi.get(self, "codeartifact")

    @codeartifact.setter
    def codeartifact(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "codeartifact", value)

    @property
    @pulumi.getter
    def codebuild(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS CodeBuild
        """
        return pulumi.get(self, "codebuild")

    @codebuild.setter
    def codebuild(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "codebuild", value)

    @property
    @pulumi.getter
    def codecommit(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS CodeCommit
        """
        return pulumi.get(self, "codecommit")

    @codecommit.setter
    def codecommit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "codecommit", value)

    @property
    @pulumi.getter
    def codedeploy(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS CodeDeploy
        """
        return pulumi.get(self, "codedeploy")

    @codedeploy.setter
    def codedeploy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "codedeploy", value)

    @property
    @pulumi.getter
    def codepipeline(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS CodePipeline
        """
        return pulumi.get(self, "codepipeline")

    @codepipeline.setter
    def codepipeline(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "codepipeline", value)

    @property
    @pulumi.getter
    def codestarconnections(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS CodeStart Connections
        """
        return pulumi.get(self, "codestarconnections")

    @codestarconnections.setter
    def codestarconnections(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "codestarconnections", value)

    @property
    @pulumi.getter
    def cognitoidentity(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon Cognito
        """
        return pulumi.get(self, "cognitoidentity")

    @cognitoidentity.setter
    def cognitoidentity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cognitoidentity", value)

    @property
    @pulumi.getter
    def configservice(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Config
        """
        return pulumi.get(self, "configservice")

    @configservice.setter
    def configservice(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configservice", value)

    @property
    @pulumi.getter
    def connect(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon Connect
        """
        return pulumi.get(self, "connect")

    @connect.setter
    def connect(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connect", value)

    @property
    @pulumi.getter
    def cur(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Cost and Usage Reports
        """
        return pulumi.get(self, "cur")

    @cur.setter
    def cur(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cur", value)

    @property
    @pulumi.getter
    def dataexchange(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Data Exchange
        """
        return pulumi.get(self, "dataexchange")

    @dataexchange.setter
    def dataexchange(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataexchange", value)

    @property
    @pulumi.getter
    def datapipeline(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Data Pipeline
        """
        return pulumi.get(self, "datapipeline")

    @datapipeline.setter
    def datapipeline(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "datapipeline", value)

    @property
    @pulumi.getter
    def datasync(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS DataSync
        """
        return pulumi.get(self, "datasync")

    @datasync.setter
    def datasync(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "datasync", value)

    @property
    @pulumi.getter
    def dax(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS DynamoDB Accelerator
        """
        return pulumi.get(self, "dax")

    @dax.setter
    def dax(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dax", value)

    @property
    @pulumi.getter
    def detective(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Detective
        """
        return pulumi.get(self, "detective")

    @detective.setter
    def detective(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "detective", value)

    @property
    @pulumi.getter
    def devicefarm(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Device Farm
        """
        return pulumi.get(self, "devicefarm")

    @devicefarm.setter
    def devicefarm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "devicefarm", value)

    @property
    @pulumi.getter
    def directconnect(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Direct Connect
        """
        return pulumi.get(self, "directconnect")

    @directconnect.setter
    def directconnect(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "directconnect", value)

    @property
    @pulumi.getter
    def dlm(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Data Lifecycle Manager
        """
        return pulumi.get(self, "dlm")

    @dlm.setter
    def dlm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dlm", value)

    @property
    @pulumi.getter
    def dms(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Database Migration Service
        """
        return pulumi.get(self, "dms")

    @dms.setter
    def dms(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dms", value)

    @property
    @pulumi.getter
    def docdb(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS DocumentDB
        """
        return pulumi.get(self, "docdb")

    @docdb.setter
    def docdb(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "docdb", value)

    @property
    @pulumi.getter
    def ds(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Directory Service
        """
        return pulumi.get(self, "ds")

    @ds.setter
    def ds(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ds", value)

    @property
    @pulumi.getter
    def dynamodb(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS DynamoDB
        """
        return pulumi.get(self, "dynamodb")

    @dynamodb.setter
    def dynamodb(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dynamodb", value)

    @property
    @pulumi.getter
    def ec2(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Elastic Compute Cloud (EC2)
        """
        return pulumi.get(self, "ec2")

    @ec2.setter
    def ec2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ec2", value)

    @property
    @pulumi.getter
    def ecr(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Elastic Container Registry (ECR)
        """
        return pulumi.get(self, "ecr")

    @ecr.setter
    def ecr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ecr", value)

    @property
    @pulumi.getter
    def ecrpublic(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Elastic Container Registry (ECR) Public
        """
        return pulumi.get(self, "ecrpublic")

    @ecrpublic.setter
    def ecrpublic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ecrpublic", value)

    @property
    @pulumi.getter
    def ecs(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Elastic Container Service (ECS)
        """
        return pulumi.get(self, "ecs")

    @ecs.setter
    def ecs(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ecs", value)

    @property
    @pulumi.getter
    def efs(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Elastic File System (EFS)
        """
        return pulumi.get(self, "efs")

    @efs.setter
    def efs(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "efs", value)

    @property
    @pulumi.getter
    def eks(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Elastic Kubernetes Service (EKS)
        """
        return pulumi.get(self, "eks")

    @eks.setter
    def eks(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eks", value)

    @property
    @pulumi.getter
    def elasticache(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS ElastiCache
        """
        return pulumi.get(self, "elasticache")

    @elasticache.setter
    def elasticache(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "elasticache", value)

    @property
    @pulumi.getter
    def elasticbeanstalk(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Elastic Beanstalk
        """
        return pulumi.get(self, "elasticbeanstalk")

    @elasticbeanstalk.setter
    def elasticbeanstalk(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "elasticbeanstalk", value)

    @property
    @pulumi.getter
    def elastictranscoder(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Elastic Transcoder
        """
        return pulumi.get(self, "elastictranscoder")

    @elastictranscoder.setter
    def elastictranscoder(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "elastictranscoder", value)

    @property
    @pulumi.getter
    def elb(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Elastic Load Balancing
        """
        return pulumi.get(self, "elb")

    @elb.setter
    def elb(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "elb", value)

    @property
    @pulumi.getter
    def elbv2(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Elastic Load Balancing V2
        """
        return pulumi.get(self, "elbv2")

    @elbv2.setter
    def elbv2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "elbv2", value)

    @property
    @pulumi.getter
    def emr(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS EMR
        """
        return pulumi.get(self, "emr")

    @emr.setter
    def emr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "emr", value)

    @property
    @pulumi.getter
    def emrcontainers(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS EMR on EKS
        """
        return pulumi.get(self, "emrcontainers")

    @emrcontainers.setter
    def emrcontainers(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "emrcontainers", value)

    @property
    @pulumi.getter
    def es(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS OpenSearch Service (formerly Elasticsearch)
        """
        return pulumi.get(self, "es")

    @es.setter
    def es(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "es", value)

    @property
    @pulumi.getter
    def firehose(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Kinesis Data Firehose
        """
        return pulumi.get(self, "firehose")

    @firehose.setter
    def firehose(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "firehose", value)

    @property
    @pulumi.getter
    def fms(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Firewall Manager
        """
        return pulumi.get(self, "fms")

    @fms.setter
    def fms(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fms", value)

    @property
    @pulumi.getter
    def forecast(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon Forecast
        """
        return pulumi.get(self, "forecast")

    @forecast.setter
    def forecast(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "forecast", value)

    @property
    @pulumi.getter
    def fsx(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS FSx
        """
        return pulumi.get(self, "fsx")

    @fsx.setter
    def fsx(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fsx", value)

    @property
    @pulumi.getter
    def gamelift(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS GameLift
        """
        return pulumi.get(self, "gamelift")

    @gamelift.setter
    def gamelift(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gamelift", value)

    @property
    @pulumi.getter
    def glacier(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon S3 Glacier
        """
        return pulumi.get(self, "glacier")

    @glacier.setter
    def glacier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "glacier", value)

    @property
    @pulumi.getter
    def globalaccelerator(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Global Accelerator
        """
        return pulumi.get(self, "globalaccelerator")

    @globalaccelerator.setter
    def globalaccelerator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "globalaccelerator", value)

    @property
    @pulumi.getter
    def glue(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Glue
        """
        return pulumi.get(self, "glue")

    @glue.setter
    def glue(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "glue", value)

    @property
    @pulumi.getter
    def greengrass(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS IoT Greengrass
        """
        return pulumi.get(self, "greengrass")

    @greengrass.setter
    def greengrass(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "greengrass", value)

    @property
    @pulumi.getter
    def guardduty(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS GuardDuty
        """
        return pulumi.get(self, "guardduty")

    @guardduty.setter
    def guardduty(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "guardduty", value)

    @property
    @pulumi.getter
    def iam(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Identity and Access Management
        """
        return pulumi.get(self, "iam")

    @iam.setter
    def iam(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iam", value)

    @property
    @pulumi.getter
    def identitystore(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Single Sign-On (SSO) Identity Store
        """
        return pulumi.get(self, "identitystore")

    @identitystore.setter
    def identitystore(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identitystore", value)

    @property
    @pulumi.getter
    def imagebuilder(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Image Builder
        """
        return pulumi.get(self, "imagebuilder")

    @imagebuilder.setter
    def imagebuilder(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "imagebuilder", value)

    @property
    @pulumi.getter
    def inspector(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon Inspector
        """
        return pulumi.get(self, "inspector")

    @inspector.setter
    def inspector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "inspector", value)

    @property
    @pulumi.getter
    def iot(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS IoT
        """
        return pulumi.get(self, "iot")

    @iot.setter
    def iot(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iot", value)

    @property
    @pulumi.getter
    def iotanalytics(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS IoT Analytics
        """
        return pulumi.get(self, "iotanalytics")

    @iotanalytics.setter
    def iotanalytics(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iotanalytics", value)

    @property
    @pulumi.getter
    def iotevents(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS IoT Events
        """
        return pulumi.get(self, "iotevents")

    @iotevents.setter
    def iotevents(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iotevents", value)

    @property
    @pulumi.getter
    def kafka(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon Managed Streaming for Apache Kafka (MSK)
        """
        return pulumi.get(self, "kafka")

    @kafka.setter
    def kafka(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kafka", value)

    @property
    @pulumi.getter
    def kinesis(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon Kinesis
        """
        return pulumi.get(self, "kinesis")

    @kinesis.setter
    def kinesis(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kinesis", value)

    @property
    @pulumi.getter
    def kinesisanalytics(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon Kinesis Data Analytics
        """
        return pulumi.get(self, "kinesisanalytics")

    @kinesisanalytics.setter
    def kinesisanalytics(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kinesisanalytics", value)

    @property
    @pulumi.getter
    def kinesisanalyticsv2(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon Kinesis Data Analytics V2
        """
        return pulumi.get(self, "kinesisanalyticsv2")

    @kinesisanalyticsv2.setter
    def kinesisanalyticsv2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kinesisanalyticsv2", value)

    @property
    @pulumi.getter
    def kinesisvideo(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon Kinesis Video Streams
        """
        return pulumi.get(self, "kinesisvideo")

    @kinesisvideo.setter
    def kinesisvideo(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kinesisvideo", value)

    @property
    @pulumi.getter
    def kms(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Key Management Service
        """
        return pulumi.get(self, "kms")

    @kms.setter
    def kms(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms", value)

    @property
    @pulumi.getter
    def lakeformation(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Lake Formation
        """
        return pulumi.get(self, "lakeformation")

    @lakeformation.setter
    def lakeformation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lakeformation", value)

    @property
    @pulumi.getter(name="lambda")
    def lambda_(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Lambda
        """
        return pulumi.get(self, "lambda_")

    @lambda_.setter
    def lambda_(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lambda_", value)

    @property
    @pulumi.getter
    def lexmodels(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon Lex
        """
        return pulumi.get(self, "lexmodels")

    @lexmodels.setter
    def lexmodels(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lexmodels", value)

    @property
    @pulumi.getter
    def licensemanager(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS License Manager
        """
        return pulumi.get(self, "licensemanager")

    @licensemanager.setter
    def licensemanager(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "licensemanager", value)

    @property
    @pulumi.getter
    def lightsail(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon Lightsail
        """
        return pulumi.get(self, "lightsail")

    @lightsail.setter
    def lightsail(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lightsail", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon Location
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def macie(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon Macie
        """
        return pulumi.get(self, "macie")

    @macie.setter
    def macie(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "macie", value)

    @property
    @pulumi.getter
    def macie2(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon Macie V2
        """
        return pulumi.get(self, "macie2")

    @macie2.setter
    def macie2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "macie2", value)

    @property
    @pulumi.getter
    def managedblockchain(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon Managed Blockchain
        """
        return pulumi.get(self, "managedblockchain")

    @managedblockchain.setter
    def managedblockchain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "managedblockchain", value)

    @property
    @pulumi.getter
    def marketplacecatalog(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Marketplace Catalog
        """
        return pulumi.get(self, "marketplacecatalog")

    @marketplacecatalog.setter
    def marketplacecatalog(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "marketplacecatalog", value)

    @property
    @pulumi.getter
    def mediaconnect(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS MediaConnect
        """
        return pulumi.get(self, "mediaconnect")

    @mediaconnect.setter
    def mediaconnect(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mediaconnect", value)

    @property
    @pulumi.getter
    def mediaconvert(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS MediaConvert
        """
        return pulumi.get(self, "mediaconvert")

    @mediaconvert.setter
    def mediaconvert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mediaconvert", value)

    @property
    @pulumi.getter
    def medialive(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS MediaLive
        """
        return pulumi.get(self, "medialive")

    @medialive.setter
    def medialive(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "medialive", value)

    @property
    @pulumi.getter
    def mediapackage(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS MediaPackage
        """
        return pulumi.get(self, "mediapackage")

    @mediapackage.setter
    def mediapackage(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mediapackage", value)

    @property
    @pulumi.getter
    def mediastore(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Elemental MediaStore container
        """
        return pulumi.get(self, "mediastore")

    @mediastore.setter
    def mediastore(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mediastore", value)

    @property
    @pulumi.getter
    def mediastoredata(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Elemental MediaStore asset
        """
        return pulumi.get(self, "mediastoredata")

    @mediastoredata.setter
    def mediastoredata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mediastoredata", value)

    @property
    @pulumi.getter
    def memorydb(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS MemoryDB for Redis
        """
        return pulumi.get(self, "memorydb")

    @memorydb.setter
    def memorydb(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "memorydb", value)

    @property
    @pulumi.getter
    def mq(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon MQ
        """
        return pulumi.get(self, "mq")

    @mq.setter
    def mq(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mq", value)

    @property
    @pulumi.getter
    def mwaa(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon Managed Workflows for Apache Airflow
        """
        return pulumi.get(self, "mwaa")

    @mwaa.setter
    def mwaa(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mwaa", value)

    @property
    @pulumi.getter
    def neptune(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon Neptune
        """
        return pulumi.get(self, "neptune")

    @neptune.setter
    def neptune(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "neptune", value)

    @property
    @pulumi.getter
    def networkfirewall(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Network Firewall
        """
        return pulumi.get(self, "networkfirewall")

    @networkfirewall.setter
    def networkfirewall(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "networkfirewall", value)

    @property
    @pulumi.getter
    def networkmanager(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Network Manager
        """
        return pulumi.get(self, "networkmanager")

    @networkmanager.setter
    def networkmanager(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "networkmanager", value)

    @property
    @pulumi.getter
    def opsworks(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS OpsWorks
        """
        return pulumi.get(self, "opsworks")

    @opsworks.setter
    def opsworks(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "opsworks", value)

    @property
    @pulumi.getter
    def organizations(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Organizations
        """
        return pulumi.get(self, "organizations")

    @organizations.setter
    def organizations(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organizations", value)

    @property
    @pulumi.getter
    def outposts(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Outposts
        """
        return pulumi.get(self, "outposts")

    @outposts.setter
    def outposts(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "outposts", value)

    @property
    @pulumi.getter
    def personalize(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon Personalize
        """
        return pulumi.get(self, "personalize")

    @personalize.setter
    def personalize(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "personalize", value)

    @property
    @pulumi.getter
    def pinpoint(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon Pinpoint
        """
        return pulumi.get(self, "pinpoint")

    @pinpoint.setter
    def pinpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pinpoint", value)

    @property
    @pulumi.getter
    def pricing(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon Web Services Price List Service
        """
        return pulumi.get(self, "pricing")

    @pricing.setter
    def pricing(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pricing", value)

    @property
    @pulumi.getter
    def qldb(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon QLDB
        """
        return pulumi.get(self, "qldb")

    @qldb.setter
    def qldb(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "qldb", value)

    @property
    @pulumi.getter
    def quicksight(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon QuickSight
        """
        return pulumi.get(self, "quicksight")

    @quicksight.setter
    def quicksight(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "quicksight", value)

    @property
    @pulumi.getter
    def ram(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Resource Access Manager
        """
        return pulumi.get(self, "ram")

    @ram.setter
    def ram(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ram", value)

    @property
    @pulumi.getter
    def rds(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon Relational Database Service
        """
        return pulumi.get(self, "rds")

    @rds.setter
    def rds(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rds", value)

    @property
    @pulumi.getter
    def redshift(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon Redshift
        """
        return pulumi.get(self, "redshift")

    @redshift.setter
    def redshift(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redshift", value)

    @property
    @pulumi.getter
    def resourcegroups(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Resource Groups
        """
        return pulumi.get(self, "resourcegroups")

    @resourcegroups.setter
    def resourcegroups(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resourcegroups", value)

    @property
    @pulumi.getter
    def resourcegroupstaggingapi(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Resource Groups Tagging API
        """
        return pulumi.get(self, "resourcegroupstaggingapi")

    @resourcegroupstaggingapi.setter
    def resourcegroupstaggingapi(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resourcegroupstaggingapi", value)

    @property
    @pulumi.getter
    def route53(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon Route 53
        """
        return pulumi.get(self, "route53")

    @route53.setter
    def route53(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "route53", value)

    @property
    @pulumi.getter
    def route53domains(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon Route 53 Domains
        """
        return pulumi.get(self, "route53domains")

    @route53domains.setter
    def route53domains(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "route53domains", value)

    @property
    @pulumi.getter
    def route53recoverycontrolconfig(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon Route 53 Recovery Control
        """
        return pulumi.get(self, "route53recoverycontrolconfig")

    @route53recoverycontrolconfig.setter
    def route53recoverycontrolconfig(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "route53recoverycontrolconfig", value)

    @property
    @pulumi.getter
    def route53recoveryreadiness(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon Route 53 Recovery Readiness
        """
        return pulumi.get(self, "route53recoveryreadiness")

    @route53recoveryreadiness.setter
    def route53recoveryreadiness(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "route53recoveryreadiness", value)

    @property
    @pulumi.getter
    def route53resolver(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon Route 53 Resolver
        """
        return pulumi.get(self, "route53resolver")

    @route53resolver.setter
    def route53resolver(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "route53resolver", value)

    @property
    @pulumi.getter
    def s3(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon Simple Storage Service (S3)
        """
        return pulumi.get(self, "s3")

    @s3.setter
    def s3(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3", value)

    @property
    @pulumi.getter
    def s3control(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon Simple Storage Service (S3) Control
        """
        return pulumi.get(self, "s3control")

    @s3control.setter
    def s3control(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3control", value)

    @property
    @pulumi.getter
    def s3outposts(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon S3 on Outposts
        """
        return pulumi.get(self, "s3outposts")

    @s3outposts.setter
    def s3outposts(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3outposts", value)

    @property
    @pulumi.getter
    def sagemaker(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS SageMaker
        """
        return pulumi.get(self, "sagemaker")

    @sagemaker.setter
    def sagemaker(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sagemaker", value)

    @property
    @pulumi.getter
    def schemas(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon EventBridge Schema Registry
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter
    def sdb(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon SimpleDB
        """
        return pulumi.get(self, "sdb")

    @sdb.setter
    def sdb(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sdb", value)

    @property
    @pulumi.getter
    def secretsmanager(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Secrets Manager
        """
        return pulumi.get(self, "secretsmanager")

    @secretsmanager.setter
    def secretsmanager(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secretsmanager", value)

    @property
    @pulumi.getter
    def securityhub(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Security Hub
        """
        return pulumi.get(self, "securityhub")

    @securityhub.setter
    def securityhub(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "securityhub", value)

    @property
    @pulumi.getter
    def serverlessrepo(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Serverless Application Repository
        """
        return pulumi.get(self, "serverlessrepo")

    @serverlessrepo.setter
    def serverlessrepo(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "serverlessrepo", value)

    @property
    @pulumi.getter
    def servicecatalog(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Service Catalog
        """
        return pulumi.get(self, "servicecatalog")

    @servicecatalog.setter
    def servicecatalog(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "servicecatalog", value)

    @property
    @pulumi.getter
    def servicediscovery(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Cloud Map
        """
        return pulumi.get(self, "servicediscovery")

    @servicediscovery.setter
    def servicediscovery(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "servicediscovery", value)

    @property
    @pulumi.getter
    def servicequotas(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Service Quotas
        """
        return pulumi.get(self, "servicequotas")

    @servicequotas.setter
    def servicequotas(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "servicequotas", value)

    @property
    @pulumi.getter
    def ses(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon Simple Email Service (SES)
        """
        return pulumi.get(self, "ses")

    @ses.setter
    def ses(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ses", value)

    @property
    @pulumi.getter
    def shield(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Shield Advanced API
        """
        return pulumi.get(self, "shield")

    @shield.setter
    def shield(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shield", value)

    @property
    @pulumi.getter
    def signer(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Signer
        """
        return pulumi.get(self, "signer")

    @signer.setter
    def signer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signer", value)

    @property
    @pulumi.getter
    def sns(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon Simple Notification Service (SNS)
        """
        return pulumi.get(self, "sns")

    @sns.setter
    def sns(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sns", value)

    @property
    @pulumi.getter
    def sqs(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon Simple Queue Service (SQS)
        """
        return pulumi.get(self, "sqs")

    @sqs.setter
    def sqs(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sqs", value)

    @property
    @pulumi.getter
    def ssm(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Systems Manager
        """
        return pulumi.get(self, "ssm")

    @ssm.setter
    def ssm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssm", value)

    @property
    @pulumi.getter
    def ssoadmin(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Single Sign On (SSO)
        """
        return pulumi.get(self, "ssoadmin")

    @ssoadmin.setter
    def ssoadmin(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssoadmin", value)

    @property
    @pulumi.getter
    def stepfunctions(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Step Functions
        """
        return pulumi.get(self, "stepfunctions")

    @stepfunctions.setter
    def stepfunctions(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stepfunctions", value)

    @property
    @pulumi.getter
    def storagegateway(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Storage Gateway
        """
        return pulumi.get(self, "storagegateway")

    @storagegateway.setter
    def storagegateway(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storagegateway", value)

    @property
    @pulumi.getter
    def sts(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Security Token Service (STS)
        """
        return pulumi.get(self, "sts")

    @sts.setter
    def sts(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sts", value)

    @property
    @pulumi.getter
    def swf(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon Simple Workflow Service (SWF)
        """
        return pulumi.get(self, "swf")

    @swf.setter
    def swf(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "swf", value)

    @property
    @pulumi.getter
    def synthetics(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon CloudWatch Synthetics
        """
        return pulumi.get(self, "synthetics")

    @synthetics.setter
    def synthetics(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "synthetics", value)

    @property
    @pulumi.getter
    def timestreamwrite(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon Timestream
        """
        return pulumi.get(self, "timestreamwrite")

    @timestreamwrite.setter
    def timestreamwrite(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timestreamwrite", value)

    @property
    @pulumi.getter
    def transfer(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS Transfer Family
        """
        return pulumi.get(self, "transfer")

    @transfer.setter
    def transfer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transfer", value)

    @property
    @pulumi.getter
    def waf(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS WAF Classic
        """
        return pulumi.get(self, "waf")

    @waf.setter
    def waf(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "waf", value)

    @property
    @pulumi.getter
    def wafregional(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS WAF Regional Classic
        """
        return pulumi.get(self, "wafregional")

    @wafregional.setter
    def wafregional(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wafregional", value)

    @property
    @pulumi.getter
    def wafv2(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS WAF V2
        """
        return pulumi.get(self, "wafv2")

    @wafv2.setter
    def wafv2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wafv2", value)

    @property
    @pulumi.getter
    def worklink(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon WorkLink
        """
        return pulumi.get(self, "worklink")

    @worklink.setter
    def worklink(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "worklink", value)

    @property
    @pulumi.getter
    def workmail(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon WorkMail
        """
        return pulumi.get(self, "workmail")

    @workmail.setter
    def workmail(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workmail", value)

    @property
    @pulumi.getter
    def workspaces(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for Amazon WorkSpaces
        """
        return pulumi.get(self, "workspaces")

    @workspaces.setter
    def workspaces(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workspaces", value)

    @property
    @pulumi.getter
    def xray(self) -> Optional[pulumi.Input[str]]:
        """
        Override the default endpoint for AWS X-Ray
        """
        return pulumi.get(self, "xray")

    @xray.setter
    def xray(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "xray", value)


@pulumi.input_type
class ProviderIgnoreTagsArgs:
    def __init__(__self__, *,
                 key_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The configuration with resource tag settings to ignore across all resources handled by this provider (except any individual service tag resources such as `ec2.Tag`) for situations where external systems are managing certain resource tags.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] key_prefixes: List of exact resource tag keys to ignore across all resources handled by this provider. This configuration prevents Pulumi from returning the tag in any `tags` attributes and displaying any configuration difference for the tag value. If any resource configuration still has this tag key configured in the `tags` argument, it will display a perpetual difference until the tag is removed from the argument or `ignoreChanges` is also used.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] keys: List of resource tag key prefixes to ignore across all resources handled by this provider. This configuration prevents Pulumi from returning any tag key matching the prefixes in any `tags` attributes and displaying any configuration difference for those tag values. If any resource configuration still has a tag matching one of the prefixes configured in the `tags` argument, it will display a perpetual difference until the tag is removed from the argument or `ignoreChanges` is also used.
        """
        if key_prefixes is not None:
            pulumi.set(__self__, "key_prefixes", key_prefixes)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)

    @property
    @pulumi.getter(name="keyPrefixes")
    def key_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of exact resource tag keys to ignore across all resources handled by this provider. This configuration prevents Pulumi from returning the tag in any `tags` attributes and displaying any configuration difference for the tag value. If any resource configuration still has this tag key configured in the `tags` argument, it will display a perpetual difference until the tag is removed from the argument or `ignoreChanges` is also used.
        """
        return pulumi.get(self, "key_prefixes")

    @key_prefixes.setter
    def key_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "key_prefixes", value)

    @property
    @pulumi.getter
    def keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of resource tag key prefixes to ignore across all resources handled by this provider. This configuration prevents Pulumi from returning any tag key matching the prefixes in any `tags` attributes and displaying any configuration difference for those tag values. If any resource configuration still has a tag matching one of the prefixes configured in the `tags` argument, it will display a perpetual difference until the tag is removed from the argument or `ignoreChanges` is also used.
        """
        return pulumi.get(self, "keys")

    @keys.setter
    def keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "keys", value)


