# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/CLI.ipynb.

# %% auto 0
__all__ = ['new', 'prepare', 'preview', 'docs', 'generate_social_image']

# %% ../nbs/CLI.ipynb 1
from typing import *
from pathlib import Path
from asyncio import run as aiorun

import typer

import nbdev_mkdocs
import nbdev_mkdocs.mkdocs

# %% ../nbs/CLI.ipynb 3
_app = typer.Typer(help="")


@_app.command(
    help="Creates files in **mkdocs** subdirectory needed for other **nbdev_mkdocs** subcommands",
)
def new(root_path: str = typer.Option(".", help="")):
    """CLI command for creating files for nbdev_mkdocs command"""
    try:
        nbdev_mkdocs.mkdocs.new(root_path=root_path)
    except Exception as e:
        typer.secho(f"Unexpected internal error: {e}", err=True, fg=typer.colors.RED)
        raise typer.Exit(1)


@_app.command(
    help="Runs tests and prepares files in **mkdocs/docs** and then runs **mkdocs build** command on them ",
)
def prepare(root_path: str = typer.Option(".", help="")):
    """CLI command for running tests and creating files for nbdev_mkdocs command"""
    try:
        nbdev_mkdocs.mkdocs.prepare(root_path=root_path)
    except Exception as e:
        typer.secho(f"Unexpected internal error: {e}", err=True, fg=typer.colors.RED)
        raise typer.Exit(1)


@_app.command(
    help="Prepares files in **mkdocs/docs** and then runs **mkdocs serve** command on them ",
)
def preview(
    root_path: str = typer.Option(
        ".", help="path under which mkdocs directory will be created"
    ),
    port: int = typer.Option(4000, help="port to use"),
):
    """CLI command for creating files for nbdev_mkdocs command"""
    try:
        nbdev_mkdocs.mkdocs.preview(root_path=root_path, port=port)
    except Exception as e:
        typer.secho(f"Unexpected internal error: {e}", err=True, fg=typer.colors.RED)
        raise typer.Exit(1)


@_app.command(
    help="Prepares files in **mkdocs/docs** and then runs **mkdocs build** command on them ",
)
def docs(root_path: str = typer.Option(".", help="Project's root path.")):
    """CLI command for creating files for nbdev_mkdocs command"""
    try:
        nbdev_mkdocs.mkdocs.nbdev_mkdocs_docs(
            root_path=root_path, refresh_quarto_settings=True
        )
    except Exception as e:
        typer.secho(f"Unexpected internal error: {e}", err=True, fg=typer.colors.RED)
        raise typer.Exit(1)


@_app.command(
    help="Generate a custom social share image",
)
def generate_social_image(
    root_path: str = typer.Option(".", help="Project's root path."),
    generator: nbdev_mkdocs.social_image_generator._IMG_Generator = typer.Option(
        "file",
        help="Generator to use to create the social image. Valid options are: 'file' and 'dall_e'. Choose 'file' if you want to use an existing image from your local machine in the social share image.",
    ),
    prompt: Optional[str] = typer.Option(
        "Cute animal wearing hoodie sitting in high chair in purple room, browsing computer, 3d render",
        help="The prompt to use for generating the image.",
    ),
    image_path: Optional[str] = typer.Option(
        None,
        help="Image file path to use in the social share image. Use images with a 1:1 aspect ratio and at least 512x512 pixels for the best results. If None, then the default image will be used.",
    ),
):
    """CLI command for generating a custom social share image"""

    async def _generate_social_image(root_path, generator, prompt, image_path):
        try:
            await nbdev_mkdocs.social_image_generator.generate_social_image(
                root_path=root_path,
                generator=generator,
                prompt=prompt,
                image_path=image_path,
            )
        except Exception as e:
            typer.secho(
                f"Unexpected internal error: {e}", err=True, fg=typer.colors.RED
            )
            raise typer.Exit(1)

    aiorun(_generate_social_image(root_path, generator, prompt, image_path))
