from ssc_codegen._compat import StrEnum

CONVERTERS_PATH = "ssc_codegen.converters"


# typer groups choice, later convert to converter module
# <lang_suffix>_<backend_lib>.py
class PyLIBS(StrEnum):
    BS4 = "bs4"
    PARSEL = "parsel"
    SELECTOLAX = "selectolax"
    LXML = "lxml"


class JsLIBS(StrEnum):
    PURE = "pure"


class GoLIBS(StrEnum):
    GOQUERY = "goquery"


class LuaLIBS(StrEnum):
    LUA_HTMLPARSER = "htmlparser"


COMMENT_STRING = "autogenerated by ssc-gen DO NOT EDIT"
# arguments helps
HELP_SSC_FILES_ARG = "ssc-gen config files"
HELP_OUTPUT_FOLDER = "output folder"
HELP_CORE_LIB = "core parser library"
HELP_FILE_PREFIX = "out files prefix (<prefix>+<out>)"
HELP_FILE_SUFFIX = "out files suffix (<out>+<suffix>)"
HELP_FMT = "format code output"
HELP_TO_XPATH = "convert all css queries to xpath"
HELP_TO_CSS = "convert all xpath queries to css (works not guaranteed)"
HELP_DEBUG_COMM_TOKENS = "add debug comment for each generated instruction"
HELP_JSON_TO_SCHEMA = "convert json response to ssc-gen schema"

HELP_LUA_PCRE_FLAG = "Use `lrexlib` dependency for PCRE regex syntax support or try convert to lua pattern matching syntax"

# cmd group description
HELP_DOCSTRING = "disable docstring and fields signature generate"
CMD_VERSION = "Show version and exit"
CMD_PY = "generate python modules"
CMD_JS = "generate javascript modules"
CMD_GO = "generate golang modules"
CMD_LUA = "generate lua modules"
CMD_JSON_GEN = """generate schema code from json.
entrypoint should be: map or array object and key starts as _[a-zA-Z] char
"""

DEFAULT_UA = (
    "Mozilla/5.0 (X11; Linux x86_64; rv:135.0) Gecko/20100101 Firefox/135.0"
)
