import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NamespaceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description for this namespace.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/namespace#description Namespace#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/namespace#id Namespace#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Metadata associated with the namespace.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/namespace#meta Namespace#meta}
    */
    readonly meta?: {
        [key: string]: string;
    };
    /**
    * Unique name for this namespace.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/namespace#name Namespace#name}
    */
    readonly name: string;
    /**
    * Quota to set for this namespace.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/namespace#quota Namespace#quota}
    */
    readonly quota?: string;
    /**
    * capabilities block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/namespace#capabilities Namespace#capabilities}
    */
    readonly capabilities?: NamespaceCapabilities;
}
export interface NamespaceCapabilities {
    /**
    * Disabled task drivers for the namespace.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/namespace#disabled_task_drivers Namespace#disabled_task_drivers}
    */
    readonly disabledTaskDrivers?: string[];
    /**
    * Enabled task drivers for the namespace.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/namespace#enabled_task_drivers Namespace#enabled_task_drivers}
    */
    readonly enabledTaskDrivers?: string[];
}
export declare function namespaceCapabilitiesToTerraform(struct?: NamespaceCapabilitiesOutputReference | NamespaceCapabilities): any;
export declare class NamespaceCapabilitiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NamespaceCapabilities | undefined;
    set internalValue(value: NamespaceCapabilities | undefined);
    private _disabledTaskDrivers?;
    get disabledTaskDrivers(): string[];
    set disabledTaskDrivers(value: string[]);
    resetDisabledTaskDrivers(): void;
    get disabledTaskDriversInput(): string[] | undefined;
    private _enabledTaskDrivers?;
    get enabledTaskDrivers(): string[];
    set enabledTaskDrivers(value: string[]);
    resetEnabledTaskDrivers(): void;
    get enabledTaskDriversInput(): string[] | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/nomad/r/namespace nomad_namespace}
*/
export declare class Namespace extends cdktf.TerraformResource {
    static readonly tfResourceType = "nomad_namespace";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/nomad/r/namespace nomad_namespace} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NamespaceConfig
    */
    constructor(scope: Construct, id: string, config: NamespaceConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _meta?;
    get meta(): {
        [key: string]: string;
    };
    set meta(value: {
        [key: string]: string;
    });
    resetMeta(): void;
    get metaInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _quota?;
    get quota(): string;
    set quota(value: string);
    resetQuota(): void;
    get quotaInput(): string | undefined;
    private _capabilities;
    get capabilities(): NamespaceCapabilitiesOutputReference;
    putCapabilities(value: NamespaceCapabilities): void;
    resetCapabilities(): void;
    get capabilitiesInput(): NamespaceCapabilities | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
