import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataNomadSchedulerConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/d/scheduler_config#id DataNomadSchedulerConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/nomad/d/scheduler_config nomad_scheduler_config}
*/
export declare class DataNomadSchedulerConfig extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "nomad_scheduler_config";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/nomad/d/scheduler_config nomad_scheduler_config} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataNomadSchedulerConfigConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataNomadSchedulerConfigConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get memoryOversubscriptionEnabled(): cdktf.IResolvable;
    private _preemptionConfig;
    get preemptionConfig(): cdktf.BooleanMap;
    get schedulerAlgorithm(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
