import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AclTokenConfig extends cdktf.TerraformMetaArguments {
    /**
    * Provides a TTL for the token in the form of a time duration such as "5m" or "1h".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/acl_token#expiration_ttl AclToken#expiration_ttl}
    */
    readonly expirationTtl?: string;
    /**
    * Whether the token should be replicated to all regions or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/acl_token#global AclToken#global}
    */
    readonly global?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/acl_token#id AclToken#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Human-readable name for this token.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/acl_token#name AclToken#name}
    */
    readonly name?: string;
    /**
    * The ACL policies to associate with the token, if it's a 'client' type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/acl_token#policies AclToken#policies}
    */
    readonly policies?: string[];
    /**
    * The type of token to create, 'client' or 'management'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/acl_token#type AclToken#type}
    */
    readonly type: string;
    /**
    * role block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/acl_token#role AclToken#role}
    */
    readonly role?: AclTokenRole[] | cdktf.IResolvable;
}
export interface AclTokenRole {
    /**
    * The ID of the ACL role to link.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/nomad/r/acl_token#id AclToken#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
}
export declare function aclTokenRoleToTerraform(struct?: AclTokenRole | cdktf.IResolvable): any;
export declare class AclTokenRoleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AclTokenRole | cdktf.IResolvable | undefined;
    set internalValue(value: AclTokenRole | cdktf.IResolvable | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    get name(): string;
}
export declare class AclTokenRoleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AclTokenRole[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AclTokenRoleOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/nomad/r/acl_token nomad_acl_token}
*/
export declare class AclToken extends cdktf.TerraformResource {
    static readonly tfResourceType = "nomad_acl_token";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/nomad/r/acl_token nomad_acl_token} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AclTokenConfig
    */
    constructor(scope: Construct, id: string, config: AclTokenConfig);
    get accessorId(): string;
    get createTime(): string;
    get expirationTime(): string;
    private _expirationTtl?;
    get expirationTtl(): string;
    set expirationTtl(value: string);
    resetExpirationTtl(): void;
    get expirationTtlInput(): string | undefined;
    private _global?;
    get global(): boolean | cdktf.IResolvable;
    set global(value: boolean | cdktf.IResolvable);
    resetGlobal(): void;
    get globalInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _policies?;
    get policies(): string[];
    set policies(value: string[]);
    resetPolicies(): void;
    get policiesInput(): string[] | undefined;
    get secretId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _role;
    get role(): AclTokenRoleList;
    putRole(value: AclTokenRole[] | cdktf.IResolvable): void;
    resetRole(): void;
    get roleInput(): cdktf.IResolvable | AclTokenRole[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
