"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hashValues = void 0;
const crypto = require("crypto");
/**
 * Generates a unique hash identfifer using SHA256 encryption algorithm
 */
function hashValues(...ids) {
    const sha256 = crypto.createHash('sha256');
    ids.forEach(val => sha256.update(val));
    return sha256.digest('hex').slice(0, 12);
}
exports.hashValues = hashValues;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInV0aWwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsaUNBQWlDO0FBRWpDOztHQUVHO0FBQ0gsU0FBZ0IsVUFBVSxDQUFDLEdBQUcsR0FBYTtJQUN6QyxNQUFNLE1BQU0sR0FBRyxNQUFNLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDO0lBQzNDLEdBQUcsQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7SUFDdkMsT0FBTyxNQUFNLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDLEtBQUssQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUM7QUFDM0MsQ0FBQztBQUpELGdDQUlDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY3J5cHRvIGZyb20gJ2NyeXB0byc7XG5cbi8qKlxuICogR2VuZXJhdGVzIGEgdW5pcXVlIGhhc2ggaWRlbnRmaWZlciB1c2luZyBTSEEyNTYgZW5jcnlwdGlvbiBhbGdvcml0aG1cbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIGhhc2hWYWx1ZXMoLi4uaWRzOiBzdHJpbmdbXSk6IHN0cmluZyB7XG4gIGNvbnN0IHNoYTI1NiA9IGNyeXB0by5jcmVhdGVIYXNoKCdzaGEyNTYnKTtcbiAgaWRzLmZvckVhY2godmFsID0+IHNoYTI1Ni51cGRhdGUodmFsKSk7XG4gIHJldHVybiBzaGEyNTYuZGlnZXN0KCdoZXgnKS5zbGljZSgwLCAxMik7XG59XG4iXX0=