import web3

address = web3.Web3().toChecksumAddress("0xf38593388079f7f5130d605e38abf6090d981ec2")
ABI = [
    {"type": "constructor", "inputs": [], "stateMutability": "nonpayable"},
    {
        "anonymous": False,
        "inputs": [
            {
                "name": "owner",
                "type": "address",
                "internalType": "address",
                "indexed": True,
            },
            {
                "name": "spender",
                "type": "address",
                "indexed": True,
                "internalType": "address",
            },
            {
                "type": "uint256",
                "internalType": "uint256",
                "name": "value",
                "indexed": False,
            },
        ],
        "name": "Approval",
        "type": "event",
    },
    {
        "type": "event",
        "name": "LogRebase",
        "anonymous": False,
        "inputs": [
            {
                "name": "epoch",
                "type": "uint256",
                "internalType": "uint256",
                "indexed": True,
            },
            {
                "name": "rebase",
                "internalType": "uint256",
                "indexed": False,
                "type": "uint256",
            },
            {
                "type": "uint256",
                "internalType": "uint256",
                "indexed": False,
                "name": "index",
            },
        ],
    },
    {
        "anonymous": False,
        "inputs": [
            {
                "internalType": "address",
                "indexed": False,
                "name": "stakingContract",
                "type": "address",
            }
        ],
        "type": "event",
        "name": "LogStakingContractUpdated",
    },
    {
        "name": "LogSupply",
        "type": "event",
        "anonymous": False,
        "inputs": [
            {
                "name": "epoch",
                "type": "uint256",
                "indexed": True,
                "internalType": "uint256",
            },
            {
                "indexed": False,
                "name": "timestamp",
                "internalType": "uint256",
                "type": "uint256",
            },
            {
                "type": "uint256",
                "name": "totalSupply",
                "internalType": "uint256",
                "indexed": False,
            },
        ],
    },
    {
        "anonymous": False,
        "type": "event",
        "name": "OwnershipTransferred",
        "inputs": [
            {
                "name": "previousOwner",
                "type": "address",
                "indexed": True,
                "internalType": "address",
            },
            {
                "type": "address",
                "indexed": True,
                "name": "newOwner",
                "internalType": "address",
            },
        ],
    },
    {
        "inputs": [
            {
                "internalType": "address",
                "name": "from",
                "type": "address",
                "indexed": True,
            },
            {
                "indexed": True,
                "internalType": "address",
                "name": "to",
                "type": "address",
            },
            {
                "indexed": False,
                "name": "value",
                "type": "uint256",
                "internalType": "uint256",
            },
        ],
        "type": "event",
        "anonymous": False,
        "name": "Transfer",
    },
    {
        "name": "DOMAIN_SEPARATOR",
        "type": "function",
        "inputs": [],
        "outputs": [{"internalType": "bytes32", "name": "", "type": "bytes32"}],
        "stateMutability": "view",
        "constant": True,
        "signature": "0x3644e515",
    },
    {
        "type": "function",
        "name": "INDEX",
        "outputs": [{"name": "", "type": "uint256", "internalType": "uint256"}],
        "stateMutability": "view",
        "inputs": [],
        "constant": True,
        "signature": "0x2df75cb1",
    },
    {
        "inputs": [],
        "name": "PERMIT_TYPEHASH",
        "outputs": [{"type": "bytes32", "internalType": "bytes32", "name": ""}],
        "type": "function",
        "stateMutability": "view",
        "constant": True,
        "signature": "0x30adf81f",
    },
    {
        "inputs": [],
        "name": "decimals",
        "type": "function",
        "stateMutability": "view",
        "outputs": [{"internalType": "uint8", "name": "", "type": "uint8"}],
        "constant": True,
        "signature": "0x313ce567",
    },
    {
        "outputs": [{"type": "address", "name": "", "internalType": "address"}],
        "inputs": [],
        "stateMutability": "view",
        "name": "initializer",
        "type": "function",
        "constant": True,
        "signature": "0x9ce110d7",
    },
    {
        "inputs": [],
        "outputs": [{"type": "string", "internalType": "string", "name": ""}],
        "name": "name",
        "stateMutability": "view",
        "type": "function",
        "constant": True,
        "signature": "0x06fdde03",
    },
    {
        "type": "function",
        "stateMutability": "view",
        "name": "nonces",
        "outputs": [{"internalType": "uint256", "name": "", "type": "uint256"}],
        "inputs": [{"internalType": "address", "name": "owner", "type": "address"}],
    },
    {
        "stateMutability": "nonpayable",
        "inputs": [
            {"type": "address", "name": "owner", "internalType": "address"},
            {"name": "spender", "type": "address", "internalType": "address"},
            {"name": "amount", "internalType": "uint256", "type": "uint256"},
            {"type": "uint256", "internalType": "uint256", "name": "deadline"},
            {"name": "v", "type": "uint8", "internalType": "uint8"},
            {"name": "r", "type": "bytes32", "internalType": "bytes32"},
            {"name": "s", "type": "bytes32", "internalType": "bytes32"},
        ],
        "type": "function",
        "outputs": [],
        "name": "permit",
    },
    {
        "stateMutability": "view",
        "inputs": [],
        "type": "function",
        "outputs": [{"type": "address", "internalType": "address", "name": ""}],
        "name": "policy",
        "constant": True,
        "signature": "0x0505c8c9",
    },
    {
        "name": "pullPolicy",
        "outputs": [],
        "inputs": [],
        "stateMutability": "nonpayable",
        "type": "function",
    },
    {
        "name": "pushPolicy",
        "stateMutability": "nonpayable",
        "inputs": [
            {"name": "newPolicy_", "type": "address", "internalType": "address"}
        ],
        "outputs": [],
        "type": "function",
    },
    {
        "name": "rebases",
        "type": "function",
        "stateMutability": "view",
        "outputs": [
            {"type": "uint256", "name": "epoch", "internalType": "uint256"},
            {"internalType": "uint256", "type": "uint256", "name": "rebase"},
            {"name": "totalStakedBefore", "internalType": "uint256", "type": "uint256"},
            {"internalType": "uint256", "name": "totalStakedAfter", "type": "uint256"},
            {"type": "uint256", "internalType": "uint256", "name": "amountRebased"},
            {"name": "index", "internalType": "uint256", "type": "uint256"},
            {"type": "uint32", "name": "timeOccured", "internalType": "uint32"},
        ],
        "inputs": [{"type": "uint256", "name": "", "internalType": "uint256"}],
    },
    {
        "name": "renouncePolicy",
        "type": "function",
        "stateMutability": "nonpayable",
        "inputs": [],
        "outputs": [],
    },
    {
        "name": "stakingContract",
        "stateMutability": "view",
        "inputs": [],
        "type": "function",
        "outputs": [{"type": "address", "name": "", "internalType": "address"}],
        "constant": True,
        "signature": "0xee99205c",
    },
    {
        "stateMutability": "view",
        "type": "function",
        "outputs": [{"name": "", "type": "string", "internalType": "string"}],
        "name": "symbol",
        "inputs": [],
        "constant": True,
        "signature": "0x95d89b41",
    },
    {
        "type": "function",
        "inputs": [],
        "outputs": [{"internalType": "uint256", "name": "", "type": "uint256"}],
        "name": "totalSupply",
        "stateMutability": "view",
        "constant": True,
        "signature": "0x18160ddd",
    },
    {
        "type": "function",
        "inputs": [
            {"internalType": "address", "type": "address", "name": "stakingContract_"}
        ],
        "outputs": [{"internalType": "bool", "name": "", "type": "bool"}],
        "name": "initialize",
        "stateMutability": "nonpayable",
    },
    {
        "type": "function",
        "inputs": [{"name": "_INDEX", "type": "uint256", "internalType": "uint256"}],
        "name": "setIndex",
        "stateMutability": "nonpayable",
        "outputs": [{"internalType": "bool", "name": "", "type": "bool"}],
    },
    {
        "type": "function",
        "inputs": [
            {"name": "profit_", "internalType": "uint256", "type": "uint256"},
            {"name": "epoch_", "type": "uint256", "internalType": "uint256"},
        ],
        "name": "rebase",
        "stateMutability": "nonpayable",
        "outputs": [{"internalType": "uint256", "name": "", "type": "uint256"}],
    },
    {
        "outputs": [{"name": "", "type": "uint256", "internalType": "uint256"}],
        "name": "balanceOf",
        "type": "function",
        "stateMutability": "view",
        "inputs": [{"internalType": "address", "type": "address", "name": "who"}],
    },
    {
        "type": "function",
        "inputs": [{"name": "amount", "type": "uint256", "internalType": "uint256"}],
        "outputs": [{"internalType": "uint256", "type": "uint256", "name": ""}],
        "name": "gonsForBalance",
        "stateMutability": "view",
    },
    {
        "type": "function",
        "inputs": [{"internalType": "uint256", "type": "uint256", "name": "gons"}],
        "name": "balanceForGons",
        "stateMutability": "view",
        "outputs": [{"internalType": "uint256", "type": "uint256", "name": ""}],
    },
    {
        "outputs": [{"type": "uint256", "name": "", "internalType": "uint256"}],
        "name": "circulatingSupply",
        "type": "function",
        "inputs": [],
        "stateMutability": "view",
        "constant": True,
        "signature": "0x9358928b",
    },
    {
        "name": "index",
        "outputs": [{"type": "uint256", "internalType": "uint256", "name": ""}],
        "inputs": [],
        "type": "function",
        "stateMutability": "view",
        "constant": True,
        "signature": "0x2986c0e5",
    },
    {
        "name": "transfer",
        "stateMutability": "nonpayable",
        "outputs": [{"internalType": "bool", "name": "", "type": "bool"}],
        "type": "function",
        "inputs": [
            {"internalType": "address", "type": "address", "name": "to"},
            {"type": "uint256", "name": "value", "internalType": "uint256"},
        ],
    },
    {
        "inputs": [
            {"internalType": "address", "type": "address", "name": "owner_"},
            {"name": "spender", "type": "address", "internalType": "address"},
        ],
        "outputs": [{"name": "", "internalType": "uint256", "type": "uint256"}],
        "stateMutability": "view",
        "type": "function",
        "name": "allowance",
    },
    {
        "stateMutability": "nonpayable",
        "outputs": [{"type": "bool", "internalType": "bool", "name": ""}],
        "type": "function",
        "name": "transferFrom",
        "inputs": [
            {"internalType": "address", "type": "address", "name": "from"},
            {"internalType": "address", "type": "address", "name": "to"},
            {"internalType": "uint256", "type": "uint256", "name": "value"},
        ],
    },
    {
        "stateMutability": "nonpayable",
        "type": "function",
        "inputs": [
            {"type": "address", "internalType": "address", "name": "spender"},
            {"type": "uint256", "name": "value", "internalType": "uint256"},
        ],
        "name": "approve",
        "outputs": [{"internalType": "bool", "name": "", "type": "bool"}],
    },
    {
        "name": "increaseAllowance",
        "stateMutability": "nonpayable",
        "inputs": [
            {"name": "spender", "internalType": "address", "type": "address"},
            {"name": "addedValue", "type": "uint256", "internalType": "uint256"},
        ],
        "outputs": [{"name": "", "internalType": "bool", "type": "bool"}],
        "type": "function",
    },
    {
        "inputs": [
            {"type": "address", "name": "spender", "internalType": "address"},
            {"internalType": "uint256", "name": "subtractedValue", "type": "uint256"},
        ],
        "name": "decreaseAllowance",
        "outputs": [{"type": "bool", "internalType": "bool", "name": ""}],
        "stateMutability": "nonpayable",
        "type": "function",
    },
]
