import web3

address = web3.Web3().toChecksumAddress("0x0dc78c79b4eb080ead5c1d16559225a46b580694")
ABI = [
    {"inputs": [], "type": "constructor", "stateMutability": "nonpayable"},
    {
        "type": "event",
        "anonymous": False,
        "name": "Approval",
        "inputs": [
            {
                "indexed": True,
                "type": "address",
                "internalType": "address",
                "name": "owner",
            },
            {
                "name": "spender",
                "type": "address",
                "internalType": "address",
                "indexed": True,
            },
            {
                "indexed": False,
                "name": "value",
                "internalType": "uint256",
                "type": "uint256",
            },
        ],
    },
    {
        "anonymous": False,
        "name": "OwnershipTransferred",
        "type": "event",
        "inputs": [
            {
                "type": "address",
                "name": "previousOwner",
                "indexed": True,
                "internalType": "address",
            },
            {
                "name": "newOwner",
                "indexed": True,
                "type": "address",
                "internalType": "address",
            },
        ],
    },
    {
        "anonymous": False,
        "name": "Transfer",
        "type": "event",
        "inputs": [
            {
                "internalType": "address",
                "name": "from",
                "type": "address",
                "indexed": True,
            },
            {
                "name": "to",
                "type": "address",
                "internalType": "address",
                "indexed": True,
            },
            {
                "type": "uint256",
                "name": "value",
                "internalType": "uint256",
                "indexed": False,
            },
        ],
    },
    {
        "type": "function",
        "name": "DOMAIN_SEPARATOR",
        "stateMutability": "view",
        "inputs": [],
        "outputs": [{"type": "bytes32", "name": "", "internalType": "bytes32"}],
        "constant": True,
        "signature": "0x3644e515",
    },
    {
        "type": "function",
        "outputs": [{"internalType": "bytes32", "type": "bytes32", "name": ""}],
        "name": "PERMIT_TYPEHASH",
        "stateMutability": "view",
        "inputs": [],
        "constant": True,
        "signature": "0x30adf81f",
    },
    {
        "name": "allowance",
        "outputs": [{"name": "", "internalType": "uint256", "type": "uint256"}],
        "stateMutability": "view",
        "inputs": [
            {"type": "address", "name": "owner", "internalType": "address"},
            {"name": "spender", "internalType": "address", "type": "address"},
        ],
        "type": "function",
    },
    {
        "name": "approve",
        "type": "function",
        "stateMutability": "nonpayable",
        "inputs": [
            {"type": "address", "name": "spender", "internalType": "address"},
            {"type": "uint256", "internalType": "uint256", "name": "amount"},
        ],
        "outputs": [{"name": "", "type": "bool", "internalType": "bool"}],
    },
    {
        "type": "function",
        "inputs": [{"internalType": "address", "name": "account", "type": "address"}],
        "name": "balanceOf",
        "outputs": [{"internalType": "uint256", "type": "uint256", "name": ""}],
        "stateMutability": "view",
        "constant": True,
        "signature": "0x70a08231",
    },
    {
        "stateMutability": "view",
        "inputs": [],
        "type": "function",
        "name": "decimals",
        "outputs": [{"type": "uint8", "internalType": "uint8", "name": ""}],
        "constant": True,
        "signature": "0x313ce567",
    },
    {
        "outputs": [{"name": "", "type": "bool", "internalType": "bool"}],
        "inputs": [
            {"type": "address", "name": "spender", "internalType": "address"},
            {"internalType": "uint256", "name": "subtractedValue", "type": "uint256"},
        ],
        "type": "function",
        "name": "decreaseAllowance",
        "stateMutability": "nonpayable",
    },
    {
        "type": "function",
        "name": "increaseAllowance",
        "inputs": [
            {"type": "address", "name": "spender", "internalType": "address"},
            {"type": "uint256", "internalType": "uint256", "name": "addedValue"},
        ],
        "outputs": [{"internalType": "bool", "name": "", "type": "bool"}],
        "stateMutability": "nonpayable",
    },
    {
        "stateMutability": "view",
        "inputs": [],
        "outputs": [{"name": "", "type": "string", "internalType": "string"}],
        "type": "function",
        "name": "name",
        "constant": True,
        "signature": "0x06fdde03",
    },
    {
        "inputs": [{"internalType": "address", "type": "address", "name": "owner"}],
        "type": "function",
        "outputs": [{"name": "", "type": "uint256", "internalType": "uint256"}],
        "name": "nonces",
        "stateMutability": "view",
    },
    {
        "name": "owner",
        "stateMutability": "view",
        "outputs": [{"internalType": "address", "name": "", "type": "address"}],
        "type": "function",
        "inputs": [],
        "constant": True,
        "signature": "0x8da5cb5b",
    },
    {
        "outputs": [],
        "inputs": [
            {"internalType": "address", "type": "address", "name": "owner"},
            {"internalType": "address", "name": "spender", "type": "address"},
            {"internalType": "uint256", "type": "uint256", "name": "amount"},
            {"type": "uint256", "internalType": "uint256", "name": "deadline"},
            {"type": "uint8", "internalType": "uint8", "name": "v"},
            {"type": "bytes32", "name": "r", "internalType": "bytes32"},
            {"type": "bytes32", "internalType": "bytes32", "name": "s"},
        ],
        "name": "permit",
        "type": "function",
        "stateMutability": "nonpayable",
    },
    {
        "outputs": [],
        "stateMutability": "nonpayable",
        "name": "renounceOwnership",
        "type": "function",
        "inputs": [],
    },
    {
        "stateMutability": "nonpayable",
        "name": "setVault",
        "outputs": [{"type": "bool", "internalType": "bool", "name": ""}],
        "inputs": [{"internalType": "address", "type": "address", "name": "vault_"}],
        "type": "function",
    },
    {
        "outputs": [{"type": "string", "name": "", "internalType": "string"}],
        "type": "function",
        "inputs": [],
        "name": "symbol",
        "stateMutability": "view",
        "constant": True,
        "signature": "0x95d89b41",
    },
    {
        "stateMutability": "view",
        "name": "totalSupply",
        "inputs": [],
        "type": "function",
        "outputs": [{"type": "uint256", "name": "", "internalType": "uint256"}],
        "constant": True,
        "signature": "0x18160ddd",
    },
    {
        "type": "function",
        "stateMutability": "nonpayable",
        "name": "transfer",
        "inputs": [
            {"type": "address", "internalType": "address", "name": "recipient"},
            {"type": "uint256", "name": "amount", "internalType": "uint256"},
        ],
        "outputs": [{"type": "bool", "name": "", "internalType": "bool"}],
    },
    {
        "name": "transferFrom",
        "inputs": [
            {"name": "sender", "internalType": "address", "type": "address"},
            {"internalType": "address", "name": "recipient", "type": "address"},
            {"internalType": "uint256", "name": "amount", "type": "uint256"},
        ],
        "type": "function",
        "stateMutability": "nonpayable",
        "outputs": [{"internalType": "bool", "type": "bool", "name": ""}],
    },
    {
        "outputs": [],
        "name": "transferOwnership",
        "type": "function",
        "stateMutability": "nonpayable",
        "inputs": [{"type": "address", "name": "newOwner", "internalType": "address"}],
    },
    {
        "stateMutability": "view",
        "inputs": [],
        "name": "vault",
        "outputs": [{"internalType": "address", "name": "", "type": "address"}],
        "type": "function",
        "constant": True,
        "signature": "0xfbfa77cf",
    },
    {
        "type": "function",
        "outputs": [],
        "name": "mint",
        "stateMutability": "nonpayable",
        "inputs": [
            {"name": "account_", "internalType": "address", "type": "address"},
            {"internalType": "uint256", "name": "amount_", "type": "uint256"},
        ],
    },
    {
        "outputs": [],
        "stateMutability": "nonpayable",
        "type": "function",
        "name": "burn",
        "inputs": [{"type": "uint256", "name": "amount", "internalType": "uint256"}],
    },
    {
        "stateMutability": "nonpayable",
        "outputs": [],
        "inputs": [
            {"type": "address", "name": "account_", "internalType": "address"},
            {"type": "uint256", "name": "amount_", "internalType": "uint256"},
        ],
        "name": "burnFrom",
        "type": "function",
    },
    {
        "name": "_burnFrom",
        "inputs": [
            {"type": "address", "name": "account_", "internalType": "address"},
            {"internalType": "uint256", "name": "amount_", "type": "uint256"},
        ],
        "stateMutability": "nonpayable",
        "outputs": [],
        "type": "function",
    },
]
