#!/usr/bin/env python
# coding: utf-8

from setuptools import setup

def readme():
    with open("README.txt") as f:
        readme = f.read()
    return readme

classifiers = [
        "Intended Audience :: Science/Research",
        "Topic :: Scientific/Engineering :: Artificial Intelligence",
        "License :: OSI Approved :: Apache Software License",
        "Operating System :: Microsoft :: Windows :: Windows 10",
        "Programming Language :: Python :: 3",
    ]

setup(
    name = "toynn",
    version = "0.0.6",
    author = "KJ Chung",
    author_email = "kjchung495@yonsei.ac.kr",
    description = "DeepLearning Model Builder",
    long_description = readme(),
    long_description_content_type = "text/markdown",
    license = "Apache Software License 2.0",
    keywords = "ANN, Artifictial Neural Network, DeepLearning",
    url = "https://github.com/kjchung495/toynn",
    classifiers = classifiers,
    packages = ["toynn"],
    include_package_data = True,
    install_requires = ['numpy']
)

