# Generated by Django 3.2.13 on 2022-04-25 11:45

import django.db.models.deletion
import django_comments_ink.models
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("contenttypes", "0002_remove_content_type_name"),
        ("django_comments", "0004_add_object_pk_is_removed_index"),
        ("sites", "0002_alter_domain_unique"),
    ]

    operations = [
        migrations.CreateModel(
            name="BlackListedDomain",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("domain", models.CharField(db_index=True, max_length=200)),
            ],
            options={
                "ordering": ("domain",),
            },
        ),
        migrations.CreateModel(
            name="CommentReaction",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "reaction",
                    django_comments_ink.models.ReactionField(
                        db_index=True, verbose_name="reaction"
                    ),
                ),
                ("counter", models.IntegerField(default=0)),
            ],
            options={
                "verbose_name": "comment reactions",
                "verbose_name_plural": "comments reactions",
            },
        ),
        migrations.CreateModel(
            name="InkComment",
            fields=[
                (
                    "comment_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="django_comments.comment",
                    ),
                ),
                ("thread_id", models.IntegerField(db_index=True, default=0)),
                ("parent_id", models.IntegerField(default=0)),
                ("level", models.SmallIntegerField(default=0)),
                ("order", models.IntegerField(db_index=True, default=1)),
                (
                    "followup",
                    models.BooleanField(
                        blank=True,
                        default=False,
                        help_text="Notify follow-up comments",
                    ),
                ),
                ("nested_count", models.IntegerField(db_index=True, default=0)),
            ],
            options={
                "verbose_name": "comment",
                "verbose_name_plural": "comments",
                "ordering": ("submit_date",),
                "permissions": [("can_moderate", "Can moderate comments")],
                "abstract": False,
            },
            bases=("django_comments.comment",),
        ),
        migrations.CreateModel(
            name="ObjectReaction",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "reaction",
                    django_comments_ink.models.ReactionField(
                        db_index=True, verbose_name="reaction"
                    ),
                ),
                (
                    "object_pk",
                    models.CharField(
                        db_index=True, max_length=64, verbose_name="object ID"
                    ),
                ),
                ("counter", models.IntegerField(default=0)),
            ],
            options={
                "verbose_name": "object reactions",
                "verbose_name_plural": "objects reactions",
            },
        ),
        migrations.CreateModel(
            name="ObjectReactionAuthor",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "author",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "reaction",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="django_comments_ink.objectreaction",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="objectreaction",
            name="authors",
            field=models.ManyToManyField(
                through="django_comments_ink.ObjectReactionAuthor",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="objectreaction",
            name="content_type",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="content_type_set_for_objectreaction",
                to="contenttypes.contenttype",
                verbose_name="content type",
            ),
        ),
        migrations.AddField(
            model_name="objectreaction",
            name="site",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="sites.site"
            ),
        ),
        migrations.CreateModel(
            name="CommentReactionAuthor",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "author",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "reaction",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="django_comments_ink.commentreaction",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="commentreaction",
            name="authors",
            field=models.ManyToManyField(
                through="django_comments_ink.CommentReactionAuthor",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="commentreaction",
            name="comment",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="reactions",
                to="django_comments_ink.inkcomment",
                verbose_name="reactions",
            ),
        ),
    ]
