# AUTOGENERATED! DO NOT EDIT! File to edit: dataset_ted_en_az.ipynb (unless otherwise specified).

__all__ = ['load_dataset', 'vectorize_data', 'get_dataset']

# Cell

from tensorflow.keras.layers.experimental.preprocessing import TextVectorization
import tensorflow_datasets as tfds

# Cell

def load_dataset():
    dataset, info = tfds.load("ted_hrlr_translate", with_info=True)

    # TODO: shuffle data

    def get_en(item):
      return item["en"]
    def get_az(item):
      return item["az"]

    dataset_test, dataset_train = dataset['test'], dataset['train']

    dataset_en = dataset_train.map(get_en)
    dataset_az = dataset_train.map(get_az)

    return dataset_en, dataset_az, info

# Cell

def vectorize_data(dataset_en, dataset_az, max_seq_len):

    # TODO: mask!

    vectorize_layer_en = TextVectorization(
     max_tokens=10000,
     output_mode='int',
     output_sequence_length=max_seq_len)
    vectorize_layer_en.adapt(dataset_en)


    vectorize_layer_az = TextVectorization(
     max_tokens=10000,
     output_mode='int',
     output_sequence_length=max_seq_len)
    vectorize_layer_az.adapt(dataset_az)

    return vectorize_layer_en, vectorize_layer_az

# Cell

def get_dataset(max_seq_len=64):
    """

    :param max_seq_len:
    :return:
    """
    dataset_en, dataset_az, info = load_dataset()
    vec_layer_en, vec_layer_az = vectorize_data(dataset_en, dataset_az, max_seq_len)

    vocab_en = vec_layer_en.get_vocabulary()
    vocab_az = vec_layer_az.get_vocabulary()

    # vocab_size_en = len(vocab_en)
    # vocab_size_az = len(vocab_az)

    return vec_layer_en(list(dataset_en.as_numpy_iterator())),\
           vec_layer_az(list(dataset_az.as_numpy_iterator())),\
           vocab_en,\
           vocab_az
