"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebsiteAliasRecord = void 0;
const crypto = require("crypto");
const aws_route53_1 = require("@aws-cdk/aws-route53");
const core_1 = require("@aws-cdk/core");
class WebsiteAliasRecord extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { domainName, recordNames, target } = props;
        const zone = aws_route53_1.HostedZone.fromLookup(this, 'Zone', {
            domainName,
        });
        recordNames.forEach((recordName) => {
            const hash = crypto
                .createHash('md5')
                .update(recordName)
                .digest('hex')
                .substr(0, 6);
            new aws_route53_1.ARecord(this, `WebsiteAliasRecord${hash}`, {
                zone,
                recordName: `${recordName}.`,
                target: aws_route53_1.RecordTarget.fromAlias(target),
            });
            if (!props.disableIPv6) {
                new aws_route53_1.AaaaRecord(this, `WebsiteIPv6AliasRecord${hash}`, {
                    zone,
                    recordName: `${recordName}.`,
                    target: aws_route53_1.RecordTarget.fromAlias(target),
                });
            }
        });
    }
}
exports.WebsiteAliasRecord = WebsiteAliasRecord;
//# sourceMappingURL=data:application/json;base64,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