DEFAULT_FONT = "metal-font"

NORMALIZED_SPACE_WIDTH = 0.4
NORMALIZED_CHAR_SPACING = 0.1

FONTS = {
"metal-font": {

'a':[[(-3359800.0,-80000.0),(-3412600.0,119800.0),(-3386000.0,119800.0),(-3334200.0,-80000.0)],[(-3448200.0,-80000.0),(-3471000.0,-80000.0),(-3421000.0,107000.0),(-3410400.0,66400.0),(-3430400.0,-11600.0),(-3389800.0,-11600.0),(-3385000.0,-29800.0),(-3435200.0,-29800.0)],],
'b':[[(-3276400.0,95400.0),(-3276400.0,119800.0),(-3222200.0,119800.0),(-3193800.0,91600.0),(-3193800.0,44400.0),(-3212200.0,25800.0),(-3192400.0,6400.0),(-3192400.0,-50400.0),(-3222400.0,-80000.0),(-3276400.0,-80000.0),(-3276400.0,-55400.0),(-3232400.0,-55400.0),(-3217200.0,-40200.0),(-3217200.0,0.0),(-3231600.0,14200.0),(-3276400.0,14200.0),(-3276400.0,35800.0),(-3232400.0,35800.0),(-3218200.0,50200.0),(-3218200.0,80800.0),(-3232400.0,95400.0)],[(-3312600.0,-80000.0),(-3312600.0,119800.0),(-3287800.0,119800.0),(-3287800.0,-80000.0)],],
'c':[[(-3094200.0,95000.0),(-3094200.0,119800.0),(-3066600.0,119800.0),(-3038200.0,91600.0),(-3038200.0,53000.0),(-3063000.0,53000.0),(-3063000.0,80800.0),(-3077200.0,95000.0)],[(-3166000.0,86400.0),(-3133000.0,119800.0),(-3105600.0,119800.0),(-3105600.0,95000.0),(-3123200.0,95000.0),(-3141600.0,76800.0),(-3141600.0,-36400.0),(-3122400.0,-55400.0),(-3105600.0,-55400.0),(-3105600.0,-80000.0),(-3131200.0,-80000.0),(-3166000.0,-45200.0)],[(-3063000.0,-40400.0),(-3063000.0,-8600.0),(-3038200.0,-8600.0),(-3038200.0,-50400.0),(-3068200.0,-80000.0),(-3094200.0,-80000.0),(-3094200.0,-55400.0),(-3078200.0,-55400.0)],],
'd':[[(-2972600.0,95400.0),(-2972600.0,119800.0),(-2920800.0,119800.0),(-2882200.0,81400.0),(-2882200.0,-39800.0),(-2922400.0,-80000.0),(-2972600.0,-80000.0),(-2972600.0,-55400.0),(-2930800.0,-55400.0),(-2906800.0,-31400.0),(-2906800.0,72200.0),(-2929600.0,95400.0)],[(-3008800.0,-80000.0),(-3008800.0,119800.0),(-2984000.0,119800.0),(-2984000.0,-80000.0)],],
'e':[[(-2816600.0,95400.0),(-2816600.0,119800.0),(-2733200.0,119800.0),(-2733200.0,95400.0)],[(-2852800.0,-80000.0),(-2852800.0,119800.0),(-2828000.0,119800.0),(-2828000.0,-80000.0)],[(-2816600.0,14200.0),(-2816600.0,35800.0),(-2759600.0,35800.0),(-2759600.0,14200.0)],[(-2816600.0,-80000.0),(-2816600.0,-55400.0),(-2732600.0,-55400.0),(-2732600.0,-80000.0)],],
'f':[[(-2670000.0,95400.0),(-2670000.0,119800.0),(-2586400.0,119800.0),(-2586400.0,95400.0)],[(-2706000.0,-80000.0),(-2706000.0,119800.0),(-2681400.0,119800.0),(-2681400.0,-80000.0)],[(-2670000.0,10000.0),(-2670000.0,31600.0),(-2605400.0,31600.0),(-2605400.0,10000.0)],],
'g':[[(-2497800.0,95400.0),(-2497800.0,119800.0),(-2466600.0,119800.0),(-2438400.0,91600.0),(-2438400.0,56200.0),(-2462800.0,56200.0),(-2462800.0,80800.0),(-2477200.0,95400.0)],[(-2568800.0,86400.0),(-2535600.0,119800.0),(-2509200.0,119800.0),(-2509200.0,95400.0),(-2526000.0,95400.0),(-2544400.0,77000.0),(-2544400.0,-36400.0),(-2525200.0,-55400.0),(-2509200.0,-55400.0),(-2509200.0,-80000.0),(-2533800.0,-80000.0),(-2568800.0,-45000.0)],[(-2497800.0,8400.0),(-2497800.0,25800.0),(-2438400.0,25800.0),(-2438400.0,-80000.0),(-2462000.0,-80000.0),(-2462000.0,-57600.0),(-2484600.0,-80000.0),(-2497800.0,-80000.0),(-2497800.0,-55400.0),(-2484000.0,-55400.0),(-2462800.0,-34400.0),(-2462800.0,8400.0)],],
'h':[[(-2308400.0,-80000.0),(-2308400.0,119800.0),(-2283600.0,119800.0),(-2283600.0,-80000.0)],[(-2409000.0,-80000.0),(-2409000.0,119800.0),(-2384600.0,119800.0),(-2384600.0,35000.0),(-2320000.0,35000.0),(-2320000.0,15000.0),(-2384600.0,15000.0),(-2384600.0,-80000.0)],],
'i':[[(-2224200.0,-80000.0),(-2249000.0,-80000.0),(-2249000.0,119800.0),(-2224200.0,119800.0)],],
'j':[[(-2105000.0,-36400.0),(-2105000.0,119800.0),(-2080000.0,119800.0),(-2080000.0,-45200.0),(-2115200.0,-80000.0),(-2134800.0,-80000.0),(-2134800.0,-55400.0),(-2124200.0,-55400.0)],[(-2197200.0,-50400.0),(-2197200.0,-5000.0),(-2172400.0,-5000.0),(-2172400.0,-40400.0),(-2157200.0,-55400.0),(-2146000.0,-55400.0),(-2146000.0,-80000.0),(-2167400.0,-80000.0)],],
'k':[[(-2014000.0,43200.0),(-1951400.0,119800.0),(-1923600.0,119800.0),(-2014000.0,6800.0)],[(-2050800.0,-80000.0),(-2050800.0,119800.0),(-2025400.0,119800.0),(-2025400.0,-80000.0)],[(-1948600.0,-80000.0),(-1991800.0,14800.0),(-1976200.0,34800.0),(-1923000.0,-80000.0)],],
'l':[[(-1897800.0,-44000.0),(-1897800.0,119800.0),(-1873000.0,119800.0),(-1873000.0,-44000.0)],[(-1897800.0,-80000.0),(-1897800.0,-55400.0),(-1779600.0,-55400.0),(-1779600.0,-80000.0)],],
'm':[[(-1636800.0,-80000.0),(-1636800.0,119800.0),(-1613000.0,119800.0),(-1613000.0,-80000.0)],[(-1756800.0,-80000.0),(-1756800.0,119800.0),(-1733000.0,119800.0),(-1733000.0,-80000.0)],[(-1721600.0,110600.0),(-1684000.0,40800.0),(-1648200.0,110600.0),(-1648200.0,64400.0),(-1678600.0,9000.0),(-1691400.0,9000.0),(-1721600.0,64400.0)],],
'n':[[(-1473000.0,-80000.0),(-1473000.0,119800.0),(-1451400.0,119800.0),(-1451400.0,-80000.0)],[(-1581000.0,-80000.0),(-1581000.0,119800.0),(-1559200.0,119800.0),(-1559200.0,-80000.0)],[(-1547800.0,63000.0),(-1547800.0,117000.0),(-1484600.0,-8600.0),(-1484600.0,-61400.0)],],
'o':[[(-1349000.0,95400.0),(-1349000.0,119800.0),(-1321800.0,119800.0),(-1291000.0,89000.0),(-1291000.0,-47800.0),(-1323400.0,-80000.0),(-1349000.0,-80000.0),(-1349000.0,-55400.0),(-1333000.0,-55400.0),(-1315600.0,-38000.0),(-1315600.0,79000.0),(-1332000.0,95400.0)],[(-1421600.0,89000.0),(-1390800.0,119800.0),(-1360600.0,119800.0),(-1360600.0,95400.0),(-1380800.0,95400.0),(-1397000.0,79000.0),(-1397000.0,-38000.0),(-1379600.0,-55400.0),(-1360600.0,-55400.0),(-1360600.0,-80000.0),(-1389400.0,-80000.0),(-1421600.0,-47800.0)],],
'p':[[(-1225600.0,95400.0),(-1225600.0,119800.0),(-1167800.0,119800.0),(-1137000.0,89000.0),(-1137000.0,26400.0),(-1167800.0,-4400.0),(-1225600.0,-4400.0),(-1225600.0,18200.0),(-1177800.0,18200.0),(-1161400.0,34600.0),(-1161400.0,79000.0),(-1177800.0,95400.0)],[(-1261800.0,-80000.0),(-1261800.0,119800.0),(-1237000.0,119800.0),(-1237000.0,-80000.0)],],
'q':[[(-1042200.0,95000.0),(-1042200.0,119800.0),(-1015600.0,119800.0),(-984600.0,89000.0),(-984600.0,-47800.0),(-1017200.0,-80000.0),(-1028200.0,-80000.0),(-1028200.0,-55400.0),(-1026600.0,-55400.0),(-1009600.0,-38200.0),(-1009600.0,78800.0),(-1025800.0,95000.0)],[(-1115200.0,89000.0),(-1084600.0,119800.0),(-1053600.0,119800.0),(-1053600.0,95000.0),(-1074400.0,95000.0),(-1090600.0,78800.0),(-1090600.0,-38200.0),(-1073400.0,-55400.0),(-1072000.0,-55400.0),(-1072000.0,-80000.0),(-1083000.0,-80000.0),(-1115200.0,-47800.0)],[(-1060600.0,-108000.0),(-1060600.0,-30400.0),(-1039600.0,-30400.0),(-1039600.0,-108000.0)],],
'r':[[(-919400.0,95000.0),(-919400.0,119800.0),(-861600.0,119800.0),(-833600.0,91600.0),(-833600.0,33600.0),(-860800.0,6400.0),(-919400.0,6400.0),(-919400.0,28200.0),(-872600.0,28200.0),(-858200.0,42400.0),(-858200.0,80800.0),(-872600.0,95000.0)],[(-955400.0,-80000.0),(-955400.0,119800.0),(-930800.0,119800.0),(-930800.0,-80000.0)],[(-863000.0,-80000.0),(-896000.0,-5000.0),(-870800.0,-5000.0),(-837400.0,-80000.0)],],
's':[[(-737800.0,95400.0),(-737800.0,119800.0),(-710600.0,119800.0),(-682600.0,91600.0),(-682600.0,63400.0),(-707200.0,63400.0),(-707200.0,80800.0),(-721800.0,95400.0)],[(-807400.0,91600.0),(-779000.0,119800.0),(-749000.0,119800.0),(-749000.0,95400.0),(-768400.0,95400.0),(-782800.0,80800.0),(-782800.0,45400.0),(-772000.0,35000.0),(-749000.0,35000.0),(-749000.0,12000.0),(-784200.0,12000.0),(-807400.0,34800.0)],[(-737800.0,12000.0),(-737800.0,35000.0),(-703400.0,35000.0),(-680600.0,12800.0),(-680600.0,-50400.0),(-710400.0,-80000.0),(-737800.0,-80000.0),(-737800.0,-55400.0),(-720600.0,-55400.0),(-705400.0,-40200.0),(-705400.0,1400.0),(-715800.0,12000.0)],[(-807400.0,-50400.0),(-807400.0,-13800.0),(-782800.0,-13800.0),(-782800.0,-40200.0),(-767400.0,-55400.0),(-749000.0,-55400.0),(-749000.0,-80000.0),(-777600.0,-80000.0)],],
't':[[(-663400.0,96400.0),(-663400.0,119800.0),(-527800.0,119800.0),(-527800.0,96400.0)],[(-608000.0,-80000.0),(-608000.0,85000.0),(-583200.0,85000.0),(-583200.0,-80000.0)],],
'u':[[(-407600.0,-38000.0),(-407600.0,119800.0),(-383600.0,119800.0),(-383600.0,-49400.0),(-414000.0,-80000.0),(-439800.0,-80000.0),(-439800.0,-55400.0),(-425000.0,-55400.0)],[(-508400.0,-49400.0),(-508400.0,119800.0),(-483800.0,119800.0),(-483800.0,-38000.0),(-466400.0,-55400.0),(-451200.0,-55400.0),(-451200.0,-80000.0),(-477800.0,-80000.0)],],
'v':[[(-286800.0,-26800.0),(-249000.0,119800.0),(-225600.0,119800.0),(-275800.0,-68400.0)],[(-310200.0,-80000.0),(-362200.0,119800.0),(-337200.0,119800.0),(-284600.0,-80000.0)],],
'w':[[(-36800.0,-23800.0),(-5800.0,119800.0),(16800.0,119800.0),(-24800.0,-74400.0)],[(-57400.0,-80000.0),(-107400.0,119800.0),(-84200.0,119800.0),(-34800.0,-80000.0)],[(-173400.0,-80000.0),(-214800.0,119800.0),(-190800.0,119800.0),(-146200.0,-80000.0)],[(-147000.0,-21600.0),(-115600.0,105600.0),(-104200.0,59600.0),(-136600.0,-69600.0)],],
'x':[[(103400.0,59000.0),(135800.0,119800.0),(160600.0,119800.0),(115400.0,37000.0)],[(139200.0,-80000.0),(31800.0,119800.0),(57800.0,119800.0),(165200.0,-80000.0)],[(52400.0,-80000.0),(27200.0,-80000.0),(77000.0,10800.0),(88800.0,-11200.0)],],
'y':[[(247800.0,40200.0),(280600.0,119800.0),(304000.0,119800.0),(258400.0,14400.0)],[(227400.0,800.0),(176000.0,119800.0),(202200.0,119800.0),(252400.0,-2000.0),(252400.0,-80000.0),(227400.0,-80000.0)],],
'z':[[(319600.0,96200.0),(319200.0,119800.0),(451400.0,119800.0),(451400.0,99400.0),(449200.0,96200.0)],[(328400.0,-45000.0),(410400.0,84800.0),(442000.0,84800.0),(359800.0,-45000.0)],[(319200.0,-59800.0),(321000.0,-56400.0),(452600.0,-56400.0),(452600.0,-80000.0),(319200.0,-80000.0)],],
'1':[[(527600.0,-55400.0),(548600.0,-55400.0),(548600.0,-80000.0),(480200.0,-80000.0),(480200.0,-55400.0),(503000.0,-55400.0),(503000.0,92400.0),(483400.0,80200.0),(476000.0,99600.0),(510600.0,119800.0),(527600.0,119800.0)],],
'2':[[(644800.0,95400.0),(644800.0,119800.0),(672800.0,119800.0),(701200.0,91600.0),(701200.0,31800.0),(678000.0,8800.0),(644800.0,8800.0),(644800.0,31800.0),(665800.0,31800.0),(676600.0,42400.0),(676600.0,80800.0),(662000.0,95400.0)],[(577200.0,91600.0),(605400.0,119800.0),(633400.0,119800.0),(633400.0,95400.0),(616400.0,95400.0),(602000.0,80800.0),(602000.0,63000.0),(577200.0,63000.0)],[(575400.0,9600.0),(598400.0,31800.0),(633400.0,31800.0),(633400.0,8800.0),(610600.0,8800.0),(600000.0,-1400.0),(600000.0,-44000.0),(575400.0,-44000.0)],[(575400.0,-80000.0),(575400.0,-55400.0),(701200.0,-55400.0),(702000.0,-80000.0)],],
'3':[[(800200.0,95400.0),(800200.0,119800.0),(826200.0,119800.0),(854200.0,91600.0),(854200.0,45200.0),(836000.0,26600.0),(855600.0,7000.0),(855600.0,-50400.0),(826000.0,-80000.0),(800200.0,-80000.0),(800200.0,-55400.0),(815600.0,-55400.0),(830800.0,-40200.0),(830800.0,0.0),(816400.0,14200.0),(800200.0,14200.0),(800200.0,35800.0),(815600.0,35800.0),(830000.0,50200.0),(830000.0,80800.0),(815600.0,95400.0)],[(730000.0,91600.0),(758400.0,119800.0),(788800.0,119800.0),(788800.0,95400.0),(768800.0,95400.0),(754600.0,80800.0),(754600.0,64000.0),(730000.0,64000.0)],[(765800.0,14200.0),(765800.0,35800.0),(788800.0,35800.0),(788800.0,14200.0)],[(728800.0,-50400.0),(728800.0,-14800.0),(753400.0,-14800.0),(753400.0,-40200.0),(768800.0,-55400.0),(788800.0,-55400.0),(788800.0,-80000.0),(758600.0,-80000.0)],],
'4':[[(877200.0,-3200.0),(959800.0,119800.0),(984000.0,119800.0),(887400.0,-21800.0),(877200.0,-21800.0)],[(961000.0,-1000.0),(961000.0,65600.0),(986400.0,103000.0),(986400.0,-1000.0),(1007400.0,-1000.0),(1007400.0,-21800.0),(901400.0,-21800.0),(915600.0,-1000.0)],[(961000.0,-80000.0),(961000.0,-33200.0),(986400.0,-33200.0),(986400.0,-80000.0)],],
'5':[[(1100600.0,95400.0),(1100600.0,119800.0),(1154200.0,119800.0),(1154200.0,95400.0)],[(1032200.0,18800.0),(1032200.0,119800.0),(1089200.0,119800.0),(1089200.0,95400.0),(1057000.0,95400.0),(1057000.0,41800.0),(1089200.0,41800.0),(1089200.0,18800.0)],[(1100600.0,18800.0),(1100600.0,41800.0),(1134400.0,41800.0),(1157000.0,19600.0),(1157000.0,-50400.0),(1127400.0,-80000.0),(1100600.0,-80000.0),(1100600.0,-55400.0),(1117000.0,-55400.0),(1132600.0,-40200.0),(1132600.0,8200.0),(1122000.0,18800.0)],[(1030600.0,-50400.0),(1030600.0,-12400.0),(1055200.0,-12400.0),(1055200.0,-40200.0),(1070400.0,-55400.0),(1089200.0,-55400.0),(1089200.0,-80000.0),(1060200.0,-80000.0)],],
'6':[[(1254000.0,95400.0),(1254000.0,119800.0),(1280800.0,119800.0),(1308800.0,91600.0),(1308800.0,63400.0),(1284200.0,63400.0),(1284200.0,80800.0),(1269600.0,95400.0)],[(1184000.0,91600.0),(1212200.0,119800.0),(1242600.0,119800.0),(1242600.0,95400.0),(1223000.0,95400.0),(1208600.0,80800.0),(1208600.0,40800.0),(1242600.0,40800.0),(1242600.0,17600.0),(1208600.0,17600.0),(1208600.0,-40200.0),(1223800.0,-55400.0),(1242600.0,-55400.0),(1242600.0,-80000.0),(1213600.0,-80000.0),(1184000.0,-50400.0)],[(1254000.0,17600.0),(1254000.0,40800.0),(1287800.0,40800.0),(1310800.0,18400.0),(1310800.0,-50400.0),(1281000.0,-80000.0),(1254000.0,-80000.0),(1254000.0,-55400.0),(1270800.0,-55400.0),(1286000.0,-40200.0),(1286000.0,7000.0),(1275600.0,17600.0)],],
'7':[[(1333000.0,97000.0),(1333000.0,119800.0),(1452800.0,119800.0),(1452800.0,97000.0)],[(1426200.0,77600.0),(1426200.0,85600.0),(1452800.0,85600.0),(1452800.0,80200.0),(1387600.0,-80000.0),(1361000.0,-80000.0)],],
'8':[[(1546000.0,95400.0),(1546000.0,119800.0),(1573800.0,119800.0),(1601800.0,91600.0),(1601800.0,45200.0),(1583600.0,26600.0),(1603200.0,7000.0),(1603200.0,-50400.0),(1573600.0,-80000.0),(1546000.0,-80000.0),(1546000.0,-55400.0),(1563200.0,-55400.0),(1578400.0,-40200.0),(1578400.0,800.0),(1564000.0,15000.0),(1546000.0,15000.0),(1546000.0,36800.0),(1563200.0,36800.0),(1577600.0,51200.0),(1577600.0,80800.0),(1563200.0,95400.0)],[(1477600.0,91600.0),(1505800.0,119800.0),(1534800.0,119800.0),(1534800.0,95400.0),(1516400.0,95400.0),(1502200.0,80800.0),(1502200.0,51200.0),(1516400.0,36800.0),(1534800.0,36800.0),(1534800.0,15000.0),(1515400.0,15000.0),(1501000.0,800.0),(1501000.0,-40200.0),(1516400.0,-55400.0),(1534800.0,-55400.0),(1534800.0,-80000.0),(1506200.0,-80000.0),(1476400.0,-50400.0),(1476400.0,7000.0),(1496200.0,26600.0),(1477600.0,45200.0)],],
'9':[[(1700400.0,95400.0),(1700400.0,119800.0),(1727000.0,119800.0),(1756400.0,90400.0),(1756400.0,-51600.0),(1727800.0,-80000.0),(1700400.0,-80000.0),(1700400.0,-55400.0),(1717400.0,-55400.0),(1731800.0,-41000.0),(1731800.0,10000.0),(1700400.0,10000.0),(1700400.0,32600.0),(1731800.0,32600.0),(1731800.0,79800.0),(1716400.0,95400.0)],[(1630200.0,90400.0),(1659600.0,119800.0),(1689000.0,119800.0),(1689000.0,95400.0),(1670000.0,95400.0),(1654600.0,79800.0),(1654600.0,43200.0),(1665600.0,32600.0),(1689000.0,32600.0),(1689000.0,10000.0),(1653200.0,10000.0),(1630200.0,32600.0)],[(1631000.0,-51600.0),(1631000.0,-13800.0),(1655800.0,-13800.0),(1655800.0,-41000.0),(1670000.0,-55400.0),(1689000.0,-55400.0),(1689000.0,-80000.0),(1659800.0,-80000.0)],],
'0':[[(1783200.0,89000.0),(1814000.0,119800.0),(1883000.0,119800.0),(1913800.0,89000.0),(1913800.0,28800.0),(1889200.0,28800.0),(1889200.0,79000.0),(1873000.0,95400.0),(1824200.0,95400.0),(1807800.0,79000.0),(1807800.0,28800.0),(1783200.0,28800.0)],[(1889200.0,-38000.0),(1889200.0,17400.0),(1913800.0,17400.0),(1913800.0,-47800.0),(1881400.0,-80000.0),(1815400.0,-80000.0),(1783200.0,-47800.0),(1783200.0,17400.0),(1807800.0,17400.0),(1807800.0,-38000.0),(1825200.0,-55400.0),(1871800.0,-55400.0)],],
'!':[[(1950800.0,-18400.0),(1948000.0,119800.0),(1974400.0,119800.0),(1971600.0,-18400.0)],[(1949400.0,-80000.0),(1949400.0,-51600.0),(1973000.0,-51600.0),(1973000.0,-80000.0)],],
'"':[[(2043400.0,64400.0),(2041000.0,128600.0),(2057400.0,128600.0),(2055200.0,64400.0)],[(2011000.0,64400.0),(2008800.0,128600.0),(2024600.0,128600.0),(2022400.0,64400.0)],],
'£':[[(2163000.0,99600.0),(2163000.0,119800.0),(2187600.0,119800.0),(2210400.0,97000.0),(2210400.0,53800.0),(2188400.0,53800.0),(2188400.0,89000.0),(2178000.0,99600.0)],[(2105000.0,97000.0),(2128200.0,119800.0),(2151600.0,119800.0),(2151600.0,99600.0),(2140400.0,99600.0),(2129800.0,89000.0),(2129800.0,25600.0),(2190800.0,25600.0),(2190800.0,10000.0),(2084200.0,10000.0),(2084200.0,25600.0),(2105000.0,25600.0)],[(2105000.0,-55400.0),(2105000.0,-1400.0),(2129800.0,-1400.0),(2129800.0,-55400.0),(2199600.0,-55400.0),(2199600.0,-26000.0),(2220600.0,-26000.0),(2220600.0,-80000.0),(2084200.0,-80000.0),(2084200.0,-55400.0)],],
'$':[[(2297800.0,103600.0),(2297800.0,119800.0),(2310600.0,119800.0),(2310600.0,103600.0),(2333400.0,103600.0),(2359800.0,77600.0),(2359800.0,55000.0),(2338400.0,55000.0),(2338400.0,68200.0),(2324400.0,82400.0),(2279800.0,82400.0),(2269600.0,72200.0),(2269600.0,43000.0),(2277800.0,34600.0),(2299600.0,34600.0),(2299600.0,15000.0),(2267600.0,15000.0),(2248200.0,34600.0),(2248200.0,81400.0),(2270400.0,103600.0)],[(2310800.0,15000.0),(2310800.0,34600.0),(2342400.0,34600.0),(2361600.0,16000.0),(2361600.0,-35600.0),(2337600.0,-59200.0),(2310600.0,-59200.0),(2310600.0,-80000.0),(2297800.0,-80000.0),(2297800.0,-59200.0),(2275000.0,-59200.0),(2247200.0,-31400.0),(2247200.0,-3200.0),(2268400.0,-3200.0),(2268400.0,-23000.0),(2283600.0,-38000.0),(2328800.0,-38000.0),(2340000.0,-26800.0),(2340000.0,6800.0),(2331800.0,15000.0)],],
'%':[[(2409400.0,-80000.0),(2522600.0,119800.0),(2540000.0,119800.0),(2427000.0,-80000.0)],[(2431000.0,103200.0),(2431000.0,119800.0),(2446800.0,119800.0),(2461800.0,104800.0),(2461800.0,44600.0),(2445400.0,28600.0),(2431000.0,28600.0),(2431000.0,44600.0),(2437800.0,44600.0),(2445400.0,52200.0),(2445400.0,96800.0),(2439000.0,103200.0)],[(2388400.0,104800.0),(2403800.0,119800.0),(2419600.0,119800.0),(2419600.0,103200.0),(2411400.0,103200.0),(2404400.0,96800.0),(2404400.0,52200.0),(2412200.0,44600.0),(2419600.0,44600.0),(2419600.0,28600.0),(2405000.0,28600.0),(2388400.0,44600.0)],[(2531800.0,-5000.0),(2531800.0,11400.0),(2547400.0,11400.0),(2563000.0,-3800.0),(2563000.0,-63800.0),(2546400.0,-80000.0),(2531800.0,-80000.0),(2531800.0,-63800.0),(2539000.0,-63800.0),(2546600.0,-56000.0),(2546600.0,-11800.0),(2540000.0,-5000.0)],[(2489600.0,-3800.0),(2504600.0,11400.0),(2520400.0,11400.0),(2520400.0,-5000.0),(2512400.0,-5000.0),(2505400.0,-11800.0),(2505400.0,-56000.0),(2513200.0,-63800.0),(2520400.0,-63800.0),(2520400.0,-80000.0),(2506200.0,-80000.0),(2489600.0,-63600.0)],],
'^':[[(2664600.0,61200.0),(2648200.0,61200.0),(2627200.0,102800.0),(2606400.0,61200.0),(2589800.0,61200.0),(2621000.0,119800.0),(2633800.0,119800.0)],],
'&':[[(2742600.0,98600.0),(2742600.0,119800.0),(2756000.0,119800.0),(2776600.0,99000.0),(2776600.0,53600.0),(2755200.0,31800.0),(2743800.0,46800.0),(2757800.0,61000.0),(2757800.0,89400.0),(2748600.0,98600.0)],[(2697000.0,99000.0),(2717400.0,119800.0),(2731200.0,119800.0),(2731200.0,98600.0),(2726400.0,98600.0),(2717200.0,89400.0),(2717200.0,62200.0),(2780000.0,-19000.0),(2798600.0,12200.0),(2819200.0,12200.0),(2792400.0,-35000.0),(2827800.0,-80000.0),(2804000.0,-80000.0),(2697000.0,57600.0)],[(2688600.0,-53600.0),(2688600.0,-5800.0),(2712800.0,18000.0),(2725800.0,1600.0),(2710600.0,-13200.0),(2710600.0,-45200.0),(2724600.0,-59000.0),(2753200.0,-59000.0),(2761800.0,-45000.0),(2774400.0,-61400.0),(2763000.0,-80000.0),(2715200.0,-80000.0),(2701600.0,-66800.0),(2695200.0,-60200.0)],],
'*':[[(2897800.0,94200.0),(2931200.0,85600.0),(2928000.0,73200.0),(2895200.0,85800.0),(2897000.0,51200.0),(2884400.0,51200.0),(2886400.0,86200.0),(2853800.0,73200.0),(2849800.0,85000.0),(2883600.0,94400.0),(2861800.0,121000.0),(2871400.0,128800.0),(2890600.0,99400.0),(2909400.0,128600.0),(2919800.0,121600.0)],],
'(':[[(2972800.0,99600.0),(2972800.0,-60800.0),(2997400.0,-108600.0),(2981800.0,-108600.0),(2957800.0,-62000.0),(2957800.0,101600.0),(2981800.0,148400.0),(2998000.0,148400.0)],],
')':[[(3065200.0,101600.0),(3065200.0,-62000.0),(3040800.0,-108600.0),(3025400.0,-108600.0),(3050000.0,-60800.0),(3050000.0,99600.0),(3024800.0,148400.0),(3040800.0,148400.0)],],
'\\':[[(3159000.0,-107200.0),(3143200.0,-107200.0),(3080400.0,127800.0),(3096200.0,127800.0)],],
',':[[(3198400.0,-78400.0),(3174800.0,-119000.0),(3164800.0,-114600.0),(3174800.0,-73200.0),(3174800.0,-56800.0),(3198400.0,-56800.0)],],
'.':[[(3248600.0,-80000.0),(3225200.0,-80000.0),(3225200.0,-51600.0),(3248600.0,-51600.0)],],
'/':[[(3275000.0,-107200.0),(3259200.0,-107200.0),(3322000.0,127800.0),(3337600.0,127800.0)],],
';':[[(3356200.0,23600.0),(3356200.0,52200.0),(3380000.0,52200.0),(3380000.0,23600.0)],[(3357000.0,-73200.0),(3357000.0,-56800.0),(3380400.0,-56800.0),(3380400.0,-78400.0),(3356800.0,-119000.0),(3346800.0,-114600.0)],],
"'":[[(3421000.0,64400.0),(3409600.0,64400.0),(3407400.0,128600.0),(3423400.0,128600.0)],],
'#':[[(3526800.0,58400.0),(3533600.0,119800.0),(3551800.0,119800.0),(3545000.0,58400.0),(3561000.0,58400.0),(3561000.0,42400.0),(3543200.0,42400.0),(3539000.0,1400.0),(3555000.0,1400.0),(3555000.0,-14800.0),(3537200.0,-14800.0),(3530400.0,-80000.0),(3512200.0,-80000.0),(3519000.0,-14800.0),(3492000.0,-14800.0),(3493600.0,1400.0),(3520800.0,1400.0),(3525000.0,42400.0),(3498200.0,42400.0),(3499800.0,58400.0)],[(3469800.0,58400.0),(3476800.0,119800.0),(3495000.0,119800.0),(3473600.0,-80000.0),(3455400.0,-80000.0),(3462200.0,-14800.0),(3446400.0,-14800.0),(3446400.0,1400.0),(3463800.0,1400.0),(3468200.0,42400.0),(3452400.0,42400.0),(3452400.0,58400.0)],],
'[':[[(3630800.0,137000.0),(3599400.0,137000.0),(3599400.0,-97200.0),(3630800.0,-97200.0),(3630800.0,-108600.0),(3584200.0,-108600.0),(3584200.0,148400.0),(3630800.0,148400.0)],],
']':[[(3704200.0,-108600.0),(3657600.0,-108600.0),(3657600.0,-97200.0),(3688800.0,-97200.0),(3688800.0,137000.0),(3657600.0,137000.0),(3657600.0,148400.0),(3704200.0,148400.0)],],
'-':[[(3790600.0,13800.0),(3721400.0,13800.0),(3721400.0,31000.0),(3790600.0,31000.0)],],
'=':[[(3807600.0,33400.0),(3807600.0,47600.0),(3897600.0,47600.0),(3897600.0,33400.0)],[(3807600.0,-4200.0),(3807600.0,10600.0),(3897600.0,10600.0),(3897600.0,-4200.0)],],
'|':[[(3939400.0,-111600.0),(3924400.0,-111600.0),(3924400.0,127800.0),(3939400.0,127800.0)],],
'<':[[(4061200.0,61800.0),(3984400.0,22200.0),(4061200.0,-17600.0),(4061200.0,-35800.0),(3966400.0,13800.0),(3966400.0,30800.0),(4061200.0,80200.0)],],
'>':[[(4182800.0,13800.0),(4088000.0,-35800.0),(4088000.0,-17600.0),(4164800.0,22200.0),(4088000.0,61800.0),(4088000.0,80200.0),(4182800.0,30800.0)],],
'?':[[(4270800.0,96200.0),(4270800.0,119800.0),(4296200.0,119800.0),(4324400.0,91600.0),(4324400.0,53000.0),(4271600.0,0.0),(4271600.0,-20000.0),(4250800.0,-20000.0),(4250800.0,10000.0),(4299600.0,59000.0),(4299600.0,82000.0),(4285200.0,96200.0)],[(4207800.0,91600.0),(4235800.0,119800.0),(4259200.0,119800.0),(4259200.0,96200.0),(4244800.0,96200.0),(4230400.0,82000.0),(4230400.0,64200.0),(4207800.0,64200.0)],[(4249600.0,-80000.0),(4249600.0,-51600.0),(4273000.0,-51600.0),(4273000.0,-80000.0)],],
':':[[(4348600.0,41000.0),(4348600.0,69600.0),(4372200.0,69600.0),(4372200.0,41000.0)],[(4348600.0,-36600.0),(4348600.0,-7800.0),(4372200.0,-7800.0),(4372200.0,-36600.0)],],
'@':[[(4398800.0,84800.0),(4434000.0,119800.0),(4511400.0,119800.0),(4531400.0,100000.0),(4531400.0,75600.0),(4512600.0,75600.0),(4512600.0,89800.0),(4502800.0,99600.0),(4442200.0,99600.0),(4421200.0,78400.0),(4421200.0,25200.0),(4398800.0,25200.0)],[(4498600.0,48200.0),(4498600.0,64200.0),(4531400.0,64200.0),(4531400.0,-3000.0),(4516200.0,-18000.0),(4498600.0,-18000.0),(4498600.0,-2000.0),(4504800.0,-2000.0),(4512600.0,5600.0),(4512600.0,48200.0)],[(4455600.0,53000.0),(4466800.0,64200.0),(4487200.0,64200.0),(4487200.0,48200.0),(4479000.0,48200.0),(4472600.0,41400.0),(4472600.0,5600.0),(4480200.0,-2000.0),(4487200.0,-2000.0),(4487200.0,-18000.0),(4469000.0,-18000.0),(4455600.0,-4600.0)],[(4398800.0,-44800.0),(4398800.0,13800.0),(4421200.0,13800.0),(4421200.0,-34400.0),(4442200.0,-55400.0),(4525600.0,-55400.0),(4525600.0,-80000.0),(4434400.0,-80000.0)],],
'~':[[(4640400.0,12000.0),(4636200.0,8200.0),(4631600.0,5600.0),(4626200.0,4200.0),(4620600.0,3600.0),(4618200.0,3600.0),(4615600.0,4200.0),(4613000.0,4600.0),(4610200.0,5600.0),(4607200.0,6600.0),(4604200.0,7800.0),(4601200.0,8800.0),(4598400.0,10200.0),(4595200.0,11400.0),(4592400.0,12600.0),(4589400.0,13600.0),(4586400.0,14800.0),(4583600.0,15600.0),(4581000.0,16200.0),(4578400.0,16600.0),(4576000.0,16800.0),(4570800.0,16200.0),(4566200.0,14600.0),(4561800.0,11800.0),(4558000.0,7800.0),(4558000.0,25200.0),(4561600.0,28600.0),(4565800.0,31200.0),(4571000.0,32600.0),(4577200.0,33200.0),(4580000.0,33000.0),(4582800.0,32600.0),(4585600.0,31800.0),(4588400.0,31000.0),(4591200.0,30000.0),(4594000.0,29000.0),(4596800.0,27600.0),(4599600.0,26600.0),(4602400.0,25200.0),(4605200.0,24200.0),(4608000.0,23200.0),(4610800.0,22200.0),(4613600.0,21200.0),(4616800.0,20600.0),(4619600.0,20200.0),(4622800.0,20200.0),(4627400.0,20600.0),(4632000.0,22000.0),(4636200.0,24600.0),(4640400.0,28200.0)],],
'{':[[(4744200.0,137000.0),(4719400.0,137000.0),(4706800.0,124800.0),(4706800.0,44200.0),(4691400.0,20200.0),(4706800.0,-4200.0),(4706800.0,-84800.0),(4719400.0,-97200.0),(4744200.0,-97200.0),(4744200.0,-108600.0),(4714600.0,-108600.0),(4691600.0,-85800.0),(4691600.0,-5600.0),(4680400.0,13800.0),(4666800.0,13800.0),(4666800.0,26400.0),(4680400.0,26400.0),(4691600.0,45600.0),(4691600.0,125600.0),(4714600.0,148400.0),(4744200.0,148400.0)],],
'}':[[(4823800.0,45600.0),(4834800.0,26400.0),(4848600.0,26400.0),(4848600.0,13800.0),(4834800.0,13800.0),(4823800.0,-5600.0),(4823800.0,-85800.0),(4800800.0,-108600.0),(4771200.0,-108600.0),(4771200.0,-97200.0),(4796000.0,-97200.0),(4808200.0,-84800.0),(4808200.0,-4200.0),(4824000.0,20200.0),(4808200.0,44200.0),(4808200.0,124800.0),(4796000.0,137000.0),(4771200.0,137000.0),(4771200.0,148400.0),(4800800.0,148400.0),(4823800.0,125600.0)],],
'_':[[(4991400.0,-101200.0),(4862000.0,-101200.0),(4862000.0,-90600.0),(4991400.0,-90600.0)],],
'+':[[(5094200.0,13400.0),(5056200.0,13400.0),(5056200.0,-24400.0),(5042000.0,-24400.0),(5042000.0,13400.0),(5004400.0,13400.0),(5004400.0,28000.0),(5042000.0,28000.0),(5042000.0,65600.0),(5056200.0,65600.0),(5056200.0,28000.0),(5094200.0,28000.0)],]
},

"__is_normalized__": False
}

def _normalizeFontDb():
    global FONTS
    
    normalized = {}
    for font in FONTS:
        if font == "__is_normalized__":
            continue
        
        normalized[font] = {}

        yList = [y for char in FONTS[font] for poly in FONTS[font][char] for x,y in poly]
        minY = min(yList)
        height = max(yList) - minY
        for char in FONTS[font]:
            xList = [x for poly in FONTS[font][char] for x,y in poly]
            minX = min(xList)

            normalized[font][char] = [[((x-minX)/height,(y-minY)/height) for x,y in poly] for poly in FONTS[font][char]]
            
    FONTS = normalized
    FONTS["__is_normalized__"] = True


def makeText(text, font=None, width=None, height=None):
    size = 1
    if height != None:
      size = height
      
    if font == None:
        font = DEFAULT_FONT
    
    if font not in FONTS:
        raise ValueError("Font '{}' does not exist.".format(font))
        
    polygons = []
    currentX = 0
    for char in text:
        if char == " ":
            currentX += size * NORMALIZED_SPACE_WIDTH
            
        else:
            if char.lower() not in FONTS[font]:
                raise ValueError("Character '{}' does not exist in font '{}'.".format(char, font))
                
            if not FONTS["__is_normalized__"]:
                _normalizeFontDb()
                
            polygons.extend([[(currentX + size*x,size*y) for x,y in poly] for poly in FONTS[font][char.lower()]])
    
            xList = [x for poly in FONTS[font][char.lower()] for x,y in poly]
            currentX += size * (NORMALIZED_CHAR_SPACING + max(xList)-min(xList))
    
    if width != None:
      xList = [x for poly in polygons for x,y in poly]
      size = width/(max(xList)-min(xList))
      polygons = [[[size*x,size*y] for x,y in poly] for poly in polygons]
      
    return polygons
