# coding: utf-8

"""
    PocketSmith

    The public PocketSmith API  # noqa: E501

    The version of the OpenAPI document: 2.0
    Contact: api@pocketsmith.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from pocketsmith.configuration import Configuration


class Transaction(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'amount': 'float',
        'category': 'Category',
        'cheque_number': 'str',
        'closing_balance': 'float',
        'date': 'date',
        'id': 'int',
        'is_transfer': 'bool',
        'labels': 'list[str]',
        'memo': 'str',
        'note': 'str',
        'original_payee': 'str',
        'payee': 'str',
        'status': 'str',
        'transaction_account': 'TransactionAccount',
        'type': 'str',
        'upload_source': 'str'
    }

    attribute_map = {
        'amount': 'amount',
        'category': 'category',
        'cheque_number': 'cheque_number',
        'closing_balance': 'closing_balance',
        'date': 'date',
        'id': 'id',
        'is_transfer': 'is_transfer',
        'labels': 'labels',
        'memo': 'memo',
        'note': 'note',
        'original_payee': 'original_payee',
        'payee': 'payee',
        'status': 'status',
        'transaction_account': 'transaction_account',
        'type': 'type',
        'upload_source': 'upload_source'
    }

    def __init__(self, amount=None, category=None, cheque_number=None, closing_balance=None, date=None, id=None, is_transfer=None, labels=None, memo=None, note=None, original_payee=None, payee=None, status=None, transaction_account=None, type=None, upload_source=None, local_vars_configuration=None):  # noqa: E501
        """Transaction - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._amount = None
        self._category = None
        self._cheque_number = None
        self._closing_balance = None
        self._date = None
        self._id = None
        self._is_transfer = None
        self._labels = None
        self._memo = None
        self._note = None
        self._original_payee = None
        self._payee = None
        self._status = None
        self._transaction_account = None
        self._type = None
        self._upload_source = None
        self.discriminator = None

        if amount is not None:
            self.amount = amount
        if category is not None:
            self.category = category
        if cheque_number is not None:
            self.cheque_number = cheque_number
        if closing_balance is not None:
            self.closing_balance = closing_balance
        if date is not None:
            self.date = date
        if id is not None:
            self.id = id
        if is_transfer is not None:
            self.is_transfer = is_transfer
        if labels is not None:
            self.labels = labels
        if memo is not None:
            self.memo = memo
        if note is not None:
            self.note = note
        if original_payee is not None:
            self.original_payee = original_payee
        if payee is not None:
            self.payee = payee
        if status is not None:
            self.status = status
        if transaction_account is not None:
            self.transaction_account = transaction_account
        if type is not None:
            self.type = type
        if upload_source is not None:
            self.upload_source = upload_source

    @property
    def amount(self):
        """Gets the amount of this Transaction.  # noqa: E501


        :return: The amount of this Transaction.  # noqa: E501
        :rtype: float
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this Transaction.


        :param amount: The amount of this Transaction.  # noqa: E501
        :type: float
        """

        self._amount = amount

    @property
    def category(self):
        """Gets the category of this Transaction.  # noqa: E501


        :return: The category of this Transaction.  # noqa: E501
        :rtype: Category
        """
        return self._category

    @category.setter
    def category(self, category):
        """Sets the category of this Transaction.


        :param category: The category of this Transaction.  # noqa: E501
        :type: Category
        """

        self._category = category

    @property
    def cheque_number(self):
        """Gets the cheque_number of this Transaction.  # noqa: E501


        :return: The cheque_number of this Transaction.  # noqa: E501
        :rtype: str
        """
        return self._cheque_number

    @cheque_number.setter
    def cheque_number(self, cheque_number):
        """Sets the cheque_number of this Transaction.


        :param cheque_number: The cheque_number of this Transaction.  # noqa: E501
        :type: str
        """

        self._cheque_number = cheque_number

    @property
    def closing_balance(self):
        """Gets the closing_balance of this Transaction.  # noqa: E501

        The closing balance of the account at the transaction.  # noqa: E501

        :return: The closing_balance of this Transaction.  # noqa: E501
        :rtype: float
        """
        return self._closing_balance

    @closing_balance.setter
    def closing_balance(self, closing_balance):
        """Sets the closing_balance of this Transaction.

        The closing balance of the account at the transaction.  # noqa: E501

        :param closing_balance: The closing_balance of this Transaction.  # noqa: E501
        :type: float
        """

        self._closing_balance = closing_balance

    @property
    def date(self):
        """Gets the date of this Transaction.  # noqa: E501

        The date the transaction took place.  # noqa: E501

        :return: The date of this Transaction.  # noqa: E501
        :rtype: date
        """
        return self._date

    @date.setter
    def date(self, date):
        """Sets the date of this Transaction.

        The date the transaction took place.  # noqa: E501

        :param date: The date of this Transaction.  # noqa: E501
        :type: date
        """

        self._date = date

    @property
    def id(self):
        """Gets the id of this Transaction.  # noqa: E501

        The unique identifier of the transaction.  # noqa: E501

        :return: The id of this Transaction.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Transaction.

        The unique identifier of the transaction.  # noqa: E501

        :param id: The id of this Transaction.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def is_transfer(self):
        """Gets the is_transfer of this Transaction.  # noqa: E501

        Whether the transaction was a transfer.  # noqa: E501

        :return: The is_transfer of this Transaction.  # noqa: E501
        :rtype: bool
        """
        return self._is_transfer

    @is_transfer.setter
    def is_transfer(self, is_transfer):
        """Sets the is_transfer of this Transaction.

        Whether the transaction was a transfer.  # noqa: E501

        :param is_transfer: The is_transfer of this Transaction.  # noqa: E501
        :type: bool
        """

        self._is_transfer = is_transfer

    @property
    def labels(self):
        """Gets the labels of this Transaction.  # noqa: E501


        :return: The labels of this Transaction.  # noqa: E501
        :rtype: list[str]
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this Transaction.


        :param labels: The labels of this Transaction.  # noqa: E501
        :type: list[str]
        """

        self._labels = labels

    @property
    def memo(self):
        """Gets the memo of this Transaction.  # noqa: E501


        :return: The memo of this Transaction.  # noqa: E501
        :rtype: str
        """
        return self._memo

    @memo.setter
    def memo(self, memo):
        """Sets the memo of this Transaction.


        :param memo: The memo of this Transaction.  # noqa: E501
        :type: str
        """

        self._memo = memo

    @property
    def note(self):
        """Gets the note of this Transaction.  # noqa: E501


        :return: The note of this Transaction.  # noqa: E501
        :rtype: str
        """
        return self._note

    @note.setter
    def note(self, note):
        """Sets the note of this Transaction.


        :param note: The note of this Transaction.  # noqa: E501
        :type: str
        """

        self._note = note

    @property
    def original_payee(self):
        """Gets the original_payee of this Transaction.  # noqa: E501

        The payee the transaction was created with.  # noqa: E501

        :return: The original_payee of this Transaction.  # noqa: E501
        :rtype: str
        """
        return self._original_payee

    @original_payee.setter
    def original_payee(self, original_payee):
        """Sets the original_payee of this Transaction.

        The payee the transaction was created with.  # noqa: E501

        :param original_payee: The original_payee of this Transaction.  # noqa: E501
        :type: str
        """

        self._original_payee = original_payee

    @property
    def payee(self):
        """Gets the payee of this Transaction.  # noqa: E501

        The payee/merchant of the transaction.  # noqa: E501

        :return: The payee of this Transaction.  # noqa: E501
        :rtype: str
        """
        return self._payee

    @payee.setter
    def payee(self, payee):
        """Sets the payee of this Transaction.

        The payee/merchant of the transaction.  # noqa: E501

        :param payee: The payee of this Transaction.  # noqa: E501
        :type: str
        """

        self._payee = payee

    @property
    def status(self):
        """Gets the status of this Transaction.  # noqa: E501

        The status of the transaction. Pending transactions are temporary and may be superseded later by their posted counterparts, which are permanent.  # noqa: E501

        :return: The status of this Transaction.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this Transaction.

        The status of the transaction. Pending transactions are temporary and may be superseded later by their posted counterparts, which are permanent.  # noqa: E501

        :param status: The status of this Transaction.  # noqa: E501
        :type: str
        """
        allowed_values = ["pending", "posted"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and status not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def transaction_account(self):
        """Gets the transaction_account of this Transaction.  # noqa: E501


        :return: The transaction_account of this Transaction.  # noqa: E501
        :rtype: TransactionAccount
        """
        return self._transaction_account

    @transaction_account.setter
    def transaction_account(self, transaction_account):
        """Sets the transaction_account of this Transaction.


        :param transaction_account: The transaction_account of this Transaction.  # noqa: E501
        :type: TransactionAccount
        """

        self._transaction_account = transaction_account

    @property
    def type(self):
        """Gets the type of this Transaction.  # noqa: E501

        Whether the transaction is a debit or a credit  # noqa: E501

        :return: The type of this Transaction.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Transaction.

        Whether the transaction is a debit or a credit  # noqa: E501

        :param type: The type of this Transaction.  # noqa: E501
        :type: str
        """
        allowed_values = ["debit", "credit"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def upload_source(self):
        """Gets the upload_source of this Transaction.  # noqa: E501

        Where the transaction came from.  # noqa: E501

        :return: The upload_source of this Transaction.  # noqa: E501
        :rtype: str
        """
        return self._upload_source

    @upload_source.setter
    def upload_source(self, upload_source):
        """Sets the upload_source of this Transaction.

        Where the transaction came from.  # noqa: E501

        :param upload_source: The upload_source of this Transaction.  # noqa: E501
        :type: str
        """

        self._upload_source = upload_source

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Transaction):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Transaction):
            return True

        return self.to_dict() != other.to_dict()
