"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IDPPOCDecider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const sfn = require("aws-cdk-lib/aws-stepfunctions");
const tasks = require("aws-cdk-lib/aws-stepfunctions-tasks");
class IDPPOCDecider extends sfn.StateMachineFragment {
    constructor(parent, id, props) {
        super(parent, id);
        if (!props.s3OutputBucket || !props.s3OutputPrefix) {
            throw new Error('no s3OutputBucket and s3OutputPrefix passed in');
        }
        var defaultClassification = '';
        if (typeof (props.defaultClassification != 'undefined') && props.defaultClassification) {
            defaultClassification = props.defaultClassification;
        }
        const deciderFunction = new lambda.DockerImageFunction(this, 'TextractDecider', {
            code: lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../lambda/decider/')),
            memorySize: 128,
            environment: {
                DEFAULT_CLASSIFICATION: defaultClassification,
            },
        });
        deciderFunction.addToRolePolicy(new iam.PolicyStatement({ actions: ['s3:GetObject'], resources: ['*'] }));
        const deciderLambdaInvoke = new tasks.LambdaInvoke(this, 'deciderLambdaInvoke', {
            lambdaFunction: deciderFunction,
            timeout: aws_cdk_lib_1.Duration.seconds(100),
            outputPath: '$.Payload',
        });
        this.startState = deciderLambdaInvoke;
        this.endStates = [deciderLambdaInvoke];
    }
}
exports.IDPPOCDecider = IDPPOCDecider;
_a = JSII_RTTI_SYMBOL_1;
IDPPOCDecider[_a] = { fqn: "schadem-cdk-construct-sfn-idp-decider.IDPPOCDecider", version: "0.0.0" };
//# sourceMappingURL=data:application/json;base64,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